/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*
* $Id: mem.h,v 4.28 1998/12/31 16:03:26 erik Rel $
*******************************************************************************/
#ifndef _XZX_MEM_H
#define _XZX_MEM_H
#include "z80.h"
#define XZX_PAGESIZE	16384
enum {
SP48ROM,
SP128ROM0, SP128ROM1,
#ifdef XZX_PLUS3
SP3ROM0, SP3ROM1, SP3ROM2, SP3ROM3,
#endif
#ifdef XZX_PENTAGON
PENTROM0, PENTROM1, PENTROM2,
#endif
#ifdef XZX_SCORPION
SCORROM0, SCORROM1, SCORROM2, SCORROM3,
#endif
#ifdef XZX_IF1
IF1ROM,
#endif
#ifdef XZX_MF
MF128ROM,
#ifdef XZX_PLUS3
MF3ROM,
#endif
#endif
#ifdef XZX_TRDOS
TRDOSROM,
#endif
#ifdef XZX_MGT
MGTROM,
#endif
RAM0, RAM1, RAM2, RAM3, RAM4, RAM5, RAM6, RAM7,
#ifdef XZX_SCORPION
RAM8, RAM9, RAMA, RAMB, RAMC, RAMD, RAME, RAMF,
#endif
#ifndef REGISTERED
OSD,
#endif
NPAGES
};
#define MFRAM			RAM0
#define MGTRAM			RAM0
#define VPAGE(addr)		((addr) >> 13)
#define RPAGE(addr)		(RealPageNumbers[VPAGE(addr)])
#define MEM(addr)		(TheMemory[VPAGE(addr)][(addr) & 0x1fff])
#define READ_ONLY(addr)	(RPAGE(addr) < RAM0)
#define ULA_DRAWS_BORDER \
(UlaDelay[TSTATES] & 0x80)
#define ULA_DRAWS_SCREEN \
(!ULA_DRAWS_BORDER)
enum {
ROM_UNKNOWN,
ROM_STANDARD, ROM_TK95, ROM_GROOT, ROM_IMC,
ROM_128,
ROM_PLUS2,
#ifdef XZX_PLUS3
ROM_PLUS3,
#endif
#ifdef XZX_PENTAGON
ROM_PENTAGON,
#endif
#ifdef XZX_SCORPION
ROM_SCORPION,
#endif
NUMROMS
};
extern void MemoryInit(void);
extern int LoadRomImage(char *, int, int);
extern int GetRomChecksum(int , int);
extern uns8 ReadOpcode48(uns16);
extern uns8 ReadMem48(uns16);
extern void WriteMem48(uns16, uns8);
extern void InitPages48(void);
extern void PageIn48(int, int);
extern uns8 ReadOpcode128(uns16);
extern uns8 ReadMem128(uns16);
extern void WriteMem128(uns16, uns8);
extern void InitPages128(void);
extern void PageIn128(int, int);
extern uns8 ReadOpcode3(uns16);
extern uns8 ReadMem3(uns16);
extern void WriteMem3(uns16, uns8);
extern void InitPages3(void);
extern void PageIn3(int, int);
extern uns8 *TheMemory[8];
extern int RealPageNumbers[8];
extern uns8 *RealMemory[NPAGES];
#endif
