/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: emul.c,v 4.24 1999/01/23 08:47:00 erik Rel $";
#endif
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <assert.h>
#include "z80.h"
#include "resource.h"
#include "machine.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "dialog.h"
#include "keyboard.h"
#include "sbar.h"
#include "screen.h"
#include "emul.h"
typedef struct _event {
EmuEventFunc func;
void *arg;
int delay;
} Event;
#define MAX_EVENTS		2
#define TIMER_INTERVAL	100
#define UPDATE_INTERVAL	2000
static void emuTimer(int);
#ifdef EVENT_SCHEDULER
static void emuScheduleEvents(void);
#endif
unsigned int Vline = 0;
unsigned int Frame = 0;
static volatile int timerInterrupt;
static volatile int tstatesPerTimer;
static volatile double tstatesPerUpdate;
#ifdef EVENT_SCHEDULER
static Event *eventTable;
#endif
static void
emuTimer(int signo)
{
if (!InDialog)
{
timerInterrupt++;
}
}
void
Emulate(void)
{
unsigned int cycles = 0;
double tpu;
int tpt, ipu, fps, skipFrame;
sigset_t smask;
struct sigaction sigact;
#ifdef EVENT_SCHEDULER
eventTable = Malloc(sizeof(Event) * MAX_EVENTS, "Emulate");
#endif
timerInterrupt = 0;
EmuSetSpeed(GETCFG(speed));
tpt = tstatesPerTimer;
(void)sigfillset(&smask);
(void)sigdelset(&smask, SIGALRM);
sigact.sa_handler = emuTimer;
(void)sigemptyset(&sigact.sa_mask);
#ifdef SA_RESTART
sigact.sa_flags = SA_RESTART;
#else
sigact.sa_flags = 0;
#endif
(void)sigaction(SIGALRM, &sigact, NULL);
IntFrequency(TIMER_INTERVAL * 1000);
ipu = UPDATE_INTERVAL / TIMER_INTERVAL;
tpu = 0.0;
fps = 0;
for (;;)
{
if (Vline == Machine->intLine)
{
Z80_INT(0xff);
}
cycles += Machine->tstatesPerLine;
(void)Z80_Execute(cycles);
skipFrame = Frame % (GETCFG(fast) ? 10 : GETCFG(refresh));
if (!skipFrame)
{
UpdateLine((short)Vline);
}
if (++Vline == Machine->tvLines)
{
Vline = 0;
Frame++;
TSTATES -= cycles;
cycles = 0;
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
AudioPlayBuffer();
#endif
ProcessEvents();
KbdRefresh();
if (!(Frame % 25))
{
DoFlashing();
}
if (!skipFrame)
{
ScreenRefresh();
fps++;
}
}
#ifdef EVENT_SCHEDULER
emuScheduleEvents();
#endif
if ((tpt -= Machine->tstatesPerLine) <= 0)
{
tpt += tstatesPerTimer;
tpu += (double)tstatesPerTimer;
if (GETCFG(speed) && !GETCFG(fast))
{
if (!timerInterrupt)
{
(void)sigsuspend(&smask);
}
}
if ((ipu -= timerInterrupt) <= 0)
{
SbarDisplaySpeed((int)(tpu / tstatesPerUpdate + 0.5),
fps / (UPDATE_INTERVAL / 1000));
ipu = UPDATE_INTERVAL / TIMER_INTERVAL;
tpu = 0.0;
fps = 0;
}
timerInterrupt = 0;
}
}
}
void
EmuSetSpeed(int speed)
{
tstatesPerTimer = Machine->tstatesPerFrame * (speed ? speed : 100) / 2;
tstatesPerTimer /= 1000 / TIMER_INTERVAL;
tstatesPerUpdate = (double)Machine->tstatesPerFrame * 50.0;
tstatesPerUpdate *= (double)(UPDATE_INTERVAL / 1000);
tstatesPerUpdate /= 100.0;
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
AudioControl(AUC_REINIT);
#endif
}
#ifdef EVENT_SCHEDULER
int
EmuAddEvent(EmuEventFunc func, void *arg, int delay)
{
Event *e;
for (e = eventTable; e < &eventTable[MAX_EVENTS]; e++)
{
if (!e->func)
{
e->func = func;
e->arg = arg;
e->delay = delay;
return (e - eventTable);
}
}
Msg(M_FATAL, "event table overflow");
return -1;
}
#endif
#ifdef EVENT_SCHEDULER
void
EmuRemoveEvent(int slot, int call)
{
Event *e = &eventTable[slot];
assert (slot >= 0 && slot < MAX_EVENTS);
if (e->func)
{
if (call)
{
e->func(e->arg);
}
e->func = (EmuEventFunc)0;
}
}
#endif
#ifdef EVENT_SCHEDULER
static void
emuScheduleEvents(void)
{
Event *e;
EmuEventFunc f;
for (e = eventTable; e < &eventTable[MAX_EVENTS]; e++)
{
if (e->func && !--e->delay)
{
f = e->func;
e->func = (EmuEventFunc)0;
f(e->arg);
}
}
}
#endif
