/********************************************************************************
* Copyright (c) Erik Kunze 1998 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef XZX_KMOUSE
#ifndef lint
static char rcsid[] = "$Id: kmouse.c,v 1.6 1999/03/22 12:44:51 erik Rel $";
#endif
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <stdio.h>
#include "debug.h"
#include "resource.h"
#include "util.h"
#include "screen.h"
#include "kmouse.h"
#define EVENT_MASK		(PointerMotionMask | ButtonPressMask | ButtonReleaseMask)
#define L_BUTTON		0x02
#define M_BUTTON		0x04
#define R_BUTTON		0x01
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_X11) { x } }
#else
#define DEB(x)
#endif
#ifdef REGISTERED
static void kmouseMove(Widget, XtPointer, XEvent *, Boolean *);
static void kmouseButton(Widget, XtPointer, XEvent *, Boolean *);
static void kmouseEnter(Widget, XtPointer, XEvent *, Boolean *);
#endif
uns8 KmouseX, KmouseY, KmouseButtons;
#ifdef REGISTERED
static Widget widget;
#endif
static Window window;
static Cursor blankCursor;
static int x, y;
void
#ifdef REGISTERED
KmouseInit(Widget w)
#else
KmouseInit(Window w)
#endif
{
char bm;
Pixmap pm;
XColor c;
#ifdef REGISTERED
widget = w;
window = XtWindow(w);
#else
window = w;
#endif
bm = 0;
pm = XCreatePixmapFromBitmapData(Dpy, window, &bm, 1, 1, 0, 0, 1);
blankCursor = XCreatePixmapCursor(Dpy, pm, pm, &c, &c, 0, 0);
if (GETCFG(kmouseActive))
{
KmouseOn();
}
}
void
KmouseOn(void)
{
#ifdef REGISTERED
XtAddEventHandler(widget, PointerMotionMask, 0,
(XtEventHandler)kmouseMove, NULL);
XtAddEventHandler(widget, ButtonPressMask | ButtonReleaseMask, 0,
(XtEventHandler)kmouseButton, NULL);
XtAddEventHandler(widget, EnterWindowMask, 0,
(XtEventHandler)kmouseEnter, NULL);
#else
XSetWindowAttributes newAttr;
XWindowAttributes curAttr;
XGetWindowAttributes(Dpy, window, &curAttr);
newAttr.event_mask = curAttr.your_event_mask | EVENT_MASK;
XChangeWindowAttributes(Dpy, window, CWEventMask, &newAttr);
#endif
XDefineCursor(Dpy, window, blankCursor);
if (GETCFG(kmouseGrab))
{
(void)XGrabPointer(Dpy, window, True, PointerMotionMask,
GrabModeAsync, GrabModeAsync,
window, None, CurrentTime);
XWarpPointer(Dpy, window, window, 0, 0, 0U, 0U, 0, 0);
XSync(Dpy, False);
}
KmouseX = x = 0;
KmouseY = y = 0;
KmouseButtons = 0xff;
}
void
KmouseOff(void)
{
#ifdef REGISTERED
XtRemoveEventHandler(widget, PointerMotionMask, 0,
(XtEventHandler)kmouseMove, NULL);
XtRemoveEventHandler(widget, ButtonPressMask | ButtonReleaseMask, 0,
(XtEventHandler)kmouseButton, NULL);
XtRemoveEventHandler(widget, EnterWindowMask, 0,
(XtEventHandler)kmouseEnter, NULL);
#else
XSetWindowAttributes newAttr;
XWindowAttributes curAttr;
XGetWindowAttributes(Dpy, window, &curAttr);
newAttr.event_mask = curAttr.your_event_mask & ~EVENT_MASK;
XChangeWindowAttributes(Dpy, window, CWEventMask, &newAttr);
#endif
XUndefineCursor(Dpy, window);
XUngrabPointer(Dpy, CurrentTime);
}
#ifdef REGISTERED
static void
kmouseMove(Widget w, XtPointer client, XEvent *xev, Boolean *cont)
#else
void
KmouseMove(XEvent *xev)
#endif
{
int offx, offy;
DEB(Msg(M_DEBUG, "KMOUSE: x %d, y %d", xev->xmotion.x, xev->xmotion.y););
offx = x - xev->xmotion.x;
offy = y - xev->xmotion.y;
x = xev->xmotion.x;
y = xev->xmotion.y;
KmouseX -= offx / GETCFG(scale);
KmouseY += offy / GETCFG(scale);
}
#ifdef REGISTERED
static void
kmouseButton(Widget w, XtPointer client, XEvent *xev, Boolean *cont)
#else
void
KmouseButton(XEvent *xev)
#endif
{
uns8 mask;
switch (xev->xbutton.button)
{
case Button1:
mask = L_BUTTON;
break;
case Button2:
mask = M_BUTTON;
break;
case Button3:
mask = R_BUTTON;
break;
default:
mask = 0;
break;
}
DEB(Msg(M_DEBUG, "KMOUSE: %s %x",
xev->type == ButtonPress ? "press" : "release", mask););
if (xev->type == ButtonPress)
{
KmouseButtons &= ~mask;
}
else
{
KmouseButtons |= mask;
}
}
#ifdef REGISTERED
static void
kmouseEnter(Widget w, XtPointer client, XEvent *xev, Boolean *cont)
{
if (GETCFG(kmouseGrab))
{
(void)XtGrabPointer(w, True, PointerMotionMask,
GrabModeAsync, GrabModeAsync,
XtWindow(w), None, CurrentTime);
XSync(Dpy, False);
}
}
#endif
#endif
