/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 * changed: mpichler, 19970919
 *
 * $Id: Browser.java,v 1.2 1997/09/19 15:18:57 mpichler Exp $
 */

package vrml.external;

import iicm.vrml.vrwave.VRwave;
import iicm.vrml.vrwave.Scene;
import iicm.vrml.pw.DefParserOutput;
import iicm.vrml.pw.VRMLparser;
import iicm.vrml.pw.GroupNode;
import vrml.external.exception.*;

import java.applet.*;
import java.io.*;
import java.util.Vector;
import java.util.Hashtable;


/* if you prefer to use Java-EAI with dirty JavaScript browser
 * location code (like done in the Java-EAI examples from SGI), use
 * this:
 */

public class Browser extends netscape.plugin.Plugin

/* if you prefer to get a Browser handle the clean way via the static
 * getBrowser method, being independent from netscape's Plugin java
 * class, use this:
 */

// public class Browser

/* end of browser dependent ugliness */

{
  /**
   * Get the name of the VRML browser. */

  public String getName ()
  {
    return VRwave.NAME;
  }


  /**
   * Get the version of the VRML browser.
   */

  public String getVersion ()
  {
    return VRwave.VERSION;
  }


  /**
   * Get the current velocity of the bound viewpoint in meters/sec,
   * if available, or 0.0 if not.
   */

  public float getCurrentSpeed ()
  {
    return 0.0f;  // information not available, always return 0.0
  }


  /**
   * Get the current frame rate of the browser, or 0.0 if not available.
   */

  public float getCurrentFrameRate ()
  {
    getScene ();
    return scene_.framespersecond_;
  }


  /**
   * Get the URL for the root of the current world, or an empty string
   * if not available.
   */

  public String getWorldURL ()
  {
    getScene ();
    return (scene_.getWorldURL ());
  }


  /**
   * Replace the current world with the passed array of nodes.
   */

  public void replaceWorld (Node[] nodes) throws IllegalArgumentException
  {
    getScene ();
    GroupNode root = new GroupNode ();

    iicm.vrml.pw.Node[] pwnodes = new iicm.vrml.pw.Node[nodes.length];
    for (int i = 0; i < nodes.length; i++)
      pwnodes[i] = nodes[i].getpwNode ();
    
    root.children.setValue (pwnodes);

    scene_.replaceScene (root);
  }


  /**
   * Load the given URL with the passed parameters (as described
   * in the Anchor node).
   */

  public void loadURL (String[] url, String[] parameter)
  {
    getScene ();
    scene_.activateAnchor (url[0], parameter, (parameter != null) ? parameter.length : 0);
  }


  /**
   * Set the description of the current world. To clear the description,
   * pass an empty string as argument.
   */
   
  public void setDescription (String description)
  {
    getScene ();
    scene_.statusMessage (description, 0);
  }


  /**
   * Parse STRING into a VRML scene and return the list of root
   * nodes for the resulting scene.
   */

  public Node[] createVrmlFromString (String vrmlSyntax) throws InvalidVrmlException
  {
    getScene ();
    VRMLparser parser = new VRMLparser (new StringBufferInputStream ("#VRML V2.0 utf8\n" + vrmlSyntax));

    GroupNode root = parser.readStream ();
    if (root == null)
      throw new InvalidVrmlException ();

    scene_.buildNode (root);

    Vector pwnodes = root.children.getNodes ();
    Node[] nodes = new Node[pwnodes.size ()];
    
    for (int i = 0; i < pwnodes.size (); i++)
      nodes[i] = new Node ((iicm.vrml.pw.Node) pwnodes.elementAt (i), scene_);

    return nodes;
  }


  /**
   * Tells the browser to load a VRML scene from the passed URL or
   * URLs. After the scene is loaded, an event is sent to the MFNode
   * eventIn in node NODE named by the EVENT argument.
   */

  public void createVrmlFromURL (String[] url, Node node, String event)
  {
    // not yet implemented
  }


  /**
   * Get a DEFed node by name. Nodes given names in the root scene are
   * available to this method, DEFed nodes in inlines, as well as DEFed
   * nodes returned from createVrmlFromString/URL are not.
   */

  public Node getNode (String name) throws InvalidNodeException
  {
    getScene ();
    Hashtable nodenames = scene_.getNodeNames ();
    if (nodenames == null)  // on parsing errors
      throw new InvalidNodeException ();
    iicm.vrml.pw.Node pwnode = (iicm.vrml.pw.Node) nodenames.get (name);
    if (pwnode == null)
      throw new InvalidNodeException ();

    return (new Node (pwnode, scene_));
  }


  /**
   * Add a route between the specified eventOut and eventIn of the
   * given nodes.
   */

  public void addRoute (Node fromNode, String fromEventOut, Node toNode, String toEventIn)
    throws IllegalArgumentException
  {
    if (iicm.vrml.pw.Node.addRoute (null, fromNode.getpwNode (), fromEventOut,
                                    null, toNode.getpwNode (), toEventIn,
                                    pout, null, false) == null)
      throw new IllegalArgumentException ();
  }


  /**
   * Delete a route between the specified eventOut and eventIn of the
   * given nodes.
   */

  public void deleteRoute (Node fromNode, String fromEventOut, Node toNode, String toEventIn)
    throws IllegalArgumentException
  {
    if (!iicm.vrml.pw.Node.deleteRoute (fromNode.getpwNode (), fromEventOut, toNode.getpwNode (), toEventIn))
      throw new IllegalArgumentException ();
  }


  /**
   * Return an instance of the Browser class.
   */

  static public Browser getBrowser (Applet pApplet)
  {
    if (activescene_ != null)
    {
      Browser instance = new Browser ();
      instance.scene_ = activescene_;
      return instance;
    }
    return null;
  }

  /**
   * Return an instance of the Browser class.
   */

  static public Browser getBrowser (Applet pApplet, String frameName, int index)
  {
    if (activescene_ != null)
    {
      Browser instance = new Browser ();
      instance.scene_ = activescene_;
      return instance;
    }
    return null;
  }


  /** VRwave implementation. do not call from applets */

  static Scene activescene_;
  Scene scene_;
  DefParserOutput pout = new DefParserOutput ();

  static public void startVRwave (Scene scene)
  {
    activescene_ = scene;
  }

  static public void stopVRwave (Scene scene)
  {
    if (activescene_ == scene)
      activescene_ = null;
  }  

  /**
   * this is really a hack to make bad examples work,
   * which get the Browser instance via JavaScript
   * instead of using the getBrowser method.
   */
  private void getScene ()
  {
    if (scene_ != null)
      return;

    // block until scene_ is non-null, i.e. a VRwave instance has connected via startVRwave
    int maxtries = 100;
    while (maxtries-- > 0)
    {
      if ((scene_ = activescene_) != null)
        return;
      // System.err.println ("Scene not yet attached. Will try again.");
      try
      { Thread.sleep (500);
      }
      catch (Throwable e)  { }
    }
    System.err.println ("could not connect to VRwave. giving up.");
  }
} // Browser
