/*
 * URLServer.java
 *
 * created: kwagen, 19970410
 *
 * changed: kwagen, 19970507
 *
 * $Id: URLServer.java,v 1.2 1997/08/08 09:49:59 kwagen Exp $
 */


package iicm.vrml.vrwave;

import iicm.vrml.pw.*;
import iicm.ge3d.GE3D;
import iicm.vrml.vrwave.pwdat.*;
import iicm.vrml.pwutils.IntArray;

import java.net.*;
import java.io.*;
import java.awt.Toolkit;
import java.awt.Image;
import java.awt.CardLayout;


class URLServer implements Runnable
{
  private URLRequest requests_;         // head of request list
  private URLRequest last_;             // tail of request list
  private IntArray displist_ = new IntArray ();  // bound ge3d texture indices
  Scene scene_;
  ImageLoader imgloader = new ImageLoader ();


  URLServer (Scene scene)
  {
    scene_ = scene;
  }


  public void run ()
  {
    while (requests_ != null)
    {
      Node node = requests_.getNode ();

      if (node instanceof ImageTexture)
        loadTextureImage (node, requests_.getBaseURL ());
      else if (node instanceof Inline)
        loadInlineChildren ((Inline) node, requests_.getBaseURL ());
      else
        System.out.println ("URLServer: invalid request node type.");

      requests_ = requests_.getNext ();
    }
  }

  /**
   * fetch and parse children of an Inline node
   */

  private void loadInlineChildren (Inline node, URL base)
  {
    String[] urls = node.url.getValueData ();
    int urln = node.url.getValueCount ();

    for (int current = 0;  current < urln;  current++)
    {
      try
      {
        URL url = new URL (requests_.getBaseURL (), urls[current]);

        VRMLparser parser = new VRMLparser (url.openStream ());            
        GroupNode root = parser.readStream ();
        if (root != null)
        {
          System.out.println ("inline " + url.toString ());
          ((InlineData) node.userdata).url_ = url;

          scene_.buildInline (node, root);

          break;  // done
        }
        else
        {
          System.out.println ("error on parsing " + urls[current]);
          if (parser.getVersion () == 0.0f)
            System.out.println ("bad header");
        }
      }
      catch (MalformedURLException e)
      { System.out.println ("invalid URL <" + urls[current] + ">");
      }
      catch (IOException e)
      { System.out.println ("error on reading " + urls[current]);
      }           
    } // for
  } // loadInlineChildren

  /**
   * fetch image of a Texture node
   */
 
  private void loadTextureImage (Node node, URL base)
  {
    Toolkit toolkit = Toolkit.getDefaultToolkit ();
    String[] urls = ((ImageTexture) node).url.getValueData ();
    int urln = ((ImageTexture) node).url.getValueCount ();

    for (int current = 0;  current < urln;  current++)
    {
      try
      {
        Image teximage;
        URL url = new URL (base, urls[current]);
        teximage = toolkit.getImage (url);

        scene_.workingMessage ("loading " + url.toString ());
        scene_.workingState (true);

        imgloader.loadImage (teximage.getSource (), scene_);

        scene_.workingState (false);

        if (imgloader.error ())
        {
          System.out.println ("error on reading " + url.toString ());
        }
        else
        {
          int width = imgloader.getWidth ();
          int height = imgloader.getHeight ();
          System.out.println ("texture image " + url.toString () + " (" + width + "x" + height + ")");

          int displaylist;
          synchronized (scene_)
          {
            displaylist = GE3D.createImageTexture (width, height, imgloader.getPixels ());
          }
          ((ImageTextureData) node.userdata).hasalpha_ = (GE3D.getTextureAlpha () > 0);
          
          if (displaylist < 0)
          {
            ((ImageTextureData) node.userdata).colored_ = true;
            displaylist = - displaylist;
          }

          if (displaylist > 0)
          {
            ((ImageTextureData) node.userdata).handle_ = displaylist;
            addDisplayList (displaylist);
            scene_.redraw ();
          }

          break;  // done
        }
      }
      catch (InterruptedException e)
      {
        System.out.println ("Exception during ImageLoader.loadImage.");
      }
      catch (MalformedURLException e)
      {
        System.out.println ("invalid URL <" + urls[current] + ">");
      }
    } // for
  } // loadTextureImage


  public void addRequest (Node node, URL base)
  {
    if (requests_ == null)
    {
      requests_ = new URLRequest (node, base);
      last_ = requests_;
    }      
    else
    {
      last_.addNext (node, base);
      last_ = last_.getNext ();
    }
  }


  public void addDisplayList (int displaylist)
  {
    displist_.append (displaylist);
  }


  public void clearAll ()
  {
    int n = displist_.getCount ();
    int[] tmp = displist_.getData ();
    for (int i = 0; i < n; i++)    
    {
      // System.out.println ("free texture " + tmp[i]);
      GE3D.freeTexture (tmp[i]);
    }
    displist_.clearData ();

    requests_ = null;
    last_ = null;
  }


  public boolean isActive ()
  { return (requests_ != null); }
}
