/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.HIGHCONTRAST;
import org.eclipse.swt.internal.win32.KEYBDINPUT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MOUSEINPUT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    public MSG msg = new MSG();
    Event[] eventQueue;
    Callback windowCallback;
    int windowProc;
    int threadId;
    int processId;
    TCHAR windowClass;
    static int WindowClassCount;
    static final String WindowName = "SWT_Window";
    EventTable eventTable;
    EventTable filterTable;
    int freeSlot;
    int[] indexTable;
    Control[] controlTable;
    static final int GROW_SIZE = 1024;
    Menu[] bars;
    Menu[] popups;
    MenuItem[] items;
    static final int ID_START = 108;
    Callback msgFilterCallback;
    int msgFilterProc;
    int filterHook;
    MSG hookMsg = new MSG();
    boolean ignoreMsgFilter;
    Callback getMsgCallback;
    Callback embeddedCallback;
    int getMsgProc;
    int msgHook;
    int embeddedHwnd;
    int embeddedProc;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Tray tray;
    int nextTrayId = 0;
    int timerCount;
    int[] timerIds;
    Runnable[] timerList;
    int lastKey;
    int lastAscii;
    int lastMouse;
    boolean lastVirtual;
    boolean lastNull;
    boolean lastDead;
    byte[] keyboard = new byte[256];
    boolean accelKeyHit;
    boolean mnemonicKeyHit;
    boolean lockActiveWindow;
    boolean ignoreRestoreFocus;
    Control lastHittestControl;
    int lastHittest;
    Callback messageCallback;
    int hwndMessage;
    int messageProc;
    int[] systemFonts;
    int errorIcon;
    int infoIcon;
    int questionIcon;
    int warningIcon;
    Cursor[] cursors = new Cursor[22];
    ImageList[] imageList;
    ImageList[] toolImageList;
    ImageList[] toolHotImageList;
    ImageList[] toolDisabledImageList;
    int lpCustColors;
    Object data;
    String[] keys;
    Object[] values;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    static Monitor[] monitors;
    static int monitorCount;
    Shell[] modalShells;
    Shell modalDialogShell;
    static boolean TrimEnabled;
    static final int SWT_GETACCELCOUNT = 32768;
    static final int SWT_GETACCEL = 32769;
    static final int SWT_KEYMSG = 32770;
    static final int SWT_DESTROY = 32771;
    static final int SWT_RESIZE = 32772;
    static final int SWT_TRAYICONMSG = 32773;
    static int SWT_TASKBARCREATED;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";

    static {
        KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {38, 0x1000001}, {40, 0x1000002}, {37, 0x1000003}, {39, 0x1000004}, {33, 0x1000005}, {34, 0x1000006}, {36, 0x1000007}, {35, 0x1000008}, {45, 0x1000009}, {8, 8}, {13, 13}, {46, 127}, {27, 27}, {13, 10}, {9, 9}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}, {124, 0x1000016}, {125, 0x1000017}, {126, 0x1000018}, {106, 16777258}, {107, 16777259}, {13, 0x1000050}, {109, 16777261}, {110, 16777262}, {111, 16777263}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {19, 0x1000055}, {3, 16777302}, {44, 16777303}};
        Displays = new Display[4];
        monitors = null;
        monitorCount = 0;
        TrimEnabled = false;
        Device.DeviceFinder = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }

    static void setDevice(Device device) {
        Device.CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    int asciiKey(int n) {
        if (OS.IsWinCE) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.keyboard.length) {
            this.keyboard[n2] = 0;
            ++n2;
        }
        if (!OS.GetKeyboardState(this.keyboard)) {
            return 0;
        }
        if (OS.IsUnicode) {
            char[] cArray = new char[1];
            if (OS.ToUnicode(n, n, this.keyboard, cArray, 1, 0) == 1) {
                return cArray[0];
            }
        } else {
            short[] sArray = new short[1];
            if (OS.ToAscii(n, n, this.keyboard, sArray, 0) == 1) {
                return sArray[0];
            }
        }
        return 0;
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    void addBar(Menu menu) {
        if (this.bars == null) {
            this.bars = new Menu[4];
        }
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.bars[n2] == menu) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.bars[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            Menu[] menuArray = new Menu[n + 4];
            System.arraycopy(this.bars, 0, menuArray, 0, n);
            this.bars = menuArray;
        }
        this.bars[n2] = menu;
    }

    void addControl(int n, Control control) {
        int n2;
        if (n == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n2 = this.freeSlot + 1024;
            int[] nArray = new int[n2];
            Control[] controlArray = new Control[n2];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.controlTable, 0, controlArray, 0, this.freeSlot);
            int n3 = this.freeSlot;
            while (n3 < n2 - 1) {
                nArray[n3] = n3 + 1;
                ++n3;
            }
            nArray[n2 - 1] = -1;
            this.indexTable = nArray;
            this.controlTable = controlArray;
        }
        OS.SetWindowLong(n, -21, this.freeSlot + 1);
        n2 = this.freeSlot;
        this.freeSlot = this.indexTable[n2];
        this.indexTable[n2] = -2;
        this.controlTable[n2] = control;
    }

    void addMenuItem(MenuItem menuItem) {
        if (this.items == null) {
            this.items = new MenuItem[64];
        }
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] == null) {
                menuItem.id = n + 108;
                this.items[n] = menuItem;
                return;
            }
            ++n;
        }
        menuItem.id = this.items.length + 108;
        MenuItem[] menuItemArray = new MenuItem[this.items.length + 64];
        menuItemArray[this.items.length] = menuItem;
        System.arraycopy(this.items, 0, menuItemArray, 0, this.items.length);
        this.items = menuItemArray;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n = this.popups.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == menu) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            Menu[] menuArray = new Menu[n + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        OS.MessageBeep(0);
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    static synchronized void checkDisplay(Thread thread) {
        int n = 0;
        while (n < Displays.length) {
            if (Displays[n] != null && Display.Displays[n].thread == thread) {
                SWT.error(22);
            }
            ++n;
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int n = 0;
        int n2 = this.modalShells.length;
        while (n < n2) {
            if (this.modalShells[n] == shell) break;
            if (this.modalShells[n] == null) {
                return;
            }
            ++n;
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.modalShells, n + 1, this.modalShells, n, --n2 - n);
        this.modalShells[n2] = null;
        if (n == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            shellArray[n3].updateModal();
            ++n3;
        }
    }

    int controlKey(int n) {
        short s = OS.CharUpper((short)n);
        if (64 <= s && s <= 95) {
            return s & 0xBF;
        }
        return n;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
    }

    static synchronized void deregister(Display display) {
        int n = 0;
        while (n < Displays.length) {
            if (display == Displays[n]) {
                Display.Displays[n] = null;
            }
            ++n;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int n = 0;
        while (n < this.disposeList.length) {
            if (this.disposeList[n] == null) {
                this.disposeList[n] = runnable;
                return;
            }
            ++n;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void drawMenuBars() {
        if (this.bars == null) {
            return;
        }
        int n = 0;
        while (n < this.bars.length) {
            Menu menu = this.bars[n];
            if (menu != null && !menu.isDisposed()) {
                menu.update();
            }
            ++n;
        }
        this.bars = null;
    }

    int embeddedProc(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 32770: {
                MSG mSG = new MSG();
                OS.MoveMemory(mSG, n4, 28);
                OS.TranslateMessage(mSG);
                OS.DispatchMessage(mSG);
                int n5 = OS.GetProcessHeap();
                OS.HeapFree(n5, 0, n4);
                break;
            }
            case 32771: {
                OS.DestroyWindow(n);
                if (this.embeddedCallback != null) {
                    this.embeddedCallback.dispose();
                }
                if (this.getMsgCallback != null) {
                    this.getMsgCallback.dispose();
                }
                this.getMsgCallback = null;
                this.embeddedCallback = null;
                this.getMsgProc = 0;
                this.embeddedProc = 0;
                break;
            }
            case 32772: {
                int n6 = 52;
                OS.SetWindowPos(n3, 0, 0, 0, n4 & 0xFFFF, n4 >> 16, n6);
            }
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    boolean filterMessage(MSG mSG) {
        Control control;
        int n = mSG.message;
        if (256 <= n && n <= 264 && (control = this.findControl(mSG.hwnd)) != null && (this.translateAccelerator(mSG, control) || this.translateMnemonic(mSG, control) || this.translateTraversal(mSG, control))) {
            this.lastKey = 0;
            this.lastAscii = 0;
            this.lastDead = false;
            this.lastNull = false;
            this.lastVirtual = false;
            return true;
        }
        return false;
    }

    public Widget findWidget(int n) {
        this.checkDevice();
        return this.getControl(n);
    }

    Control findControl(int n) {
        if (n == 0) {
            return null;
        }
        do {
            Control control;
            if ((control = this.getControl(n)) == null) continue;
            return control;
        } while ((n = OS.GetParent(n)) != 0);
        return null;
    }

    public static synchronized Display findDisplay(Thread thread) {
        int n = 0;
        while (n < Displays.length) {
            Display display = Displays[n];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++n;
        }
        return null;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Control control = this.findControl(OS.GetActiveWindow());
        return control != null ? control.getShell() : null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            int n = OS.GetSystemMetrics(0);
            int n2 = OS.GetSystemMetrics(1);
            return new Rectangle(0, 0, n, n2);
        }
        int n = OS.GetSystemMetrics(76);
        int n3 = OS.GetSystemMetrics(77);
        int n4 = OS.GetSystemMetrics(78);
        int n5 = OS.GetSystemMetrics(79);
        return new Rectangle(n, n3, n4, n5);
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            RECT rECT = new RECT();
            OS.SystemParametersInfo(48, 0, rECT, 0);
            int n = rECT.right - rECT.left;
            int n2 = rECT.bottom - rECT.top;
            return new Rectangle(rECT.left, rECT.top, n, n2);
        }
        int n = OS.GetSystemMetrics(76);
        int n3 = OS.GetSystemMetrics(77);
        int n4 = OS.GetSystemMetrics(78);
        int n5 = OS.GetSystemMetrics(79);
        return new Rectangle(n, n3, n4, n5);
    }

    Control getControl(int n) {
        Control control;
        if (n == 0) {
            return null;
        }
        int n2 = OS.GetWindowLong(n, -21) - 1;
        if (n2 >= 0 && n2 < this.controlTable.length && (control = this.controlTable[n2]) != null && control.handle == n) {
            return control;
        }
        return null;
    }

    public Control getCursorControl() {
        this.checkDevice();
        POINT pOINT = new POINT();
        if (!OS.GetCursorPos(pOINT)) {
            return null;
        }
        return this.findControl(OS.WindowFromPoint(pOINT));
    }

    public Point getCursorLocation() {
        this.checkDevice();
        POINT pOINT = new POINT();
        OS.GetCursorPos(pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(13), OS.GetSystemMetrics(14))};
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return this.values[n];
            }
            ++n;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDoubleClickTime();
    }

    public Control getFocusControl() {
        this.checkDevice();
        return this.findControl(OS.GetFocus());
    }

    public boolean getHighContrast() {
        this.checkDevice();
        if (OS.IsWinCE) {
            return false;
        }
        HIGHCONTRAST hIGHCONTRAST = new HIGHCONTRAST();
        hIGHCONTRAST.cbSize = 12;
        OS.SystemParametersInfo(66, 0, hIGHCONTRAST, 0);
        return (hIGHCONTRAST.dwFlags & 1) != 0;
    }

    public int getIconDepth() {
        this.checkDevice();
        TCHAR tCHAR = new TCHAR(0, "Control Panel\\Desktop\\WindowMetrics", true);
        int[] nArray = new int[1];
        int n = OS.RegOpenKeyEx(-2147483647, tCHAR, 0, 131097, nArray);
        if (n != 0) {
            return 4;
        }
        int n2 = 4;
        TCHAR tCHAR2 = new TCHAR(0, "Shell Icon BPP", true);
        int[] nArray2 = new int[]{128};
        TCHAR tCHAR3 = new TCHAR(0, nArray2[0]);
        n = OS.RegQueryValueEx(nArray[0], tCHAR2, 0, null, tCHAR3, nArray2);
        if (n == 0) {
            try {
                n2 = Integer.parseInt(tCHAR3.toString(0, tCHAR3.strlen()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        OS.RegCloseKey(nArray[0]);
        return n2;
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(49), OS.GetSystemMetrics(50)), new Point(OS.GetSystemMetrics(11), OS.GetSystemMetrics(12))};
    }

    ImageList getImageList(Point point) {
        ImageList[] imageListArray;
        if (this.imageList == null) {
            this.imageList = new ImageList[4];
        }
        int n = 0;
        int n2 = this.imageList.length;
        while (n < n2) {
            imageListArray = this.imageList[n];
            if (imageListArray == null) break;
            if (imageListArray.getImageSize().equals(point)) {
                imageListArray.addRef();
                return imageListArray;
            }
            ++n;
        }
        if (n == n2) {
            imageListArray = new ImageList[n2 + 4];
            System.arraycopy(this.imageList, 0, imageListArray, 0, n2);
            this.imageList = imageListArray;
        }
        this.imageList[n] = imageListArray = new ImageList();
        imageListArray.addRef();
        return imageListArray;
    }

    ImageList getToolImageList(Point point) {
        ImageList[] imageListArray;
        if (this.toolImageList == null) {
            this.toolImageList = new ImageList[4];
        }
        int n = 0;
        int n2 = this.toolImageList.length;
        while (n < n2) {
            imageListArray = this.toolImageList[n];
            if (imageListArray == null) break;
            if (imageListArray.getImageSize().equals(point)) {
                imageListArray.addRef();
                return imageListArray;
            }
            ++n;
        }
        if (n == n2) {
            imageListArray = new ImageList[n2 + 4];
            System.arraycopy(this.toolImageList, 0, imageListArray, 0, n2);
            this.toolImageList = imageListArray;
        }
        this.toolImageList[n] = imageListArray = new ImageList();
        imageListArray.addRef();
        return imageListArray;
    }

    ImageList getToolHotImageList(Point point) {
        ImageList[] imageListArray;
        if (this.toolHotImageList == null) {
            this.toolHotImageList = new ImageList[4];
        }
        int n = 0;
        int n2 = this.toolHotImageList.length;
        while (n < n2) {
            imageListArray = this.toolHotImageList[n];
            if (imageListArray == null) break;
            if (imageListArray.getImageSize().equals(point)) {
                imageListArray.addRef();
                return imageListArray;
            }
            ++n;
        }
        if (n == n2) {
            imageListArray = new ImageList[n2 + 4];
            System.arraycopy(this.toolHotImageList, 0, imageListArray, 0, n2);
            this.toolHotImageList = imageListArray;
        }
        this.toolHotImageList[n] = imageListArray = new ImageList();
        imageListArray.addRef();
        return imageListArray;
    }

    ImageList getToolDisabledImageList(Point point) {
        ImageList[] imageListArray;
        if (this.toolDisabledImageList == null) {
            this.toolDisabledImageList = new ImageList[4];
        }
        int n = 0;
        int n2 = this.toolDisabledImageList.length;
        while (n < n2) {
            imageListArray = this.toolDisabledImageList[n];
            if (imageListArray == null) break;
            if (imageListArray.getImageSize().equals(point)) {
                imageListArray.addRef();
                return imageListArray;
            }
            ++n;
        }
        if (n == n2) {
            imageListArray = new ImageList[n2 + 4];
            System.arraycopy(this.toolDisabledImageList, 0, imageListArray, 0, n2);
            this.toolDisabledImageList = imageListArray;
        }
        this.toolDisabledImageList[n] = imageListArray = new ImageList();
        imageListArray.addRef();
        return imageListArray;
    }

    int getLastEventTime() {
        return OS.IsWinCE ? OS.GetTickCount() : OS.GetMessageTime();
    }

    MenuItem getMenuItem(int n) {
        if (this.items == null) {
            return null;
        }
        if ((n -= 108) >= 0 && n < this.items.length) {
            return this.items[n];
        }
        return null;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Shell getModalShell() {
        if (this.modalShells == null) {
            return null;
        }
        int n = this.modalShells.length;
        while (--n >= 0) {
            Shell shell = this.modalShells[n];
            if (shell == null) continue;
            return shell;
        }
        return null;
    }

    Shell getModalDialogShell() {
        if (this.modalDialogShell != null && this.modalDialogShell.isDisposed()) {
            this.modalDialogShell = null;
        }
        return this.modalDialogShell;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        if (OS.IsWinCE || (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return new Monitor[]{this.getPrimaryMonitor()};
        }
        monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        int n = callback.getAddress();
        OS.EnumDisplayMonitors(0, null, n, 0);
        callback.dispose();
        Monitor[] monitorArray = new Monitor[monitorCount];
        System.arraycopy(monitors, 0, monitorArray, 0, monitorCount);
        monitors = null;
        monitorCount = 0;
        return monitorArray;
    }

    int getMsgProc(int n, int n2, int n3) {
        if (this.embeddedHwnd == 0) {
            int n4 = OS.GetModuleHandle(null);
            this.embeddedHwnd = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0, 0, n4, null);
            this.embeddedCallback = new Callback(this, "embeddedProc", 4);
            this.embeddedProc = this.embeddedCallback.getAddress();
            if (this.embeddedProc == 0) {
                this.error(3);
            }
            OS.SetWindowLong(this.embeddedHwnd, -4, this.embeddedProc);
        }
        if (n >= 0 && n2 != 0) {
            MSG mSG = new MSG();
            OS.MoveMemory(mSG, n3, 28);
            switch (mSG.message) {
                case 32772: {
                    if (mSG.hwnd != 0 || mSG.wParam == 0) break;
                    OS.PostMessage(this.embeddedHwnd, 32772, mSG.wParam, mSG.lParam);
                    mSG.message = 0;
                    OS.MoveMemory(n3, mSG, 28);
                    break;
                }
                case 256: 
                case 257: 
                case 260: 
                case 261: {
                    int n5 = OS.GetProcessHeap();
                    int n6 = OS.HeapAlloc(n5, 8, 28);
                    OS.MoveMemory(n6, mSG, 28);
                    OS.PostMessage(this.hwndMessage, 32770, n2, n6);
                    mSG.message = 0;
                    OS.MoveMemory(n3, mSG, 28);
                }
            }
        }
        return OS.CallNextHookEx(this.msgHook, n, n2, n3);
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        if (OS.IsWinCE || (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            Monitor monitor = new Monitor();
            int n = OS.GetSystemMetrics(0);
            int n2 = OS.GetSystemMetrics(1);
            monitor.width = n;
            monitor.height = n2;
            RECT rECT = new RECT();
            OS.SystemParametersInfo(48, 0, rECT, 0);
            monitor.clientX = rECT.left;
            monitor.clientY = rECT.top;
            monitor.clientWidth = rECT.right - rECT.left;
            monitor.clientHeight = rECT.bottom - rECT.top;
            return monitor;
        }
        monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        int n = callback.getAddress();
        OS.EnumDisplayMonitors(0, null, n, 0);
        callback.dispose();
        Monitor monitor = null;
        MONITORINFO mONITORINFO = new MONITORINFO();
        mONITORINFO.cbSize = 40;
        int n3 = 0;
        while (n3 < monitorCount) {
            Monitor monitor2 = monitors[n3];
            OS.GetMonitorInfo(Display.monitors[n3].handle, mONITORINFO);
            if ((mONITORINFO.dwFlags & 1) != 0) {
                monitor = monitor2;
                break;
            }
            ++n3;
        }
        monitors = null;
        monitorCount = 0;
        return monitor;
    }

    public Shell[] getShells() {
        Object object;
        this.checkDevice();
        int n = 0;
        int n2 = 0;
        while (n2 < this.controlTable.length) {
            object = this.controlTable[n2];
            if (object != null && object instanceof Shell) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        object = new Shell[n];
        int n3 = 0;
        while (n3 < this.controlTable.length) {
            Control control = this.controlTable[n3];
            if (control != null && control instanceof Shell) {
                object[n2++] = (Shell)control;
            }
            ++n3;
        }
        return object;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        int n2 = 0x2000000;
        switch (n) {
            case 17: {
                n2 = OS.GetSysColor(OS.COLOR_3DDKSHADOW);
                break;
            }
            case 18: {
                n2 = OS.GetSysColor(OS.COLOR_3DSHADOW);
                break;
            }
            case 19: {
                n2 = OS.GetSysColor(OS.COLOR_3DLIGHT);
                break;
            }
            case 20: {
                n2 = OS.GetSysColor(OS.COLOR_3DHIGHLIGHT);
                break;
            }
            case 22: {
                n2 = OS.GetSysColor(OS.COLOR_3DFACE);
                break;
            }
            case 23: {
                n2 = OS.GetSysColor(OS.COLOR_WINDOWFRAME);
                break;
            }
            case 21: 
            case 24: {
                n2 = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
                break;
            }
            case 25: {
                n2 = OS.GetSysColor(OS.COLOR_WINDOW);
                break;
            }
            case 26: {
                n2 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                break;
            }
            case 27: {
                n2 = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                break;
            }
            case 28: {
                n2 = OS.GetSysColor(OS.COLOR_INFOTEXT);
                break;
            }
            case 29: {
                n2 = OS.GetSysColor(OS.COLOR_INFOBK);
                break;
            }
            case 30: {
                n2 = OS.GetSysColor(OS.COLOR_CAPTIONTEXT);
                break;
            }
            case 31: {
                n2 = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 32: {
                n2 = OS.GetSysColor(OS.COLOR_GRADIENTACTIVECAPTION);
                if (n2 != 0) break;
                n2 = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 33: {
                n2 = OS.GetSysColor(OS.COLOR_INACTIVECAPTIONTEXT);
                break;
            }
            case 34: {
                n2 = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            case 35: {
                n2 = OS.GetSysColor(OS.COLOR_GRADIENTINACTIVECAPTION);
                if (n2 != 0) break;
                n2 = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            default: {
                return super.getSystemColor(n);
            }
        }
        return Color.win32_new(this, n2);
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (n < 0 || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor(this, n);
        }
        return this.cursors[n];
    }

    public Font getSystemFont() {
        this.checkDevice();
        int n = this.systemFont();
        return Font.win32_new(this, n);
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        int n2 = 0;
        switch (n) {
            case 1: {
                if (this.errorIcon == 0) {
                    this.errorIcon = OS.LoadImage(0, 32513, 1, 0, 0, 32768);
                }
                n2 = this.errorIcon;
                break;
            }
            case 2: 
            case 16: {
                if (this.infoIcon == 0) {
                    this.infoIcon = OS.LoadImage(0, 32516, 1, 0, 0, 32768);
                }
                n2 = this.infoIcon;
                break;
            }
            case 4: {
                if (this.questionIcon == 0) {
                    this.questionIcon = OS.LoadImage(0, 32514, 1, 0, 0, 32768);
                }
                n2 = this.questionIcon;
                break;
            }
            case 8: {
                if (this.warningIcon == 0) {
                    this.warningIcon = OS.LoadImage(0, 32515, 1, 0, 0, 32768);
                }
                n2 = this.warningIcon;
            }
        }
        if (n2 == 0) {
            return null;
        }
        return Image.win32_new(this, 1, n2);
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((n = OS.GetDC(0)) == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n2 = 0x6000000;
            if ((gCData.style & n2) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.hFont = this.systemFont();
        }
        return n;
    }

    protected void init() {
        int n;
        super.init();
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.threadId = OS.GetCurrentThreadId();
        this.processId = OS.GetCurrentProcessId();
        this.windowClass = new TCHAR(0, WindowName + WindowClassCount++, true);
        int n2 = OS.GetProcessHeap();
        int n3 = OS.GetModuleHandle(null);
        WNDCLASS wNDCLASS = new WNDCLASS();
        wNDCLASS.hInstance = n3;
        wNDCLASS.lpfnWndProc = this.windowProc;
        wNDCLASS.style = 8200;
        wNDCLASS.hCursor = OS.LoadCursor(0, 32512);
        int n4 = this.windowClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = n = OS.HeapAlloc(n2, 8, n4);
        OS.MoveMemory(n, this.windowClass, n4);
        OS.RegisterClass(wNDCLASS);
        int n5 = 0;
        if (!OS.IsWinCE) {
            NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
            nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
                n5 = OS.CreateFontIndirect(OS.IsUnicode ? nONCLIENTMETRICS.lfMessageFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfMessageFont);
            }
        }
        if (n5 == 0) {
            n5 = OS.GetStockObject(17);
        }
        if (n5 == 0) {
            n5 = OS.GetStockObject(13);
        }
        if (n5 != 0) {
            this.systemFonts = new int[]{n5};
        }
        this.hwndMessage = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0, 0, n3, null);
        this.messageCallback = new Callback(this, "messageProc", 4);
        this.messageProc = this.messageCallback.getAddress();
        if (this.messageProc == 0) {
            this.error(3);
        }
        OS.SetWindowLong(this.hwndMessage, -4, this.messageProc);
        if (!OS.IsWinCE) {
            this.msgFilterCallback = new Callback(this, "msgFilterProc", 3);
            this.msgFilterProc = this.msgFilterCallback.getAddress();
            if (this.msgFilterProc == 0) {
                this.error(3);
            }
            this.filterHook = OS.SetWindowsHookEx(-1, this.msgFilterProc, 0, this.threadId);
        }
        SWT_TASKBARCREATED = OS.RegisterWindowMessage(new TCHAR(0, "TaskbarCreated", true));
        this.indexTable = new int[1024];
        this.controlTable = new Control[1024];
        int n6 = 0;
        while (n6 < 1023) {
            this.indexTable[n6] = n6 + 1;
            ++n6;
        }
        this.indexTable[1023] = -1;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        OS.ReleaseDC(0, n);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        int n3 = control != null ? control.handle : 0;
        int n4 = control2 != null ? control2.handle : 0;
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        OS.MapWindowPoints(n3, n4, pOINT, 1);
        return new Point(pOINT.x, pOINT.y);
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        int n5 = control != null ? control.handle : 0;
        int n6 = control2 != null ? control2.handle : 0;
        RECT rECT = new RECT();
        rECT.left = n;
        rECT.top = n2;
        rECT.right = n + n3;
        rECT.bottom = n2 + n4;
        OS.MapWindowPoints(n5, n6, rECT, 2);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    static char mbcsToWcs(int n) {
        return Display.mbcsToWcs(n, 0);
    }

    static char mbcsToWcs(int n, int n2) {
        char[] cArray;
        byte[] byArray;
        if (OS.IsUnicode) {
            return (char)n;
        }
        int n3 = n & 0xFFFF;
        if (n3 <= 127) {
            return (char)n;
        }
        int n4 = n2 != 0 ? n2 : 0;
        int n5 = OS.MultiByteToWideChar(n4, 1, byArray = n3 <= 255 ? new byte[]{(byte)n3} : new byte[]{(byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF)}, byArray.length, cArray = new char[1], 1);
        if (n5 == 0) {
            return '\u0000';
        }
        return cArray[0];
    }

    int messageProc(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 32770: {
                int n5;
                boolean bl = false;
                MSG mSG = new MSG();
                OS.MoveMemory(mSG, n4, 28);
                Control control = this.findControl(mSG.hwnd);
                if (control != null) {
                    mSG.hwnd = control.handle;
                    n5 = 10420227;
                    do {
                        if (bl |= this.filterMessage(mSG)) continue;
                        OS.TranslateMessage(mSG);
                        bl |= OS.DispatchMessage(mSG) == 1;
                    } while (OS.PeekMessage(mSG, mSG.hwnd, 256, 264, n5));
                }
                if (bl) {
                    n5 = OS.GetProcessHeap();
                    OS.HeapFree(n5, 0, n4);
                } else {
                    OS.PostMessage(this.embeddedHwnd, 32770, n3, n4);
                }
                return 0;
            }
            case 32773: {
                if (this.tray != null) {
                    TrayItem[] trayItemArray = this.tray.items;
                    int n6 = 0;
                    while (n6 < trayItemArray.length) {
                        TrayItem trayItem = trayItemArray[n6];
                        if (trayItem != null && trayItem.id == n3) {
                            return trayItem.messageProc(n, n2, n3, n4);
                        }
                        ++n6;
                    }
                }
                return 0;
            }
            case 28: {
                int n7;
                Object object;
                if (n3 == 0) break;
                if (this.modalDialogShell != null && this.modalDialogShell.isDisposed()) {
                    this.modalDialogShell = null;
                }
                Object object2 = object = this.modalDialogShell != null ? this.modalDialogShell : this.getModalShell();
                if (object == null) break;
                int n8 = ((Shell)object).handle;
                if (OS.IsWindowEnabled(n8)) {
                    ((Decorations)object).bringToTop();
                }
                if ((n7 = OS.GetLastActivePopup(n8)) == 0 || n7 == ((Shell)object).handle || this.getControl(n7) != null || !OS.IsWindowEnabled(n7)) break;
                OS.SetActiveWindow(n7);
                break;
            }
            case 22: {
                if (n3 == 0) break;
                this.dispose();
                System.exit(0);
                break;
            }
            case 17: {
                Object object = new Event();
                this.sendEvent(21, (Event)object);
                if (((Event)object).doit) break;
                return 0;
            }
            case 26: {
                this.updateFont();
                break;
            }
            case 275: {
                this.runTimer(n3);
            }
        }
        if (n2 == SWT_TASKBARCREATED && this.tray != null) {
            TrayItem[] trayItemArray = this.tray.items;
            int n9 = 0;
            while (n9 < trayItemArray.length) {
                TrayItem trayItem = trayItemArray[n9];
                if (trayItem != null) {
                    trayItem.recreate();
                }
                ++n9;
            }
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    int monitorEnumProc(int n, int n2, int n3, int n4) {
        Monitor[] monitorArray;
        if (monitorCount >= monitors.length) {
            monitorArray = new Monitor[monitors.length + 4];
            System.arraycopy(monitors, 0, monitorArray, 0, monitors.length);
            monitors = monitorArray;
        }
        monitorArray = new MONITORINFO();
        monitorArray.cbSize = 40;
        OS.GetMonitorInfo(n, (MONITORINFO)monitorArray);
        Monitor monitor = new Monitor();
        monitor.handle = n;
        monitor.x = monitorArray.rcMonitor_left;
        monitor.y = monitorArray.rcMonitor_top;
        monitor.width = monitorArray.rcMonitor_right - monitorArray.rcMonitor_left;
        monitor.height = monitorArray.rcMonitor_bottom - monitorArray.rcMonitor_top;
        monitor.clientX = monitorArray.rcWork_left;
        monitor.clientY = monitorArray.rcWork_top;
        monitor.clientWidth = monitorArray.rcWork_right - monitorArray.rcWork_left;
        monitor.clientHeight = monitorArray.rcWork_bottom - monitorArray.rcWork_top;
        Display.monitors[Display.monitorCount++] = monitor;
        return 1;
    }

    int msgFilterProc(int n, int n2, int n3) {
        if (!this.ignoreMsgFilter && n >= 0) {
            OS.MoveMemory(this.hookMsg, n3, 28);
            if (this.hookMsg.message == 0 && this.runAsyncMessages()) {
                this.wakeThread();
            }
        }
        return OS.CallNextHookEx(this.filterHook, n, n2, n3);
    }

    int numpadKey(int n) {
        switch (n) {
            case 96: {
                return 48;
            }
            case 97: {
                return 49;
            }
            case 98: {
                return 50;
            }
            case 99: {
                return 51;
            }
            case 100: {
                return 52;
            }
            case 101: {
                return 53;
            }
            case 102: {
                return 54;
            }
            case 103: {
                return 55;
            }
            case 104: {
                return 56;
            }
            case 105: {
                return 57;
            }
            case 106: {
                return 42;
            }
            case 107: {
                return 43;
            }
            case 108: {
                return 0;
            }
            case 109: {
                return 45;
            }
            case 110: {
                return 46;
            }
            case 111: {
                return 47;
            }
        }
        return 0;
    }

    public boolean post(Event event) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (event == null) {
            this.error(4);
        }
        int n = event.type;
        switch (n) {
            case 1: 
            case 2: {
                KEYBDINPUT kEYBDINPUT = new KEYBDINPUT();
                kEYBDINPUT.wVk = (short)Display.untranslateKey(event.keyCode);
                if (kEYBDINPUT.wVk == 0) {
                    char c = event.character;
                    switch (c) {
                        case '\u001b': {
                            kEYBDINPUT.wVk = (short)27;
                            break;
                        }
                        case '\u007f': {
                            kEYBDINPUT.wVk = (short)46;
                            break;
                        }
                        default: {
                            if (OS.IsWinCE) {
                                kEYBDINPUT.wVk = OS.CharUpper((short)c);
                                break;
                            }
                            kEYBDINPUT.wVk = OS.VkKeyScan((short)Display.wcsToMbcs(c, 0));
                            if (kEYBDINPUT.wVk != -1) break;
                            return false;
                        }
                    }
                }
                kEYBDINPUT.dwFlags = n == 2 ? 2 : 0;
                int n3 = OS.GetProcessHeap();
                int n4 = OS.HeapAlloc(n3, 8, 28);
                OS.MoveMemory(n4, new int[]{1}, 4);
                OS.MoveMemory(n4 + 4, kEYBDINPUT, 16);
                boolean bl = OS.SendInput(1, n4, 28) != 0;
                OS.HeapFree(n3, 0, n4);
                return bl;
            }
            case 3: 
            case 4: 
            case 5: {
                MOUSEINPUT mOUSEINPUT = new MOUSEINPUT();
                if (n == 5) {
                    mOUSEINPUT.dwFlags = 32769;
                    mOUSEINPUT.dx = event.x * 65535 / (OS.GetSystemMetrics(0) - 1);
                    mOUSEINPUT.dy = event.y * 65535 / (OS.GetSystemMetrics(1) - 1);
                } else {
                    switch (event.button) {
                        case 1: {
                            mOUSEINPUT.dwFlags = n == 3 ? 2 : 4;
                            break;
                        }
                        case 2: {
                            mOUSEINPUT.dwFlags = n == 3 ? 32 : 64;
                            break;
                        }
                        case 3: {
                            mOUSEINPUT.dwFlags = n == 3 ? 8 : 16;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                int n2 = OS.GetProcessHeap();
                int n3 = OS.HeapAlloc(n2, 8, 28);
                OS.MoveMemory(n3, new int[1], 4);
                OS.MoveMemory(n3 + 4, mOUSEINPUT, 24);
                boolean bl = OS.SendInput(1, n3, 28) != 0;
                OS.HeapFree(n2, 0, n3);
                return bl;
            }
        }
        return false;
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n = 0;
        int n2 = this.eventQueue.length;
        while (n < n2) {
            if (this.eventQueue[n] == null) break;
            ++n;
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.drawMenuBars();
        this.runPopups();
        if (OS.PeekMessage(this.msg, 0, 0, 0, 1)) {
            if (!this.filterMessage(this.msg)) {
                OS.TranslateMessage(this.msg);
                OS.DispatchMessage(this.msg);
            }
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages();
    }

    static synchronized void register(Display display) {
        int n = 0;
        while (n < Displays.length) {
            if (Displays[n] == null) {
                Display.Displays[n] = display;
                return;
            }
            ++n;
        }
        Display[] displayArray = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
        displayArray[Display.Displays.length] = display;
        Displays = displayArray;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++n;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            n = 0;
            while (n < this.disposeList.length) {
                if (this.disposeList[n] != null) {
                    this.disposeList[n].run();
                }
                ++n;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int n;
        if (this.embeddedHwnd != 0) {
            OS.PostMessage(this.embeddedHwnd, 32771, 0, 0);
        }
        if (!OS.IsWinCE) {
            if (this.msgHook != 0) {
                OS.UnhookWindowsHookEx(this.msgHook);
            }
            this.msgHook = 0;
        }
        if (!OS.IsWinCE) {
            if (this.filterHook != 0) {
                OS.UnhookWindowsHookEx(this.filterHook);
            }
            this.filterHook = 0;
            this.msgFilterCallback.dispose();
            this.msgFilterCallback = null;
            this.msgFilterProc = 0;
        }
        if (this.hwndMessage != 0) {
            OS.DestroyWindow(this.hwndMessage);
        }
        this.hwndMessage = 0;
        this.messageCallback.dispose();
        this.messageCallback = null;
        this.messageProc = 0;
        int n2 = OS.GetProcessHeap();
        int n3 = OS.GetModuleHandle(null);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, this.windowClass, wNDCLASS);
        OS.UnregisterClass(this.windowClass, n3);
        OS.HeapFree(n2, 0, wNDCLASS.lpszClassName);
        this.windowClass = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.windowProc = 0;
        if (this.systemFonts != null) {
            n = 0;
            while (n < this.systemFonts.length) {
                if (this.systemFonts[n] != 0) {
                    OS.DeleteObject(this.systemFonts[n]);
                }
                ++n;
            }
        }
        this.systemFonts = null;
        if (this.errorIcon != 0) {
            OS.DestroyIcon(this.errorIcon);
        }
        if (this.infoIcon != 0) {
            OS.DestroyIcon(this.infoIcon);
        }
        if (this.questionIcon != 0) {
            OS.DestroyIcon(this.questionIcon);
        }
        if (this.warningIcon != 0) {
            OS.DestroyIcon(this.warningIcon);
        }
        this.warningIcon = 0;
        this.questionIcon = 0;
        this.infoIcon = 0;
        this.errorIcon = 0;
        n = 0;
        while (n < this.cursors.length) {
            if (this.cursors[n] != null) {
                this.cursors[n].dispose();
            }
            ++n;
        }
        this.cursors = null;
        if (this.lpCustColors != 0) {
            OS.HeapFree(n2, 0, this.lpCustColors);
        }
        this.lpCustColors = 0;
        this.thread = null;
        this.msg = null;
        this.keyboard = null;
        this.modalDialogShell = null;
        this.modalShells = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.popups = null;
        this.bars = null;
        this.indexTable = null;
        this.controlTable = null;
        this.lastHittestControl = null;
        this.toolDisabledImageList = null;
        this.toolHotImageList = null;
        this.toolImageList = null;
        this.imageList = null;
    }

    void releaseImageList(ImageList imageList) {
        int n = 0;
        int n2 = this.imageList.length;
        while (n < n2) {
            if (this.imageList[n] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.imageList, n + 1, this.imageList, n, --n2 - n);
                this.imageList[n2] = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.imageList[n3] != null) {
                        return;
                    }
                    ++n3;
                }
                this.imageList = null;
                return;
            }
            ++n;
        }
    }

    void releaseToolImageList(ImageList imageList) {
        int n = 0;
        int n2 = this.toolImageList.length;
        while (n < n2) {
            if (this.toolImageList[n] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolImageList, n + 1, this.toolImageList, n, --n2 - n);
                this.toolImageList[n2] = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.toolImageList[n3] != null) {
                        return;
                    }
                    ++n3;
                }
                this.toolImageList = null;
                return;
            }
            ++n;
        }
    }

    void releaseToolHotImageList(ImageList imageList) {
        int n = 0;
        int n2 = this.toolHotImageList.length;
        while (n < n2) {
            if (this.toolHotImageList[n] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolHotImageList, n + 1, this.toolHotImageList, n, --n2 - n);
                this.toolHotImageList[n2] = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.toolHotImageList[n3] != null) {
                        return;
                    }
                    ++n3;
                }
                this.toolHotImageList = null;
                return;
            }
            ++n;
        }
    }

    void releaseToolDisabledImageList(ImageList imageList) {
        int n = 0;
        int n2 = this.toolDisabledImageList.length;
        while (n < n2) {
            if (this.toolDisabledImageList[n] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolDisabledImageList, n + 1, this.toolDisabledImageList, n, --n2 - n);
                this.toolDisabledImageList[n2] = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.toolDisabledImageList[n3] != null) {
                        return;
                    }
                    ++n3;
                }
                this.toolDisabledImageList = null;
                return;
            }
            ++n;
        }
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    void removeBar(Menu menu) {
        if (this.bars == null) {
            return;
        }
        int n = 0;
        while (n < this.bars.length) {
            if (this.bars[n] == menu) {
                this.bars[n] = null;
                return;
            }
            ++n;
        }
    }

    Control removeControl(int n) {
        if (n == 0) {
            return null;
        }
        Control control = null;
        int n2 = OS.GetWindowLong(n, -21) - 1;
        if (n2 >= 0 && n2 < this.controlTable.length) {
            control = this.controlTable[n2];
            this.controlTable[n2] = null;
            this.indexTable[n2] = this.freeSlot;
            this.freeSlot = n2;
            OS.SetWindowLong(n, -21, 0);
        }
        return control;
    }

    void removeMenuItem(MenuItem menuItem) {
        if (this.items == null) {
            return;
        }
        this.items[menuItem.id - 108] = null;
        menuItem.id = -1;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int n = 0;
        while (n < this.popups.length) {
            if (this.popups[n] == menu) {
                this.popups[n] = null;
                return;
            }
            ++n;
        }
    }

    boolean runAsyncMessages() {
        return this.synchronizer.runAsyncMessages();
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget widget;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.runDeferredEvents();
            menu._setVisible(true);
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    boolean runTimer(int n) {
        if (this.timerList != null && this.timerIds != null) {
            int n2 = 0;
            while (n2 < this.timerIds.length) {
                if (this.timerIds[n2] == n) {
                    OS.KillTimer(this.hwndMessage, this.timerIds[n2]);
                    this.timerIds[n2] = 0;
                    Runnable runnable = this.timerList[n2];
                    this.timerList[n2] = null;
                    if (runnable != null) {
                        runnable.run();
                    }
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public void setCursorLocation(int n, int n2) {
        this.checkDevice();
        OS.SetCursorPos(n, n2);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (object == null) {
            if (this.keys == null) {
                return;
            }
            int n = 0;
            while (n < this.keys.length && !this.keys[n].equals(string)) {
                ++n;
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                this.values[n] = object;
                return;
            }
            ++n;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    public static void setAppName(String string) {
    }

    void setModalDialogShell(Shell shell) {
        if (this.modalDialogShell != null && this.modalDialogShell.isDisposed()) {
            this.modalDialogShell = null;
        }
        this.modalDialogShell = shell;
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            shellArray[n].updateModal();
            ++n;
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n = 0;
        int n2 = this.modalShells.length;
        while (n < n2) {
            if (this.modalShells[n] == shell) {
                return;
            }
            if (this.modalShells[n] == null) break;
            ++n;
        }
        if (n == n2) {
            shellArray = new Shell[n2 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n2);
            this.modalShells = shellArray;
        }
        this.modalShells[n] = shell;
        shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            shellArray[n3].updateModal();
            ++n3;
        }
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages();
        }
        this.synchronizer = synchronizer;
    }

    int shiftedKey(int n) {
        if (OS.IsWinCE) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.keyboard.length) {
            this.keyboard[n2] = 0;
            ++n2;
        }
        this.keyboard[16] = (byte)(this.keyboard[16] | 0x80);
        if (OS.IsUnicode) {
            char[] cArray = new char[1];
            if (OS.ToUnicode(n, n, this.keyboard, cArray, 1, 0) == 1) {
                return cArray[0];
            }
        } else {
            short[] sArray = new short[1];
            if (OS.ToAscii(n, n, this.keyboard, sArray, 0) == 1) {
                return sArray[0];
            }
        }
        return 0;
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        if (OS.IsWinCE) {
            OS.MsgWaitForMultipleObjectsEx(0, 0, -1, 127, 4);
            return true;
        }
        return OS.WaitMessage();
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    int systemFont() {
        int n;
        int n2 = 0;
        if (this.systemFonts != null && (n = this.systemFonts.length) != 0) {
            n2 = this.systemFonts[n - 1];
        }
        if (n2 == 0) {
            n2 = OS.GetStockObject(17);
        }
        if (n2 == 0) {
            n2 = OS.GetStockObject(13);
        }
        return n2;
    }

    public void timerExec(int n, Runnable runnable) {
        int n2;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int n3 = 0;
        while (n3 < this.timerList.length) {
            if (this.timerList[n3] == runnable) break;
            ++n3;
        }
        int n4 = 0;
        if (n3 != this.timerList.length) {
            n4 = this.timerIds[n3];
            if (n < 0) {
                OS.KillTimer(this.hwndMessage, n4);
                this.timerList[n3] = null;
                this.timerIds[n3] = 0;
                return;
            }
        } else {
            if (n < 0) {
                return;
            }
            n3 = 0;
            while (n3 < this.timerList.length) {
                if (this.timerList[n3] == null) break;
                ++n3;
            }
            ++this.timerCount;
            n4 = this.timerCount;
            if (n3 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                int[] nArray = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
                this.timerIds = nArray;
            }
        }
        if ((n2 = OS.SetTimer(this.hwndMessage, n4, n, 0)) != 0) {
            this.timerList[n3] = runnable;
            this.timerIds[n3] = n2;
        }
    }

    boolean translateAccelerator(MSG mSG, Control control) {
        this.accelKeyHit = true;
        boolean bl = control.translateAccelerator(mSG);
        this.accelKeyHit = false;
        return bl;
    }

    static int translateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][0] == n) {
                return KeyTable[n2][1];
            }
            ++n2;
        }
        return 0;
    }

    boolean translateMnemonic(MSG mSG, Control control) {
        switch (mSG.message) {
            case 258: 
            case 262: {
                return control.translateMnemonic(mSG);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG mSG, Control control) {
        switch (mSG.message) {
            case 256: {
                switch (mSG.wParam) {
                    case 9: 
                    case 13: 
                    case 27: 
                    case 33: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        return control.translateTraversal(mSG);
                    }
                }
                break;
            }
            case 260: {
                switch (mSG.wParam) {
                    case 18: {
                        return control.translateTraversal(mSG);
                    }
                }
            }
        }
        return false;
    }

    static int untranslateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][1] == n) {
                return KeyTable[n2][0];
            }
            ++n2;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++n;
        }
    }

    void updateFont() {
        if (OS.IsWinCE) {
            return;
        }
        Font font = this.getSystemFont();
        int n = 0;
        NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
        nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
        if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
            n = OS.CreateFontIndirect(OS.IsUnicode ? nONCLIENTMETRICS.lfMessageFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfMessageFont);
        }
        if (n == 0) {
            n = OS.GetStockObject(17);
        }
        if (n == 0) {
            n = OS.GetStockObject(13);
        }
        if (n == 0) {
            return;
        }
        int n2 = this.systemFonts == null ? 0 : this.systemFonts.length;
        int[] nArray = new int[n2 + 1];
        if (this.systemFonts != null) {
            System.arraycopy(this.systemFonts, 0, nArray, 0, n2);
        }
        nArray[n2] = n;
        this.systemFonts = nArray;
        Font font2 = this.getSystemFont();
        Shell[] shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            Shell shell = shellArray[n3];
            if (!shell.isDisposed()) {
                shell.updateFont(font, font2);
            }
            ++n3;
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        this.wakeThread();
    }

    void wakeThread() {
        if (OS.IsWinCE) {
            OS.PostMessage(this.hwndMessage, 0, 0, 0);
        } else {
            OS.PostThreadMessage(this.threadId, 0, 0, 0);
        }
    }

    static int wcsToMbcs(char c, int n) {
        if (OS.IsUnicode) {
            return c;
        }
        if (c <= '\u007f') {
            return c;
        }
        TCHAR tCHAR = new TCHAR(n, c, false);
        return tCHAR.tcharAt(0);
    }

    static int wcsToMbcs(char c) {
        return Display.wcsToMbcs(c, 0);
    }

    int windowProc(int n, int n2, int n3, int n4) {
        Control control;
        int n5 = OS.GetWindowLong(n, -21) - 1;
        if (n5 >= 0 && n5 < this.controlTable.length && (control = this.controlTable[n5]) != null) {
            return control.windowProc(n, n2, n3, n4);
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    static String withCrLf(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(10, 0);
        if (n2 == -1) {
            return string;
        }
        if (n2 > 0 && string.charAt(n2 - 1) == '\r') {
            return string;
        }
        ++n2;
        int n3 = 1;
        while (n2 < n) {
            if ((n2 = string.indexOf(10, n2)) == -1) break;
            ++n3;
            ++n2;
        }
        n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(n3 += n);
        while (n2 < n) {
            int n4 = string.indexOf(10, n2);
            if (n4 == -1) {
                n4 = n;
            }
            stringBuffer.append(string.substring(n2, n4));
            n2 = n4;
            if (n2 >= n) continue;
            stringBuffer.append("\r\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

