package test.contrib.bug282;

// Substance test: check receiving ENTER key in TextField

import java.awt.*;

import javax.swing.*;
import javax.swing.text.*;

public class TestWindow extends JFrame {
	private TextField tf;

	public TestWindow() {
		setTitle("Test Window");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		JButton calcPB = new JButton("");

		tf = new TextField(30, calcPB);

		Container pane = getContentPane();
		pane.add(tf, BorderLayout.CENTER);
		pack();

		Dimension bounds = Toolkit.getDefaultToolkit().getScreenSize();
		Rectangle abounds = getBounds();

		setLocation((bounds.width - abounds.width) / 2,
				(bounds.height - abounds.height) / 2);
		tf.requestFocus();
		setVisible(true);
	}

	// Note: this class should be rewriten properly to work in Java:
	// createDefaultModel() gets called before this.button has a value
	// The original code in Jython allows one to defer the superclass
	// initialization until after this.button is initialized.
	// The "button" part has no impact on the current test.
	class TextField extends JTextField {
		private AbstractButton button;

		public TextField(int cols, AbstractButton button) {
			super(cols);
			this.button = button;
			setForeground(Color.green);
			setBackground(Color.black);
			setCaretColor(Color.green);
			setFont(new Font("Monospaced", Font.BOLD, 18));
			setKeymap(JTextComponent.getKeymap("TextFieldScannableMap"));
		}

		@Override
		protected Document createDefaultModel() {
			return new TextFieldModel(button);
		}
	}

	class TextFieldModel extends PlainDocument {
		private AbstractButton button;

		public TextFieldModel(AbstractButton button) {
			this.button = button;
		}

		@Override
		public void insertString(int offs, String str, AttributeSet a)
				throws BadLocationException {
			if (str == null) {
				System.out.println("Received null string");
				return;
			}

			System.out.println("Received [" + str + "]");

			if (str.endsWith("=") || str.endsWith("\n")) {
				super.insertString(offs, " =", a);
				System.out.println("Button click");
			} else
				super.insertString(offs, str, a);
		}
	}
}