package test.contrib;

import java.io.File;
import java.lang.reflect.Method;
import java.net.*;
import java.security.*;
import java.security.cert.Certificate;
import java.util.PropertyPermission;

/**
 *
 */
public class TestLoaderWithLAF
{
	public void run()
	{
		Policy policy = new AllPrivilegesPolicy();
		Policy.setPolicy( policy );

		System.setSecurityManager(new SecurityManager());

        DemoClassLoader classLoader = new DemoClassLoader(getClass().getClassLoader());

		try
		{
			Class swingSet2Class = classLoader.loadClass("SwingSet2");

			Method mainMethod = swingSet2Class.getMethod("main", new Class[]{new String[0].getClass()});
			mainMethod.invoke(null, new Object[]{new String[]{}});
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}

	public static void main( String[] args )
	{
		new TestLoaderWithLAF().run();
	}

	private static class DemoClassLoader extends URLClassLoader
	{
		DemoClassLoader(ClassLoader parent)
		{
			super(new URL[]{}, parent);

			try
			{
				addURL(new File("SwingSet2.jar").toURI().toURL());
			}
			catch(MalformedURLException ex)
			{
				ex.printStackTrace();
			}
		}
/*
		public PermissionCollection getPermissions(CodeSource codesource)
		{
			return new Permissions();
		}
*/
	}

	private class AllPrivilegesPolicy extends Policy
	{
		private PermissionCollection allPermissions_;
		private PermissionCollection demoPermissions_;

		private CodeSource demoCode_;

		public AllPrivilegesPolicy()
		{
			allPermissions_ = new Permissions();
			allPermissions_.add(new AllPermission());

			demoPermissions_ = new Permissions();
			demoPermissions_.add(new RuntimePermission( "exitVM" ));
            demoPermissions_.add(new PropertyPermission( "*", "read" ));

			// Add read permissions on the Java installation directories to be able to use substance
			//
			// demoPermissions_.add( new FilePermission( System.getProperty("java.home") + "/-", "read" ) );

			try
			{
				demoCode_ = new CodeSource(new File("SwingSet2.jar").toURI().toURL(), (Certificate[])null );
			}
			catch(Exception ex )
			{
				ex.printStackTrace();
			}
		}

		public PermissionCollection getPermissions( CodeSource codesource )
		{
			if(demoCode_.implies(codesource))
				return demoPermissions_;

			return allPermissions_;
		}

		public PermissionCollection getPermissions( ProtectionDomain domain )
		{
			return super.getPermissions(domain);
		}

		public void refresh()
		{
		}
	}
}
