package test.contrib;

/*
 * SubstanceTest.java
 *
 * Created on February 7, 2007, 5:14 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

/**
 *
 * @author Aaron Bruegl
 */

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Map;

import javax.swing.*;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.SkinInfo;
import org.jvnet.substance.skin.SubstanceSkin;

public class RendererTest extends JFrame {
	JTable table;

	public RendererTest() {
		Object[] columnNames = { "Type", "Company", "Shares", "Price" };
		Object[][] data = { { "Buy", "IBM", new Date(), new Double(80.50) },
				{ "Sell", "MicroSoft", new Date(), new Double(6.25) },
				{ "Sell", "Apple", new Date(), new Double(7.35) },
				{ "Buy", "Nortel", new Date(), new Double(20.00) } };

		DefaultTableModel model = new DefaultTableModel(data, columnNames);
		table = new JTable(model);
		try {
			table.setDefaultRenderer(Class.forName("java.lang.Object"),
					new CustomTableCellRenderer());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		table.setPreferredScrollableViewportSize(table.getPreferredSize());
		JScrollPane scrollPane = new JScrollPane(table);
		add(scrollPane);
		JMenuBar bar = new JMenuBar();
		bar.add(getSkinMenu());
		setJMenuBar(bar);
	}

	private JMenu getSkinMenu() {
		JMenu jmSkin = new JMenu("Skins");

		JMenuItem defaultSkin = new JMenuItem("Default");
		defaultSkin.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// UIManager.setLookAndFeel(new
				// SubstanceDefaultLookAndFeel());
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							UIManager.setLookAndFeel(new MetalLookAndFeel());
						} catch (UnsupportedLookAndFeelException ex) {
							ex.printStackTrace();
						}
						SwingUtilities.updateComponentTreeUI(RendererTest.this);
					}
				});
			}
		});
		jmSkin.add(defaultSkin);
		jmSkin.addSeparator();

		Map<String, SkinInfo> skinMap = SubstanceLookAndFeel.getAllSkins();
		for (final Map.Entry<String, SkinInfo> entry : skinMap.entrySet()) {
			JMenuItem jmiSkin = new JMenuItem(entry.getValue().getDisplayName());
			jmiSkin.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					SubstanceLookAndFeel.setSkin(entry.getValue()
							.getClassName());
				}
			});

			try {
				SubstanceSkin skin = ((SubstanceSkin) Class.forName(
						entry.getValue().getClassName()).newInstance());
				// jmiSkin.setIcon(new
				// ImageIcon(SubstanceImageCreator.getThemeImage(new
				// ImageIcon(this.getClass().getClassLoader().getResource("image-x-generic.png")),skin.getTheme(),
				// false)));
			} catch (Exception exc) {
				exc.printStackTrace();
			}

			jmSkin.add(jmiSkin);
		}
		return jmSkin;
	}

	class CustomTableCellRenderer extends DefaultTableCellRenderer {
		public Component getTableCellRendererComponent(JTable table,
				Object value, boolean isSelected, boolean hasFocus, int row,
				int column) {
			Component cell = super.getTableCellRendererComponent(table, value,
					isSelected, hasFocus, row, column);

			if (value != null && value instanceof Date) {
				super.setValue("date overridden");
			}

			return cell;
		}
	}

	public static void main(String[] args) {
		try {
			System.setProperty("substancelaf.gradientPainter",
					"org.jvnet.substance.painter.WaveGradientPainter");
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
			// UIManager.setLookAndFeel(new WindowsLookAndFeel());
		} catch (UnsupportedLookAndFeelException e) {
			e.printStackTrace();
		}

		RendererTest frame = new RendererTest();
		frame.setDefaultCloseOperation(EXIT_ON_CLOSE);
		frame.pack();
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}
}