package test.contrib;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.StringTokenizer;

import javax.swing.*;
import javax.swing.border.EmptyBorder;

import org.jvnet.substance.skin.SubstanceCremeLookAndFeel;

public class JListTestCase {

    public static void main(String[] args) throws Exception {
    UIManager.setLookAndFeel(new SubstanceCremeLookAndFeel());
    JFrame frame = new JFrame("JList");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    // frame.setSize(1000, 650);
    // frame.setLocationByPlatform(true);
    // frame.setLocationRelativeTo(null);
    frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
    frame.setExtendedState(JFrame.MAXIMIZED_BOTH);
    JList list = new JList(new String[] { "Person", "Data Item" });
    list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    list.setLayoutOrientation(JList.HORIZONTAL_WRAP);
    list.setVisibleRowCount(-1);
    list.setCellRenderer(new JPListCellRenderer());
    frame.setContentPane(new JScrollPane(list));
    frame.setVisible(true);
    }

    public static class JPListCellRenderer extends DefaultListCellRenderer {

    public JPListCellRenderer() {
        setHorizontalTextPosition(SwingConstants.CENTER);
        setVerticalTextPosition(SwingConstants.BOTTOM);
        setIconTextGap(2);
        setBorder(new EmptyBorder(4, 4, 4, 4));
        setHorizontalAlignment(SwingConstants.CENTER);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
        int index, boolean isSelected, boolean cellHasFocus) {
        // NOTE: place the icon here
        // setIcon(LFManager.FAMILY_DOCUMENT);
        setText(value.toString());
        setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
        setBackground(list.getSelectionBackground());
        setForeground(list.getSelectionForeground());
        } else {
        setBackground(list.getBackground());
        setForeground(list.getForeground());
        }
        setEnabled(list.isEnabled());
        setFont(list.getFont());
        return this;
    }

    public static final int LINE_TOKENS_COUNT = 8;

    @Override
    public void setText(String text) {
        if (text != null) {
        text = text.trim();
        StringTokenizer st = new StringTokenizer(text, " ");
        StringBuffer sb = new StringBuffer();
        sb.append("<html><center>");
        int pos = 0;
        while (st.hasMoreElements()) {
            String t = st.nextToken();
            if (pos == 0) {
            sb.append(t);
            } else {
            if (pos > LINE_TOKENS_COUNT) {
                sb.append("<br>");
                sb.append(t);
                pos = 0;
            } else {
                sb.append(' ');
                sb.append(t);
            }
            }
            pos += t.length();
        }
        sb.append("</center></html>");
        // original = text;
        super.setText(sb.toString());
        }
    }

    }
}