package test.contrib;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import org.jvnet.substance.SubstanceLookAndFeel;

/*
 * InternalFrameDemo.java requires:
 *   MyInternalFrame.java
 */

public class InternalFrameDemo extends JFrame {
	private Runtime runtime = Runtime.getRuntime();
	private JDesktopPane desktop;
	private ArrayList<JInternalFrame> frames = new ArrayList<JInternalFrame>();
	private JLabel repaintCount;
	private int repaints;

	public InternalFrameDemo() {
		super("InternalFrameDemo");

		// Make the big window be indented 50 pixels from each edge
		// of the screen.
		int inset = 50;
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height
				- inset * 2);

		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		setContentPane(panel);

		JPanel status = new JPanel();
		status.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
		status.add(new JLabel("Repaints/sec: "));
		repaintCount = new JLabel();
		status.add(repaintCount);

		// Set up the GUI.
		desktop = new JDesktopPane(); // a specialized layered pane
		panel.add(createToolBar(), BorderLayout.NORTH);
		panel.add(desktop, BorderLayout.CENTER);
		panel.add(status, BorderLayout.SOUTH);

		// panel.putClientProperty(SubstanceLookAndFeel.WATERMARK_IGNORE,
		// Boolean.TRUE);

		// Set up the repaint count timer
		java.util.Timer repaintTimer = new java.util.Timer();
		repaintTimer.schedule(new TimerTask() {
			public void run() {
				repaintCount.setText(String.valueOf(repaints));
				repaints = 0;
			}
		}, 0, 1000);

		// Make dragging a little faster but perhaps uglier.
		// desktop.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
	}

	// Create a new internal frame.
	protected void createFrame() {
		MyInternalFrame frame = new MyInternalFrame();
		frame.setVisible(true); // necessary as of 1.3
		desktop.add(frame);
		try {
			frame.setSelected(true);
			frame.moveToFront();
		} catch (java.beans.PropertyVetoException e) {
		}
		frames.add(frame);
	}

	/**
	 * Create the GUI and show it. For thread safety, this method should be
	 * invoked from the event-dispatching thread.
	 */
	private static void createAndShowGUI() {
		// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
		// UIManager.put(SubstanceLookAndFeel.NO_EXTRA_ELEMENTS, Boolean.TRUE);
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (UnsupportedLookAndFeelException e) {
			// Do nothing
		}
		JDialog.setDefaultLookAndFeelDecorated(true);
		// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

		// Make sure we have nice window decorations.
		JFrame.setDefaultLookAndFeelDecorated(true);

		// Create and set up the window.
		InternalFrameDemo frame = new InternalFrameDemo();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// Display the window.
		frame.setVisible(true);
	}

	private JToolBar createToolBar() {
		JToolBar toolBar = new JToolBar();
		JButton button;
		button = new JButton("New Window");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				createFrame();
			}
		});
		toolBar.add(button);
		button = new JButton("Cascade");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cascade();
			}
		});
		toolBar.add(button);
		button = new JButton("Tile");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				tileHorizontally();
			}
		});
		toolBar.add(button);
		button = new JButton("Stack");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				stack();
			}
		});
		toolBar.add(button);

		toolBar.setName("Test ToolBar");
		toolBar.setFloatable(false);
		toolBar.setAlignmentX(Component.LEFT_ALIGNMENT);
		toolBar.setRollover(true);
		return toolBar;
	}

	// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	public static void main(String[] args) {
		// Schedule a job for the event-dispatching thread:
		// creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}

	private void cascade() {
		int x = 0;
		int y = 0;
		int width = desktop.getWidth() / 2;
		int height = desktop.getHeight() / 2;

		for (JInternalFrame frame : frames) {
			if (!frame.isIcon()) {
				try {
					// try to make maximized frames resizable; this might be
					// vetoed
					frame.setMaximum(false);
					frame.reshape(x, y, width, height);
					frame.moveToFront();
					x += xOffset;
					y += yOffset;
					// wrap around at the desktop edge
					if (x + width > desktop.getWidth())
						x = 0;
					if (y + height > desktop.getHeight())
						y = 0;
				} catch (PropertyVetoException e) {
				}
			}
		}
	}

	private void tileHorizontally() {
		// count frames that aren't iconized
		int frameCount = 0;
		for (JInternalFrame frame : frames) {
			if (!frame.isIcon())
				frameCount++;
		}
		if (frameCount == 0)
			return;

		int cols = (int) Math.sqrt(frameCount);
		int rows = frameCount / cols;
		int extra = frameCount % cols;
		// number of columns with an extra row

		int width = desktop.getWidth() / cols;
		int height = desktop.getHeight() / rows;
		int r = 0;
		int c = 0;
		for (JInternalFrame frame : desktop.getAllFrames()) {
			if (!frame.isIcon()) {
				try {
					frame.setMaximum(false);
					frame.reshape(c * width, r * height, width, height);
					c++;
					if (c == cols) {
						c = 0;
						r++;
						if (r == rows - extra) {
							// start adding an extra column
							cols++;
							width = desktop.getWidth() / cols;
						}
					}
				} catch (PropertyVetoException e) {
				}
			}
		}
	}

	private void stack() {
		JInternalFrame selectedFrame = null;
		for (JInternalFrame frame : frames) {
			if (!frame.isIcon()) {
				try {
					// try to make maximized frames resizable; this might be
					// vetoed

					if (frame.isSelected()) {
						selectedFrame = frame;
					} else {
						frame.setMaximum(true);
					}
				} catch (PropertyVetoException e) {
				}
			}
		}
		// Set the selected frame to be on top of the stack by maximizing it
		// last of all.
		if (selectedFrame != null) {
			try {
				selectedFrame.setMaximum(true);
			} catch (PropertyVetoException e) {

			}
		}
	}

	static final int xOffset = 30, yOffset = 30;
	static int openFrameCount = 0;

	private class MyInternalFrame extends JInternalFrame {
		private MyLabel currentTime;
		private java.util.Timer currentTimer;

		public MyInternalFrame() {
			super("Document #" + (++openFrameCount), true, // resizable
					true, // closable
					true, // maximizable
					true);// iconifiable

			// ...Create the GUI and put it in the window...
			add(createMainPanel(), BorderLayout.CENTER);

			// ...Then set the window size or call pack...
			int width = desktop.getWidth() / 2;
			int height = desktop.getHeight() / 2;
			setSize(width, height);

			// Set the window's location.
			setLocation(xOffset * (openFrameCount - 1), yOffset
					* (openFrameCount - 1));

			// Set up the timer to refresh the current time.
			currentTimer = new java.util.Timer();
			currentTimer.schedule(new TimerTask() {
				public void run() {
					// Date date = new Date();
					// SimpleDateFormat dateFormat = new SimpleDateFormat(
					// "hh:mm:ss.SSS");
					// String timestamp = dateFormat.format(date);
					// currentTime.setText(timestamp);
//					currentTime.paintImmediately(0, 0, currentTime.getWidth(),
//							currentTime.getHeight());
					// currentTime.revalidate();
					// repaints++;
				}
			}, 10, 100);

			// Set the close operation
			this.addInternalFrameListener(new InternalFrameAdapter() {
				public void internalFrameClosed(InternalFrameEvent e) {
					currentTimer.cancel();
				}
			});
		}

		private JPanel createMainPanel() {
			JPanel panel = new JPanel();
			panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
			currentTime = new MyLabel();
			currentTime.setAlignmentX(JLabel.CENTER_ALIGNMENT);
			Date date = new Date();
			SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss.SSS");
			String timestamp = dateFormat.format(date);
			currentTime.setText(timestamp);
			panel.add(Box.createVerticalStrut(50));
			panel.add(currentTime);
			return panel;
		}

		@Override
		public void paint(Graphics g) {
			super.paint(g);
		}
	}

	private class MyLabel extends JLabel {
		protected void paintComponent(Graphics g) {
			long start = System.nanoTime();
			repaints++;
			super.paintComponent(g);
			long end = System.nanoTime();
			System.out.println("Label [" + this.getWidth() + ":"
					+ this.getHeight() + "] in " + (end - start));
			Component c = this;
			while (c != null) {
				if (c instanceof JComponent) {
					JComponent jc = (JComponent) c;
					System.out.println(jc.getClass().getSimpleName() + ":"
							+ jc.isOpaque());
				} else {
					System.out.println(c.getClass().getSimpleName());
				}
				c = c.getParent();
			}
		}
	}
}
