package test.contrib;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.*;

import org.jvnet.substance.SubstanceDefaultComboBoxRenderer;
import org.jvnet.substance.SubstanceLookAndFeel;

public class CustomComboRTL extends JFrame {

	private static final long serialVersionUID = -982798754720311902L;

	public CustomComboRTL() {
		JComboBox comboBox = new JComboBox(new String[] { "Test1", "Test2",
				"Test3", "Test4", "Test5", "Test6", "Test7", "Test8", "Test9",
				"Test10" });

		comboBox.setRenderer(new SubstanceDefaultComboBoxRenderer(comboBox) {
			private static final long serialVersionUID = 2629717016682715818L;

			@Override
			public Component getListCellRendererComponent(JList list,
					Object value, int index, boolean isSelected,
					boolean hasFocus) {
				Component c = super.getListCellRendererComponent(list, value,
						index, isSelected, hasFocus);
				try {
					((JLabel) c).setIcon(new ImageIcon(ImageIO.read(getClass()
							.getResource("/test/resource/computer.png"))));
				} catch (IOException e) {
					e.printStackTrace();
				}
				return c;
			}
		});

		add(comboBox);
		setLocationRelativeTo(null);
		setSize(200, 60);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					UIManager.setLookAndFeel(new SubstanceLookAndFeel());
				} catch (UnsupportedLookAndFeelException e) {
					e.printStackTrace();
				}
				new CustomComboRTL().setVisible(true);
			}
		});
	}

}
