package test.contrib;

/*
 * TestFrame.java
 *
 * Created on January 31, 2007, 7:12 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.*;

/**
 *
 * @author collin
 */
public class BorderMadness extends JFrame{ 
    private static final String[] matrixItems = {"Trinity","Neo","Morpheus","Cypher","Tank"};
    
    /** Creates a new instance of TestFrame */
    public BorderMadness() {
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        JTabbedPane exampleTabs = new JTabbedPane();
        exampleTabs.add("ComboBox", getComboBoxExample());
        exampleTabs.add("List", getScrollPaneExample());
        setContentPane(exampleTabs);
        pack();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        try {
//            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.setLookAndFeel("org.jvnet.substance.skin.SubstanceModerateLookAndFeel");
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        } catch (InstantiationException ex) {
            ex.printStackTrace();
        } catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        } catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                new BorderMadness().setVisible(true);
            }
        });
    }
    
    private JComponent getComboBoxExample(){
        JPanel comboBoxExample = new JPanel();
        JComboBox matrixCombo = new JComboBox(matrixItems);
        comboBoxExample.setLayout(new BoxLayout(comboBoxExample, BoxLayout.Y_AXIS));
        
        matrixCombo.setBorder(BorderFactory.createCompoundBorder(
                BorderFactory.createTitledBorder("Matrix Characters - Compound Border"), 
                matrixCombo.getBorder()));
        
        comboBoxExample.add(matrixCombo, BorderLayout.NORTH);
        
        JPanel panelBorder = new JPanel();
        panelBorder.setBorder(BorderFactory.createTitledBorder("Matrix Characters - Nested JPanel w/ Border"));
        panelBorder.setLayout(new BorderLayout());
        panelBorder.add(new JComboBox(matrixItems), BorderLayout.NORTH);
        comboBoxExample.add(panelBorder);
        comboBoxExample.add(new JLabel("The Matrix has you"));
        return comboBoxExample;
    }
    
    private JComponent getScrollPaneExample(){
        JPanel listExample = new JPanel();
        listExample.setLayout(new GridLayout(1,2));
        JList matrixList = new JList(matrixItems);
        JScrollPane targetPane = new JScrollPane(matrixList);
        
        targetPane.setBorder(BorderFactory.createCompoundBorder(
                BorderFactory.createTitledBorder("Matrix Characters - Compound Border"), 
                targetPane.getBorder()));
        
        JPanel panelBorder = new JPanel();
        panelBorder.setLayout(new BorderLayout());
        panelBorder.setBorder(BorderFactory.createTitledBorder("Matrix Characters - Nested JPanel w/ Border"));
        panelBorder.add(new JScrollPane(new JList(matrixItems)), BorderLayout.CENTER);
        
        listExample.add(targetPane);
        listExample.add(panelBorder);
        return listExample;
    }
    
}
