package test;

import java.awt.*;

import javax.swing.*;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;

public class TestMenu extends JFrame {
	TestMenu() {
		JMenuBar jmb = new JMenuBar();
		JMenu menu = new JMenu("menu");
		menu.add(new JMenuItem("item1", new Icon() {
			public int getIconHeight() {
				return 16;
			}

			public int getIconWidth() {
				return 16;
			}

			public void paintIcon(Component c, Graphics g, int x, int y) {
				Graphics2D g2 = (Graphics2D) g.create();
				g2.setColor(Color.red);
				g2.fillRect(x, y, 15, 15);
				g2.dispose();
			}
		}));
		menu.add(new JCheckBoxMenuItem("item2", new Icon() {
			public int getIconHeight() {
				return 8;
			}

			public int getIconWidth() {
				return 8;
			}

			public void paintIcon(Component c, Graphics g, int x, int y) {
				Graphics2D g2 = (Graphics2D) g.create();
				g2.setColor(Color.red);
				g2.fillRect(x, y, 7, 7);
				g2.dispose();
			}
		}));
		JRadioButtonMenuItem menuItem3 = new JRadioButtonMenuItem("item3");
		menuItem3.setSelected(true);
		menu.add(menuItem3);
		jmb.add(menu);

		this.setJMenuBar(jmb);

		this.setSize(200, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new WindowsLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TestMenu().setVisible(true);
			}
		});
	}
}
