package test;

import java.awt.*;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;

import org.jvnet.substance.SubstanceDefaultTreeCellRenderer;
import org.jvnet.substance.SubstanceLookAndFeel;

public class SubstanceTreeTest extends JFrame {
	public SubstanceTreeTest() {

		setLayout(new BorderLayout());

		DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
		DefaultMutableTreeNode node = new DefaultMutableTreeNode("Node 1");
		DefaultMutableTreeNode node2 = new DefaultMutableTreeNode("Node 2");
		DefaultMutableTreeNode node3 = new DefaultMutableTreeNode("Node 3");
		root.add(node);
		root.add(node2);
		root.add(node3);
		JTree tree = new JTree(root);
		tree.setCellRenderer(new MyRenderer());

		add(tree, BorderLayout.CENTER);

		setSize(400, 300);
		setLocationRelativeTo(null);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (UnsupportedLookAndFeelException ulafe) {
		}
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				new SubstanceTreeTest().setVisible(true);
			}
		});
	}

	class MyRenderer extends SubstanceDefaultTreeCellRenderer {
		@Override
		public Component getTreeCellRendererComponent(JTree tree, Object value,
				boolean sel, boolean expanded, boolean leaf, int row,
				boolean hasFocus) {
			Component res = super.getTreeCellRendererComponent(tree, value,
					sel, expanded, leaf, row, hasFocus);
			res.setBackground(new Color(220, 220, 220));
			return res;
		}
	}
}