package test;

import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceCremeLookAndFeel;

public class DisposableDialog extends JFrame {
	public DisposableDialog() {
		super("JDialog.dispose() test");
		this.setLayout(new FlowLayout());
		final JDialog dialog = new JDialog((JFrame) null, "Some title");

		final JButton show = new JButton("Show");
		final JButton dispose = new JButton("dispose");
		final JButton hide = new JButton("hide");
		
		show.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dialog.setSize(200, 200);
				Point myLoc = DisposableDialog.this.getLocationOnScreen();
				dialog.setLocation(myLoc.x + DisposableDialog.this.getWidth(),
						myLoc.y);
				dialog.setVisible(true);
			}
		});

		dispose.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dialog.dispose();
			}
		});

		hide.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dialog.setVisible(false);
			}
		});

		this.add(show);
		this.add(dispose);
		this.add(hide);

		this.setSize(200, 100);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceCremeLookAndFeel());
		JFrame.setDefaultLookAndFeelDecorated(true);
		JDialog.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new DisposableDialog().setVisible(true);
			}
		});
	}
}
