package test;

import java.awt.BorderLayout;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.fonts.SubstanceFontUtilities;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;

public class BigCombo extends JFrame {

	public BigCombo() {
		JComboBox comboBox = new JComboBox(new Object[] { "Sample" });
		comboBox.setEditable(true);

		FormLayout layout = new FormLayout("center:pref, 2dlu, center:pref", "");
		DefaultFormBuilder builder = new DefaultFormBuilder(layout);
		builder.setDefaultDialogBorder();

		builder.append(comboBox);

		JButton button = new JButton("Sample", new ImageIcon(BigCombo.class
				.getResource("/test/icons/access.png")));
		builder.append(button);

		JCheckBox checkbox = new JCheckBox("Sample");
		builder.append(checkbox);

		JRadioButton radio = new JRadioButton("Sample");
		builder.append(radio);

		this.add(builder.getPanel(), BorderLayout.CENTER);

		this.setSize(900, 600);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		SubstanceLookAndFeel.setFontPolicy(SubstanceFontUtilities
				.getScaledFontPolicy(6.0f));
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		// FadeConfigurationManager.getInstance().allowFades(FadeKind.FOCUS_LOOP_ANIMATION);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new BigCombo().setVisible(true);
			}
		});
	}

}
