/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.*;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.painter.decoration.BrushedMetalDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants.ColorShiftKind;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;

/**
 * <code>Office Blue 2007</code> skin. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public class OfficeBlue2007Skin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static final String NAME = "Office Blue 2007";

	/**
	 * Creates a new <code>Office Blue 2007</code> skin.
	 */
	public OfficeBlue2007Skin() {
		ColorScheme shiftBlue = new ShiftColorScheme(new AquaColorScheme(),
				new Color(100, 150, 255), 0.3);
		SubstanceTheme activeTheme = new SubstanceOrangeTheme().saturate(0.4);
		SubstanceTheme defaultTheme = new SubstanceTheme(shiftBlue,
				"Aqua Blue", ThemeKind.BRIGHT).saturate(-0.3);

		final ColorScheme disabledScheme = new SaturatedColorScheme(
				new ShiftColorScheme(new AquaColorScheme(), new Color(100, 150,
						255), 0.3), -0.1) {
			Color foreColor = new Color(36, 95, 142);

			@Override
			public Color getForegroundColor() {
				return foreColor;
			}
		};
		SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme,
				"Disabled Office Blue 2007", ThemeKind.COLD);

		SubstanceTheme activeTitleTheme = defaultTheme.saturate(-0.1);

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme) {
			@Override
			public Color getLightBackgroundColor() {
				return disabledTheme.getColorScheme().getExtraLightColor();
			}
		};
		theme.setSelectedTabFadeStart(0.1);
		theme.setSelectedTabFadeEnd(0.3);
		theme.registerComponentStateTheme(disabledTheme, 0.5f, false,
				ComponentState.DISABLED_UNSELECTED);
		theme.registerComponentStateTheme(activeTheme, 0.5f, false,
				ComponentState.DISABLED_SELECTED);
		theme.registerDecorationAreaTheme(activeTitleTheme, false,
				DecorationAreaType.PRIMARY_TITLE_PANE,
				DecorationAreaType.SECONDARY_TITLE_PANE,
				DecorationAreaType.HEADER, DecorationAreaType.GENERAL,
				DecorationAreaType.TOOLBAR);

		this.theme = theme;

		this.buttonShaper = new ClassicButtonShaper();
		this.watermark = new SubstanceStripeWatermark();
		this.gradientPainter = new ClassicGradientPainter();

		BrushedMetalDecorationPainter decorationPainter = new BrushedMetalDecorationPainter();
		decorationPainter.setPaintingSeparators(true);
		decorationPainter.setTextureAlpha(0.3f);
		this.decorationPainter = decorationPainter;

		this.highlightPainter = new ClassicHighlightPainter();

		this.borderPainter = new ClassicInnerBorderPainter(0.8f,
				ColorShiftKind.TINT);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
