/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.plugin;

import java.util.HashSet;
import java.util.Set;

import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;

/**
 * Core plugin for themes. See
 * {@link org.jvnet.substance.plugin.SubstanceThemePlugin} interface. This class
 * is <b>for internal use only</b>.
 * 
 * @author Kirill Grouchnikov.
 */
public class BaseThemePlugin implements SubstanceThemePlugin {
	/**
	 * Creates info object on a single theme.
	 * 
	 * @param themeDisplayName
	 *            Theme display name.
	 * @param themeClass
	 *            Theme class.
	 * @param themeKind
	 *            Theme kind.
	 * @param isDefault
	 *            Indication whether the specified theme is default.
	 * @return Info object on the specified theme.
	 */
	private static ThemeInfo create(String themeDisplayName, Class<?> themeClass,
			ThemeKind themeKind, boolean isDefault) {
		ThemeInfo result = new ThemeInfo(themeDisplayName,
				themeClass.getName(), themeKind);
		result.setDefault(isDefault);
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.plugin.SubstanceThemePlugin#getThemes()
	 */
	public Set<ThemeInfo> getThemes() {
		Set<ThemeInfo> result = new HashSet<ThemeInfo>();
		result
				.add(create(SubstanceAquaTheme.DISPLAY_NAME,
						SubstanceAquaTheme.class,
						SubstanceAquaTheme.THEME_KIND, false));
		result.add(create(SubstanceLightAquaTheme.DISPLAY_NAME,
				SubstanceLightAquaTheme.class,
				SubstanceLightAquaTheme.THEME_KIND, false));
		result.add(create(SubstanceLimeGreenTheme.DISPLAY_NAME,
				SubstanceLimeGreenTheme.class,
				SubstanceLimeGreenTheme.THEME_KIND, false));
		result.add(create(SubstanceBrownTheme.DISPLAY_NAME,
				SubstanceBrownTheme.class, SubstanceBrownTheme.THEME_KIND,
				false));
		result.add(create(SubstanceOrangeTheme.DISPLAY_NAME,
				SubstanceOrangeTheme.class, SubstanceOrangeTheme.THEME_KIND,
				false));
		result.add(create(SubstancePurpleTheme.DISPLAY_NAME,
				SubstancePurpleTheme.class, SubstancePurpleTheme.THEME_KIND,
				false));
		result.add(create(SubstanceSunGlareTheme.DISPLAY_NAME,
				SubstanceSunGlareTheme.class,
				SubstanceSunGlareTheme.THEME_KIND, false));
		result.add(create(SubstanceSunsetTheme.DISPLAY_NAME,
				SubstanceSunsetTheme.class, SubstanceSunsetTheme.THEME_KIND,
				false));
		result.add(create(SubstanceOliveTheme.DISPLAY_NAME,
				SubstanceOliveTheme.class, SubstanceOliveTheme.THEME_KIND,
				false));
		result.add(create(SubstanceTerracottaTheme.DISPLAY_NAME,
				SubstanceTerracottaTheme.class,
				SubstanceTerracottaTheme.THEME_KIND, false));
		result.add(create(SubstanceSepiaTheme.DISPLAY_NAME,
				SubstanceSepiaTheme.class, SubstanceSepiaTheme.THEME_KIND,
				false));
		result.add(create(SubstanceSteelBlueTheme.DISPLAY_NAME,
				SubstanceSteelBlueTheme.class,
				SubstanceSteelBlueTheme.THEME_KIND, false));
		result.add(create(SubstanceEbonyTheme.DISPLAY_NAME,
				SubstanceEbonyTheme.class, SubstanceEbonyTheme.THEME_KIND,
				false));
		result.add(create(SubstanceCharcoalTheme.DISPLAY_NAME,
				SubstanceCharcoalTheme.class,
				SubstanceCharcoalTheme.THEME_KIND, false));
		result.add(create(SubstanceDarkVioletTheme.DISPLAY_NAME,
				SubstanceDarkVioletTheme.class,
				SubstanceDarkVioletTheme.THEME_KIND, false));
		result.add(create(SubstanceUltramarineTheme.DISPLAY_NAME,
				SubstanceUltramarineTheme.class,
				SubstanceUltramarineTheme.THEME_KIND, false));
		result.add(create(SubstanceJadeForestTheme.DISPLAY_NAME,
				SubstanceJadeForestTheme.class,
				SubstanceJadeForestTheme.THEME_KIND, false));
		result.add(create(SubstanceBottleGreenTheme.DISPLAY_NAME,
				SubstanceBottleGreenTheme.class,
				SubstanceBottleGreenTheme.THEME_KIND, false));
		result.add(create(SubstanceRaspberryTheme.DISPLAY_NAME,
				SubstanceRaspberryTheme.class,
				SubstanceRaspberryTheme.THEME_KIND, false));
		result.add(create(SubstanceBarbyPinkTheme.DISPLAY_NAME,
				SubstanceBarbyPinkTheme.class,
				SubstanceBarbyPinkTheme.THEME_KIND, false));
		result.add(create(SubstanceDesertSandTheme.DISPLAY_NAME,
				SubstanceDesertSandTheme.class,
				SubstanceDesertSandTheme.THEME_KIND, false));
		result.add(create(SubstanceCremeTheme.DISPLAY_NAME,
				SubstanceCremeTheme.class,
				SubstanceCremeTheme.THEME_KIND, false));
		return result;
	}

	public String getDefaultThemeClassName() {
		return null;
	}
}
