#ifndef TREEDRAW_H
#define TREEDRAW_H
#include "seaview.h"
#include "FL/Fl_Round_Button.H"
#include "FL/Fl_Button.H"
#include "FL/Fl_Check_Button.H"
#include <FL/Fl_Scrollbar.H>
#include <FL/Fl_Counter.H>
#if 100*FL_MAJOR_VERSION + FL_MINOR_VERSION >= 103
#define HAS_PRINTER
#endif
#if defined(HAS_PRINTER)
#include <FL/Fl_Printer.H>
#endif
#define myrint(x) (int)floor(x + 0.5)

#if defined(__APPLE__)
#include <ApplicationServices/ApplicationServices.h>
#if  (!__LP64__) && MAC_OS_X_VERSION_MAX_ALLOWED < 1070
#define USE_PICT
#endif
#endif

#if defined(HAS_PRINTER)
#if (defined(__APPLE__) || defined(WIN32))

class Fl_Copy_Surface : public Fl_Surface_Device {
#ifdef __APPLE__
  bool use_pict;
  void *data;
#ifdef USE_PICT
  PicHandle mypicture;
#endif
#else
  HDC oldflgc;
#endif
public:
#ifdef __APPLE__
  Fl_Copy_Surface(bool use_pict, int w, int h);
#else
  Fl_Copy_Surface(int w, int h);
#endif
  ~Fl_Copy_Surface();
};
#endif

#ifndef NO_PDF
#include <pdflib.h>
class Fl_PDF_File_Device : public Fl_Paged_Device
{
  int width, height;
  Fl_Surface_Device *previous_surface;
  int left_margin, top_margin;
public:
  char *filename;
  Fl_PDF_File_Device();
  int start_job(const char *name, enum Fl_Paged_Device::Page_Format format=Fl_Paged_Device::A4, 
		enum Fl_Paged_Device::Page_Layout layout=Fl_Paged_Device::PORTRAIT);
  int printable_rect(int *w, int *h);
  int 	start_page (void);
  int 	end_page (void);
  void 	end_job (void);
  PDF *pdf();
  void error_catch();
  ~Fl_PDF_File_Device();
};
#endif
#endif // HAS_PRINTER


#if !(defined(__APPLE__) || defined(WIN32)) && 100*FL_MAJOR_VERSION + 10*FL_MINOR_VERSION  + FL_PATCH_VERSION == 130
// for X11 under 1.3.0 only
#include <FL/Fl_Printer.H>
class corr_Fl_Printer : public Fl_Printer {
  int count, m, M;
public:
  corr_Fl_Printer();
  int start_job(int pagecount, int *frompage=NULL, int *topage=NULL);
  int start_page();
};
#define Fl_Printer corr_Fl_Printer

class corr_Fl_PostScript_File_Device : public Fl_PostScript_File_Device {
  int count, m, M;
public:
  corr_Fl_PostScript_File_Device();
  int start_job (int pagecount, enum Fl_Paged_Device::Page_Format format=Fl_Paged_Device::A4, 
		   enum Fl_Paged_Device::Page_Layout layout=Fl_Paged_Device::PORTRAIT);
  int start_page();
};
#define Fl_PostScript_File_Device corr_Fl_PostScript_File_Device

#endif

struct noeud {
	double l1,l2,l3;
	struct noeud *v1,*v2,*v3;
	char *nom;
	int rank;
};

struct nom {
	double x,y;
	char *nom;
	char disp_option;
};
struct mon_point {
	double x,y;
	int number;
};
struct trait {
	double xd,yd,xf,yf;
};

enum operations {show_tree = 1, depl_racine, permutation, subtree, selection, prune_clade, prune_clade_found};

class tree_panel : public Fl_Widget {
    FL_EXPORT int handle(int);
public:
    FL_EXPORT void draw(void);
    FL_EXPORT tree_panel(int x,int y,int w,int h) :
	Fl_Widget(x,y,w,h,NULL) {
		;
	}
};

struct FD_nj_plot {
	char *tree_name;
	char *tree_label;
	int notu;
	int totbranches;
	int has_br_length;
	int lost_br_lengths;
	int has_internal;
	int root_num;
	int rooted;
	struct noeud **tabtax;
	struct noeud *racine;
	char **labels;
	struct branche *branches;
	struct nom *noms;
	struct trait *traits;
	struct mon_point *points;
	char *br_length_txt;
	int totnoms;
	int totpoints;
	int tottraits;
	double deltay;
	double tek_dx, tek_dy, tek_ymin;
	int show_bootstrap;
	int need_runtree;
	enum operations choix;
	int *widnames;
	double *profs;
	int long_arbre_parenth; /* long de la chaine decrivant l'arbre lu */
	struct noeud *subtree_center, *subtree_ascend;
	int subtree_notu;
	int plot_br_l;
	double root_br_l;
	int char_height;
	int ascent;
	int font_size;
	int font_family;
	int swap;
	float bootstrap_threshold;
	char *current_tree;
	SEA_VIEW *view;
	Fl_Round_Button *full;
	Fl_Round_Button *swap_button;
	Fl_Round_Button *subtree;
  Fl_Round_Button *select;
	Fl_Round_Button *new_outgroup;
	Fl_Button *up;
	Fl_Check_Button *l_button;
	Fl_Check_Button *bt_button;
	tree_panel *panel;
	void *fd_unrooted;
	Fl_Scrollbar *scroller;
	Fl_Menu_Button *menu_file, *menu_edit;
	double zoomvalue;
	struct noeud *prune_clade_node;
	int colored_names_1, colored_traits_1, colored_names_2, colored_traits_2;
	int edit_shape_rank;
	int center_rank;
	Fl_Button *select_clade_button, *delete_clade_button, *complete_edit_button;
	Fl_Counter *zoom;
	Fl_Choice *root_unroot;
	int page_count;
};
#endif
