/******************************************************************************/
/*                                                                            */
/* Title       : satlice.c                                                    */
/* Author      : Manfred Bester                                               */
/* Date        : 10Feb95                                                      */
/* Last change : 04Jan97                                                      */
/*                                                                            */
/* Synopsis    : This function block deals with the license issues.           */
/*               Please do not alter these functions!                         */
/*                                                                            */
/*               Instead of tampering with this module, look into the         */
/*               documentation to find out how to suppress the                */
/*               'registration via email'.                                    */
/*                                                                            */
/*                                                                            */
/* SatTrack V3.1                                                              */
/*                                                                            */
/* Copyright (c) 1992-1997 Bester Tracking Systems. All Rights Reserved.      */
/*                                                                            */
/* Permission to use, copy, and distribute SatTrack V3.1 and its              */
/* documentation in its entirety for educational, research and non-profit     */
/* purposes, without fee, and without a written agreement is hereby granted,  */
/* provided that the above copyright notice and the following three           */
/* paragraphs appear in all copies. SatTrack may be modified for personal     */
/* purposes, but modified versions may NOT be distributed without prior       */
/* consent of Bester Tracking Systems.                                        */
/*                                                                            */
/* Permission to incorporate this software into commercial products may be    */
/* obtained Bester Tracking Systems at the address below.                     */
/*                                                                            */
/*                                                                            */
/*     Bester Tracking Systems                                                */
/*     P.O. Box 8899                                                          */
/*     Emeryville, CA 94662, USA                                              */
/*                                                                            */
/*     Phone: (510) 654-7824                                                  */
/*     Email: license@bester.com                                              */
/*     WWW:   www.bester.com                                                  */
/*                                                                            */
/*                                                                            */
/* Note that distributing SatTrack 'bundled' in with ANY product is           */
/* considered to be a 'commercial purpose'.                                   */
/*                                                                            */
/* IN NO EVENT SHALL BESTER TRACKING SYSTEMS, ITS OWNER OR ITS EMPLOYEES BE   */
/* LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR          */
/* CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS      */
/* DOCUMENTATION, EVEN IF BESTER TRACKING SYSTEMS HAS BEEN ADVISED OF THE     */
/* POSSIBILITY OF SUCH DAMAGE.                                                */
/*                                                                            */
/* BESTER TRACKING SYSTEMS SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,  */
/* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS  */
/* FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" */
/* BASIS, AND BESTER TRACKING SYSTEMS, ITS OWNER OR ITS EMPLOYEES HAVE NO     */
/* OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR     */
/* MODIFICATIONS FREE OF CHARGE.                                              */
/*                                                                            */
/* Federal and international laws provide severe civil and criminal           */
/* penalties for the unauthorized reproduction and distribution of            */
/* copyrighted software. Criminal copyright infringement is investigated      */
/* by the FBI and may constitute a felony with severe penalties.              */
/*                                                                            */
/******************************************************************************/

#include <math.h>
#include <stdio.h>
#include <string.h>

#ifndef STDLIB
#include <stdlib.h>
#endif

#include "satglobalsx.h"
#include "sattrack.h"

#ifdef HPTERM
#include "hpterm.h"               /* definitions of hpterm macros             */
#else
#include "vt100.h"                /* definitions of VT100 macros              */
#endif

/******************************************************************************/
/*                                                                            */
/* checkLicense: don't tamper with this function since this might cause       */
/*               trouble elsewhere!                                           */
/*                                                                            */
/******************************************************************************/

void checkLicense()

{
    int  rFlag;
    char rStr[80];

    sprintf(licenseFile,"%s/.sattrack",strpRgst);

    if ((fpr = fopen(licenseFile,"r")) != NULL)
    {
        fclose(fpr);
        return;
    }

    sprintf(sattrackTitle,"%s %s --- License #%d",sattrName,sattrVersion,LCNUM);
    printf("\n%s %s\n",sattrName,sattrVersion);
    printf("\nCopyright (c) 1992-1997 Bester Tracking Systems. ");
    printf("All Rights Reserved.\n");

    reverseBlink();
    printf("\n Congratulations! \n");
    normal();
    printf("\nYou acquired and successfully installed %s.\n\n",sattrackTitle);

    printf("There is no license required for private, non-commercial use.\n");
    printf("However, if you intend to use this software or parts of it\n");
    printf("commercially, please contact Bester Tracking Systems.\n\n");

    printf("  Bester Tracking Systems\n");
    printf("  P.O. Box 8899\n");
    printf("  Emeryville, CA 94662, U.S.A.\n\n");
    printf("  Phone: (510) 654-7824\n");
    printf("  Email: license@bester.com\n");
    printf("  WWW:   www.bester.com\n\n");

    printf("Even for non-commercial applications it would make sense to\n");
    printf("register your copy of SatTrack with the author, so that you\n");
    printf("can be informed about future upgrades or fixes of bugs.\n\n");

    doBeep();
    rFlag = FALSE;

    while (!rFlag)
    {
        printf("Would you like to register your copy of SatTrack now (y/n) ? ");
        mGets(rStr,80,stdin);
        upperCase(rStr);

        if (!strncmp(rStr,"N",1) || !strncmp(rStr,"Y",1))
            rFlag = TRUE;
    }

    if (!strncmp(rStr,"Y",1))
    {
        rFlag = FALSE;

        while (!rFlag)
        {
            printf("Can your computer send electronic mail   ");
            printf("            (y/n) ? ");
            mGets(rStr,80,stdin);
            upperCase(rStr);

            if (!strncmp(rStr,"N",1) || !strncmp(rStr,"Y",1))
                rFlag = TRUE;
        }

        if (!strncmp(rStr,"Y",1))
        {
            if ((fpr = fopen(licenseFile,"w")) == NULL)
            {
                printf("Cannot create license file.\n\n");
                exit(-1);
            }

            else
            {
                fprintf(fpr,"Registration of %s\n",sattrackTitle);
                fclose(fpr);
            }

            printf("\nTrying to send registration via email ...\n");
            mailRegistration();
            printf("\nThanks for your registration!\n\n");
        }

        else
            printf("\nCannot send registration via email!\n\n");

        printf("Starting SatTrack any moment ...\n");
        milliSleep(950);
    }

    else
    {
        printf("\nWell, maybe some other time.\n");
        printf("\nStarting SatTrack any moment ...\n");
        milliSleep(950);
    }

    return;
}

/******************************************************************************/
/*                                                                            */
/* mailRegistration: sends registration message                               */
/*                                                                            */
/******************************************************************************/

void mailRegistration()

{
    char mStr[120];

    sprintf(mStr,"mail %s < %s",REGMAIL,licenseFile);
    system(mStr);
    return;
}

/******************************************************************************/
/*                                                                            */
/* End of function block satlice.c                                            */
/*                                                                            */
/******************************************************************************/
