/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    static ArgumentsMatchInfo compareArguments(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue((expectedArgTypes.size() == suppliedArgTypes.size() ? 1 : 0) != 0, (String)"Expected argument types and supplied argument types should be arrays of same length");
        ArgsMatchKind match = ArgsMatchKind.EXACT;
        ArrayList<Integer> argsRequiringConversion = null;
        for (int i = 0; i < expectedArgTypes.size() && match != null; ++i) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (expectedArg.equals((Object)suppliedArg)) continue;
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgsMatchKind.CLOSE;
                continue;
            }
            if (typeConverter.canConvert(suppliedArg, expectedArg)) {
                if (argsRequiringConversion == null) {
                    argsRequiringConversion = new ArrayList<Integer>();
                }
                argsRequiringConversion.add(i);
                match = ArgsMatchKind.REQUIRES_CONVERSION;
                continue;
            }
            match = null;
        }
        if (match == null) {
            return null;
        }
        if (match == ArgsMatchKind.REQUIRES_CONVERSION) {
            int[] argsArray = new int[argsRequiringConversion.size()];
            for (int i = 0; i < argsRequiringConversion.size(); ++i) {
                argsArray[i] = (Integer)argsRequiringConversion.get(i);
            }
            return new ArgumentsMatchInfo(match, argsArray);
        }
        return new ArgumentsMatchInfo(match);
    }

    public static int getTypeDifferenceWeight(List<TypeDescriptor> paramTypes, List<TypeDescriptor> argTypes) {
        int result = 0;
        int max = paramTypes.size();
        for (int i = 0; i < max; ++i) {
            TypeDescriptor argType = argTypes.get(i);
            TypeDescriptor paramType = paramTypes.get(i);
            if (argType == null && paramType.isPrimitive()) {
                return Integer.MAX_VALUE;
            }
            if (!ClassUtils.isAssignable(paramType.getClass(), argType.getClass())) {
                return Integer.MAX_VALUE;
            }
            if (argType == null) continue;
            Class<Object> paramTypeClazz = paramType.getType();
            if (paramTypeClazz.isPrimitive()) {
                paramTypeClazz = Object.class;
            }
            Class<?> superClass = argType.getClass().getSuperclass();
            while (superClass != null) {
                if (paramType.equals(superClass)) {
                    result += 2;
                    superClass = null;
                    continue;
                }
                if (ClassUtils.isAssignable(paramTypeClazz, superClass)) {
                    result += 2;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
            if (!paramTypeClazz.isInterface()) continue;
            ++result;
        }
        return result;
    }

    static ArgumentsMatchInfo compareArgumentsVarargs(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue((expectedArgTypes != null && expectedArgTypes.size() > 0 ? 1 : 0) != 0, (String)"Expected arguments must at least include one array (the vargargs parameter)");
        Assert.isTrue((boolean)expectedArgTypes.get(expectedArgTypes.size() - 1).isArray(), (String)"Final expected argument should be array type (the varargs parameter)");
        ArgsMatchKind match = ArgsMatchKind.EXACT;
        ArrayList<Integer> argsRequiringConversion = null;
        int argCountUpToVarargs = expectedArgTypes.size() - 1;
        for (int i = 0; i < argCountUpToVarargs && match != null; ++i) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (expectedArg.equals((Object)suppliedArg)) continue;
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgsMatchKind.CLOSE;
                continue;
            }
            if (typeConverter.canConvert(suppliedArg, expectedArg)) {
                if (argsRequiringConversion == null) {
                    argsRequiringConversion = new ArrayList<Integer>();
                }
                argsRequiringConversion.add(i);
                match = ArgsMatchKind.REQUIRES_CONVERSION;
                continue;
            }
            match = null;
        }
        if (match == null) {
            return null;
        }
        if (suppliedArgTypes.size() != expectedArgTypes.size() || !expectedArgTypes.get(expectedArgTypes.size() - 1).equals((Object)suppliedArgTypes.get(suppliedArgTypes.size() - 1))) {
            Class varargsParameterType = expectedArgTypes.get(expectedArgTypes.size() - 1).getElementTypeDescriptor().getType();
            for (int i = expectedArgTypes.size() - 1; i < suppliedArgTypes.size(); ++i) {
                TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
                if (suppliedArg == null) {
                    if (!varargsParameterType.isPrimitive()) continue;
                    match = null;
                    continue;
                }
                if (varargsParameterType == suppliedArg.getType()) continue;
                if (ClassUtils.isAssignable((Class)varargsParameterType, (Class)suppliedArg.getType())) {
                    if (match == ArgsMatchKind.REQUIRES_CONVERSION) continue;
                    match = ArgsMatchKind.CLOSE;
                    continue;
                }
                if (typeConverter.canConvert(suppliedArg, TypeDescriptor.valueOf((Class)varargsParameterType))) {
                    if (argsRequiringConversion == null) {
                        argsRequiringConversion = new ArrayList();
                    }
                    argsRequiringConversion.add(i);
                    match = ArgsMatchKind.REQUIRES_CONVERSION;
                    continue;
                }
                match = null;
            }
        }
        if (match == null) {
            return null;
        }
        if (match == ArgsMatchKind.REQUIRES_CONVERSION) {
            int[] argsArray = new int[argsRequiringConversion.size()];
            for (int i = 0; i < argsRequiringConversion.size(); ++i) {
                argsArray[i] = (Integer)argsRequiringConversion.get(i);
            }
            return new ArgumentsMatchInfo(match, argsArray);
        }
        return new ArgumentsMatchInfo(match);
    }

    static void convertArguments(TypeConverter converter, Object[] arguments, Object methodOrCtor, int[] argumentsRequiringConversion, Integer varargsPosition) throws EvaluationException {
        if (varargsPosition == null) {
            for (int i = 0; i < arguments.length; ++i) {
                TypeDescriptor targetType = new TypeDescriptor(MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)i));
                Object argument = arguments[i];
                arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject((Object)argument), targetType);
            }
        } else {
            Object argument;
            TypeDescriptor targetType;
            for (int i = 0; i < varargsPosition; ++i) {
                targetType = new TypeDescriptor(MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)i));
                argument = arguments[i];
                arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject((Object)argument), targetType);
            }
            MethodParameter methodParam = MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)varargsPosition);
            if (varargsPosition == arguments.length - 1) {
                targetType = new TypeDescriptor(methodParam);
                argument = arguments[varargsPosition];
                arguments[varargsPosition.intValue()] = converter.convertValue(argument, TypeDescriptor.forObject((Object)argument), targetType);
            } else {
                targetType = TypeDescriptor.nested((MethodParameter)methodParam, (int)1);
                for (int i = varargsPosition.intValue(); i < arguments.length; ++i) {
                    Object argument2 = arguments[i];
                    arguments[i] = converter.convertValue(argument2, TypeDescriptor.forObject((Object)argument2), targetType);
                }
            }
        }
    }

    public static void convertAllArguments(TypeConverter converter, Object[] arguments, Method method) throws SpelEvaluationException {
        Integer varargsPosition = null;
        if (method.isVarArgs()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            varargsPosition = paramTypes.length - 1;
        }
        for (int argPosition = 0; argPosition < arguments.length; ++argPosition) {
            TypeDescriptor targetType;
            if (varargsPosition != null && argPosition >= varargsPosition) {
                MethodParameter methodParam = new MethodParameter(method, varargsPosition.intValue());
                targetType = TypeDescriptor.nested((MethodParameter)methodParam, (int)1);
            } else {
                targetType = new TypeDescriptor(new MethodParameter(method, argPosition));
            }
            try {
                Object argument = arguments[argPosition];
                if (argument == null || targetType.getObjectType().isInstance(argument)) continue;
                if (converter == null) {
                    throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, argument.getClass().getName(), targetType);
                }
                arguments[argPosition] = converter.convertValue(argument, TypeDescriptor.forObject((Object)argument), targetType);
                continue;
            }
            catch (EvaluationException ex) {
                if (ex instanceof SpelEvaluationException) {
                    throw (SpelEvaluationException)ex;
                }
                throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, arguments[argPosition].getClass().getName(), targetType);
            }
        }
    }

    public static Object[] setupArgumentsForVarargsInvocation(Class[] requiredParameterTypes, Object ... args) {
        int parameterCount = requiredParameterTypes.length;
        int argumentCount = args.length;
        if (parameterCount != args.length || requiredParameterTypes[parameterCount - 1] != (args[argumentCount - 1] == null ? null : args[argumentCount - 1].getClass())) {
            int arraySize = 0;
            if (argumentCount >= parameterCount) {
                arraySize = argumentCount - (parameterCount - 1);
            }
            Object[] newArgs = new Object[parameterCount];
            for (int i = 0; i < newArgs.length - 1; ++i) {
                newArgs[i] = args[i];
            }
            Class<?> componentType = requiredParameterTypes[parameterCount - 1].getComponentType();
            if (componentType.isPrimitive()) {
                if (componentType == Integer.TYPE) {
                    int[] repackagedArguments = (int[])Array.newInstance(componentType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        repackagedArguments[i] = (Integer)args[parameterCount + i - 1];
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Float.TYPE) {
                    float[] repackagedArguments = (float[])Array.newInstance(componentType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        repackagedArguments[i] = ((Float)args[parameterCount + i - 1]).floatValue();
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Double.TYPE) {
                    double[] repackagedArguments = (double[])Array.newInstance(componentType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        repackagedArguments[i] = (Double)args[parameterCount + i - 1];
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Short.TYPE) {
                    short[] repackagedArguments = (short[])Array.newInstance(componentType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        repackagedArguments[i] = (Short)args[parameterCount + i - 1];
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Character.TYPE) {
                    char[] repackagedArguments = (char[])Array.newInstance(componentType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        repackagedArguments[i] = ((Character)args[parameterCount + i - 1]).charValue();
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Byte.TYPE) {
                    byte[] repackagedArguments = (byte[])Array.newInstance(componentType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        repackagedArguments[i] = (Byte)args[parameterCount + i - 1];
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Boolean.TYPE) {
                    boolean[] repackagedArguments = (boolean[])Array.newInstance(componentType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        repackagedArguments[i] = (Boolean)args[parameterCount + i - 1];
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Long.TYPE) {
                    long[] repackagedArguments = (long[])Array.newInstance(componentType, arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        repackagedArguments[i] = (Long)args[parameterCount + i - 1];
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                }
            } else {
                Object[] repackagedArguments = (Object[])Array.newInstance(componentType, arraySize);
                for (int i = 0; i < arraySize; ++i) {
                    repackagedArguments[i] = args[parameterCount + i - 1];
                }
                newArgs[newArgs.length - 1] = repackagedArguments;
            }
            return newArgs;
        }
        return args;
    }

    public static class ArgumentsMatchInfo {
        public final ArgsMatchKind kind;
        public int[] argsRequiringConversion;

        ArgumentsMatchInfo(ArgsMatchKind kind, int[] integers) {
            this.kind = kind;
            this.argsRequiringConversion = integers;
        }

        ArgumentsMatchInfo(ArgsMatchKind kind) {
            this.kind = kind;
        }

        public boolean isExactMatch() {
            return this.kind == ArgsMatchKind.EXACT;
        }

        public boolean isCloseMatch() {
            return this.kind == ArgsMatchKind.CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this.kind == ArgsMatchKind.REQUIRES_CONVERSION;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ArgumentMatch: ").append((Object)this.kind);
            if (this.argsRequiringConversion != null) {
                sb.append("  (argsForConversion:");
                for (int i = 0; i < this.argsRequiringConversion.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.argsRequiringConversion[i]);
                }
                sb.append(")");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;

    }
}

