/*
 *   mwmipc1.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include "mwmparse.h"
#include "mwmparsi.h"

static char szThisFile[] = "MWMIPC1.C";

/*****************************************************************************/
/* This routine is written to handle all errors generated by the AT command  */
/* parser.  It is operating system dependent.                                */
/* Typically, this routine will allocate an "Error" structure, and post a    */
/* message to the main window (or dialog) procedure.                         */
/* The "Error" structure will be deallocated by the receiving side after     */
/* the message is displayed to the user.                                     */
/*****************************************************************************/
void mwmIPCHandleError( char *achFile, SHORT sLine, PMWMERROR pmwmError,
                        ULONG ulPrimaryCode, ULONG ulSecondaryCode )
{
/*  PMWMERROR   pmwmError;*/
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmipc1::mwmIPCHandleError entry\n");

  /***************************************************************************/
  /* Put the parameter information of this routine into the error structure  */
  /***************************************************************************/
  if (pmwmError)
  {
    strncpy(pmwmError->achFile,achFile,MWM_MAX_FILENAME_LENGTH);
    pmwmError->sLine = sLine;
    pmwmError->ulPrimaryCode = ulPrimaryCode;
    pmwmError->ulSecondaryCode = ulSecondaryCode;
  }

  /***************************************************************************/
  /* Post a Message to the main window (or dialog) instructing it to display */
  /* the message in whatever form it wishes.                                 */
  /***************************************************************************/
  mwmParsePostMessage( WM_MWMPARSERERROR, 0, (LONG)pmwmError);
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmipc1::mwmIPCHandleError exit ulRC 0\n");
  return;
}






/*****************************************************************************/
/* mwmIPC1InterruptHandler()                                                 */
/*****************************************************************************/
/* Entry point for all interrupts received from MDMCTL                       */
/*****************************************************************************/
int FAR PASCAL mwmIPC1InterruptHandler(void)
{
  ULONG ulRC;
  USHORT usControlStat;
  USHORT usParserStatus=0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmipc1::mwmIPC1InterruptHandler entry\n");

  /***************************************************************************/
  /* Get CNTLSTAT Variable from MDMCTL.                                      */
  /***************************************************************************/
  ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrCNTLSTAT,
                        &usControlStat, 1,
                        DSP_MEMXFER_DATA_READ);
  /***************************************************************************/
  /* Check to make sure that the MemTransfer worked.                         */
  /***************************************************************************/
  if (ulRC != DSP_NOERROR)
  {
    mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                      MWM_DSP_ERROR,
                      ulRC );
   return 0;
  }

  #ifdef DEBUG
      if (usControlStat < 0x1000)
        DPF("Received IPC: %d\n",usControlStat);
      else
        DPF("Received IPC: 0x%04x\n",usControlStat);
  #endif

 MW_SYSLOG_2(TRACE_MWMPW32,"mwmipc1::mwmIPC1InterruptHandler case usControlStat %x\n",usControlStat);
  if (!usControlStat) {
    /* HACK. Sometimes the mwave chip interrupts before the control status register has been set. If this is the */
    /*       case just assume that a usControlStat of 4 was what was meant */
    MW_SYSLOG_ERROR(LOG_ERR,"mwmipc1::mwmIPC1InterruptHandler, WARNING usControlStat was %x (setting to 4)\n",usControlStat);
    usControlStat=4; 
  }
  switch (usControlStat)
  {
    case 1:  /* process new AT command buffer */
      /***********************************************************************/
      /* pachRemainingCommands will be advanced as we parse the AT command   */
      /* string.  It will need to be saved across interrupts for the buffer  */
      /* full condition.  In that case, Control Stat 2 will signal the       */
      /* parser to continue with the rest of the AT buffer.                  */
      /***********************************************************************/
      /* When returning the "Get More Buffers" PP Command, set the           */
      /* usCurrentCommand, and usSubCommandInfo portions of the StateInfo    */
      /* structure appropriately.                                            */
      /***********************************************************************/


      /***********************************************************************/
      /* Read the AT Command from MDMCTL's ATCMDBUF public label.            */
      /***********************************************************************/
      ulRC = mwmParseReadATStringFromDSP(psi);
      /***********************************************************************/
      /* The only possible error from this routine is a MemTransfer error.   */
      /* If that happens, we are in big trouble.  Try to return from this    */
      /* interrupt.                                                          */
      /***********************************************************************/
      if (ulRC != DSP_NOERROR)
          {
	    return 0;
          }

      /***********************************************************************/
      /* print the buffer to a pmprintf window if in OS/2                    */
      /***********************************************************************/
      #ifdef DEBUG
        if (psi->usDebugWindow)
        {
          DPF("AT Cmd: %s\n",psi->achCommandBuffer);
        }
      #endif

      /***********************************************************************/
      /* Start Parsing this new AT Command.                                  */
      /***********************************************************************/

      usParserStatus = mwmCmdParseATcmd(psi);

      /***********************************************************************/
      /* Writes PP Command to the DSP with a dspMemTransfer.                 */
      /* if the ParserStatus variable says the Buffer is full, add a PP_CMD  */
      /* asking to process this buffer and return an empty buffer via        */
      /* CNTLSTAT = 2                                                        */
      /***********************************************************************/
      mwmParseWriteCmdToDSP(psi,usParserStatus);
      break;

    case 2:      /* PP Command Buffer is empty...continue processing.        */
      switch(psi->usCurrentCommand)
      {
        case MWM_INITIALIZE_MODEM:
          /*******************************************************************/
          /* DCR 2456 Initialize with the proper profile if NOT recovering   */
          /* from a "Suspend"                                                */
          /* Otherwise, Initialize with Profile 3.  It contains the last     */
          /* settings (AT commands) before the suspend.                      */
          /*******************************************************************/
          if (!psi->usSuspendFlag)                                  /* DCR 2456*/
          {                                                         /* DCR 2456*/
            usParserStatus = mwmParseInitializeModem(psi,           /* DCR 2456*/
                                               psi->ModemMemory.usStartupProfile);
          } else                                                    /* DCR 2456*/
          {                                                         /* DCR 2456*/
            usParserStatus = mwmParseInitializeModem(psi,           /* DCR 2456*/
                                                     3);            /* DCR 2456*/
          } /* endif */                                             /* DCR 2456*/
          break;
        case MWM_LOAD_SPECIFIC_PROFILE:
          usParserStatus = mwmParseInitializeModem(psi,
                                                   psi->usSavedCommandParameter);
          break;

        case MWM_AMP_F_CMD:                                         /* PTR 2356*/
          usParserStatus = mwmParseInitializeModem(psi,
                                                   psi->usSavedCommandParameter);
          /*******************************************************************/
          /* PTR 2356...Any command following an &F was being ignored.       */
          /* 12/06/93                                                        */
          /* This is another instance of the 10/30/93 problem fixed below    */
          /* for the &V and I commands.                                      */
          /*******************************************************************/
          if (!(usParserStatus & MWM_GET_MORE_BUFFERS))
          {
            /*****************************************************************/
            /* This command is completely finished...we didn't request any   */
            /* more buffers.                                                 */
            /*****************************************************************/
            /*****************************************************************/
            /* When the command failed (in mwmCmd() ), the AT index was      */
            /* set back to the beginning of this command.  Since we have     */
            /* now processed it, we must increment the command pointer past  */
            /* this command.                                                 */
            /*                                                               */
            /* Since this is a 2 character command, we must move the pointer */
            /* forward by 2...                                               */
            /*****************************************************************/
            psi->usNextATIndex+=2;

            psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
            usParserStatus = usParserStatus | MWM_GET_MORE_BUFFERS;
          }
          break;                                                /* End PTR 2356*/

        case MWM_I_COMMAND:
          usParserStatus = mwmCmdICommand(psi);
          /*******************************************************************/
          /* Trial....10/30/93 to fix i3i3i3 problem.                        */
          /* Logic:                                                          */
          /*   If we just processed a full buffer from a specific type of AT */
          /* command (not MWM_CONTINUE_AT_BUFFER)...currently this is AMP_V &*/
          /* I commands...we should anticipate the possibility of more AT    */
          /* commands in the buffer...set the usCurrentCommand to            */
          /* MWM_CONTINUE_AT_BUFFER, and set the buffer full again.          */
          /*******************************************************************/
          if (!(usParserStatus & MWM_GET_MORE_BUFFERS))
          {
            /*****************************************************************/
            /* This command is completely finished...we didn't request any   */
            /* more buffers.                                                 */
            /*****************************************************************/

            /*****************************************************************/
            /* When the command failed (in mwmCmd() ), the AT index was      */
            /* set back to the beginning of this command.  Since we have     */
            /* now processed it, we must increment the command pointer past  */
            /* this command.                                                 */
            /*                                                               */
            /* We don't have to worry about the parameter.  The pointer was  */
            /* incremented past it by mwmParseGetArgFromATString from the    */
            /* mwmCmdICommand routine.                                       */
            /*****************************************************************/
            psi->usNextATIndex++;

            psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
            usParserStatus = usParserStatus | MWM_GET_MORE_BUFFERS;
          }
          break;

        case MWM_AMP_V_CMD:
          usParserStatus = mwmAmpVCommand(psi);
          /*******************************************************************/
          /* Trial....10/30/93 to fix i3i3i3 problem.                        */
          /* Logic:                                                          */
          /*   If we just processed a full buffer from a specific type of AT */
          /* command (not MWM_CONTINUE_AT_BUFFER)...currently this is AMP_V &*/
          /* I commands...we should anticipate the possibility of more AT    */
          /* commands in the buffer...set the usCurrentCommand to            */
          /* MWM_CONTINUE_AT_BUFFER, and set the buffer full again.          */
          /*******************************************************************/
          if (!(usParserStatus & MWM_GET_MORE_BUFFERS))
          {
            /*****************************************************************/
            /* This command is completely finished...we didn't request any   */
            /* more buffers.                                                 */
            /*****************************************************************/


            /*****************************************************************/
            /* When the command failed (in mwmCmd() ), the AT index was      */
            /* set back to the beginning of this command.  Since we have     */
            /* now processed it, we must increment the command pointer past  */
            /* this command.                                                 */
            /*                                                               */
            /* Since this is a 2 character command, we must move the pointer */
            /* forward by 2...                                               */
            /*****************************************************************/
            psi->usNextATIndex+=2;

            psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
            usParserStatus = usParserStatus | MWM_GET_MORE_BUFFERS;
          }
          break;
         case MWM_PND_UD_CMD:
           usParserStatus = mwmPoundUDEchoBuffer(psi);

           if (!(usParserStatus & MWM_GET_MORE_BUFFERS))
           {
             /*****************************************************************/
             /* This command is completely finished...we didn't request any   */
             /* more buffers.                                                 */
             /*****************************************************************/


             /*****************************************************************/
             /* When the command failed (in mwmCmd() ), the AT index was      */
             /* set back to the beginning of this command.  Since we have     */
             /* now processed it, we must increment the command pointer past  */
             /* this command.                                                 */
             /*                                                               */
             /* Since this is a 2 character command, we must move the pointer */
             /* forward by 2...                                               */
             /*****************************************************************/
             psi->usNextATIndex+=3;

             psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
             usParserStatus = usParserStatus | MWM_GET_MORE_BUFFERS;
           }
           break;

        case MWM_CONTINUE_AT_BUFFER:
          #ifdef DEBUG
            DPF("What's left of AT Buffer: %s\n",&psi->achCommandBuffer[psi->usNextATIndex]);
          #endif
          usParserStatus = mwmCmdParseATcmd(psi);
          break;
      }
      /***********************************************************************/
      /* Writes PP Command to the DSP with a dspMemTransfer.                 */
      /* if the ParserStatus variable says the Buffer is full, add a PP_CMD  */
      /* asking to process this buffer and return an empty buffer via        */
      /* CNTLSTAT = 2                                                        */
      /***********************************************************************/
      mwmParseWriteCmdToDSP(psi,usParserStatus);
      break;

    case 3:    /* &W,&Y,&Z commands...*/
      break;

    case 4:    /* Initialize S Register Settings. (Received on modem startup */

      /***********************************************************************/
      /* This is the start of this command, so set the subcommand info to    */
      /* 1.  It will be incremented as the command is processed.             */
      /* When (if) the Preprocessed command buffer gets full, the subcommand */
      /* info will indicate where to continue.                               */
      /***********************************************************************/
      psi->usSubCommandInfo = 1;
      psi->usCurrentCommand = MWM_INITIALIZE_MODEM;
      /***********************************************************************/
      /* DCR 2456 Initialize with the proper profile if NOT recovering       */
      /* from a "Suspend"                                                    */
      /* Otherwise, Initialize with Profile 3.  It contains the last settings*/
      /* (AT commands) before the suspend.                                   */
      /***********************************************************************/
      if (!psi->usSuspendFlag)                                       /*DCR 2456*/
      {                                                              /*DCR 2456*/
        usParserStatus = mwmParseInitializeModem(psi,
                                               psi->ModemMemory.usStartupProfile);
      } else                                                         /*DCR 2456*/
      {                                                              /*DCR 2456*/
        usParserStatus = mwmParseInitializeModem(psi,                /*DCR 2456*/
                                                 3);                 /*DCR 2456*/
      } /* endif */                                                  /*DCR 2456*/

      /***********************************************************************/
      /* Writes PP Command to the DSP with a dspMemTransfer.                 */
      /* if the ParserStatus variable says the Buffer is full, add a PP_CMD  */
      /* asking to process this buffer and return an empty buffer via        */
      /* CNTLSTAT = 2                                                        */
      /***********************************************************************/
      if(psi->usWTChangeFlag)
      {
        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x1150;
      }
      mwmParseWriteCmdToDSP(psi,usParserStatus);

      break;
   case 69:     /* caller id message interrupt */
      usParserStatus = mwmCidpParseCID( psi );
      break;

   case 100: 
      break;
   case 102: 
      break;
   case 101: 
      break;

   case 0x1100:

      /***********************************************************************/
      /* Write Profile 0                                                     */
      /***********************************************************************/
      /* MTS 4175 Handle multiple writes on one line. (&W0&W1)               */
      /*          Do this by changing single CNTLSTAT=3 for all writes to    */
      /*          separate CNTLSTATS for each write.                         */
      /***********************************************************************/
      /***********************************************************************/
      /* MTS 3538 Start using IPC 3 for writing profile to load and stored   */
      /* phone numbers. (&Y and &Z)                                          */
      /***********************************************************************/

      /***********************************************************************/
      /* Need to Query Registers NOW, and post message to write profile.     */
      /***********************************************************************/
      mwmParseQueryModemRegisters(&psi->ModemMemory.aStoredRegs[3]);

      mwmParsePostMessage( WM_MWM_PARSER_CALLBACK, MWM_WRITE_PROFILE0, (LONG)&psi->ModemMemory.aStoredRegs[3] );

      /***********************************************************************/
      /* MTS 3265 ... We were telling MCTL that we were finished with the    */
      /*          &W.  However, in some cases, the info that is actually     */
      /*          written to the disk is changing before we get finished.    */
      /*          So, we are now making MCTL wait until we are finished with */
      /*          the file I/O before we tell MCTL to continue (DRVRSTAT=1)  */
      /***********************************************************************/
      break;
    case 0x1101:
      /***********************************************************************/
      /* Write Profile 1                                                     */
      /***********************************************************************/
      /* MTS 4175 Handle multiple writes on one line. (&W0&W1)               */
      /*          Do this by changing single CNTLSTAT=3 for all writes to    */
      /*          separate CNTLSTATS for each write.                         */
      /***********************************************************************/
      /***********************************************************************/
      /* MTS 3538 Start using IPC 3 for writing profile to load and stored   */
      /* phone numbers. (&Y and &Z)                                          */
      /***********************************************************************/

      /***********************************************************************/
      /* Need to Query Registers NOW, and post message to write profile.     */
      /***********************************************************************/
      mwmParseQueryModemRegisters(&psi->ModemMemory.aStoredRegs[3]);

      mwmParsePostMessage( WM_MWM_PARSER_CALLBACK, MWM_WRITE_PROFILE1, (LONG)&psi->ModemMemory.aStoredRegs[3] );

      /***********************************************************************/
      /* MTS 3265 ... We were telling MCTL that we were finished with the    */
      /*          &W.  However, in some cases, the info that is actually     */
      /*          written to the disk is changing before we get finished.    */
      /*          So, we are now making MCTL wait until we are finished with */
      /*          the file I/O before we tell MCTL to continue (DRVRSTAT=1)  */
      /***********************************************************************/
      break;
    case 0x1102:
      /***********************************************************************/
      /* Write Profile To Load                                               */
      /***********************************************************************/
      /* MTS 4175 Handle multiple writes on one line. (&W0&W1)               */
      /*          Do this by changing single CNTLSTAT=3 for all writes to    */
      /*          separate CNTLSTATS for each write.                         */
      /***********************************************************************/
      mwmParsePostMessage( WM_MWM_PARSER_CALLBACK, MWM_WRITE_PROFILE_TO_LOAD, (LONG)&psi->ModemMemory.usStartupProfile );
      break;
    case 0x1103:
      /***********************************************************************/
      /* Write Phone Number 0                                                */
      /***********************************************************************/
      /* MTS 4175 Handle multiple writes on one line. (&W0&W1)               */
      /*          Do this by changing single CNTLSTAT=3 for all writes to    */
      /*          separate CNTLSTATS for each write.                         */
      /***********************************************************************/
      mwmParsePostMessage( WM_MWM_PARSER_CALLBACK, MWM_WRITE_PROFILE_PHONE_NUM0, (LONG)&psi->ModemMemory.aachStoredNumbers[0] );
      break;
    case 0x1104:
      /***********************************************************************/
      /* Write Phone Number 1                                                */
      /***********************************************************************/
      /* MTS 4175 Handle multiple writes on one line. (&W0&W1)               */
      /*          Do this by changing single CNTLSTAT=3 for all writes to    */
      /*          separate CNTLSTATS for each write.                         */
      /***********************************************************************/
      mwmParsePostMessage( WM_MWM_PARSER_CALLBACK, MWM_WRITE_PROFILE_PHONE_NUM1, (LONG)&psi->ModemMemory.aachStoredNumbers[1] );
      break;
    case 0x1105:
      /***********************************************************************/
      /* Write Phone Number 2                                                */
      /***********************************************************************/
      /* MTS 4175 Handle multiple writes on one line. (&W0&W1)               */
      /*          Do this by changing single CNTLSTAT=3 for all writes to    */
      /*          separate CNTLSTATS for each write.                         */
      /***********************************************************************/
      mwmParsePostMessage( WM_MWM_PARSER_CALLBACK, MWM_WRITE_PROFILE_PHONE_NUM2, (LONG)&psi->ModemMemory.aachStoredNumbers[2] );
      break;
    case 0x1106:
      /***********************************************************************/
      /* Write Phone Number 3                                                */
      /***********************************************************************/
      /* MTS 4175 Handle multiple writes on one line. (&W0&W1)               */
      /*          Do this by changing single CNTLSTAT=3 for all writes to    */
      /*          separate CNTLSTATS for each write.                         */
      /***********************************************************************/
      mwmParsePostMessage( WM_MWM_PARSER_CALLBACK, MWM_WRITE_PROFILE_PHONE_NUM3, (LONG)&psi->ModemMemory.aachStoredNumbers[3] );
      break;
    case 0x1150:
      mwmParsePostMessage( WM_MWM_TABLE_CHANGED, 0, 0);
      mwmParseSetDRVRSTAT(2);
    break;

    case 19:
    case 77:    /* MTS 7262 - send the DRVRSTAT right after post for speed*/
    case 78:    /* MTS 7262 - send the DRVRSTAT right after post for speed*/
    case 79:    /* MTS 7262 - send the DRVRSTAT right after post for speed*/
    case 33:    /* MTS 7262 - send the DRVRSTAT right after post for speed*/
      mwmParsePostMessage( WM_MWM_MODEM_IPC, usControlStat, 0 );
      mwmParseSetDRVRSTAT(2);
      break;
    default:
      mwmParsePostMessage( WM_MWM_MODEM_IPC, usControlStat, 0 );
      break;
  }

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmipc1::mwmIPC1InterruptHandler exit ulRC 0\n");
  return 0;
}

