/*
 *   mwmcidl.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporatio
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmspcfc.h>
#include <mwmcntnd.h>

static char szThisFile[] = "mwmcidl.c";

/* called by mwmLoadMakeMeioConnections to initialize callerid */
/* called in all cases */
void mwmCidlInit(PMWM_DSPINFO pmwmDspInfo)
{

   { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlInit entry\n");  }

  DPF("mwmCidlInit called");
  pmwmDspInfo->hmodCALLERID = NULL;
  pmwmDspInfo->hmtCALLERID_ASYNC = NULL;
  pmwmDspInfo->bCIDCapability = 0;
  mwmCidpInitCid( FALSE, 0l, 0l );

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlInit exit\n");  }

}

/* called by mwmLoadMakeMeioConnections to query the hardware for caller id */
/*    and initialize the MWPARSE stuff for callerid */
/* called only if the line is available and DISCRIM not loaded */
void mwmCidlCheck(PMWM_DSPINFO pmwmDspInfo)
{


  union {
        LONG bits;                      /* bit defined version */
        MEIO_TAIOCONNCHAR structure;    /* structure definition */
        } MeioReturnedValue;
  ULONG ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlCheck entry\n");  }

  pmwmDspInfo->bCIDCapability = 0;      /* assume not capable */
  mwmCidpInitCid( FALSE, 0l, 0l );



  /***************************************************************************/
  /* Don't try to enable callerid if we are running under the discriminator  */
  /* In this case, we don't own the phone line, so we shouldn't try to       */
  /* query the MEIO connection (hConnect1) when we don't have it.            */
  /*                                                                         */
  /* So, the logic now is:                                                   */
  /* Turn on Caller id if...                                                 */
  /* 1.  The hardware is enabled.                                            */
  /* 2.  The modem is in "slimbase" (we don't have room in non-slimbase...)  */
  /* 3.  We are NOT running under the discriminator.                         */
  /***************************************************************************/
   { MW_SYSLOG_2(TRACE_MWMLW32,"mwmidl::mwmCidlCheck ulFeaturesToLoad %lx\n",pmwmDspInfo->ulFeaturesToLoad);  }
  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE )
  {     /* if SLIMBASE=0, caller ID allowed*/
    ulRC = dspMeioQueryConnection(pmwmDspInfo->hConnect1,
                    /* connection for teledac to teleout */
                 MEIO_CONNECTION_CHARACTERISTICS,
                 &MeioReturnedValue.bits);
     { MW_SYSLOG_2(TRACE_MWMLW32,"mwmcidl::mwmCidlCheck, return from dspMeioQueryConnection, ulRC %lx\n",ulRC);  }
    if( !(ulRC == MEIO_NOERROR) )
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                 MWM_MEIO_ERROR, ulRC);
    }

    if (MeioReturnedValue.structure.CallerID == 0)
    { /* caller ID not in hardware */
      MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlCheck, Caller ID not in MEIO\n");  
      DPF("mwmCidlCheck Caller ID not in MEIO");
    }
    else
    {
      DPF("mwmCidlCheck Caller ID in MEIO");
       { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlCheck, Caller ID in MEIO, turning on...\n");  }
      MeioReturnedValue.structure.CallerID_Enabled = 1;
      if( !(dspMeioUpdateConnection(pmwmDspInfo->hConnect1, /* turn on caller id support */
                MEIO_CONNECTION_CHARACTERISTICS,
                MeioReturnedValue.bits) == MEIO_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                MWM_MEIO_ERROR, ulRC);
      }
       { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlCheck, bCIDCapability set to 1\n");  }
      pmwmDspInfo->bCIDCapability = 1;      /* set capable */
      mwmCidpInitCid( TRUE, 0l, 0l );
    } /* endif CallerID == 0 */
  } /* endif SLIMBASE */

  {  MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlCheck exit\n");  }

}

ULONG mwmCidlLoad(PMWM_DSPINFO pmwmDspInfo, ULONG ulDesiredCid)
{
  ULONG ulRC = 0l;
  ULONG ulDspAddrCallerIDLength = 0l;
  ULONG ulDspAddrCallerIDData = 0l;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlLoad entry\n");  }


  DPF("mwmCidlLoad called ulDesiredCid=0x%lx, hmodCALLERID=0x%lx",
        ulDesiredCid, pmwmDspInfo->hmodCALLERID );
  switch(ulDesiredCid)
  {
  case 0:       /* disable / unload as needed */
    mwmCidpInitCid( TRUE, 0l, 0l );
    if(!( pmwmDspInfo->hmodCALLERID == NULL ) )
    { /* there is a module to uload */
      ulRC = dspFreeModule( pmwmDspInfo->hmodCALLERID );
      DPF("mwmCidlLoad FreeModule");
      if( !(ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
    }
    pmwmDspInfo->hmodCALLERID = NULL;
    pmwmDspInfo->hmtCALLERID_ASYNC = NULL;
    break;
  case 1:
  case 2:
    if( pmwmDspInfo->hmodCALLERID == NULL )
    { /* we need to load - standby */
      DPF("mwmCidlLoad LoadModule required");
      ulRC = mwmCntndLoadModule(pmwmDspInfo,"CALLERID","CALLERID",
                            &pmwmDspInfo->hmodCALLERID,szThisFile,__LINE__);
      if( !(ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
      DPF("mwmCidlLoad hmodCALLERID = 0x%lx", pmwmDspInfo->hmodCALLERID);
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodCALLERID, "ASYNCID",
                             &pmwmDspInfo->hmtCALLERID_ASYNC);
      if (!( ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
      DPF("mwmCidlLoad hmtCALLERID_ASYNC = 0x%lx", pmwmDspInfo->hmtCALLERID_ASYNC);
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtCALLERID_ASYNC, "WR_COUNT",
                             &ulDspAddrCallerIDLength);
      if (!( ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
      DPF("mwmCidlLoad WR_COUNT = 0x%lx", ulDspAddrCallerIDLength);
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtCALLERID_ASYNC, "CID_STRG",
                             &ulDspAddrCallerIDData);
      if (!( ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
      DPF("mwmCidlLoad CID_STRG = 0x%lx", ulDspAddrCallerIDData);
      ulRC=dspConnectITCB(pmwmDspInfo->hmtCALLERID_ASYNC,
                "ASYNCID_OUTPUT_ITCB",
                pmwmDspInfo->hmctlTask,"CIDITCB");
      if (!( ulRC == DSP_NOERROR))
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
      mwmCidpInitCid( TRUE, ulDspAddrCallerIDLength, ulDspAddrCallerIDData );
      ulRC = dspChangeModuleState(pmwmDspInfo->hmodCALLERID,
                   DSP_ACTIVATE_ACTIVE );
      if(! (ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
    }
    mwmCntndLoadComplete(pmwmDspInfo, 1);
    break;
  default : /* bad ulDesiredCid */
    DPF("mwmCidlLoad Bad ulDesiredMode=%lx", ulDesiredCid);
    break;
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlLoad exit\n");  }

  return ulRC;
}

void mwmCidlInitDRing(PMWM_DSPINFO pmwmDspInfo)
{

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlInitDRing entry\n");  }

  DPF("mwmCidlInitDRing called");
  pmwmDspInfo->hmodDRing = NULL;
  pmwmDspInfo->hmtDRing = NULL;
  pmwmDspInfo->bDRingCapability = 0;
  mwmCidpInitDRing( FALSE );

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlInitDRing exit\n");  }

}

void mwmCidlCheckDRing(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulDRing;                                                 //$1

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlCheckDRing entry\n");  }


  pmwmDspInfo->bDRingCapability = 0;      /* assume not capable */
  mwmCidpInitDRing( FALSE );


  /***************************************************************************/
  /* Turn on distinctive ring if...                                          */
  /* 1.  The modem is in "slimbase" (we don't have room in non-slimbase...)  */
  /* 2.  We are NOT running under the discriminator.                         */
  /***************************************************************************/
  ulDRing = GetPrivateProfileInt("FEATURES","DRING",0,INIFile ); //$1
  if (ulDRing) {                                                 //$1
    if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE )
    {
      pmwmDspInfo->bDRingCapability = 1;      /* set capable */
      mwmCidpInitDRing( TRUE );

    } /* endif SLIMBASE */
  } /* endif ulDring */                                          //$1

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlCheckDRing exit\n");  }

}

ULONG mwmCidlLoadDRing(PMWM_DSPINFO pmwmDspInfo, ULONG ulDesiredDRing)
{
  ULONG ulRC = 0l;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlLoadDRing entry\n");  }


  DPF("mwmCidlLoadDRing called ulDesiredDRing=0x%lx, hmodDRing=0x%lx",
        ulDesiredDRing, pmwmDspInfo->hmodDRing );
  switch(ulDesiredDRing)
  {
  case 0:       /* disable / unload as needed */
    if(!( pmwmDspInfo->hmodDRing == NULL ) )
    { /* there is a module to uload */
      ulRC = dspFreeModule( pmwmDspInfo->hmodDRing );
      DPF("mwmCidlLoadDRing FreeModule");
      if( !(ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
    }
    pmwmDspInfo->hmodDRing = NULL;
    pmwmDspInfo->hmtDRing = NULL;
    break;
  case 1:
    if( pmwmDspInfo->hmodDRing == NULL )
    { /* we need to load - standby */
      DPF("mwmCidlLoadDRing LoadModule required");
      ulRC = mwmCntndLoadModule(pmwmDspInfo,"DRING","DRING",
                            &pmwmDspInfo->hmodDRing,szThisFile,__LINE__);
      if( !(ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
      DPF("mwmCidlLoadDRing hmodDRing = 0x%lx", pmwmDspInfo->hmodDRing);
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodDRing, "DR",
                             &pmwmDspInfo->hmtDRing);
      if (!( ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
      DPF("mwmCidlLoadDRing hmtDRing = 0x%lx", pmwmDspInfo->hmtDRing);

      ulRC=dspConnectITCB(pmwmDspInfo->hmtDRing,
                "DRITCB",
                pmwmDspInfo->hmctlTask,"DRITCB");
      if (!( ulRC == DSP_NOERROR))
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
        return ulRC;
      }

      ulRC = dspChangeModuleState(pmwmDspInfo->hmodDRing,
                   DSP_ACTIVATE_ACTIVE );
      if(! (ulRC == DSP_NOERROR) )
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
        return ulRC;
      }
    }
    mwmCntndLoadComplete(pmwmDspInfo, 1);
    break;
  default : /* bad ulDesiredDRing */
    DPF("mwmCidlLoadDRing Bad ulDesiredMode=%lx", ulDesiredDRing);
    break;
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcidl::mwmCidlLoadDRing exit\n");  }

  return ulRC;
}

