/*
 *   mwagent.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#if !defined(__MWAGENT_H__)
#define __MWAGENT_H__

#if !defined(APIENTRY)
#define APIENTRY  _far _pascal _export _loadds
#endif

#define APIPFN(fn)  (APIENTRY *fn)

/**/
/*------------------------------------------------------------------------*/
/* define types for interface                                             */
/*------------------------------------------------------------------------*/
typedef
unsigned long APIPFN(CLIPROC)(unsigned long  dwConversationId,
                            unsigned short wMessage,
                            unsigned long lParam,
                            unsigned short wSize,
                            void FAR * pBuffer);

typedef
unsigned long APIPFN(SRVPROC)(unsigned long  dwServerId,
                            unsigned long  dwConversationId,
                            unsigned short wMessage,
                            unsigned long lParam,
                            unsigned short wSize,
                            void FAR * pBuffer);

typedef unsigned long HMWAVE;       /* handle for Mwave Access*/
typedef unsigned long HMSERVER;     /* handle for a Server*/
typedef unsigned long HMCONV;       /* handle for a conversation*/

/*------------------------------------------------------------------------*/
/* define Client and Server Proc prototypes first                         */
/*------------------------------------------------------------------------*/
unsigned long APIENTRY ClientProc(unsigned long  dwConversationId,
                            unsigned short wMessage,
                            unsigned long lParam,
                            unsigned short wSize,
                            void FAR * pBuffer);

unsigned long APIENTRY mwDefClientProc(unsigned long  dwConversationId,
                                 unsigned short wMessage,
                                 unsigned long lParam,
                                 unsigned short wSize,
                                 void FAR * pBuffer);

unsigned long APIENTRY ServerProc(unsigned long  dwServerId,
                              unsigned long  dwConversationId,
                              unsigned short wMessage,
                              unsigned long lParam,
                              unsigned short wSize,
                              void FAR * pBuffer);

unsigned long APIENTRY mwDefServerProc(unsigned long  dwServerId,
                               unsigned long  dwConversationId,
                               unsigned short wMessage,
                               unsigned long lParam,
                               unsigned short wSize,
                               void FAR * pBuffer);

/**/
/*------------------------------------------------------------------------*/
/* next define API function prototypes                                    */
/*------------------------------------------------------------------------*/
HMWAVE   APIENTRY mwOpenMwave(char FAR * lpszUserName,
                              unsigned long Reserved1,
                              unsigned long Reserved2);

unsigned long  APIENTRY mwCloseMwave(HMWAVE hMwave, unsigned long Reserved);

HMSERVER APIENTRY mwRegisterServer(HMWAVE  hMwave,
                                   char FAR *   lpszServerName,
                                   SRVPROC pServerProc,
                                   unsigned long  lParam,
                                   unsigned long  Reserved);

unsigned long  APIENTRY mwUnregisterServer(HMSERVER hServer,
                                           unsigned long Reserved);

HMCONV   APIENTRY mwConnectToServer(HMWAVE  hMwave,
                                    char FAR *   lpszServerName,
                                    char FAR *   lpszClientName,
                                    CLIPROC pClientProc,
                                    unsigned long  lParam);

unsigned long  APIENTRY mwDisconnectFromServer(HMCONV hConversation,
                                               unsigned long Reserved);

unsigned long  APIENTRY mwSendToServer(HMCONV hConversation,
                                 unsigned short wMessage,
                                 unsigned long lParam,
                                 unsigned short wSize,
                                 void FAR * pBuffer);

unsigned long  APIENTRY mwNotifyClient(HMCONV hConversation,
                                 unsigned short wMessage,
                                 unsigned long lParam,
                                 unsigned short wSize,
                                 void FAR * pBuffer);


/*****************************************************************************/
/* ADDITIONAL PROTOTYPES FOR OS/2 BASED AGENT.                               */
/*****************************************************************************/
typedef
unsigned long APIPFN(VCLIPROC)(void FAR * pBuffer);

typedef
unsigned long APIPFN(VSRVPROC)(void FAR * pBuffer);

unsigned long APIENTRY RouterProc(void FAR * pBuffer);

/* Additional API's supported by OS/2 MWAGENT */
HMCONV   APIENTRY mwVConnectToServer(HMWAVE  hMwave,
                                    char FAR * lpszServerName,
                                    char FAR * lpszClientName,
                                    CLIPROC pClientProc,
                                    unsigned long lParam,
                                    unsigned long hVDM,
                                    unsigned long hVDMQueue,
                                    VCLIPROC pRouterProc);

HMSERVER APIENTRY mwVRegisterServer(HMWAVE  hMwave,
                                   char FAR * lpszServerName,
                                   SRVPROC pServerProc,
                                   unsigned long lParam,
                                   unsigned long Reserved,
                                   unsigned long hVDM,
                                   unsigned long hVDMQueue,
                                   VSRVPROC pRouterProc);

/* DosExitList() processor routine */
unsigned long  APIENTRY mwShutdown(HMWAVE hMwave, unsigned long Reserved);

/*****************************************************************************/
/* END OF OS/2 ADDITIONS.                                                    */
/*****************************************************************************/
/**/
/*------------------------------------------------------------------------*/
/* next define API Messages and Notifications                             */
/*------------------------------------------------------------------------*/
/**/
/* Server Messages*/
/**/
#define SRV_REGISTER         0x0001
#define SRV_UNREGISTER       0x0002
#define SRV_CONNECT          0x0003
#define SRV_DISCONNECT       0x0004
#define SRV_QUERY            0x0080
/**/
/* Client Messages*/
/**/
#define CLI_CONNECT          0x0101
#define CLI_DISCONNECT       0x0102
#define CLI_QUERY            0x0180
/**/
/*  Mwave Manager Messages*/
/**/
#define MWM_REQUEST_NOTIFY   0x0401
#define MWM_REMOVE_NOTIFY    0x0402
#define MWM_UNLOAD_REQUEST   0x0403
/**/
/*  Mwave Manager Notifications*/
/**/
#define MWN_DSPINIT          0x0501
#define MWN_DSPFAIL          0x0502
#define MWN_UNLOAD_REQUEST   0x0503
/**/
/*  Mwave Manager Responses*/
/**/
#define MWR_REQUEST_ACCEPTED 0x0601
#define MWR_REQUEST_DENIED   0x0602
/**/
/*  define base values for user messages*/
/**/
#define SRV_USERBASE         0x1000
#define CLI_USERBASE         0x4000
/**/
/* define MWAGENT ERROR codes*/
/**/
#define MWAGERR_INVALIDPARMS        0xffff0000L   /* invalid parameters*/
#define MWAGERR_NAMEINUSE           0xfffe0000L   /* Object Name already in use*/
#define MWAGERR_SERVERNOTREGISTERED 0xfffd0000L   /* unknown server*/
#define MWAGERR_INVALIDHANDLE       0xfffc0000L   /* invalid handle*/
#define MWAGERR_UNSUPPORTEDMESSAGE  0xfffb0000L   /* unsupported message*/
#define MWAGERR_INVALIDPROC         0xfffa0000L   /* invalid proc address*/
#define MWAGERR_SYSTEMERROR         0xfff90000L   /* O/S system error*/
#define MWAGERR_NOMORERESOURCES     0xfff80000L   /* out of available resources*/
#define mwAGErrChk(rc)  ((0xff000000L & (unsigned long)rc)==0xff000000L)

#endif

