/************************************************************************/
/* Module : msgbox.c					                */
/* Purpose: Provides basic message dialogs     	                        */
/* By     : Keith R. Davis					        */
/* Date   : 7/24/98					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software			*/
/************************************************************************/

#include <Xm/MessageB.h>	/* message box header	        */

/************************************************************************/
/* Function: MSGBOX_Message                                             */
/* Purpose : displays a basic message box with a string                 */
/* Params  : title : dialog title                                       */
/*           msg : dialog box message string                            */
/*           w : msgbox parent                                          */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void MSGBOX_Message(char *title, char *msg, Widget w)
{ 
  /* dialog widget */
  static Widget msg_dialog = NULL;

  if(!msg_dialog){
    msg_dialog = XmCreateInformationDialog(w, "msgdialog", NULL, 0);
    
    /* remove uneeded children */
    XtUnmanageChild(XmMessageBoxGetChild(msg_dialog, XmDIALOG_HELP_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(msg_dialog, XmDIALOG_CANCEL_BUTTON));
 
  }
  /* setup dialog */
  XtVaSetValues(msg_dialog,
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XtVaTypedArg, XmNdialogTitle, XmRString,
		title, strlen(title)+1,
		XtVaTypedArg, XmNmessageString, XmRString,
		msg, strlen(msg)+1, NULL);
 
  XtManageChild(msg_dialog);
}

/************************************************************************/
/* Function: MSGBOX_Error                                               */
/* Purpose : displays a basic message box with an error string          */
/* Params  : title : dialog title                                       */
/*           msg : dialog box message string                            */
/*           w : msgbox parent                                          */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void MSGBOX_Error(char *title, char *msg, Widget w)
{ 
  /* dialog widget */
  static Widget error_dialog = NULL;

  if(!error_dialog){
    error_dialog = XmCreateErrorDialog(w, "errordialog", NULL, 0);
    
    /* remove uneeded children */
    XtUnmanageChild(XmMessageBoxGetChild(error_dialog, XmDIALOG_HELP_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(error_dialog, XmDIALOG_CANCEL_BUTTON));
 
  }
  /* setup dialog */
  XtVaSetValues(error_dialog,
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XtVaTypedArg, XmNdialogTitle, XmRString,
		title, strlen(title)+1,
		XtVaTypedArg, XmNmessageString, XmRString,
		msg, strlen(msg)+1, NULL);
 
  XtManageChild(error_dialog);
}

/************************************************************************/
/* Function: MSGBOX_ResponseCB                                          */
/* Purpose : sets user's response to Response dialog                    */
/* Params  : standard callback stuff                                    */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void MSGBOX_ResponseCB(Widget w, XtPointer clientdata, XtPointer callData)
{
  Boolean *result = (Boolean*)clientdata;
  *result = TRUE;
}

/************************************************************************/
/* Function: MSGBOX_Response                                            */
/* Purpose : displays a basic message box with a text string            */
/* Params  : title : dialog title                                       */
/*           msg : dialog box message string                            */
/*           w : msgbox parent                                          */
/* Returns : Boolean : user response                                    */
/* Notes   :                                                            */
/************************************************************************/

Boolean MSGBOX_Response(char *title, char *msg, Widget w)
{ 
  /* dialog widget */
  Widget response_dialog;

  const char *ok = "Yes";
  const char *cancel = "No";
  static Boolean result;

  response_dialog = XmCreateQuestionDialog(w, "responsedialog", NULL, 0);
  
  /* remove uneeded children */
  XtUnmanageChild(XmMessageBoxGetChild(response_dialog, XmDIALOG_HELP_BUTTON));

  /* setup dialog */
  XtVaSetValues(response_dialog,
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XtVaTypedArg, XmNdialogTitle, XmRString,
		title, strlen(title)+1,
		XtVaTypedArg, XmNokLabelString, XmRString,
		ok, strlen(ok)+1,
		XtVaTypedArg, XmNcancelLabelString, XmRString,
		cancel, strlen(cancel)+1,
		XtVaTypedArg, XmNmessageString, XmRString,
		msg, strlen(msg)+1, NULL);
  
  XtAddCallback(response_dialog, XmNokCallback,
		MSGBOX_ResponseCB, (XtPointer)&result);

  result = False;

  XtManageChild(response_dialog);
  
  /* enter a loop to wait for the user's response */
  while(XtIsManaged(response_dialog)){
    XEvent event;
    
    XtAppNextEvent(XtWidgetToApplicationContext(response_dialog),
		   &event);
    XtDispatchEvent(&event);
  }

  /* destroy the dialog */
  XtDestroyWidget(response_dialog);

  return result;
}

