/* Inder / Dinamic Video */


/* */


#pragma once

#ifndef __INDER_VIDEO__
#define __INDER_VIDEO__


#include "video/ramdac.h"
#include "cpu/tms34010/tms34010.h"

extern const device_type INDER_VIDEO;

#define MCFG_INDER_VIDEO_ADD(_tag) \
	MCFG_DEVICE_ADD(_tag, INDER_VIDEO, 0)


class inder_vid_device :  public device_t
/*  public device_video_interface */
{
public:
	// construction/destruction
	inder_vid_device(const machine_config &mconfig, const char *tag, device_t *owner, UINT32 clock);

	required_shared_ptr<UINT16> m_vram;
	required_device<palette_device> m_palette;
	required_device<tms34010_device> m_tms;

	int m_shiftfull; // this might be a driver specific hack for a TMS bug.

protected:
	virtual machine_config_constructor device_mconfig_additions() const;
	virtual void device_start();
	virtual void device_reset();



private:


};

#endif
