/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *STtrimIws (const char Si[])

Purpose:
  Trim leading white-space

Description:
  This routine returns a pointer to the first character in a string that is not
  white-space (as defined by isspace).  If the input string consists entirely
  of white-space, this routine returns a pointer to the terminating null
  character.

Parameters:
  <-  char *STrimIws
      Pointer to the first non-white-space character
   -> const char Si[]
      Input character string

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.5 $  $Date: 1997/10/02 14:18:10 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STtrimIws.c 1.5 1997/10/02 libtsp-v3r0 $";

#include <ctype.h>
#include <libtsp/nucleus.h>

char *
STtrimIws (Si)

     const char Si[];

{
  /* Find the first non-white-space character */
  for (; isspace (*Si); ++Si)
    ;

  return ((char *) Si);
}
