/****************************************************************************
 **
 ** $Id: cvsignorelistview.cpp,v 1.23 2005/01/06 22:55:26 frank Exp $
 **
 ** Copyright (C) 2001-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.org>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Tom Mishima <tmishima@mail.at-m.or.jp>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/


#include "config.h"

//----------------------------------------------------------------------------

#include <stdio.h>
#include <qlistview.h>
#include <qevent.h>
#include <qpopupmenu.h>

//----------------------------------------------------------------------------

#include "FileListView.h"
#include "cvsignorelistview.h"
#include "globals.h"
#include "pixmapcache.h"

//----------------------------------------------------------------------------

CvsIgnoreListView::CvsIgnoreListView(QPopupMenu * menu, QWidget *Parent, const char * name) 
   : CFileListView(Parent, name), m_pMenu(menu), m_PrevCount(0), m_selectedOnPress(false)
{
   /* Use extended selection mode.  When we click on this
    * window we usually want to operate on a single file by using
    * the menu unless the user uses the shift or control key.
    * We don't want to use the standard multiple selection mode
    * because the point in having a tree view is so we can perform
    * the operation on the whole directory hierarchy in one go.
    */
   setSelectionMode (QListView::Extended);
   setAllColumnsShowFocus(true);
   setShowSortIndicator( true);

   addColumn(tr("Name"));
   addColumn(tr("Modified"));

   connect(this, SIGNAL(doubleClicked(QListViewItem *)),
	 this, SLOT(selFile(QListViewItem *)));
   connect (this, SIGNAL( selectionChanged()),
	 this, SLOT( selectionChanged()));
   selected = false;
}

//----------------------------------------------------------------------------

FileListViewItem * CvsIgnoreListView::firstChild() const {
   return static_cast<FileListViewItem*>(CFileListView::firstChild());
}

//----------------------------------------------------------------------------

void CvsIgnoreListView::contentsMousePressEvent (QMouseEvent * e)
{
   if (!globalListViewsEnabled) return;

   if (!hasFocus() && !viewport()->hasFocus()) setFocus();

   QListViewItem * item = itemAt(contentsToViewport(e->pos()));
   if (item) m_selectedOnPress = item->isSelected();

   QListView::contentsMousePressEvent(e);

   QPoint offset(10, 30);
   if (item) {
      if (e->button() == RightButton) {
	 setSelected(item, true);
	 setCurrentItem(item);
	 m_pMenu->popup(mapToGlobal(contentsToViewport(e->pos())) + offset);
      } else if ( (e->button() == LeftButton) && !m_selectedOnPress) {
	 setSelected(item, item->isSelected());
	 setCurrentItem(item);
      }
   }
}

//----------------------------------------------------------------------------

void CvsIgnoreListView::contentsMouseReleaseEvent(QMouseEvent * e)
{
   if (!globalListViewsEnabled) return;

   QListViewItem* item = itemAt(contentsToViewport(e->pos()));
   QListView::contentsMouseReleaseEvent( e );
   if ( item && (e->button() == LeftButton) && m_selectedOnPress) {
      setCurrentItem(item);
      setSelected(item, false);
   }
}

//----------------------------------------------------------------------------

void CvsIgnoreListView::keyPressEvent ( QKeyEvent * e ) 
{
   if (!globalListViewsEnabled) return;

   QListView::keyPressEvent( e );

   if(e->key() == Qt::Key_Return) {   
      if (currentItem()) {
	 setSelected(currentItem(), true);
	 m_pMenu->popup(mapToGlobal(QPoint(60, 40)));
      }
   } else if (e->key() == Qt::Key_Escape) {
      FileListViewItem * item = firstChild();
      while (item) {
	 if (item->isSelected()) setSelected(item,false);
	 item = item->nextSibling();
      }
   }
}

//----------------------------------------------------------------------------

void CvsIgnoreListView::signalState(void)
{
   if (childCount() != m_PrevCount) {
      m_PrevCount = childCount();
      emit itemCount(m_PrevCount);
   }
}

//----------------------------------------------------------------------------
