/****************************************************************************
 **
 ** $Id: WrappersIgnoreDialogImpl.cpp,v 1.11 2004/10/06 00:07:55 frank Exp $
 **
 ** Copyright (C) 2001-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.org>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Tom Mishima <tmishima@mail.at-m.or.jp>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "config.h"

#include <qgroupbox.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qwhatsthis.h>

#include "globals.h"
#include "WrappersIgnoreDialogImpl.h"

WrappersIgnoreDialogImpl::WrappersIgnoreDialogImpl( QStringList* src,
      const QIconSet &whatsThisIconSet,
      QString caption,
      QWidget* parent,
      const char* name,
      bool modal,
      WFlags f)
   : WrappersIgnoreDialog( parent, name, modal,f),
     m_pSrc(src),m_Caption(caption)
{
   m_pWhatsThis->setIconSet(whatsThisIconSet);
   m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());

   setCaption(m_Caption);
   m_GroupBox->setTitle(m_Caption);
   m_ListBox->insertStringList(*m_pSrc);
   connect(m_ListBox,SIGNAL(clicked(QListBoxItem*)),this,SLOT(edited(QListBoxItem*)));
   connect(m_ListBox,SIGNAL(returnPressed(QListBoxItem*)),this,SLOT(edited(QListBoxItem*)));
   connect(m_ListBox,SIGNAL(selectionChanged(QListBoxItem*)),this,SLOT(selectionChanged(QListBoxItem*)));
   m_EnterField->setFocus();

   setTabOrder(m_EnterField,m_ListBox);
   setTabOrder(m_ListBox,AddButton);
   setTabOrder(OkButton,ModifyButton);
   setTabOrder(ModifyButton,RemoveButton);
   setTabOrder(RemoveButton,UpButton);
   setTabOrder(UpButton,DownButton);
   setTabOrder(DownButton,OkButton);
   setTabOrder(OkButton,CancelButton);
   setTabOrder(CancelButton,m_EnterField);

}

/*  
 *  Destroys the object and frees any allocated resources
 */
WrappersIgnoreDialogImpl::~WrappersIgnoreDialogImpl()
{
   // no need to delete child widgets, Qt does it all for us
}

void WrappersIgnoreDialogImpl::resetClicked() {
   m_ListBox->clear();
   m_ListBox->insertStringList(*m_pSrc);
}

void WrappersIgnoreDialogImpl::addClicked() {
   QString tmp = m_EnterField->text();
   if (tmp.isEmpty()) return;
   int pos = m_ListBox->currentItem();
   m_ListBox->insertItem(tmp,++pos);
   m_ListBox->setSelected(pos,true);
   m_ListBox->ensureCurrentVisible();
   m_ListBox->centerCurrentItem();
   m_EnterField->clear();
}

void WrappersIgnoreDialogImpl::modifyClicked() {
   QString tmp = m_EnterField->text();
   if (tmp.isEmpty()) return;
   int pos = m_ListBox->currentItem();
   if (pos >=0) {
      m_ListBox->changeItem(tmp,pos);
      m_EnterField->clear();
   }
}

void WrappersIgnoreDialogImpl::removeClicked() {
   int pos = m_ListBox->currentItem();
   m_ListBox->removeItem(pos);
   if ((int)m_ListBox->count()<=pos) {
      pos--;
   }
   if (pos<0) {
      m_EnterField->clear();
      return;
   }
   m_ListBox->setSelected(pos,true);
}

void WrappersIgnoreDialogImpl::upClicked() {
   QString tmp = m_ListBox->currentText();
   int pos = m_ListBox->currentItem();
   m_ListBox->removeItem(pos);
   m_ListBox->insertItem(tmp,--pos);
   m_ListBox->setSelected(pos,true);
   m_ListBox->ensureCurrentVisible();
   m_ListBox->centerCurrentItem();
}

void WrappersIgnoreDialogImpl::downClicked() {
   QString tmp = m_ListBox->currentText();
   int pos = m_ListBox->currentItem();
   m_ListBox->removeItem(pos);
   m_ListBox->insertItem(tmp,++pos);
   m_ListBox->setSelected(pos,true);
   m_ListBox->ensureCurrentVisible();
   m_ListBox->centerCurrentItem();
}

void WrappersIgnoreDialogImpl::selectionChanged(QListBoxItem* item) {
   if (!item) return;
   m_EnterField->setText(item->text());
   m_EnterField->selectAll();
}

void WrappersIgnoreDialogImpl::edited(QListBoxItem*) {
   m_EnterField->setFocus();
}

void WrappersIgnoreDialogImpl::accept() {
   WrappersIgnoreDialog::accept();

   //set entrylist
   m_pSrc->clear();
   QListBoxItem* item;
   item = m_ListBox->firstItem();
   while (item) {
      m_pSrc->append(item->text());
      item = item->next();
   }
}

void WrappersIgnoreDialogImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}
