/****************************************************************************
 **
 ** $Id: Rename.cpp,v 1.4 2004/12/20 02:42:11 frank Exp $
 **
 ** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "Rename.h"

#include <qapplication.h>
#include <assert.h>
#include <qinputdialog.h>

#include "globals.h"
#include "Add.h"
#include "Remove.h"

Rename * Rename::renameFile(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, false);
}

Rename * Rename::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, bool isDir) {

   DirBase * dir = workBench->selectedItem();
   if (!dir) return NULL;

   QStringList fileList = dir->getSelectedFiles();
   if (fileList.count() != 1) {
      return NULL;
   }

   bool ok;
   QString fileName = QInputDialog::getText(tr("Rename"), tr("New name : "),
	 QLineEdit::Normal,
	 fileList[0], &ok, parent ).stripWhiteSpace();

   if( (!ok) || fileName.isEmpty() || fileName == fileList[0] ) {//not detected by system(command.ascii())
      return NULL;
   }

   if (dir->getType() == DirBase::Cvs) {
      Rename * p = new Rename(whatsThisIconSet, parent, workBench, dir, isDir);
      p->m_oldName = fileList[0];
      p->m_newName = fileName;
      p->m_mode = RENAME;
      p->acceptCvs();
   } else {
      qDebug("Rename: Method not implemented");
   }
   return NULL;
}

Rename::Rename(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, bool isDir)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_dlg(NULL),
      m_isDir(isDir)
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
   connect(this,SIGNAL(checkInProgress(bool)),parent,SLOT(checkInProgress(bool)));
   connect(this,SIGNAL(showWarning(const QString&,const QString&)),parent,SLOT(showWarning(const QString&,const QString&)));
}

Rename::~Rename() {
   if (m_dlg) delete m_dlg;
   m_dlg = NULL;
}

void Rename::acceptCvs() {

   while (true) {
      assert(m_dir);
      switch(m_mode) {
	 case RENAME: {
	    if (m_dir->isBinary(m_oldName)) {
	       m_kind = BINARY;
	    } else {
	       m_kind = ASCII;
	    }
	    QString path = m_dir->fullName()+"/";
	    if (!rename(path+m_oldName,path+m_newName)) {
	       emit showWarning( tr("Rename"), tr("Cannot rename file") );
	       reject(false);
	       return;
	    }
	    m_mode = REMOVE;
	    break;
	 }
	 case REMOVE: {
	    m_mode = ADD;
	    Remove::removeSelectionFile(m_whatsThisIconSet,m_parent,m_workBench,m_dir,QStringList(m_oldName),this);
	    return;
	 }
	 case ADD: {
	    m_mode = DONE;
	    if (m_kind == ASCII) {
	       Add::addSelectionAscii(m_whatsThisIconSet,m_parent,m_workBench,m_dir,QStringList(m_newName),this);
	    } else {
	       Add::addSelectionBinary(m_whatsThisIconSet,m_parent,m_workBench,m_dir,QStringList(m_newName),this);
	    }
	    return;
	 }
	 case DONE: {
	    emit checkInProgress(true);
	    m_dir->postCallCheck(DirBase::Controled);
	    emit checkInProgress(false);
	    reject(true);
	    return;
	 }
      }
   }

}

void Rename::callDone(bool state) {
   if (state) {
      acceptCvs();
   } else {
      emit showWarning(tr("Warning"),tr("Command failed"));
      reject(false);
   }
}

void Rename::reject(bool state) {
   emit done(state);
   emit deleteObject(this);
}

void Rename::cvsCallStarted() {
   QApplication::setOverrideCursor(Qt::waitCursor);
}

void Rename::cvsCallFinished() {
   QApplication::restoreOverrideCursor();
}

void Rename::afterCall(int cmd,CvsBuffer*,bool failed) {
   cvsCallFinished();
   if (failed) {
      reject(false);
      return;
   }
   switch( cmd) {
      case NOOP: {
	 break;
      }
      default: {
	 qDebug("Rename::afterCall: Unknown cmd");
      }
   }
   reject(true);
}
