/****************************************************************************
 **
 ** $Id: Log.cpp,v 1.5 2004/12/20 02:42:11 frank Exp $
 **
 ** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "Log.h"

#include <qapplication.h>
#include <assert.h>

#include "globals.h"
#include "LogDialogImpl.h"

Log * Log::logFile(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, false);
}

Log * Log::logDir(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, true);
}

Log * Log::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, bool isDir) {

   DirBase * dir = workBench->selectedItem();
   if (!dir) return NULL;

   if (dir->getType() == DirBase::Cvs) {

      Log * p = new Log(whatsThisIconSet, parent, workBench, dir, isDir);
      p->acceptCvs();
      return p;

   } else {

      qDebug("Log: Method not implemented");
      return NULL;
   }
}

Log::Log(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, bool isDir)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_dlg(NULL),
      m_isDir(isDir)
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
}

Log::~Log() {
   if (m_dlg) delete m_dlg;
   m_dlg = NULL;
}

void Log::acceptCvs() {

   assert(m_dir);

   int cmd = -1;
   QString command = CvsOptions::cmprStr() + " log";
   QStringList filesList;
   if (!m_isDir) {
      filesList = m_dir->getSelectedFiles();
      if (filesList.isEmpty()) {
	 reject();
	 return;
      }
      if (filesList.count() == 1) {
	 QString tmp = filesList[0];
	 m_rev = m_dir->getRev(&tmp);
      }
      m_files = masqWs(filesList.join("\" \""));
      cmd = CVS_LOG_CMD;
   } else {
      cmd = CVS_LOG_DIR_CMD;
   }

   QString dir = m_dir->fullName();
   QString topModule = m_dir->topControlledDir()->relativeName();
   
   callInteractive( topModule, dir, command,
	 m_files, cmd,
	 ExtApps::g_cvsRsh.path,  //additional options of cvsRsh not supported yet
	 NOROOT);
}

void Log::reject() {
   emit deleteObject(this);
}

void Log::cvsCallStarted() {
   QApplication::setOverrideCursor(Qt::waitCursor);
}

void Log::cvsCallFinished() {
   QApplication::restoreOverrideCursor();
}

void Log::afterCall(int cmd,CvsBuffer * buf,bool failed) {
   cvsCallFinished();
   if (failed) {
      reject();
      return;
   }
   assert(m_dir);
   switch( cmd) {
      case CVS_LOG_CMD: {
	 LogDialogImpl * dlg = new LogDialogImpl (m_workBench,
	       m_dir,
	       m_whatsThisIconSet,
	       m_parent, "LogDlg",
	       LookAndFeel::g_nonModalF | WDestructiveClose);
           
	 connect( dlg, SIGNAL(editFile(QString)), m_parent, SLOT(viewFileWithPath(QString)));
	 dlg->parseCvsLog( m_dir->fullName(), m_files, m_rev , buf );
	 dlg->show();
	 break;
      }
      case CVS_LOG_DIR_CMD: {
	 LogDialogImpl * dlg = new LogDialogImpl (m_workBench,
	       m_dir,
	       m_whatsThisIconSet,
	       m_parent, "LogDlg",
	       LookAndFeel::g_nonModalF | WDestructiveClose);
           
	 connect( dlg, SIGNAL(editFile(QString)), m_parent, SLOT(viewFileWithPath(QString)));
	 dlg->parseCvsLog( m_dir->fullName(), m_dir->shortName(), "", buf );
	 dlg->show();
	 break;
      }
      default: {
	 qDebug("Log::afterCall: Unknown cmd");
      }
   }
   reject();
}
