/****************************************************************************
 **
 ** $Id: Add.cpp,v 1.7 2004/12/22 12:34:15 frank Exp $
 **
 ** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "Add.h"

#include <qapplication.h>
#include <assert.h>

#include "globals.h"

Add * Add::addFileAscii(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, false, ASCII);
}

Add * Add::addFileBinary(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, false, BINARY);
}

Add * Add::addDir(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, true, DIR);
}

Add * Add::addResurrect(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, false, RESURRECT);
}

Add * Add::addSelectionAscii(const QIconSet &whatsThisIconSet,
      QWidget* parent,
      CvsDirListView * workBench,
      DirBase * dir,
      QStringList list,
      QObject * receiver) {
   return setup(whatsThisIconSet, parent, workBench, dir, false, ASCII, list, receiver);
}

Add * Add::addSelectionBinary(const QIconSet &whatsThisIconSet,
      QWidget* parent,
      CvsDirListView * workBench,
      DirBase * dir,
      QStringList list,
      QObject * receiver) {
   return setup(whatsThisIconSet, parent, workBench, dir, false,BINARY, list, receiver);
}

Add * Add::addSelectionDir(const QIconSet &whatsThisIconSet,
      QWidget* parent,
      CvsDirListView * workBench,
      DirBase * dir,
      QStringList list,
      QObject * receiver) {
   return setup(whatsThisIconSet, parent, workBench, dir, true, DIR, list, receiver);
}

Add * Add::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, bool isDir, int mode) {

   DirBase * dir = workBench->selectedItem();
   if (!dir) return NULL;

   QStringList list;
   if (!isDir || (dir->getType() == DirBase::Cvs)) {
      list = dir->getSelectedFiles();
      if (list.isEmpty()) return NULL;
   }

   return setup(whatsThisIconSet, parent, workBench, dir, isDir, mode, list);
}

Add * Add::setup(const QIconSet &whatsThisIconSet,
      QWidget* parent,
      CvsDirListView * workBench,
      DirBase * dir,
      bool isDir,
      int mode,
      QStringList filesList,
      QObject * receiver) {

   if (dir->getType() == DirBase::Cvs) {
      Add * p = new Add(whatsThisIconSet, parent, workBench, dir, isDir, mode);
      if (receiver) {
	 connect(p, SIGNAL(done(bool)), receiver, SLOT(callDone(bool)));
	 p->m_activate = false;
      }
      p->m_filesList = filesList;
      p->acceptCvs();
      return p;
   } else {
      qDebug("Add: Method not implemented");
   }
   return NULL;
}

Add::Add(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, bool isDir, int mode)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_dlg(NULL),
      m_isDir(isDir),
      m_mode(mode),
      m_activate(true)
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
   connect(this,SIGNAL(checkTree(DirBase *)),parent,SLOT(slot_checkStatusOfTree(DirBase *)));
   connect(this,SIGNAL(checkInProgress(bool)),parent,SLOT(checkInProgress(bool)));
   connect(this,SIGNAL(selectSubDir(DirBase **,QString)),parent,SLOT(slot_selectSubDir(DirBase **,QString)));
}

Add::~Add() {
   if (m_dlg) {
      delete m_dlg;
      m_dlg = NULL;
   }
}

void Add::acceptCvs() {

   assert(m_dir);

   m_firstPosAddedDir = "";

   QString command = "";
   if (!bRWPermission) command += "-r ";
   command += CvsOptions::cmprStr();
   command += " add";

   int cmd = -1;
   switch (m_mode) {
      case RESURRECT: {
	 cmd = CVS_RESURRECT_CMD;
	 break;
      }
      case ASCII: {
	 cmd = CVS_ADD_CMD;
	 break;
      }
      case BINARY: {
	 cmd = CVS_ADD_CMD;
	 command += " -kb";
	 break;
      }
      case DIR: {
	 cmd = CVS_ADD_CMD;
	 if (!m_filesList.isEmpty()) {
	    m_firstPosAddedDir = m_dir->fullName()+"/"+m_filesList[0];
	 }
	 break;
      }
      default: {
	 assert(false);
	 break;
      }
   }

   QString files = m_filesList.isEmpty() ? "" : masqWs(m_filesList.join("\" \""));
   QString dir = m_dir->fullName();
   QString topModule = m_dir->topControlledDir()->relativeName();
   
   callInteractive( topModule, dir, command,
	 files, cmd,
	 ExtApps::g_cvsRsh.path,  //additional options of cvsRsh not supported yet
	 NOROOT);
}

void Add::reject(bool state) {
   emit done(state);
   emit deleteObject(this);
}

void Add::cvsCallStarted() {
   QApplication::setOverrideCursor(Qt::waitCursor);
}

void Add::cvsCallFinished() {
   QApplication::restoreOverrideCursor();
}

void Add::afterCall(int cmd,CvsBuffer * buf,bool failed) {
   cvsCallFinished();
   if (failed) {
      reject(false);
      return;
   }
   assert(m_dir);
   switch( cmd) {
      case CALL_ID: {
	 break;
      }
      case CVS_RESURRECT_CMD:
      case CVS_ADD_CMD: {
	 m_dir->parseCallResult( buf, cmd);
	 if (m_activate) {
	    emit checkInProgress(true);
	    m_dir->activateItem(true);
	    if( !m_firstPosAddedDir.isEmpty()) {
	       DirBase * tmp = m_dir;
	       emit selectSubDir(&tmp,m_firstPosAddedDir);//might delete m_dir
	       m_dir = tmp;
	    }
	    emit checkInProgress(false);
	 }
	 m_firstPosAddedDir = "";
	 m_filesList.clear();
	 break;
      }
      default: {
	 qDebug("Add::afterCall: Unknown cmd");
      }
   }
   reject(true);
}
