/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util;

import htsjdk.tribble.util.URLHelper;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

public class HTTPHelper
implements URLHelper {
    static Proxy proxy;
    private URL url;

    public HTTPHelper(URL url) {
        this.url = url;
        proxy = null;
        try {
            HttpURLConnection conn = this.openConnection();
            conn.setDefaultUseCaches(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void setProxy(Proxy p) {
        proxy = p;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getContentLength() throws IOException {
        HttpURLConnection con = null;
        try {
            con = this.openConnection();
            con.setRequestMethod("HEAD");
            if (con.getResponseCode() != 200) {
                System.out.println("Error (" + con.getResponseMessage() + " ) fetching content length: " + this.url);
                long l = -1L;
                return l;
            }
            String contentLength = con.getHeaderField("Content-Length");
            long l = contentLength == null ? -1L : Long.parseLong(contentLength);
            return l;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    @Override
    public InputStream openInputStream() throws IOException {
        HttpURLConnection connection = this.openConnection();
        return new WrapperInputStream(connection, connection.getInputStream());
    }

    @Override
    public InputStream openInputStreamForRange(long start, long end) throws IOException {
        HttpURLConnection connection = this.openConnection();
        String byteRange = "bytes=" + start + "-" + end;
        connection.setRequestProperty("Range", byteRange);
        return new WrapperInputStream(connection, connection.getInputStream());
    }

    private HttpURLConnection openConnection() throws IOException {
        HttpURLConnection connection = proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(proxy);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws IOException {
        HttpURLConnection con = null;
        try {
            con = this.openConnection();
            con.setRequestMethod("HEAD");
            boolean bl = con.getResponseCode() == 200;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    class WrapperInputStream
    extends FilterInputStream {
        HttpURLConnection connection;

        protected WrapperInputStream(HttpURLConnection connection, InputStream inputStream) {
            super(inputStream);
            this.connection = connection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.connection.disconnect();
        }
    }
}

