/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.SAMBinaryTagAndUnsignedArrayValue;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SAMRecord
implements Cloneable {
    public static final int UNKNOWN_MAPPING_QUALITY = 255;
    public static final int NO_MAPPING_QUALITY = 0;
    public static final String NO_ALIGNMENT_REFERENCE_NAME = "*";
    public static final int NO_ALIGNMENT_REFERENCE_INDEX = -1;
    public static final String NO_ALIGNMENT_CIGAR = "*";
    public static final int NO_ALIGNMENT_START = 0;
    public static final byte[] NULL_SEQUENCE = new byte[0];
    public static final String NULL_SEQUENCE_STRING = "*";
    public static final byte[] NULL_QUALS = new byte[0];
    public static final String NULL_QUALS_STRING = "*";
    public static final int MAX_INSERT_SIZE = 0x20000000;
    private static final int READ_PAIRED_FLAG = 1;
    private static final int PROPER_PAIR_FLAG = 2;
    private static final int READ_UNMAPPED_FLAG = 4;
    private static final int MATE_UNMAPPED_FLAG = 8;
    private static final int READ_STRAND_FLAG = 16;
    private static final int MATE_STRAND_FLAG = 32;
    private static final int FIRST_OF_PAIR_FLAG = 64;
    private static final int SECOND_OF_PAIR_FLAG = 128;
    private static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    private static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    private static final int DUPLICATE_READ_FLAG = 1024;
    private static final int SUPPLEMENTARY_ALIGNMENT_FLAG = 2048;
    private String mReadName = null;
    private byte[] mReadBases = NULL_SEQUENCE;
    private byte[] mBaseQualities = NULL_QUALS;
    private String mReferenceName = "*";
    private int mAlignmentStart = 0;
    private transient int mAlignmentEnd = 0;
    private int mMappingQuality = 0;
    private String mCigarString = "*";
    private Cigar mCigar = null;
    private List<AlignmentBlock> mAlignmentBlocks = null;
    private int mFlags = 0;
    private String mMateReferenceName = "*";
    private int mMateAlignmentStart = 0;
    private int mInferredInsertSize = 0;
    private SAMBinaryTagAndValue mAttributes = null;
    protected Integer mReferenceIndex = null;
    protected Integer mMateReferenceIndex = null;
    private Integer mIndexingBin = null;
    private ValidationStringency mValidationStringency = ValidationStringency.SILENT;
    private SAMFileSource mFileSource;
    private SAMFileHeader mHeader = null;

    public SAMRecord(SAMFileHeader header) {
        this.mHeader = header;
    }

    public String getReadName() {
        return this.mReadName;
    }

    public int getReadNameLength() {
        return this.mReadName.length();
    }

    public void setReadName(String value) {
        this.mReadName = value;
    }

    public String getReadString() {
        byte[] readBases = this.getReadBases();
        if (readBases.length == 0) {
            return "*";
        }
        return StringUtil.bytesToString(readBases);
    }

    public void setReadString(String value) {
        if ("*".equals(value)) {
            this.mReadBases = NULL_SEQUENCE;
        } else {
            byte[] bases = StringUtil.stringToBytes(value);
            SAMUtils.normalizeBases(bases);
            this.setReadBases(bases);
        }
    }

    public byte[] getReadBases() {
        return this.mReadBases;
    }

    public void setReadBases(byte[] value) {
        this.mReadBases = value;
    }

    public int getReadLength() {
        return this.getReadBases().length;
    }

    public String getBaseQualityString() {
        if (Arrays.equals(NULL_QUALS, this.getBaseQualities())) {
            return "*";
        }
        return SAMUtils.phredToFastq(this.getBaseQualities());
    }

    public void setBaseQualityString(String value) {
        if ("*".equals(value)) {
            this.setBaseQualities(NULL_QUALS);
        } else {
            this.setBaseQualities(SAMUtils.fastqToPhred(value));
        }
    }

    public byte[] getBaseQualities() {
        return this.mBaseQualities;
    }

    public void setBaseQualities(byte[] value) {
        this.mBaseQualities = value;
    }

    public byte[] getOriginalBaseQualities() {
        String oqString = (String)this.getAttribute("OQ");
        if (oqString != null && oqString.length() > 0) {
            return SAMUtils.fastqToPhred(oqString);
        }
        return null;
    }

    public void setOriginalBaseQualities(byte[] oq) {
        this.setAttribute("OQ", (Object)SAMUtils.phredToFastq(oq));
    }

    private static boolean hasReferenceName(Integer referenceIndex, String referenceName) {
        return referenceIndex != null && referenceIndex != -1 || !"*".equals(referenceName);
    }

    private boolean hasReferenceName() {
        return SAMRecord.hasReferenceName(this.mReferenceIndex, this.mReferenceName);
    }

    private boolean hasMateReferenceName() {
        return SAMRecord.hasReferenceName(this.mMateReferenceIndex, this.mMateReferenceName);
    }

    public String getReferenceName() {
        return this.mReferenceName;
    }

    public void setReferenceName(String value) {
        int referenceIndex;
        if ("*".equals(value)) {
            this.mReferenceName = "*";
            this.mReferenceIndex = -1;
            return;
        }
        if (this.mHeader != null && (referenceIndex = this.mHeader.getSequenceIndex(value)) != -1) {
            this.setReferenceIndex(referenceIndex);
            return;
        }
        this.mReferenceName = value.intern();
        this.mReferenceIndex = null;
    }

    public Integer getReferenceIndex() {
        if (this.mReferenceIndex == null) {
            this.mReferenceIndex = this.mReferenceName == null ? Integer.valueOf(-1) : ("*".equals(this.mReferenceName) ? Integer.valueOf(-1) : Integer.valueOf(this.mHeader.getSequenceIndex(this.mReferenceName)));
        }
        return this.mReferenceIndex;
    }

    public void setReferenceIndex(int referenceIndex) {
        this.mReferenceIndex = referenceIndex;
        if (this.mReferenceIndex == -1) {
            this.mReferenceName = "*";
        } else {
            try {
                this.mReferenceName = this.mHeader.getSequence(referenceIndex).getSequenceName();
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Reference index " + referenceIndex + " not found in sequence dictionary.", e);
            }
        }
    }

    public String getMateReferenceName() {
        return this.mMateReferenceName;
    }

    public void setMateReferenceName(String mateReferenceName) {
        int referenceIndex;
        if ("*".equals(mateReferenceName)) {
            this.mMateReferenceName = "*";
            this.mMateReferenceIndex = -1;
            return;
        }
        if (this.mHeader != null && (referenceIndex = this.mHeader.getSequenceIndex(mateReferenceName)) != -1) {
            this.setMateReferenceIndex(referenceIndex);
            return;
        }
        this.mMateReferenceName = mateReferenceName.intern();
        this.mMateReferenceIndex = null;
    }

    public Integer getMateReferenceIndex() {
        if (this.mMateReferenceIndex == null) {
            this.mMateReferenceIndex = this.mMateReferenceName == null ? Integer.valueOf(-1) : ("*".equals(this.mMateReferenceName) ? Integer.valueOf(-1) : Integer.valueOf(this.mHeader.getSequenceIndex(this.mMateReferenceName)));
        }
        return this.mMateReferenceIndex;
    }

    public void setMateReferenceIndex(int referenceIndex) {
        this.mMateReferenceIndex = referenceIndex;
        if (this.mMateReferenceIndex == -1) {
            this.mMateReferenceName = "*";
        } else {
            try {
                this.mMateReferenceName = this.mHeader.getSequence(referenceIndex).getSequenceName();
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Reference index " + referenceIndex + " not found in sequence dictionary.", e);
            }
        }
    }

    public int getAlignmentStart() {
        return this.mAlignmentStart;
    }

    public void setAlignmentStart(int value) {
        this.mAlignmentStart = value;
        this.mAlignmentEnd = 0;
        this.setIndexingBin(null);
    }

    public int getAlignmentEnd() {
        if (this.getReadUnmappedFlag()) {
            return 0;
        }
        if (this.mAlignmentEnd == 0) {
            this.mAlignmentEnd = this.mAlignmentStart + this.getCigar().getReferenceLength() - 1;
        }
        return this.mAlignmentEnd;
    }

    public int getUnclippedStart() {
        return SAMUtils.getUnclippedStart(this.getAlignmentStart(), this.getCigar());
    }

    public int getUnclippedEnd() {
        return SAMUtils.getUnclippedEnd(this.getAlignmentEnd(), this.getCigar());
    }

    public int getReferencePositionAtReadPosition(int offset) {
        if (offset == 0) {
            return 0;
        }
        for (AlignmentBlock alignmentBlock : this.getAlignmentBlocks()) {
            if (CoordMath.getEnd(alignmentBlock.getReadStart(), alignmentBlock.getLength()) < offset) continue;
            if (offset < alignmentBlock.getReadStart()) {
                return 0;
            }
            return alignmentBlock.getReferenceStart() + offset - alignmentBlock.getReadStart();
        }
        return 0;
    }

    public void setAlignmentEnd(int value) {
        throw new UnsupportedOperationException("Not supported: setAlignmentEnd");
    }

    public int getMateAlignmentStart() {
        return this.mMateAlignmentStart;
    }

    public void setMateAlignmentStart(int mateAlignmentStart) {
        this.mMateAlignmentStart = mateAlignmentStart;
    }

    public int getInferredInsertSize() {
        return this.mInferredInsertSize;
    }

    public void setInferredInsertSize(int inferredInsertSize) {
        this.mInferredInsertSize = inferredInsertSize;
    }

    public int getMappingQuality() {
        return this.mMappingQuality;
    }

    public void setMappingQuality(int value) {
        this.mMappingQuality = value;
    }

    public String getCigarString() {
        if (this.mCigarString == null && this.getCigar() != null) {
            this.mCigarString = TextCigarCodec.getSingleton().encode(this.getCigar());
        }
        return this.mCigarString;
    }

    public void setCigarString(String value) {
        this.mCigarString = value;
        this.mCigar = null;
        this.mAlignmentBlocks = null;
        this.mAlignmentEnd = 0;
        this.setIndexingBin(null);
    }

    public Cigar getCigar() {
        if (this.mCigar == null && this.mCigarString != null) {
            this.mCigar = TextCigarCodec.getSingleton().decode(this.mCigarString);
            if (this.getValidationStringency() != ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
                SAMUtils.processValidationErrors(this.validateCigar(-1L), -1L, this.getValidationStringency());
            }
        }
        return this.mCigar;
    }

    public int getCigarLength() {
        return this.getCigar().numCigarElements();
    }

    public void setCigar(Cigar cigar) {
        this.initializeCigar(cigar);
        this.setIndexingBin(null);
    }

    protected void initializeCigar(Cigar cigar) {
        this.mCigar = cigar;
        this.mCigarString = null;
        this.mAlignmentBlocks = null;
        this.mAlignmentEnd = 0;
    }

    public SAMReadGroupRecord getReadGroup() {
        String rgId = (String)this.getAttribute(SAMTagUtil.getSingleton().RG);
        if (rgId == null) {
            return null;
        }
        return this.getHeader().getReadGroup(rgId);
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setFlags(int value) {
        this.mFlags = value;
        this.setIndexingBin(null);
    }

    public boolean getReadPairedFlag() {
        return (this.mFlags & 1) != 0;
    }

    private void requireReadPaired() {
        if (!this.getReadPairedFlag()) {
            throw new IllegalStateException("Inappropriate call if not paired read");
        }
    }

    public boolean getProperPairFlag() {
        this.requireReadPaired();
        return this.getProperPairFlagUnchecked();
    }

    private boolean getProperPairFlagUnchecked() {
        return (this.mFlags & 2) != 0;
    }

    public boolean getReadUnmappedFlag() {
        return (this.mFlags & 4) != 0;
    }

    public boolean getMateUnmappedFlag() {
        this.requireReadPaired();
        return this.getMateUnmappedFlagUnchecked();
    }

    private boolean getMateUnmappedFlagUnchecked() {
        return (this.mFlags & 8) != 0;
    }

    public boolean getReadNegativeStrandFlag() {
        return (this.mFlags & 0x10) != 0;
    }

    public boolean getMateNegativeStrandFlag() {
        this.requireReadPaired();
        return this.getMateNegativeStrandFlagUnchecked();
    }

    private boolean getMateNegativeStrandFlagUnchecked() {
        return (this.mFlags & 0x20) != 0;
    }

    public boolean getFirstOfPairFlag() {
        this.requireReadPaired();
        return this.getFirstOfPairFlagUnchecked();
    }

    private boolean getFirstOfPairFlagUnchecked() {
        return (this.mFlags & 0x40) != 0;
    }

    public boolean getSecondOfPairFlag() {
        this.requireReadPaired();
        return this.getSecondOfPairFlagUnchecked();
    }

    private boolean getSecondOfPairFlagUnchecked() {
        return (this.mFlags & 0x80) != 0;
    }

    public boolean getNotPrimaryAlignmentFlag() {
        return (this.mFlags & 0x100) != 0;
    }

    public boolean getSupplementaryAlignmentFlag() {
        return (this.mFlags & 0x800) != 0;
    }

    public boolean getReadFailsVendorQualityCheckFlag() {
        return (this.mFlags & 0x200) != 0;
    }

    public boolean getDuplicateReadFlag() {
        return (this.mFlags & 0x400) != 0;
    }

    public void setReadPairedFlag(boolean flag) {
        this.setFlag(flag, 1);
    }

    public void setProperPairFlag(boolean flag) {
        this.setFlag(flag, 2);
    }

    public void setReadUmappedFlag(boolean flag) {
        this.setReadUnmappedFlag(flag);
    }

    public void setReadUnmappedFlag(boolean flag) {
        this.setFlag(flag, 4);
        this.setIndexingBin(null);
    }

    public void setMateUnmappedFlag(boolean flag) {
        this.setFlag(flag, 8);
    }

    public void setReadNegativeStrandFlag(boolean flag) {
        this.setFlag(flag, 16);
    }

    public void setMateNegativeStrandFlag(boolean flag) {
        this.setFlag(flag, 32);
    }

    public void setFirstOfPairFlag(boolean flag) {
        this.setFlag(flag, 64);
    }

    public void setSecondOfPairFlag(boolean flag) {
        this.setFlag(flag, 128);
    }

    public void setNotPrimaryAlignmentFlag(boolean flag) {
        this.setFlag(flag, 256);
    }

    public void setSupplementaryAlignmentFlag(boolean flag) {
        this.setFlag(flag, 2048);
    }

    public void setReadFailsVendorQualityCheckFlag(boolean flag) {
        this.setFlag(flag, 512);
    }

    public void setDuplicateReadFlag(boolean flag) {
        this.setFlag(flag, 1024);
    }

    public boolean isSecondaryOrSupplementary() {
        return this.getNotPrimaryAlignmentFlag() || this.getSupplementaryAlignmentFlag();
    }

    private void setFlag(boolean flag, int bit) {
        this.mFlags = flag ? (this.mFlags |= bit) : (this.mFlags &= ~bit);
    }

    public ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    public Object getAttribute(String tag) {
        return this.getAttribute(SAMTagUtil.getSingleton().makeBinaryTag(tag));
    }

    public Integer getIntegerAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (!(val instanceof Number)) {
            throw new RuntimeException("Value for tag " + tag + " is not Number: " + val.getClass());
        }
        long longVal = ((Number)val).longValue();
        if (longVal < Integer.MIN_VALUE || longVal > Integer.MAX_VALUE) {
            throw new RuntimeException("Value for tag " + tag + " is not in Integer range: " + longVal);
        }
        return (int)longVal;
    }

    public Short getShortAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Short) {
            return (Short)val;
        }
        if (!(val instanceof Number)) {
            throw new RuntimeException("Value for tag " + tag + " is not Number: " + val.getClass());
        }
        long longVal = ((Number)val).longValue();
        if (longVal < -32768L || longVal > 32767L) {
            throw new RuntimeException("Value for tag " + tag + " is not in Short range: " + longVal);
        }
        return (short)longVal;
    }

    public Byte getByteAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (!(val instanceof Number)) {
            throw new RuntimeException("Value for tag " + tag + " is not Number: " + val.getClass());
        }
        long longVal = ((Number)val).longValue();
        if (longVal < -128L || longVal > 127L) {
            throw new RuntimeException("Value for tag " + tag + " is not in Short range: " + longVal);
        }
        return (byte)longVal;
    }

    public String getStringAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        throw new SAMException("Value for tag " + tag + " is not a String: " + val.getClass());
    }

    public Character getCharacterAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Character) {
            return (Character)val;
        }
        throw new SAMException("Value for tag " + tag + " is not a Character: " + val.getClass());
    }

    public Float getFloatAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        throw new SAMException("Value for tag " + tag + " is not a Float: " + val.getClass());
    }

    public byte[] getByteArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a byte[]: " + val.getClass());
    }

    public byte[] getUnsignedByteArrayAttribute(String tag) {
        byte[] ret = this.getByteArrayAttribute(tag);
        if (ret != null) {
            this.requireUnsigned(tag);
        }
        return ret;
    }

    public byte[] getSignedByteArrayAttribute(String tag) {
        byte[] ret = this.getByteArrayAttribute(tag);
        if (ret != null) {
            this.requireSigned(tag);
        }
        return ret;
    }

    public short[] getUnsignedShortArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof short[]) {
            this.requireUnsigned(tag);
            return (short[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a short[]: " + val.getClass());
    }

    public short[] getSignedShortArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof short[]) {
            this.requireSigned(tag);
            return (short[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a short[]: " + val.getClass());
    }

    public int[] getUnsignedIntArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof int[]) {
            this.requireUnsigned(tag);
            return (int[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a int[]: " + val.getClass());
    }

    public int[] getSignedIntArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof int[]) {
            this.requireSigned(tag);
            return (int[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a int[]: " + val.getClass());
    }

    public float[] getFloatArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val != null && !(val instanceof float[])) {
            throw new SAMException("Value for tag " + tag + " is not a float[]: " + val.getClass());
        }
        return (float[])val;
    }

    public boolean isUnsignedArrayAttribute(String tag) {
        SAMBinaryTagAndValue tmp = this.mAttributes.find(SAMTagUtil.getSingleton().makeBinaryTag(tag));
        if (tmp != null) {
            return tmp.isUnsignedArray();
        }
        throw new SAMException("Tag " + tag + " is not present in this SAMRecord");
    }

    private void requireSigned(String tag) {
        if (this.isUnsignedArrayAttribute(tag)) {
            throw new SAMException("Value for tag " + tag + " is not signed");
        }
    }

    private void requireUnsigned(String tag) {
        if (!this.isUnsignedArrayAttribute(tag)) {
            throw new SAMException("Value for tag " + tag + " is not unsigned");
        }
    }

    public Object getAttribute(short tag) {
        if (this.mAttributes == null) {
            return null;
        }
        SAMBinaryTagAndValue tmp = this.mAttributes.find(tag);
        if (tmp != null) {
            return tmp.value;
        }
        return null;
    }

    public void setAttribute(String tag, Object value) {
        if (value != null && value.getClass().isArray() && Array.getLength(value) == 0) {
            throw new IllegalArgumentException("Empty value passed for tag " + tag);
        }
        this.setAttribute(SAMTagUtil.getSingleton().makeBinaryTag(tag), value);
    }

    public void setUnsignedArrayAttribute(String tag, Object value) {
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to setUnsignedArrayAttribute for tag " + tag);
        }
        if (Array.getLength(value) == 0) {
            throw new IllegalArgumentException("Empty array passed to setUnsignedArrayAttribute for tag " + tag);
        }
        this.setAttribute(SAMTagUtil.getSingleton().makeBinaryTag(tag), value, true);
    }

    protected void setAttribute(short tag, Object value) {
        this.setAttribute(tag, value, false);
    }

    protected void setAttribute(short tag, Object value, boolean isUnsignedArray) {
        if (!(value == null || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof String || value instanceof Character || value instanceof Float || value instanceof byte[] || value instanceof short[] || value instanceof int[] || value instanceof float[])) {
            throw new SAMException("Attribute type " + value.getClass() + " not supported. Tag: " + SAMTagUtil.getSingleton().makeStringTag(tag));
        }
        if (value == null) {
            if (this.mAttributes != null) {
                this.mAttributes = this.mAttributes.remove(tag);
            }
        } else {
            SAMBinaryTagAndValue tmp;
            if (!isUnsignedArray) {
                tmp = new SAMBinaryTagAndValue(tag, value);
            } else {
                if (!value.getClass().isArray() || value instanceof float[]) {
                    throw new SAMException("Attribute type " + value.getClass() + " cannot be encoded as an unsigned array. Tag: " + SAMTagUtil.getSingleton().makeStringTag(tag));
                }
                tmp = new SAMBinaryTagAndUnsignedArrayValue(tag, value);
            }
            this.mAttributes = this.mAttributes == null ? tmp : this.mAttributes.insert(tmp);
        }
    }

    public void clearAttributes() {
        this.mAttributes = null;
    }

    protected void setAttributes(SAMBinaryTagAndValue attributes) {
        this.mAttributes = attributes;
    }

    protected SAMBinaryTagAndValue getBinaryAttributes() {
        return this.mAttributes;
    }

    public List<SAMTagAndValue> getAttributes() {
        ArrayList<SAMTagAndValue> ret = new ArrayList<SAMTagAndValue>();
        for (SAMBinaryTagAndValue binaryAttributes = this.getBinaryAttributes(); binaryAttributes != null; binaryAttributes = binaryAttributes.getNext()) {
            ret.add(new SAMTagAndValue(SAMTagUtil.getSingleton().makeStringTag(binaryAttributes.tag), binaryAttributes.value));
        }
        return ret;
    }

    Integer getIndexingBin() {
        return this.mIndexingBin;
    }

    void setIndexingBin(Integer mIndexingBin) {
        this.mIndexingBin = mIndexingBin;
    }

    int computeIndexingBin() {
        int alignmentStart = this.getAlignmentStart() - 1;
        int alignmentEnd = this.getAlignmentEnd();
        if (alignmentEnd <= 0) {
            alignmentEnd = alignmentStart + 1;
        }
        return GenomicIndexUtil.reg2bin(alignmentStart, alignmentEnd);
    }

    public SAMFileHeader getHeader() {
        return this.mHeader;
    }

    public void setHeader(SAMFileHeader header) {
        this.mHeader = header;
    }

    public byte[] getVariableBinaryRepresentation() {
        return null;
    }

    public int getAttributesBinarySize() {
        return -1;
    }

    public String format() {
        StringBuilder buffer = new StringBuilder();
        this.addField(buffer, this.getReadName(), null, null);
        this.addField(buffer, this.getFlags(), null, null);
        this.addField(buffer, this.getReferenceName(), null, "*");
        this.addField(buffer, this.getAlignmentStart(), 0, "*");
        this.addField(buffer, this.getMappingQuality(), 0, "0");
        this.addField(buffer, this.getCigarString(), null, "*");
        this.addField(buffer, this.getMateReferenceName(), null, "*");
        this.addField(buffer, this.getMateAlignmentStart(), 0, "*");
        this.addField(buffer, this.getInferredInsertSize(), 0, "*");
        this.addField(buffer, this.getReadString(), null, "*");
        this.addField(buffer, this.getBaseQualityString(), null, "*");
        if (this.mAttributes != null) {
            for (SAMBinaryTagAndValue entry = this.getBinaryAttributes(); entry != null; entry = entry.getNext()) {
                this.addField(buffer, this.formatTagValue(entry.tag, entry.value));
            }
        }
        return buffer.toString();
    }

    private void addField(StringBuilder buffer, Object value, Object defaultValue, String defaultString) {
        if (this.safeEquals(value, defaultValue)) {
            this.addField(buffer, defaultString);
        } else if (value == null) {
            this.addField(buffer, "");
        } else {
            this.addField(buffer, value.toString());
        }
    }

    private void addField(StringBuilder buffer, String field) {
        if (buffer.length() > 0) {
            buffer.append('\t');
        }
        buffer.append(field);
    }

    private String formatTagValue(short tag, Object value) {
        String tagString = SAMTagUtil.getSingleton().makeStringTag(tag);
        if (value == null || value instanceof String) {
            return tagString + ":Z:" + value;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            return tagString + ":i:" + value;
        }
        if (value instanceof Character) {
            return tagString + ":A:" + value;
        }
        if (value instanceof Float) {
            return tagString + ":f:" + value;
        }
        if (value instanceof byte[]) {
            return tagString + ":H:" + StringUtil.bytesToHexString((byte[])value);
        }
        throw new RuntimeException("Unexpected value type for tag " + tagString + ": " + value + " of class " + value.getClass().getName());
    }

    private boolean safeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected void eagerDecode() {
        this.getCigar();
        this.getCigarString();
    }

    public List<AlignmentBlock> getAlignmentBlocks() {
        if (this.mAlignmentBlocks == null) {
            this.mAlignmentBlocks = SAMUtils.getAlignmentBlocks(this.getCigar(), this.getAlignmentStart(), "read cigar");
        }
        return this.mAlignmentBlocks;
    }

    public List<SAMValidationError> validateCigar(long recordNumber) {
        List<SAMValidationError> ret = null;
        if (this.getValidationStringency() != ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
            ret = SAMUtils.validateCigar(this, this.getCigar(), this.getReferenceIndex(), this.getAlignmentBlocks(), recordNumber, "Read CIGAR");
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SAMRecord)) {
            return false;
        }
        SAMRecord samRecord = (SAMRecord)o;
        if (this.mAlignmentStart != samRecord.mAlignmentStart) {
            return false;
        }
        if (this.mFlags != samRecord.mFlags) {
            return false;
        }
        if (this.mInferredInsertSize != samRecord.mInferredInsertSize) {
            return false;
        }
        if (this.mMappingQuality != samRecord.mMappingQuality) {
            return false;
        }
        if (this.mMateAlignmentStart != samRecord.mMateAlignmentStart) {
            return false;
        }
        if (this.mIndexingBin != null ? !this.mIndexingBin.equals(samRecord.mIndexingBin) : samRecord.mIndexingBin != null) {
            return false;
        }
        if (this.mMateReferenceIndex != null ? !this.mMateReferenceIndex.equals(samRecord.mMateReferenceIndex) : samRecord.mMateReferenceIndex != null) {
            return false;
        }
        if (this.mReferenceIndex != null ? !this.mReferenceIndex.equals(samRecord.mReferenceIndex) : samRecord.mReferenceIndex != null) {
            return false;
        }
        this.eagerDecode();
        samRecord.eagerDecode();
        if (this.mReadName != null ? !this.mReadName.equals(samRecord.mReadName) : samRecord.mReadName != null) {
            return false;
        }
        if (this.mAttributes != null ? !this.mAttributes.equals(samRecord.mAttributes) : samRecord.mAttributes != null) {
            return false;
        }
        if (!Arrays.equals(this.mBaseQualities, samRecord.mBaseQualities)) {
            return false;
        }
        if (this.mCigar != null ? !this.mCigar.equals(samRecord.mCigar) : samRecord.mCigar != null) {
            return false;
        }
        if (this.mMateReferenceName != null ? !this.mMateReferenceName.equals(samRecord.mMateReferenceName) : samRecord.mMateReferenceName != null) {
            return false;
        }
        if (!Arrays.equals(this.mReadBases, samRecord.mReadBases)) {
            return false;
        }
        return !(this.mReferenceName != null ? !this.mReferenceName.equals(samRecord.mReferenceName) : samRecord.mReferenceName != null);
    }

    public int hashCode() {
        this.eagerDecode();
        int result = this.mReadName != null ? this.mReadName.hashCode() : 0;
        result = 31 * result + (this.mReadBases != null ? Arrays.hashCode(this.mReadBases) : 0);
        result = 31 * result + (this.mBaseQualities != null ? Arrays.hashCode(this.mBaseQualities) : 0);
        result = 31 * result + (this.mReferenceName != null ? this.mReferenceName.hashCode() : 0);
        result = 31 * result + this.mAlignmentStart;
        result = 31 * result + this.mMappingQuality;
        result = 31 * result + (this.mCigarString != null ? this.mCigarString.hashCode() : 0);
        result = 31 * result + this.mFlags;
        result = 31 * result + (this.mMateReferenceName != null ? this.mMateReferenceName.hashCode() : 0);
        result = 31 * result + this.mMateAlignmentStart;
        result = 31 * result + this.mInferredInsertSize;
        result = 31 * result + (this.mAttributes != null ? this.mAttributes.hashCode() : 0);
        result = 31 * result + (this.mReferenceIndex != null ? this.mReferenceIndex.hashCode() : 0);
        result = 31 * result + (this.mMateReferenceIndex != null ? this.mMateReferenceIndex.hashCode() : 0);
        result = 31 * result + (this.mIndexingBin != null ? this.mIndexingBin.hashCode() : 0);
        return result;
    }

    public List<SAMValidationError> isValid() {
        return this.isValid(false);
    }

    public List<SAMValidationError> isValid(boolean firstOnly) {
        Object fz;
        List<SAMValidationError> errors;
        String rgId;
        ArrayList<SAMValidationError> ret = null;
        if (!this.getReadPairedFlag()) {
            if (this.getProperPairFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList<SAMValidationError>();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_PROPER_PAIR, "Proper pair flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getMateUnmappedFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_UNMAPPED, "Mate unmapped flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getMateNegativeStrandFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_NEG_STRAND, "Mate negative strand flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getFirstOfPairFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_FIRST_OF_PAIR, "First of pair flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getSecondOfPairFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_SECOND_OF_PAIR, "Second of pair flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getMateReferenceIndex() != -1) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_MATE_REF_INDEX, "MRNM should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        } else {
            List<SAMValidationError> errors2 = this.isValidReferenceIndexAndPosition(this.mMateReferenceIndex, this.mMateReferenceName, this.getMateAlignmentStart(), true, firstOnly);
            if (errors2 != null) {
                if (firstOnly) {
                    return errors2;
                }
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.addAll(errors2);
            }
            if (!this.hasMateReferenceName() && !this.getMateUnmappedFlag()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_UNMAPPED, "Mapped mate should have mate reference name", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (!this.getFirstOfPairFlagUnchecked() && !this.getSecondOfPairFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.PAIRED_READ_NOT_MARKED_AS_FIRST_OR_SECOND, "Paired read should be marked as first of pair or second of pair.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        }
        if (this.getInferredInsertSize() > 0x20000000 || this.getInferredInsertSize() < -536870912) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_INSERT_SIZE, "Insert size out of range", this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if (this.getReadUnmappedFlag()) {
            if (this.getNotPrimaryAlignmentFlag()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_NOT_PRIM_ALIGNMENT, "Not primary alignment flag should not be set for unmapped read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getSupplementaryAlignmentFlag()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_SUPPLEMENTARY_ALIGNMENT, "Supplementary alignment flag should not be set for unmapped read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getMappingQuality() != 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_MAPPING_QUALITY, "MAPQ should be 0 for unmapped read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        } else {
            if (this.getMappingQuality() >= 256) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_MAPPING_QUALITY, "MAPQ should be < 256.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getCigarLength() == 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "CIGAR should have > zero elements for mapped read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getHeader().getSequenceDictionary().size() == 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.MISSING_SEQUENCE_DICTIONARY, "Empty sequence dictionary.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (!this.hasReferenceName()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_READ_UNMAPPED, "Mapped read should have valid reference name", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        }
        if ((rgId = (String)this.getAttribute(SAMTagUtil.getSingleton().RG)) != null && this.getHeader().getReadGroup(rgId) == null) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.READ_GROUP_NOT_FOUND, "RG ID on SAMRecord not found in header: " + rgId, this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if ((errors = this.isValidReferenceIndexAndPosition(this.mReferenceIndex, this.mReferenceName, this.getAlignmentStart(), false)) != null) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.addAll(errors);
            if (firstOnly) {
                return ret;
            }
        }
        if (this.getReadLength() == 0 && !this.getNotPrimaryAlignmentFlag() && (fz = this.getAttribute(SAMTagUtil.getSingleton().FZ)) == null) {
            String cq = (String)this.getAttribute(SAMTagUtil.getSingleton().CQ);
            String cs = (String)this.getAttribute(SAMTagUtil.getSingleton().CS);
            if (cq == null || cq.length() == 0 || cs == null || cs.length() == 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.EMPTY_READ, "Zero-length read without FZ, CS or CQ tag", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            } else if (!this.getReadUnmappedFlag()) {
                boolean hasIndel = false;
                for (CigarElement cigarElement : this.getCigar().getCigarElements()) {
                    if (cigarElement.getOperator() != CigarOperator.DELETION && cigarElement.getOperator() != CigarOperator.INSERTION) continue;
                    hasIndel = true;
                    break;
                }
                if (!hasIndel) {
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.EMPTY_READ, "Colorspace read with zero-length bases but no indel", this.getReadName()));
                    if (firstOnly) {
                        return ret;
                    }
                }
            }
        }
        if (this.getReadLength() != this.getBaseQualities().length && !Arrays.equals(this.getBaseQualities(), NULL_QUALS)) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_READ_LENGTH_AND_QUALS_LENGTH, "Read length does not match quals length", this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if (this.getAlignmentStart() != 0 && this.getIndexingBin() != null && this.computeIndexingBin() != this.getIndexingBin().intValue()) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_INDEXING_BIN, "bin field of BAM record does not equal value computed based on alignment start and end, and length of sequence to which read is aligned", this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public SAMFileSource getFileSource() {
        return this.mFileSource;
    }

    protected void setFileSource(SAMFileSource fileSource) {
        this.mFileSource = fileSource;
    }

    private List<SAMValidationError> isValidReferenceIndexAndPosition(Integer referenceIndex, String referenceName, int alignmentStart, boolean isMate) {
        return this.isValidReferenceIndexAndPosition(referenceIndex, referenceName, alignmentStart, isMate, false);
    }

    private List<SAMValidationError> isValidReferenceIndexAndPosition(Integer referenceIndex, String referenceName, int alignmentStart, boolean isMate, boolean firstOnly) {
        boolean hasReference = SAMRecord.hasReferenceName(referenceIndex, referenceName);
        ArrayList<SAMValidationError> ret = null;
        if (!hasReference) {
            if (alignmentStart != 0) {
                if (ret == null) {
                    ret = new ArrayList<SAMValidationError>();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start should be 0 because reference name = *.", isMate), this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        } else {
            if (alignmentStart == 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start should != 0 because reference name != *.", isMate), this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getHeader().getSequenceDictionary().size() > 0) {
                SAMSequenceRecord sequence;
                SAMSequenceRecord sAMSequenceRecord = sequence = referenceIndex != null ? this.getHeader().getSequence(referenceIndex) : this.getHeader().getSequence(referenceName);
                if (sequence == null) {
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_REFERENCE_INDEX, this.buildMessage("Reference sequence not found in sequence dictionary.", isMate), this.getReadName()));
                    if (firstOnly) {
                        return ret;
                    }
                } else if (alignmentStart > sequence.getSequenceLength()) {
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start (" + alignmentStart + ") must be <= reference sequence length (" + sequence.getSequenceLength() + ") on reference " + sequence.getSequenceName(), isMate), this.getReadName()));
                    if (firstOnly) {
                        return ret;
                    }
                }
            }
        }
        return ret;
    }

    private String buildMessage(String baseMessage, boolean isMate) {
        return isMate ? "Mate " + baseMessage : baseMessage;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMRecord newRecord = (SAMRecord)super.clone();
        if (this.mAttributes != null) {
            newRecord.mAttributes = this.mAttributes.copy();
        }
        return newRecord;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.getReadName());
        if (this.getReadPairedFlag()) {
            if (this.getFirstOfPairFlag()) {
                builder.append(" 1/2");
            } else {
                builder.append(" 2/2");
            }
        }
        builder.append(" ");
        builder.append(String.valueOf(this.getReadLength()));
        builder.append("b");
        if (this.getReadUnmappedFlag()) {
            builder.append(" unmapped read.");
        } else {
            builder.append(" aligned read.");
        }
        return builder.toString();
    }

    public String getSAMString() {
        return SAMTextWriter.getSAMString(this);
    }

    public static class SAMTagAndValue {
        public final String tag;
        public final Object value;

        public SAMTagAndValue(String tag, Object value) {
            this.tag = tag;
            this.value = value;
        }
    }
}

