/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class AddCommentsToBam
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Adds one or more comments to the header of a specified BAM file. Copies the file with the modified header to a specified output file. Note that a block copying method is used to ensure efficient transfer to the output file. SAM files are not supported";
    @Option(shortName="I", doc="Input BAM file to add a comment to the header")
    public File INPUT;
    @Option(shortName="O", doc="Output BAM file to write results")
    public File OUTPUT;
    @Option(shortName="C", doc="Comments to add to the BAM file")
    public List<String> COMMENT;

    public static void main(String[] args) {
        new AddCommentsToBam().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.INPUT.getAbsolutePath().endsWith(".sam")) {
            throw new PicardException("SAM files are not supported");
        }
        SAMFileHeader samFileHeader = new SAMFileReader(this.INPUT).getFileHeader();
        for (String comment : this.COMMENT) {
            if (comment.contains("\n")) {
                throw new PicardException("Comments can not contain a new line");
            }
            samFileHeader.addComment(comment);
        }
        BamFileIoUtils.reheaderBamFile((SAMFileHeader)samFileHeader, (File)this.INPUT, (File)this.OUTPUT, (boolean)this.CREATE_MD5_FILE, (boolean)this.CREATE_INDEX);
        return 0;
    }
}

