/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import picard.analysis.CollectAlignmentSummaryMetrics;
import picard.analysis.CollectBaseDistributionByCycle;
import picard.analysis.CollectInsertSizeMetrics;
import picard.analysis.MeanQualityByCycle;
import picard.analysis.QualityScoreDistribution;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class CollectMultipleMetrics
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Takes an input BAM and reference sequence and runs one or more Picard " + "metrics modules at the same time to cut down on I/O. Currently all programs are run with " + "default options and fixed output extesions, but this may become more flexible in future.";
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="R", doc="Reference sequence fasta.", optional=true)
    public File REFERENCE_SEQUENCE;
    @Option(doc="If true (default), then the sort order in the header file will be ignored.", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public int STOP_AFTER = 0;
    @Option(shortName="O", doc="Base name of output files.")
    public String OUTPUT;
    @Option(doc="List of metrics programs to apply during the pass through the SAM file.")
    public List<Program> PROGRAM = CollectionUtil.makeList((Object[])Program.values());
    private List<ProgramInterface> programsToRun;

    public static void main(String[] args) {
        new CollectMultipleMetrics().instanceMainWithExit(args);
    }

    @Override
    protected String[] customCommandLineValidation() {
        this.programsToRun = new ArrayList<Program>(this.PROGRAM);
        return super.customCommandLineValidation();
    }

    public void setProgramsToRun(List<ProgramInterface> programsToRun) {
        this.programsToRun = programsToRun;
    }

    @Override
    public int doWork() {
        if (this.OUTPUT.endsWith(".")) {
            this.OUTPUT = this.OUTPUT.substring(0, this.OUTPUT.length() - 1);
        }
        ArrayList<SinglePassSamProgram> programs = new ArrayList<SinglePassSamProgram>();
        for (ProgramInterface program : new HashSet<ProgramInterface>(this.programsToRun)) {
            SinglePassSamProgram instance = program.makeInstance(this.OUTPUT);
            instance.INPUT = this.INPUT;
            instance.REFERENCE_SEQUENCE = this.REFERENCE_SEQUENCE;
            instance.setDefaultHeaders(this.getDefaultHeaders());
            programs.add(instance);
        }
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, programs);
        return 0;
    }

    public static enum Program implements ProgramInterface
    {
        CollectAlignmentSummaryMetrics{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                CollectAlignmentSummaryMetrics program = new CollectAlignmentSummaryMetrics();
                program.OUTPUT = new File(outbase + ".alignment_summary_metrics");
                return program;
            }
        }
        ,
        CollectInsertSizeMetrics{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                CollectInsertSizeMetrics program = new CollectInsertSizeMetrics();
                program.OUTPUT = new File(outbase + ".insert_size_metrics");
                program.Histogram_FILE = new File(outbase + ".insert_size_Histogram.pdf");
                return program;
            }
        }
        ,
        QualityScoreDistribution{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                QualityScoreDistribution program = new QualityScoreDistribution();
                program.OUTPUT = new File(outbase + ".quality_distribution_metrics");
                program.CHART_OUTPUT = new File(outbase + ".quality_distribution.pdf");
                return program;
            }
        }
        ,
        MeanQualityByCycle{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                MeanQualityByCycle program = new MeanQualityByCycle();
                program.OUTPUT = new File(outbase + ".quality_by_cycle_metrics");
                program.CHART_OUTPUT = new File(outbase + ".quality_by_cycle.pdf");
                return program;
            }
        }
        ,
        CollectBaseDistributionByCycle{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                CollectBaseDistributionByCycle program = new CollectBaseDistributionByCycle();
                program.OUTPUT = new File(outbase + ".base_distribution_by_cycle_metrics");
                program.CHART_OUTPUT = new File(outbase + ".base_distribution_by_cycle.pdf");
                return program;
            }
        };

    }

    public static interface ProgramInterface {
        public SinglePassSamProgram makeInstance(String var1);
    }
}

