/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

package org.broad.tribble.index;

import org.broad.tribble.FeatureCodec;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.ParsingUtils;

import java.io.File;
import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: jrobinso
 * Date: Jul 16, 2010
 * Time: 10:02:27 PM
 * To change this template use File | Settings | File Templates.
 */
abstract public class IndexCreator {
    protected File featureFile;
    protected FeatureCodec codec;
    protected File idxFile;

    public IndexCreator(File featureFile, FeatureCodec codec) {
        this.featureFile = featureFile;
        this.codec = codec;
        idxFile = new File(featureFile.getParent(), featureFile.getName() + ".idx");
        forceReadHeader(featureFile);
    }

    protected void forceReadHeader(File featureFile) {

        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(featureFile.getAbsolutePath());
            codec.readHeader(reader);
        }
        catch (IOException e) {
            //TODO -- fix this with proper exception handling
            e.printStackTrace();
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public abstract Index createIndex() throws IOException ;
}
