/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * ColorComposite.java
 *
 * Created on November 17, 2007, 10:51 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package demos;


import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ColorComposite extends JFrame {
    MyCanvas canvas;

    JTextField textField;

    float alphaValue = 0.65f;

    public ColorComposite() {
        super();
        Container container = getContentPane();

        canvas = new MyCanvas();
        container.add(canvas);

        JPanel panel = new JPanel();

        JLabel label = new JLabel("Color-Composite: ");

        JSlider slider = new JSlider(JSlider.HORIZONTAL, 0, 100, 65);
        slider.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                JSlider tempSlider = (JSlider) e.getSource();
                alphaValue = (float) (tempSlider.getValue() / 100.0);
                textField.setText(Float.toString(alphaValue));
                canvas.repaint();
            }
        });

        textField = new JTextField("0.65", 4);

        panel.add(label);
        panel.add(slider);
        panel.add(textField);

        container.add(BorderLayout.SOUTH, panel);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        setSize(450, 450);
        setVisible(true);
    }

    public static void main(String arg[]) {
        new ColorComposite();
    }

    class MyCanvas extends JLabel {
        Rectangle2D rec1, rec2, rec3, rec4, rec5;

        MyCanvas() {
            rec1 = new Rectangle2D.Float(25, 25, 75, 150);
            rec2 = new Rectangle2D.Float(125, 25, 100, 75);
            rec3 = new Rectangle2D.Float(75, 125, 125, 75);
            rec4 = new Rectangle2D.Float(225, 125, 125, 75);
            rec5 = new Rectangle2D.Float(150, 50, 125, 175);

            setBackground(Color.white);
            setSize(400, 225);
        }

        public void paint(Graphics g) {
            Graphics2D g2D = (Graphics2D) g;

            AlphaComposite ac = AlphaComposite.getInstance(
                    AlphaComposite.SRC_OVER, alphaValue);
            g2D.setComposite(ac);

            g2D.setStroke(new BasicStroke(5.0f));
            g2D.draw(rec1);

            GradientPaint gp = new GradientPaint(125f, 25f, Color.yellow, 225f,
                    100f, Color.blue);
            g2D.setPaint(gp);
            g2D.fill(rec2);

            BufferedImage bi = new BufferedImage(5, 5,
                    BufferedImage.TYPE_INT_RGB);
            Graphics2D big = bi.createGraphics();
            big.setColor(Color.magenta);
            big.fillRect(0, 0, 5, 5);
            big.setColor(Color.black);
            big.drawLine(0, 0, 5, 5);
            Rectangle r = new Rectangle(0, 0, 5, 5);

            TexturePaint tp = new TexturePaint(bi, r);

            g2D.setPaint(tp);
            g2D.fill(rec3);

            g2D.setColor(Color.green);
            g2D.fill(rec4);
            g2D.setColor(Color.red);
            g2D.fill(rec5);
        }
    }
}
