#!/usr/bin/perl

$|=1;
###############################################################
# Copyright Adarweb and Sebastien Joncheray                   #
# GOAL : RUN STATS ON BSD MACHINES  AND ROTATE LOG FILES      #
# Each time this script is executed, all stats are done       #
# after logs are rotated, and log files older than 15 days    #
# are deleted (error_log too...)                              #
# v3.0 14/09/99                                               #
###############################################################

###############################################################
$debug=0;
$logfile='./last_rotate.log';	# output messages are put here
$timestamp=&gettimestamp;	# timestamp here for rotated logs and gunzip
###############################################################

  if (open (TRACE,">$logfile") ) {
    print TRACE "Dbut du rotate log\n";
    print TRACE ("TIMESTAMP IS: $timestamp\n");
  }

##  FIRST, LET'S RUN STATS ####################################
  $res=`~/usr/local/lib/http-analyze/run_stats.pl`;
  print TRACE ("Premier run_stats fait, rsultat :\n $res \n");

## SECOND, LET'S ##############################################
##  - DELETE OLD LOG FILES,  ##################################
##  - GZIP CURRENT LOG FILES ##################################
##  - RESTART_APACHE         ##################################
###############################################################

  ## GET LOG FILE LIST ##
  opendir (DIR,"$ENV{HOME}/www/logs");
  @LOGS=readdir(DIR);
  closedir (DIR);

  ## DELETE OLD LOG FILES ##
  foreach $file (@LOGS) {
    if ( (-M "$ENV{HOME}/www/logs/$file" > 15) && ($file ne '..') && ($file ne '.') ) {
      unlink("$ENV{HOME}/www/logs/$file") unless ($debug==1);
      print TRACE ("$ENV{HOME}/www/logs/$file supprim.\n");
    }
  }

  ## DELETE error_log FILE ##
  if (-e "$ENV{HOME}/www/logs/error_log") {
    unlink ("$ENV{HOME}/www/logs/error_log") unless ($debug==1);
    print TRACE ("FICHIER error_log SUPPRIM.\n");
  }

  ## GET LOG FILES STILL HERE ##
  @LOGS=();
  opendir (DIR2,"$ENV{HOME}/www/logs");
  @LOGS=readdir(DIR2);
  closedir (DIR2);

  ## ROTATE AND GUNZIP ##
  if ($debug ==0) {
    foreach $file (@LOGS) {
      if  ( ($file ne '..') && ($file ne '.') ) {
        if (rename ("$ENV{HOME}/www/logs/$file","$ENV{HOME}/www/logs/$file".'_'."$timestamp") ) {
          print TRACE ("$ENV{HOME}/www/logs/$file renomm.\n");
          sleep(1);
          if (system ("gzip","-f","$ENV{HOME}/www/logs/$file".'_'."$timestamp")) {
            print TRACE ("$ENV{HOME}/www/logs/$file".'_'."$timestamp gzipp.\n");
          } else {
            print TRACE ("$ENV{HOME}/www/logs/$file".'_'."$timestamp gzipp, retour system egal 0 ...\n");
          }
        } else {
          print TRACE ("Impossible de renommer $ENV{HOME}/www/logs/$file:$!");
        }
      }
    }
  }

  sleep (10);
  system("restart_apache");	# Reboot apache in order to re-create the log files
  print TRACE ("Serveur Apache redmarr.\n");
  sleep (10);


  ##  THIRD, LET'S RE-RUN STATS #################################
  $res=`~/usr/local/lib/http-analyze/run_stats.pl`;
  print TRACE ("Second run_stats fait, rsultat :\n $res \n");
  print TRACE ("\nFIN...\n");
  close (TRACE);

1;


  

################################################
sub gettimestamp {
  @date=localtime(time());
  $ms=$date[4];
  if (length($ms)==1) {$ms='0'.$ms;}
  $an=1900+$date[5];
  return "$ms$an";
}
################################################
1;
