#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <signal.h>

#include "fudgit.h"
#include "macro.h"
#include "head.h"
#include "setshow.h"

int Ft_Interact = 0;
char Ft_HostName[64];
char Ft_UserName[32];
char *Ft_Progname;
static int initload(void);
static int initnames(void);

void main(int c, char **v)
{
	/****
	mallopt(M_DEBUG, 1);
	mallopt(M_MXFAST, 0);
	******/
	Ft_initmac();
	Ft_initstacks();  /* don't fool around with the order */
	Ft_initparser();
	Ft_initmacros();
	Ft_initcode();
	Ft_initsetup();
	Ft_initdl();
	Ft_clearpush_cwd();
#ifndef VMS
	setpgid(getpid(), getpid());
	signal(SIGCHLD, Ft_catcher);
#endif
	signal(SIGPIPE, Ft_catcher);
	signal(SIGFPE, Ft_catcher);
	signal(SIGINT, Ft_catcher);
	signal(SIGQUIT, Ft_catcher);
#ifdef SIGTSTP /* ! VMS */
	signal(SIGTSTP, Ft_catcher);
#endif
#if defined(SIGBUS) && !defined(VMS)
	signal(SIGBUS, Ft_catcher);
#endif
	signal(SIGHUP, Ft_catcher);
	signal(SIGSEGV, Ft_catcher);
	signal(SIGILL, Ft_catcher);
	Ft_Interact = isatty(fileno(stdin));
	Ft_Progname = v[0];
	initnames();

	if (c == 1 && Ft_Interact) {
		initload();
		Ft_initreadline();
		Ft_printversion();
		Ft_run();
	}
	else {
		int i;

		Ft_Interact = 0;
		if (c==1) {
			initload();
			Ft_run();
		}
		else {
			for (i=c-1;i>0;i--) {  /* push all the files on the I/O stack */
				Ft_pushio(v[i], AFILE, 0);
			}
			initload();
			Ft_run();
		}
	}
	Ft_exit(0);
}

#include <sys/types.h>
#include <sys/stat.h>

static int initload(void)
{
	char name[TOKENSIZE];
	struct stat buf;

	sprintf(name, "%s/.fudgitrc", Ft_Home);
	if (stat(name, &buf) == 0)
		return(Ft_pushio(name, AFILE, 0));

	return(0);
}

int Ft_printversion(void)
{
	fprintf(stderr, "\n\tF U D G I T\n\tversion  %s\n\tNovember 1994\n",
	VERSION);
	fprintf(stderr, "\tlast modified %s\n", DATE);
	fputs("\tCopyright (C) 1994  Martin-D. Lacasse <isaac@physics.mcgill.ca>\n", stderr);
	fputs("\tSee the `Credits' and `README' help topics for more.\n\n", stderr);
	return(0);
}

#include <pwd.h>

static int initnames(void)
{
	struct passwd *pw;

	if (gethostname(Ft_HostName, 64) < 0) {
		fputs("Warning: Could not get hostname.\n", stderr);
		strcpy(Ft_HostName, "Unknown");
	}
	if ((pw = getpwuid(geteuid())) == (struct passwd *)NULL) {
		fputs("Warning: Could not get your name.\n", stderr);
		strcpy(Ft_UserName, "Unknown");
	}
	else {
		strcpy(Ft_UserName, pw->pw_name);
	}

	return(0);
}

