#define NSTACK 1024
#define NPROG 2048
#define NFRAME 512

#ifndef CODETYPE
typedef void Code;
#define CODETYPE
#endif
typedef Code (*Inst)(void);

typedef union Datum {
	double val;
	Symbol *sym;
	char *str;
} Datum;

extern Datum Ft_pop(void);
extern Code Ft_nullpop(void);

#define STOP (Inst) 0
extern Inst *Ft_Progp;
extern Inst *Ft_Progbase;
extern Inst *Ft_code(Inst f), *Ft_dblcode(double d);

extern Code Ft_eval(void), Ft_add(void), Ft_sub(void), Ft_mul(void);
extern Code Ft_div(void), Ft_negate(void), Ft_power(void), Ft_modulo(void);
extern Code Ft_assign(void), Ft_eassign(void), Ft_bltin0(void);
extern Code Ft_bltin1(void), Ft_bltin1vec(void), Ft_bltin2(void);
extern Code Ft_varpush(void), Ft_constpush(void), Ft_pushnull(void);
extern Code Ft_strassign(void), Ft_streq(void), Ft_strne(void);
extern Code Ft_eeval(void), Ft_preieval(void), Ft_predeval(void);
extern Code Ft_postieval(void), Ft_postdeval(void);
extern Code Ft_preiargpush(void), Ft_predargpush(void);
extern Code Ft_postiargpush(void), Ft_postdargpush(void);
extern Code Ft_le(void), Ft_gt(void), Ft_lt(void), Ft_eq(void), Ft_ne(void);
extern Code Ft_ge(void), Ft_gt(void), Ft_and(void), Ft_or(void), Ft_not(void);
extern Code Ft_ifcode(void), Ft_whilecode(void), Ft_forcode(void);
extern Code Ft_strpush(void), Ft_streval(void), Ft_strsub(void), Ft_stradd(void);
extern Code Ft_prexpr(void), Ft_prstr(void), Ft_strbltin2(void);
extern Code Ft_linprexpr(void), Ft_linprnl(void), Ft_linprstr(void);
extern Code Ft_addassign(void), Ft_mulassign(void), Ft_divassign(void), Ft_subassign(void);
extern Code Ft_eaddassign(void), Ft_emulassign(void), Ft_edivassign(void), Ft_esubassign(void);
extern Code Ft_funcret(void), Ft_procret(void), Ft_call(void);
extern Code Ft_define(Symbol *sp), Ft_chkfunc(int type, Symbol *sp), Ft_breakit(void);
extern Code Ft_bltin0str(void), Ft_bltin2str(void), Ft_bltin1str(void);
extern Code Ft_vecloop(void), Ft_parloop(void);
extern Code Ft_pushvectype(void), Ft_pushexprtype(void), Ft_pushstrtype(void);
extern Code Ft_pushavectype(void), Ft_pushastrtype(void), Ft_pushpartype(void);
extern Code Ft_argaddassign(void), Ft_argmulassign(void);
extern Code Ft_argdivassign(void), Ft_argsubassign(void);
extern Code Ft_argassign(void), Ft_argvarpush(void), Ft_argpush(void);
extern Code Ft_boost(void), Ft_restore(void), Ft_strmake(void), Ft_vecmake(void);
extern Code Ft_extcall(void);

extern void Ft_initcode(void), Ft_initlex(), Ft_initparser(void);
extern void Ft_defnonly(int type, char *string), Ft_execute(Inst *p);
extern void Ft_matherror(char *, char *, int);

#define ALL (-1)
