/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __TICKLER_H__
#define __TICKLER_H__

#include "calendar.h"

#ifndef TCL_8_OR_HIGHER
#ifdef TCL_PARSE_PART1
#define TCL_8_OR_HIGHER 1
#else
#define TCL_8_OR_HIGHER 0
#endif /* TCL_PARSE_PART1 */
#endif /* TCL_8_OR_HIGHER */

#if TCL_8_OR_HIGHER
#define SET_INTERP_RESULT(s) Tcl_SetResult(interp, (s), TCL_STATIC)
#define GET_INTERP_RESULT() Tcl_GetStringResult(interp)
#else
#define SET_INTERP_RESULT(s) (interp->result = (s))
#define GET_INTERP_RESULT() (interp->result)
#endif /* TCL_8_OR_HIGHER */

void check_library_paths(void);

void setupbindings(void);

/* returns whether the character appears in the string */
#define isin(c, s) (strchr((s), (c)) != NULL)

#define iscmd(c) ((c) != '\0' && !isspace(c) && (isalpha(c) || isdigit(c) || \
	isin(c, "${}[]@#%^&*()`';:,.<>/?-_=+|~")))


#define UIpatientcursor() TclDo("patientcursor")
#define UInormalcursor() TclDo("normalcursor")

void source(char *s);
char *TclDoIgnoreErrors(char *s);
char *TclDo(char *s);
char *TclDo2(char *s, char *s2);
char *TclDo3(char *s, char *s2, char *s3);
char *TclDo4(char *, char *, char *, char *);
char *TclDo5(char *, char *, char *, char *, char *);
char *TclDo6(char *, char *, char *, char *, char *, char *);
char *TclDo7(char *, char *, char *, char *, char *, char *, char *);

#ifndef DBGprintf

#ifdef NO_X11
#define DBGprintf 0
#else /* have X11 */
#define DBGprintf DBG
#endif

#endif /* DBGprintf */

/* debugging versions of TclDo() */
#if DBGprintf
#define DTCLDO 1
char *dTclDo(char *s);
char *dTclDo2(char *s, char *s2);
char *dTclDo3(char *s, char *s2, char *s3);
char *dTclDo4(char *, char *, char *, char *);
char *dTclDo5(char *, char *, char *, char *, char *);
char *dTclDo6(char *, char *, char *, char *, char *, char *);
char *dTclDo7(char *, char *, char *, char *, char *, char *, char *);
#else
#define DTCLDO 0
#define dTclDo TclDo
#define dTclDo2 TclDo2
#define dTclDo3 TclDo3
#define dTclDo4 TclDo4
#define dTclDo5 TclDo5
#define dTclDo6 TclDo6
#define dTclDo7 TclDo7
#endif

/* s is the name of a Tcl variable; return whether it is true or false */
#define TclBool(s) atoi(TclDo2("gset ", (s)))
#define TclInt(s) TclBool(s)

#define TclSet(var, value) Tcl_SetVar(interp, (var), (value), TCL_GLOBAL_ONLY)
#define TclGet(var) Tcl_GetVar(interp, (var), TCL_GLOBAL_ONLY)

int floaterentrypoint(ClientData clientData, Tcl_Interp *interp,
		 int argc, char *argv[]);
int FloaterClose(ClientData clientData, Tcl_Interp *interp,
		 int argc, char *argv[]);
int floatertimeout(ClientData clientData, Tcl_Interp *interp,
		   int argc, char *argv[]);
int cmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
int receivemessage(ClientData clientData, Tcl_Interp *interp,
		   int argc, char *argv[]);
int talk(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);

void talkm(char *s);
void talkm2(char *s, char *s2);
void talkm3(char *s, char *s2, char *s3);
void talkm4(char *s, char *s2, char *s3, char *s4);
void talkm5(char *, char *, char *, char *, char *);
void talkm6(char *, char *, char *, char *, char *, char *);
void talkm7(char *, char *, char *, char *, char *, char *, char *);
void talkm8(char *, char *, char *, char *, char *, char *, char *, char *);
void talkm9(char *, char *, char *, char *, char *, char *, char *, char *,
	    char *);

char *tclclean(char *);
char *braceclean(char *);
char *destructivebracketclean(char *s);
#define fileclean(s) \
    destructiveBackslashToSlash(braceclean(destructivebracketclean(s)))

void mail_bug(char *s, char *filename, int line);

/* check for nasties embedded in text from outside */
char *safety_check(char *s);

void fatal(char *msg, int exitcode);
void error(void);
void inittickler(void);

#define clearcc() TclDo("uplevel #0 {set cclines(NS) [set cclines(EW) 0]}")

#if STRICT_FILESYSTEM_ACCESS
#define validfile(filename) atob(TclDo3("validfile {", (filename), "}"))
#else
#define validfile(filename) TRUE
#endif

/* returns whether it succeeded; sets Tcl variable var to the result of open */
#define TclOpen(var, filename, mode)					     \
(validfile(filename) ?							     \
  !atob(TclDo6("catch {open {", (filename), "} ", (mode), "} ", (var))) : \
  (TclDo3("set ", (var), " {File must lie in Floater's subdirectory}"), FALSE))

#ifdef LOGINSERVER

#define floatertime() localtime_as_string()

#define rtalkmsg(s) (talkm(s))
#define rtalkmsg2(s, s2) (talkm2((s), (s2)))
#define rtalkmsg3(s, s2, s3) (talkm3((s), (s2), (s3)))
#define rtalkmsg4(s, s2, s3, s4) (talkm4((s), (s2), (s3), (s4)))
#define rtalkmsg5(s, s2, s3, s4, s5) (talkm5((s), (s2), (s3), (s4), (s5)))
#define rtalkmsg6(s, s2, s3, s4, s5, s6) (talkm6((s), (s2), (s3), (s4), (s5), (s6)))
#define rtalkmsg7(s, s2, s3, s4, s5, s6, s7) (talkm7((s), (s2), (s3), (s4), (s5), (s6), (s7)))
#define rtalkmsg8(s, s2, s3, s4, s5, s6, s7, s8) (talkm8((s), (s2), (s3), (s4), (s5), (s6), (s7), (s8)))

#define talkmsg(s) (talkm2(floatertime(), (s)))
#define talkmsg2(s, s2) (talkm3(floatertime(), (s), (s2)))
#define talkmsg3(s, s2, s3) (talkm4(floatertime(), (s), (s2), (s3)))
#define talkmsg4(s, s2, s3, s4) (talkm5(floatertime(), (s), (s2), (s3), (s4)))
#define talkmsg5(s, s2, s3, s4, s5) (talkm6(floatertime(), (s), (s2), (s3), (s4), (s5)))
#define talkmsg6(s, s2, s3, s4, s5, s6) (talkm7(floatertime(), (s), (s2), (s3), (s4), (s5), (s6)))
#define talkmsg7(s, s2, s3, s4, s5, s6, s7) (talkm8(floatertime(), (s), (s2), (s3), (s4), (s5), (s6), (s7)))
#define talkmsg8(s, s2, s3, s4, s5, s6, s7, s8) (talkm9(floatertime(), (s), (s2), (s3), (s4), (s5), (s6), (s7), (s8)))

#else /* not LOGINSERVER */

#define talkmsg(s) (talkm(s))
#define talkmsg2(s, s2) (talkm2((s), (s2)))
#define talkmsg3(s, s2, s3) (talkm3((s), (s2), (s3)))
#define talkmsg4(s, s2, s3, s4) (talkm4((s), (s2), (s3), (s4)))
#define talkmsg5(s, s2, s3, s4, s5) (talkm5((s), (s2), (s3), (s4), (s5)))
#define talkmsg6(s, s2, s3, s4, s5, s6) (talkm6((s), (s2), (s3), (s4), (s5), (s6)))
#define talkmsg7(s, s2, s3, s4, s5, s6, s7) (talkm7((s), (s2), (s3), (s4), (s5), (s6), (s7)))
#define talkmsg8(s, s2, s3, s4, s5, s6, s7, s8) (talkm8((s), (s2), (s3), (s4), (s5), (s6), (s7), (s8)))
#endif /* LOGINSERVER */

#define m_turn_off_scrolllock() \
	(atob(TclGet("showerrors")) ? turn_off_scrolllock() : NULL)

#define ERRORTEXT "Error: "
#define errormsg(s) \
	(m_turn_off_scrolllock(), talkmsg2(ERRORTEXT, s))
#define errormsg2(s, s2) \
	(m_turn_off_scrolllock(), talkmsg3(ERRORTEXT, (s), (s2)))
#define errormsg3(s, s2, s3) \
	(m_turn_off_scrolllock(), talkmsg4(ERRORTEXT, (s), (s2), (s3)))
#define errormsg4(s, s2, s3, s4) \
	(m_turn_off_scrolllock(), talkmsg5(ERRORTEXT, (s), (s2), (s3), (s4)))


#define RESULTTEXT "Result: "
#define resultmsg_(s) TEMPCAT(RESULTTEXT, (s))
#define resultmsg(s) (talkmsg2(RESULTTEXT, (s)))
#define resultmsg2(s, s2) (talkmsg3(RESULTTEXT, (s), (s2)))
#define resultmsg3(s, s2, s3) (talkmsg4(RESULTTEXT, (s), (s2), (s3)))
#define resultmsg4(s, s2, s3, s4) (talkmsg5(RESULTTEXT, (s), (s2), (s3), (s4)))

#define WARNINGTEXT "Warning: "
#define warningmsg(s) (talkmsg2(WARNINGTEXT, s))
#define warningmsg2(s, s2) (talkmsg3(WARNINGTEXT, (s), (s2)))
#define warningmsg3(s, s2, s3) (talkmsg4(WARNINGTEXT, (s), (s2), (s3)))
#define warningmsg4(s, s2, s3, s4) (talkmsg5(WARNINGTEXT, (s), (s2), (s3), (s4)))

#define FOUNDTEXT "Find: "
#define foundmsg(s) (talkmsg2(FOUNDTEXT, s))
#define foundmsg2(s, s2) (talkmsg3(FOUNDTEXT, (s), (s2)))
#define foundmsg3(s, s2, s3) (talkmsg4(FOUNDTEXT, (s), (s2), (s3)))
#define foundmsg4(s, s2, s3, s4) (talkmsg5(FOUNDTEXT, (s), (s2), (s3), (s4)))

#define STATUSTEXT "` "
#define status(s) (talkmsg2(STATUSTEXT, s))
#define status2(s, s2) (talkmsg3(STATUSTEXT, (s), (s2)))
#define status3(s, s2, s3) (talkmsg4(STATUSTEXT, (s), (s2), (s3)))
#define status4(s, s2, s3, s4) (talkmsg5(STATUSTEXT, (s), (s2), (s3), (s4)))
#define status5(s, s2, s3, s4, s5) (talkmsg6(STATUSTEXT, (s), (s2), (s3), (s4), (s5)))
#define status6(s, s2, s3, s4, s5, s6) (talkmsg7(STATUSTEXT, (s), (s2), (s3), (s4), (s5), (s6)))
#define status7(s, s2, s3, s4, s5, s6, s7) (talkmsg8(STATUSTEXT, (s), (s2), (s3), (s4), (s5), (s6), (s7)))

#define HELPTEXT "Help: "
#define helpmsg(s) (talkmsg2(HELPTEXT, s))
#define helpmsg2(s, s2) (talkmsg3(HELPTEXT, (s), (s2)))
#define helpmsg3(s, s2, s3) (talkmsg4(HELPTEXT, (s), (s2), (s3)))
#define helpmsg4(s, s2, s3, s4) (talkmsg5(HELPTEXT, (s), (s2), (s3), (s4)))
#define helpmsg5(s, s2, s3, s4, s5) (talkmsg6(HELPTEXT, (s), (s2), (s3), (s4), (s5)))

#endif /* __TICKLER_H__ */
