/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
//gset pardheight 100
//gset matrixheight 200
//gset matrixwidth 240
//gset lhowidth 200
gset pardheight 100
gset matrixwidth 200 
gset lhowidth 193
gset rhowidth $lhowidth
gset self_matrix_gap 55
gset suitgap 45
gset ourcardgap 23
gset theircardgap 19
gset rhomaxx 600
gset cardrectvgap 4

proc smallmatrix {b v {m 160}} {
    global handx handy canv namex namey suitgap ourcardgap theircardgap vgap \
	    pardheight matrixheight matrixwidth lhowidth rhowidth \
	    self_matrix_gap bottom_cutoff

    set bottom_cutoff $b
    set vgap $v
    set matrixheight $m
    set matrixtop $pardheight
    set matrixl $lhowidth
    set matrixbot [expr $pardheight + $matrixheight]
    set matrixr [expr $lhowidth + $matrixwidth]
    set canv(matrix) "$matrixl $matrixtop $matrixr $matrixbot"

    set handx(self) [expr $matrixl + $matrixwidth / 2]
    set handx(pard) $handx(self)
    set handy(pard) [expr $matrixtop - 50]
    set handy(self) [expr $matrixbot + $self_matrix_gap]
    set handx(lho) 50
    set handy(lho) [expr $pardheight + 40]
    set handx(rho) [expr $matrixr + 40]
    set handy(rho) $handy(lho)
    
    set canv(height) [expr $handy(self) + 35 - $bottom_cutoff]
    set canv(width) [expr $lhowidth + $matrixwidth + $rhowidth]

    foreach p {lho self pard rho} {
	set namex($p) $handx($p)
	set namey($p) [expr $handy($p) - 43]
    }
}

proc tinymatrix {} {smallmatrix 32 26 148}

proc mdealtest {{n -1}} {
    set q(0) {AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2}
    set q(1) {AKQJT9 AKQJT98 AKQJT987 AKQJT9876 {} {} {} {} {} {} {} {} {} {} {} {}}
    set q(2) {{} {} {} {} AKQJT9 AKQJT98 AKQJT987 AKQJT9876 {} {} {} {} {} {} {} {}}
    set q(3) {{} {} {} {} {} {} {} {} AKQJT9 AKQJT98 AKQJT987 AKQJT9876 {} {} {} {}}
    set q(4) {{} {} {} {} {} {} {} {} {} {} {} {} AKQJT9 AKQJT98 AKQJT987 AKQJT9876}
    set q(5) {AKQJT987654 Q82 J J6 {} {} {} {} {} {} {} {} {} {} {} {}}
    set q(6) {{} {} {} {} AKQJT987654 Q82 J J6 {} {} {} {} {} {} {} {}}
    set q(7) {{} {} {} {} {} {} {} {} AKQJT987654 Q82 J J6 {} {} {} {}}
    set q(8) {{} {} {} {} {} {} {} {} {} {} {} {} AKQJT987654 Q82 J J6}
    if {$n >= 0} {catch {eval "fulldeal $q($n)"}} {
	for {set i 1} {$i <= 8} {incr i} {
	    after [expr $i * 5000] fulldeal $q($i)
	}
    }
}

proc mt {{n 0}} {
    mdealtest $n
 
    showplay self c q
    showplay pard s k
    showplay lho d a
    showplay rho h j
    sillynames
}

proc mtest {{d {}}} {
    catch {destroy .tc}
    toplevel .tc
    canvsetup [canvas .tc.c]
    pack .tc.c -side top -expand yes -fill both
    fulldeal AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2
    eval "mdealtest $d"

    showplay self c q
    showplay pard s k
    showplay lho d a
    showplay rho h j
    sillynames
}


