/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */

/////////////////////////////////////////////////////////////////////////////
// sending in the result emails
/////////////////////////////////////////////////////////////////////////////

// Always use pseudo-mailer for now. (Set in 1.2b1).
#undef CANNOT_MAIL
#define CANNOT_MAIL 1

set to_be_emailed_n 0

// returns an 0 on success, non-zero on error; error put in global errorstring
proc emailresult {result} {
    global resultparser errorstring to_be_emailed to_be_emailed_n

    if {[set q [what_to_send]] != ""} {set result "$result\nMagic cookie!$q"}
    if {$result == ""} {return 0}
    set r [
#ifdef CANNOT_MAIL
    pseudomail $result $resultparser
#else
    catch {exec echo $result | mail $resultparser} errorstring
#endif
    ]
    if $r {
	// failure: queue result up to be sent later, hopefully
	set to_be_emailed([incr to_be_emailed_n]) $result
    } else {
	while {$to_be_emailed_n > 0} {
	    // This could be improved by aggregating the queued messages
	    // rather than sending them off one at a time.  (Also, the
	    // while loop is superfluous, since each success fires off the
	    // next item in the queue, thus going through the whole queue until
	    // we get a failure.)
	    set result $to_be_emailed($to_be_emailed_n)
	    unset to_be_emailed($to_be_emailed_n)
	    incr to_be_emailed_n -1
	    if [emailresult $result] {return $r}
	}
    }
    return $r
}

proc emailseens {} {emailresult {}}

// returns an 0 on success, non-zero on error; error put in global errorstring
proc mail_bug {bug} {
    global bugmail errorstring

#ifdef CANNOT_MAIL
    pseudomail $bug $bugmail
#else
    catch {exec echo $bug | mail $bugmail} errorstring
#endif
}

// returns an 0 on success, non-zero on error; error put in global errorstring
proc pseudomail {what where} {
    global errorstring pseudomailaddr pseudomailport

    catch {
	set conn [FloaterConnect $pseudomailaddr $pseudomailport]
	FloaterSend $conn ozzie_and_harriet
	FloaterSend $conn "$where $what"
	FloaterClose $conn
    } errorstring
}
