/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#include "floater.h"

#if TCL_IN_C

char *tcl2cfilenames[] = {
"tclcode/floater.tcl", "tclcode/floatert.tcl"};
char *tcl2cfiles[] = {
"# 1 \"tclcode/floater.TCL\"
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 








if {[info tclversion] < 8.0 || $tk_version < 8.0} {
    puts stderr \"You have compiled Floater with Tcl [info tclversion]/Tk $tk_version.\"
    puts stderr \"You must recompile with Tcl/Tk 8.0 or higher.\"
    exit 1
}


# 1 \"tclcode/gset.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
 
proc tryset {a b} {
    if {[set x [string first \"(\" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    if [catch {set $a}] {set $a $b}
}

 
proc gset {a {b salami_on_rye}} {
    if {[set x [string first \"(\" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    if ![string compare $b salami_on_rye] {set $a} {set $a $b}
}

 
proc gunset {a} {
    if {[set x [string first \"(\" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    unset $a
}

# 36 \"tclcode/floater.TCL\" 2

gset floater_version \"Floater 1.2b1\"
# 1 \"tclcode/errorhandle.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
proc bgerror {m} {catch {debugmsg $m}}
# 38 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/files.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 
 
proc lseenhand {root number scoring} {
    global seenhands maxseenhand 	    Nseen$scoring Sseen$scoring Eseen$scoring Wseen$scoring


 


    set seen seen
    foreach d {N S E W} {
	if [info exists $d$seen$scoring] {
	    eval \"set old $$d$seen$scoring\"
	    set $d$seen$scoring $old$number-
 
	}
    }
    set seenhands($root,$number) 1
    if [info exists maxseenhand($root)] 	    {if {$maxseenhand($root) > $number} return}

    set maxseenhand($root) $number
}

 
proc seen {root {silent 0}} {
    global seenhands maxseenhand youveseen

    if ![info exists maxseenhand($root)] {
	if {$youveseen && !$silent} 		{talkmsg \"You haven't seen any hands from $root\"}

	return \"\"
    }
    set m $maxseenhand($root)
    set s \"\"
    set t \"\"
    for {set i 1} {$i <= $m} {incr i} {
	if [info exists seenhands($root,$i)] {
	    append s \"$i-\"
	    append t \"$i \"
	}
    }
    if {$youveseen && !$silent} {talkmsg \"From set $root, you've seen: $t\"}
    if {$silent} {return $t} {return $s}
}







proc floater_mkdir {s} {
    if {[info tclversion] < 7.6} {exec mkdir $s} {file mkdir $s}
}

proc floater_delete {s} {
    if {[info tclversion] < 7.6} {exec /bin/rm $s} {file delete $s}
}

if [info exists env(DOT_FLOATER)] {
    tryset floaterdir $env(DOT_FLOATER)
}
tryset floaterdir [set env(HOME)]/.floater
tryset startupfile $floaterdir/startup.tcl
tryset seenfileroot $floaterdir/seenhands

if {[file exists $floaterdir] == 0} {catch {floater_mkdir $floaterdir}}
if {[file exists $seenfileroot] == 0} {catch {floater_mkdir $seenfileroot}}

 
proc tclfiles {dir {recurse 1}} {
    set slashstar \"\\/\\*\"
    set pattern $dir$slashstar
    set files \"\"
    while 1 {
	if ![catch {glob $pattern.tcl} newfiles] {append files \" $newfiles\"}
	if {!$recurse || [catch {glob $pattern}]} {return $files}
	set pattern $pattern$slashstar
    }
}

proc source_all_tclfiles {dir {recurse 1}} {
    global startupfile

    foreach file [tclfiles $dir $recurse] {
	if {$file != $startupfile} { 





	    if [catch {source $file} err] {
		puts stderr $err
	    }
	}
    }
}

 

proc setprioruse {name} {
    global usedname startupfile

    if [info exists usedname($name)] return
    set \"usedname($name)\" 1
    set u \"\\\"usedname(\"
    catch {exec cat << \"set $u$name)\\\" 1\\n\" >> $startupfile}
}

 
 
 

set seenname _everyone_

proc seenfile {root} {
    global seenfileroot seenname
    return $seenfileroot/$seenname/$root.tcl
}

 
proc seenhand {root number scoring} {
    global seenhands

    if [info exists seenhands($root,$number)] return
    lseenhand $root $number $scoring
    if [catch {exec cat << \"lseenhand $root $number $scoring\\n\" >> 	    [seenfile $root]}] {

	floatererror \"Floater error: unable to make permanent note of what hands you've seen!\"
	set e1 \"Floater error: unable to write to file \"
	set e2 [seenfile $root]
	floatererror \"$e1$e2\"
    }
}

proc loadseen {} {
    global seenhands maxseenhand seenname seenfileroot 	    globaldate previousglobaldate


    debugmsg \"loadseen with seenname=$seenname\"

     
    if {[info exists globaldate] && [info exists previousglobaldate]} {
	cleanseen $seenfileroot/$seenname $globaldate $previousglobaldate
	if {$seenname != \"_everyone_\"} {
	    cleanseen $seenfileroot/_everyone_ $globaldate $previousglobaldate
	}
    }

    catch {unset seenhands; unset maxseenhand}
    if {[file exists $seenfileroot/_everyone_] == 0} 	    {catch {floater_mkdir $seenfileroot/_everyone_}}

    if {[file exists $seenfileroot/$seenname] == 0} 	    {catch {floater_mkdir $seenfileroot/$seenname}}

    source_all_tclfiles $seenfileroot/_everyone_

     
    source_all_tclfiles $seenfileroot 0

    if {$seenname != \"_everyone_\"} 	    {source_all_tclfiles $seenfileroot/$seenname}

}

proc cleanseen {dir except1 except2} {
    debugmsg \"cleanseen $dir $except1 $except2\"
    foreach file [tclfiles $dir 0] {
	if {![string match \"$dir/$except1*\" $file]
	    && ![string match \"$dir/$except2*\" $file]} {
		debugmsg \"Removing $file\"
		floater_delete $file
	}
    }
}



 
 
 

 
proc validfile {filename} {
    global floaterdir

    regexp $floaterdir/.* [file dirname $filename]/
}
# 39 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/connect.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
gset conn_number 0

gset default_handshake \"Floater 'shake\"
gset silent_handshake \"Floater silent 'shake\"


 
proc FloaterListen {{port 0}} {
    global localIPaddr0
    PortNumber [socket -server FloaterAcceptConnection 	    -myaddr $localIPaddr0 $port]

}

proc FloaterAcceptConnection {sock addr port} {
    debugmsg \"AcceptConnection $sock $addr $port\"
    return [FloaterNewSocket $sock]
}

proc FloaterReadable {conn sock} {
    global expecting_handshake floater_silent default_handshake

    debugmsg \"FloaterReadable $conn $sock\"
    set s [gets $sock]
    debugmsg \"Got $s from $conn\"
    if [info exists expecting_handshake($conn)] {
	debugmsg \"expecting handshake\"
	if {$s == $default_handshake} {
	     
	    unset expecting_handshake($conn)
	    return
	} else {
	    if $floater_silent {
		global silent_handshake
		if {$s == $silent_handshake} {
		    global floater_silent_conns
		    set floater_silent_conns($conn) 1
		    unset expecting_handshake($conn)
		    return
		}
	    }
	    debugmsg \"Expecting handshake but got $s\"
	}
	 
	FloaterClose $conn
	return
    }

    if {$s == \"\" && [eof $sock]} 	    {FloaterClose $conn} 	    {debugmsg \"received $s\"; floaterreceive $s $conn}


}

 
proc FloaterWritable {conn sock} {
    debugmsg \"FloaterWritable $conn $sock\"
}

 
proc FloaterConnect {addr port {handshake default}} {
    debugmsg \"FloaterConnect $addr $port\"
    FloaterNewSocket [socket $addr $port] $handshake
}

 
 
proc FloaterNewSocket {sock {handshake default}} {
    global sock_to_conn conn_to_sock conn_number expecting_handshake

    if {$handshake == \"default\"} {
	global default_handshake
	set handshake $default_handshake
    }
    debugmsg \"NewSocket $sock $handshake\"
    fconfigure $sock -blocking 0 -buffering line
    set conn [incr conn_number]
    set sock_to_conn($sock) $conn
    set conn_to_sock($conn) $sock
    set expecting_handshake($conn) 1
 
    fileevent $sock readable \"FloaterReadable $conn $sock\"
    if {$handshake != \"\"} {
	puts $sock $handshake
	debugmsg \"sent handshake ($handshake) to $conn\"
    }
    return $conn
}

proc PortNumber {sock} {
    lindex [fconfigure $sock -sockname] 2
}

 

 
tryset failedsendwait 3000
 

 
proc FloaterSend {to msg} {
    global conn_to_sock

    catch {set s $conn_to_sock($to)}






    debugmsg \"Send $to ($s) $msg\"

    if [catch {puts $s $msg}] {
	global failedsendwait

	after $failedsendwait 	    debugmsg \\\"Closing $s due to failed send\\\"; 	    catch \\{close $s\\}


    }
}

 

proc FloaterCloseName {name} {
    global name_to_conn

    set s \"<none>\"
    catch {set s $name_to_conn($name)}
    debugmsg \"FloaterCloseName $name ($s)\"
    if {$s != \"<none>\"} {
	catch {
	    FloaterClose $s
	    unset \"name_to_conn($name)\"
	}
    }
}

 
 
 

#f is a filename (or \"|program args ...\").  r is a regular expression with
#one parenthesized component.  For each line, if the regexp matches,
#lappend the parenthesized component of the match to the result.
proc filter_regexp {f r} {
    set f [open $f r]
    set result \"\"
    while {[gets $f s] >= 0} {
	if [regexp $r $s all a] { lappend result $a; set q yes } { set q no }
	#puts \"Checking $s against regexp $r: $q\"
    }
    catch { close $f }
    #puts \"filter result: $result\"
    return $result
}

 
 
 
 
proc IP_from_ifconfig {} {
    set r {inet addr:([0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)}
    set s \"\"
    catch {set s [filter_regexp \"|ifconfig ppp0\" $r]}
    if {$s == \"\"} {
	catch {set s [filter_regexp \"|ifconfig\" $r]}
    }

    set result \"\"
    foreach p $s {
	if {$p != \"127.0.0.1\"} {
	    if {$result == \"\"} {set result $p} {set result $p!$result}
	}
    }
    return $result
}

 
proc bogusIP {s} {
    if {$s == \"localhost\"} { return 1 }
    if {$s == \"localhost.localdomain\"} { return 1 }
    if {$s == \"127.0.0.1\"} { return 1 }
    if {$s == \"0.0.0.0\"} { return 1 }
    if {$s == \"255.255.255.255\"} { return 1 }
    return 0
}

proc filter_and_join {s filter joiner} {
    set result \"\"
    foreach k $s {
	if ![$filter $k] { lappend result $k }
    }
    join $result $joiner
}

proc nothing {sock ipaddr port} {}

set localIPaddr 127.0.0.1
set localIPaddr0 127.0.0.1
catch {
    set server [socket -server nothing 0]
    set socket [socket [info hostname] [PortNumber $server]]
    set localIPaddr0 [lindex [fconfigure $socket -peername] 0]
    set localIPaddr1 [lindex [fconfigure $socket -peername] 1]
    catch {close $socket}
    catch {close $server}
    set localIPaddr 	    [filter_and_join \"$localIPaddr0 $localIPaddr1\" bogusIP !]

    puts $localIPaddr
    if {$localIPaddr == \"\"} {
	set localIPaddr [set localIPaddr0 [IP_from_ifconfig]]
	puts $localIPaddr
    }
}

# 40 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/mail.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 
 
 

 



set to_be_emailed_n 0

 
proc emailresult {result} {
    global resultparser errorstring to_be_emailed to_be_emailed_n

    if {[set q [what_to_send]] != \"\"} {set result \"$result\\nMagic cookie!$q\"}
    if {$result == \"\"} {return 0}
    set r [

    pseudomail $result $resultparser



    ]
    if $r {
	 
	set to_be_emailed([incr to_be_emailed_n]) $result
    } else {
	while {$to_be_emailed_n > 0} {
	     
	     
	     
	     
	     
	    set result $to_be_emailed($to_be_emailed_n)
	    unset to_be_emailed($to_be_emailed_n)
	    incr to_be_emailed_n -1
	    if [emailresult $result] {return $r}
	}
    }
    return $r
}

proc emailseens {} {emailresult {}}

 
proc mail_bug {bug} {
    global bugmail errorstring


    pseudomail $bug $bugmail



}

 
proc pseudomail {what where} {
    global errorstring pseudomailaddr pseudomailport

    catch {
	set conn [FloaterConnect $pseudomailaddr $pseudomailport]
	FloaterSend $conn ozzie_and_harriet
	FloaterSend $conn \"$where $what\"
	FloaterClose $conn
    } errorstring
}
# 41 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/seen.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
proc query_have_seen {name set} {
    set x \"$name $set\"
    global $x
    array names $x
}

 
proc a_h_s {name set num} {
    global \"have_seen_sets_$name\"
    eval \"set \\\"have_seen_sets_$name\\($set)\\\" 1\"

    set x \"$name $set\"
    global $x
    eval \"set \\{$x\\($num)\\} 1\"
}

proc have_seen_sets {name} {
    global \"have_seen_sets_$name\"
    array names \"have_seen_sets_$name\"
}

proc discard_data_except_from {date} {
    global nameset

    foreach name $nameset {
	global \"have_seen_sets_$name\"
	foreach set [have_seen_sets $name] {
	    if ![string match *$date* $set] {
		set x \"$name $set\"
		global $x
		unset $x
 
		eval \"unset \\\"have_seen_sets_$name\\($set)\\\"\"
 
	    }
	}
    }
}

 

set to_be_sent_n 0

proc want_to_send {name set num} {
    global to_be_sent_n to_be_sent

 
    set to_be_sent([incr to_be_sent_n]) $name
    set to_be_sent([incr to_be_sent_n]) $set
    set to_be_sent([incr to_be_sent_n]) $num
}

 
 
proc what_to_send {} {
    global to_be_sent_n to_be_sent

    if {$to_be_sent_n == 0} {return \"\"}
    set s $to_be_sent(1)
    for {set i 2} {$i <= $to_be_sent_n} {incr i} {
	set s \"$s	$to_be_sent($i)\"
	unset to_be_sent($i)
    }
    set to_be_sent_n 0
    return $s
}
# 42 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/logo.deq\" 1

global floater_version
tryset about_text \"version [lrange $floater_version 1 end]\\nCopyright (c) 1996-1999 Geoff Pike\\nhttp:\\/\\/www.floater.org/\\nThis is free software.\"








proc about {{timeout 0}} {
    global logofilename about_text

    toplevel .welcome -bg black

    set f \"*-times-medium-r-normal--*-180-*-*-*-*-*-*\"
    set c \"catch {destroy .welcome}\"

    if [catch {
	tryset logofilename 		[file join [file dirname [info nameofexecutable]] Floaterlogo.gif]

	if [catch {image create photo im -file $logofilename}] 		{image create photo im -file [file rootname $logofilename]}

	label .welcome.l -image im
    }] then { label .welcome.l -text Floater }

    label .welcome.b -justify center -text \"$about_text\\nPlaying card bitmaps courtesy of\\nJohn Heidemann and Gary Sager.\"

    foreach w {.welcome.l .welcome.b} {
	$w config -border 0 -font $f -bg black -fg white 		-highlightthickness 0 -relief flat

	bind $w <1> $c
    }

    pack .welcome.l .welcome.b

    if {$timeout > 0} { after $timeout {catch {destroy .welcome}} }
}


after 2000 {about 10000}




# 43 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/texts.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
# 1 \"tclcode/the_texts.deq\" 1
gset Copyright {Copyright (c) 1996--1999 Geoff Pike.
All rights reserved.

Floater is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

This software is provided \"as is\" and comes with absolutely no
warranties.  Geoff Pike is not liable for damages under any
circumstances.  Support is not provided.  Use at your own risk.

Personal, non-commercial use is allowed.  Attempting to make money
from Floater or products or code derived from Floater is not allowed
without prior written consent from Geoff Pike.  Anything that remotely
involves commercialism, including (but not limited to) systems that
show advertisements while being used and systems that collect
information on users that is later sold or traded require prior
written consent from Geoff Pike.
}
gset Readme {			    Floater 1.2b1
		  for Unix and for Microsoft Windows
			  September 14, 1999

		       http:slashslashwww.floater.org/

                            by Geoff Pike
			  geoff@floater.org


Please check the ever growing Floater web page at
http:slashslashwww.floater.org/ for the most up-to-date
documentation and information, including everything here and much more.

Floater is a free program for duplicate bridge play on the Internet.
It also supports non-duplicate bridge and 3-player hearts.

Floater 1.2 is a minor upgrade to 1.1 that includes several changes:
  o  Faster server
  o  New installer for Microsoft Windows users
  o  Some bug fixes

Version 1.2 is not interoperable with older versions.

To install, Microsoft Windows users should download and run the
installer from the Floater web page.  Unix users will need to rebuild
from scratch as described below.

Please report bugs to bugs@floater.org.

Floater for Macintosh will be available soon.  Sorry for the delay.

Please read this file as well as the files called BUGS and CONFUSING.

Microsoft Windows Installation Instructions:
--------------------------------------------

Download and run the installer, inst12b1.exe, available at
http:slashslashwww.floater.org/inst12b1.exe.  The installer has two basic
steps.  Step 1: the installer checks for Tcl/Tk 8.0 and offers to
download and install it for you if necessary.  Step 2: the installer
downloads the Floater executable and associated files from floater.org
and creates a shortcut to Floater from the Desktop and from the
Start Menu.

After installing Floater, you may delete the installer.

Unix Installation instructions:
-------------------------------

Please be aware that these instructions are for installation only.
See the web page for other, ultimately more useful, information.

Please read carefully.  Unlike the Mac and Microsoft Windows versions,
you must compile Floater yourself for Unix.  If you have never edited
a Makefile before, you may find this difficult.

If you have problems, please consult the web page to see if there are
notes from others who may have tried compiling Floater on your
architecture/OS.  Send bugs to bugs@floater.org, and also please send
descriptions of what you had to modify to get Floater to work on your
system.  When sending email about problems that you have not yet been
able to solve, please clearly indicate what you have tried so far.
Due to the high volume of email, responses may be slow.

Almost all of the difficult-to-port features of Floater are
implemented by using Tcl and Tk, which have already been ported to
many different machines.  Floater should run on a variety of machines
with no problem.  It is known to compile on SunOS, Solaris,
Linux, HPs (HP/UX), and Silicon Graphics (IRIX), among others.  Don't
be intimidated by the amount of software you may need to install---the
autoconf scripts really work and next to nothing needs to be fixed by hand.

Floater for Unix has two versions---textual and graphical.  Both
require Tcl and Tk, which are freely available.  In addition, the text
version requires System V style curses or ncurses (GNU's free
replacement for curses).  Tcl/Tk 8.0 is required.  You should use the
latest patch level, which as of September, 1999, is 8.0.5.  (Floater
does not work with Tcl/Tk 8.1 or 8.2.  If you port it to Tcl/Tk 8.2
let us know!)

By default, the graphical and textual versions are in the same
executable.  You may build an executable that does not include the
textual version, which is useful if you have X and don't want to deal
with curses (see Makefile for details).

BSD users without ncurses should have it installed anyway, as the
maintainer of BSD curses has publically announced that he is no longer
supporting it and he encourages people to switch to ncurses.  If you
are unsure whether you need ncurses to use Floater, try it first
without ncurses.  You may get ncurses by anonymous ftp from
prep.ai.mit.edu in the /pub/gnu directory.  Or, it is too much
trouble, you may compile only the X user interface (see Makefile for
details).

Detailed instructions follow.  For easier ftp'ing, the Floater
web page (http:slashslashwww.cs.berkeley.edu/~pike/floater/release.html)
allows you to download the appropriate files.

To install Floater 1.2b1 for Unix:
----------------------------------

0. Floater more or less requires UNIX and 32-bit integers.  Brave
souls who try to install it without those things may succeed but with
some difficulty.

1. If your site doesn't have it, install Tcl/Tk, available from the
Tcl/Tk web page at http:slashslashwww.scriptics.com.  Note that Tcl/Tk 8.0.5
is what you should try to use, but 8.0.x is fine.  See above.

2. You may or may not need ncurses.  System V users and many BSD users
should either not need it or already have it.  See above.

3. Get the compressed Floater tar file from the Floater web page.
Uncompress and untar the file by doing:
        gzip -c -d floater1.2b1.tar.gz | tar xvf -

(You may remove floater1.2b1.tar.gz now.)

4. Run the configure script by doing changing to the floater1.2b1
directory and running ./configure.  The flags accepted by the
configure script are as follows:
  --with-tcl=/some/path
     will look for tcl headers files and libs in /some/path/include
     and /some/path/lib

  --with-tk=/some/path
     same as --with-tcl but for tk

  --with-curses=/some/path
     same as above but for curses (it tries to look for ncurses and
     then curses but may not be perfect...)

  --without-curses
     doesn't look for curses at all and defines GUI_ONLY when
     building.

If the configure script runs successfully, it creates a Makefile.
(Thanks to Andrew Swan for creating the new and improved configure script!)

5. Do \"make\".  It may or may not work.  If it doesn't work, edit the
file Makefile.in to try to set up the paths for various libraries,
etc., as necessary.  More instructions are in that file.  Each time
you edit Makefile.in, do \"make Makefile\" to regenerate the Makefile,
and then do (just) \"make\" again.  (On some systems you can just do
\"make\" and it will automatically recreate the Makefile and then try to
recompile.)  If desperate, you may also want to refer to
Makefile.pike, which is a Makefile that is known to work on at least
one system somewhere.

6. Once you have successfully built Floater, a common problem when you
first run it is an error message about being unable to find init.tcl
in certain directories.  The easiest solution, if you have Tcl and Tk
in sibling directories, is to create a directory called lib, sibling
to those two, and do:
        cd lib
        ln -s ../tk8.0/library tk8.0
        ln -s ../tcl8.0/library tcl8.0

Another solution is to find init.tcl and put a copy of it in one of
the directories in which it is looking when you start up Floater.
Another is, before running Floater, to do \"setenv TCL_LIBRARY <dir>\"
where <dir> is the directory containing init.tcl (typically
<something>/tcl8.0/library).  A third is to properly install Tcl by
doing \"make install\" in the tcl8.0/ 1  directory---but you probably
have to be root to do this.

(Once you fix that, the analogous problem will likely crop up with Tk.
It will complain that it can't find a usable tk.tcl.  The same fixes
apply, but be sure to copy all the .tcl files in tk8.0/library if you
choose that solution.)
}
gset Confusing {This file is intended to list some of the more confusing aspects of
using Floater.

1. Floater relies on self-alerts.  If playing formally, you are
expected to explain your bidding and carding agreements as carefully
as you would at a tournament.  In any case, you alert by using the
commands `alert,' `redalert' and `explain.'   You should alert
at the same time or before you take an alertable action.  There are no
fixed rules as to what agreements are alertable---use your judgment
and do unto others as you would have them do unto you.

The easy way to alert an action is to type \"!\" (or \"!!\" for redalert)
on the same line as the command to perform that action---and
optionally put an explanation at the end.  For example, you could type
\"2D!weak two in either major\" to bid and alert your own bid
simultaneously.  See also the help on `alert,' `redalert' and
`explain.'

If you are using the graphical user interface, you may click on the
\"Alert\" or \"Redalert\" checkboxes BEFORE clicking on the call you wish
to make.  For example, clicking on \"1C\" when the \"Alert\" checkbox is
highlighted will have the same effect as typing \"1C!\" on the keyboard.

Everyone at the table except partner sees your alerts.

2. See also the file called BUGS.
}
gset Bugs {This file lists some of the known bugs and limitations of Floater.
Please read it.  You may assume everything listed here is being worked
on and will be eventually fixed.  Older bugs are at toward the bottom;
newer bugs are toward the top.  An asterisk after the numeral
indicates that the bug has been fixed.  (Some of the listings may be
cryptic or incomprehensible---my apologies.)

Send bug reports to bugs@floater.org.

8. When I host, scoring method defaults to whatever it was at the
previous table.  Furthermore, when I do, say, \"score imp,\" the list of
tables isn't updated immediately.

7. When using the GUI, occasionally I have had the menu bar at the
top disappear and not come back.  This appears to be a Tcl/Tk bug.  If
it happens, iconify Floater and then restore it, and the menu bar
will reappear.

6. The review command sometimes puts your side's actions in parens.
I think it should always put the other guys' actions in parens.

5.. Pseudomail works but doesn't correctly report whether it succeeded.
(It always reports success.)

4. The documentation is a work in progress.  For the latest, look at:
     http:slashslashwww.floater.org/doc

3. Curses may be confused about your screen size or terminal attributes.
Putting the following in your .cshrc may do the trick:
    setenv TERM vt100

    set noglob
    eval `tset -s`
    unset noglob

Another possible fix is to try doing:
    eval `resize`

2. Logging in disconnects you from the table.  (This is becuase the other
players would become confused if your name suddenly changed.  But it
can be fixed.)

1. Sometimes after being shunted (when you do the `host' command) you
find that you do not get connected properly to the table tree.  When
this happens, try again a few times.  As a last resort, you may do
`host <tablename>' to try to join the table tree at that location.
}
gset help_texts {Copyright Readme Confusing Bugs}
# 19 \"tclcode/texts.deq\" 2

proc display_text {name s} {
    global fixedfont
     
    set slash /
    regsub -all slashslash $s $slash$slash text



    global display_text_N

    if ![info exists display_text_N] {set display_text_N 0}
    set w .display_text[incr display_text_N]
    toplevel $w
    wm title $w $name
    set f [frame $w.f]
    text $f.text -relief raised -yscrollcommand \"$f.scroll set\" 	    -width 77 -font $fixedfont

    $f.text insert end $text
    pack [scrollbar $f.scroll -command \"$f.text yview\"] 	    -side right -fill y

    pack $f.text -side left -fill both -expand y
    button $w.b -text \"Dismiss\" -command \"destroy $w\"
    pack $w.b -side bottom -pady 2
    pack $f -side top -fill both -expand y

}
# 44 \"tclcode/floater.TCL\" 2






gset floaterclock 0
gset table_arrival_time 0
gset snooze 0

# 64 \"tclcode/floater.TCL\"


 

gset ntalklines 0  

gset dtalklines 0  
		   

gset talklineattop 0  
 
 

gset showerrors 1
gset debugprinting 0

# 139 \"tclcode/floater.TCL\"

proc talkmsg {s} {
    global talktext debugtext debugprinting showerrors

    if $debugprinting then { set w $debugtext } else { set w $talktext }

    if {!$showerrors && [regexp -nocase error $s]} return

    catch {
	$w insert end \"$s\\n\"
	$w yview -pickplace end
    }
}


proc floatererror {s} { talkmsg \"ERROR: $s\" }

 


 
if {[catch {source $startupfile} err] 	&& ![regexp -nocase {no such file} $err]} {




    puts stderr $err

}







tryset loginservername \"loginserver\"
tryset loginserveraddr \"128.32.131.251\"
tryset loginserverport \"2210\"
tryset resultservername \"resultserver\"
tryset resultserveraddr \"128.32.131.251\"
tryset resultserverport \"1430\"
tryset pseudomailaddr \"128.32.131.251\"
tryset pseudomailport \"1440\"
tryset resultparserprogram /home/cs/pike/floater/floatres/parsemail
tryset resultparser \"floater@floater.org\"
tryset bugmail \"pike@cs.berkeley.edu\" ; # \"bugs@floater.org\"

 
tryset defaultnote \"\"

 
tryset tricktime 2000

 
 



tryset autonewdeal_default 35


 
tryset autonewdeal_seconds $autonewdeal_default

tryset nokibitzers 0
tryset jointableservertree 1

tryset youveseen 1

tryset newbie [expr ![info exists usedname]]

 
 
 

gset screenheight [winfo screenheight .]
gset screenwidth [winfo screenwidth .]
tryset geometry_specified 0
catch {wm title . \"Floater\"}
catch {wm minsize . 1 1}
 
 
set w 600
set h 800
if {$h >= $screenheight} {
    set h [expr $screenheight - 15]



}
if !$geometry_specified {catch {wm geometry . [join \"$w $h\" x]}}
 
 
 
 
 
set effectiveheight $h

 
 


 
 
 


# 264 \"tclcode/floater.TCL\"

tryset _suitfont(l) \"*-symbol-medium-r-normal--*-180-*-*-*-*-*-*\"
tryset _cardfont(l) \"*-times-medium-r-normal--*-180-*-*-*-*-*-*\"
tryset _NTfont(l) \"*-times-medium-r-normal--*-140-*-*-*-*-*-*\"
tryset _suitfont(m) \"*-symbol-medium-r-normal--*-120-*-*-*-*-*-*\"
tryset _cardfont(m) \"*-times-medium-r-normal--*-120-*-*-*-*-*-*\"
tryset _NTfont(m) \"*-times-medium-r-normal--*-100-*-*-*-*-*-*\"
tryset _suitfont(s) \"*-symbol-medium-r-normal--*-100-*-*-*-*-*-*\"
tryset _cardfont(s) \"*-times-medium-r-normal--*-100-*-*-*-*-*-*\"
tryset _NTfont(s) \"*-times-medium-r-normal--*-80-*-*-*-*-*-*\"
tryset _namefont(l) \"*-times-bold-r-normal--*-120-*-*-*-*-*-*\"
tryset _namefont(m) \"*-times-bold-r-normal--*-120-*-*-*-*-*-*\"
tryset _namefont(s) \"*-times-bold-r-normal--*-100-*-*-*-*-*-*\"
tryset _talkfont(e) \"*-new century schoolbook-medium-r-normal--*-240-*-*-*-*-*-*\"
tryset _talkfont(l) \"*-new century schoolbook-medium-r-normal--*-180-*-*-*-*-*-*\"
tryset _talkfont(m) \"*-new century schoolbook-medium-r-normal--*-140-*-*-*-*-*-*\"
tryset _talkfont(s) \"*-new century schoolbook-medium-r-normal--*-120-*-*-*-*-*-*\"

tryset _talkfont(8) {Courier 18}
tryset _talkfont(4) {Courier 14}
tryset _talkfont(2) {Courier 12}





if {$effectiveheight < 770} {
    set talkfont $_talkfont(s)
    set radiotalkfont Small
} else {
    set talkfont $_talkfont(m)
    set radiotalkfont Medium
}


 
 
proc refont {widget font} {
    global a_$font fonts widget_to_font

 
    if {[info exists widget_to_font($widget)] && 	    $widget_to_font($widget) != $font} {

	set oldfont $widget_to_font($widget)
	global a_$oldfont
 
	catch {eval \"unset a_$oldfont\\($widget)\"}
    }

    eval \"set a_$font\\($widget) 1\"
    set widget_to_font($widget) $font
    set fonts($font) 1
}

 
proc updatefont {font} {
    global a_$font $font

    eval \"set new $$font\"
    foreach w [array names a_$font] {
 
	if [catch {$w configure -font $new}] {eval \"unset a_$font\\($w)\"}
    }
}

 
proc updateallfonts {} {
    global fonts

    foreach font [array names fonts] {
	updatefont $font
    }
}

 
proc updatetalkfontsize {size} {
    global talkfont _talkfont talktext cmdlinefont cmdlinelabelfont debugtext
    
    if {$talkfont != $_talkfont($size)} {
	$talktext configure -font [set talkfont $_talkfont($size)]
	catch {$debugtext configure -font $talkfont}
    }
    set cmdlinefont $talkfont
    set cmdlinelabelfont $cmdlinefont
    updatefont cmdlinefont
    updatefont cmdlinelabelfont
    after 250 talkbottom
}

 
proc setfontsize {size} {
    global suitfont cardfont NTfont passfont doublefont redoublefont namefont 	    auctionlabelfont auctionbbfont cmdlinefont cmdlinelabelfont 	    _suitfont _cardfont _NTfont _namefont talkfont 	    buttoncardoptions buttonsuitoptions




    set namefont $_namefont($size)
    set suitfont $_suitfont($size)
    set cardfont $_cardfont($size)
    set NTfont $_NTfont($size)
    set passfont $NTfont
    set doublefont $cardfont
    set redoublefont $doublefont
    set auctionlabelfont $passfont
    set auctionbbfont $cardfont
    set cmdlinefont $talkfont
    set cmdlinelabelfont $cmdlinefont
    set buttoncardoptions \"-font $cardfont -padx 1 -relief flat\"
    set buttonsuitoptions \"-font $suitfont -padx 2 -relief flat\"
}



setfontsize m  


tryset NTtext NT
tryset passtext Pass
tryset doubletext X
tryset redoubletext XX

tryset auctionlabel \"The Bidding:\"
tryset auctionnamewidth 12

gset suitchar(0) [set club \"\\247\"]
gset suitchar(1) [set diamond \"\\250\"]
gset suitchar(2) [set heart \"\\251\"]
gset suitchar(3) [set spade \"\\252\"]
proc s {} {global spade; return \"$spade -fg black\"}
proc h {} {global heart; return \"$heart -fg red\"}
proc d {} {global diamond; return \"$diamond -fg red\"}
proc c {} {global club; return \"$club -fg black\"}

 
tryset framesuitoptions \"\"


 

gset tcl_interactive 1

set needAuctionUpdate 0

# 1 \"tclcode/options_common.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
 
 

 
 
 

set beepAtMyTurn_ 0
proc beepAtMyTurn {{toggle 0}} {
    global beepAtMyTurn_

    if $toggle {set beepAtMyTurn_ [expr !$beepAtMyTurn_]}
}

# 407 \"tclcode/floater.TCL\" 2


# 1 \"tclcode/options_GUI.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
 
 
 

proc copytext {old new} {
    global talktext

    set talktext $new
    catch {$new insert end [$old get 0.0 end-1c]}
}

set separateTalk_ [set talk_is_sep 0]
proc separateTalk {{toggle 0}} {
    global talk_is_sep talkfont separateTalk_

     
    if $toggle {set separateTalk_ [expr !$separateTalk_]}
    if {$talk_is_sep == $separateTalk_} return
    if [set talk_is_sep $separateTalk_] {
	catch {destroy .floaterTalk}
	toplevel .floaterTalk
	wm title .floaterTalk \"Floater Talk\"
	text .floaterTalk.text -wrap word -font $talkfont -relief raised -yscrollcommand \".floaterTalk.scroll set\"
	pack [scrollbar .floaterTalk.scroll -command \".floaterTalk.text yview\"] -side right -fill y
	pack .floaterTalk.text -side left -fill both -expand yes
	copytext .talk.text .floaterTalk.text
	.talk.text delete 0.0 end
	pack forget .talk
	.floaterTalk.text yview -pickplace end
	bind .floaterTalk.text <Configure> 		{.floaterTalk.text yview -pickplace end}

	bind .floaterTalk.text <FocusIn> focus_cmdline
    } else {
	copytext .floaterTalk.text .talk.text
	catch {destroy .floaterTalk}
	pack .talk
    }
}	

 

 

set hideMatrix_ [set matrix_hidden_during_auction 0]
proc hideMatrix {{toggle 0}} {
    global hideMatrix_ matrix_hidden_during_auction needAuctionUpdate

     
    if $toggle {set hideMatrix_ [expr !$hideMatrix_]}
    if {$hideMatrix_ == $matrix_hidden_during_auction} return
    set matrix_hidden_during_auction $hideMatrix_
    set needAuctionUpdate 1
}

 
if {$effectiveheight < 770} {hideMatrix 1}

set matrix_showing 1
proc showMatrix {b} {
    global matrix_showing canv

     
    if {$b == $matrix_showing} return
    if [set matrix_showing $b] {
	$canv(c) move all 0 [expr - $canv(YMatrixHide)]
	$canv(c) configure -height $canv(height)
    } else {
	$canv(c) move all 0 $canv(YMatrixHide)
	$canv(c) configure -height $canv(matrixHiddenHeight)
    }
}

 

set hideCommandLine_ 0
proc hideCommandLine {{toggle 0}} {
    global hideCommandLine_

    if $toggle {set hideCommandLine_ [expr !$hideCommandLine_]}
    if $hideCommandLine_ {
	pack forget .cmd.cmdline
	pack forget .cmd.f.labelc
    } else {
        pack .cmd.cmdline -before .cmd.talk -fill x -side top -expand yes
	pack .cmd.f.labelc -before .cmd.f.labelt -side top -anchor e
    }
}

 

set bidButtons_ [set bid_buttons_during_auction 1]
proc bidButtons {{toggle 0}} {
    global bidButtons_ bid_buttons_during_auction needAuctionUpdate

     
    if $toggle {set bidButtons_ [expr !$bidButtons_]}
    if {$bidButtons_ == $bid_buttons_during_auction} return
    set bid_buttons_during_auction $bidButtons_
    set needAuctionUpdate 1
}

 
if {$effectiveheight < 700} {bidButtons 1}

 
 
 

set deiconifyIfBeeped_ 1
proc deiconifyIfBeeped {{toggle 0}} {
    global deiconifyIfBeeped_

     
    if $toggle {set deiconifyIfBeeped_ [expr !$deiconifyIfBeeped_]}
}

proc Floater_deiconify {} {
    global deiconifyIfBeeped_

    catch {
	if {$deiconifyIfBeeped_ && [wm state .] == \"iconic\"} {wm deiconify .}
    }
}

 
 
 
 

if {$effectiveheight > 770} {
    set auction_hide_time -1
} else {
    set auction_hide_time 10
}

proc Floater_bell {} { catch { bell } }


# 409 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/matrix0.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
gset newstyle_matrix 0

proc redrawmatrixcards {} {}

proc togglepassedcard {suit card} {
    global togglepassedaction

    if [info exists togglepassedaction([string toupper $suit$card])] 	    {catch $togglepassedaction([string toupper $suit$card])}

}

proc removecardfromhand {suit card} {
    global removecard

    if [info exists removecard([string toupper $suit$card])] 	    {catch $removecard([string toupper $suit$card])}

}


proc tpcard {w} {
     
    if ![string match *ello* [$w config -fg]] {
	$w config -fg yellow
	 
    } else {
	$w config -fg black
	 
    }
}


# 84 \"tclcode/matrix0.deq\"

  

 
proc suit {f cards suit} {
# 101 \"tclcode/matrix0.deq\"

    global buttoncardoptions buttonsuitoptions removecard togglepassedaction

    set buttons {}
    for {set i [expr [string length $cards] - 1]} {$i >= 0} {incr i -1} {
	set card [string index $cards $i]
	set comm \"-command \\\"command $suit$card\\\"\"
	set newbutton [eval \"button $f.$suit.$suit$card 		$buttoncardoptions -text $card $comm\"]

	refont $newbutton cardfont
	set buttons [linsert $buttons 0 $newbutton]
	set removecard([string toupper $suit$card]) \"destroy $newbutton\"
	set togglepassedaction([string toupper $suit$card]) \"tpcard $newbutton\"
    }

 
 
 

    refont [eval \"label $f.$suit.suit $buttonsuitoptions -text [$suit]\"] suitfont
    eval \"pack $f.$suit.suit $buttons -side left\"

}

 
 
proc hand {f s h d c} {

    global framesuitoptions

     
    if [winfo exists $f.name] {
	foreach i {name s h d c} {
	    foreach child [winfo children $f.$i] {
		catch {destroy $child}
	    }
	}
    } else {
	catch {destroy $f.name $f.s $f.h $f.d $f.c}
	frame $f.name
	frame $f.s
	frame $f.h
	frame $f.d
	frame $f.c
	pack $f.name -side top -anchor w
	eval \"pack $f.s $f.h $f.d $f.c -side top -anchor w $framesuitoptions\"
    }





    suit $f $s s
    suit $f $h h
    suit $f $d d
    suit $f $c c 
}

# 184 \"tclcode/matrix0.deq\"



 
 
 
proc prop_on {} {
 
 
 
}


 
 
 
proc fulldeal {s h d c LHOs LHOh LHOd LHOc 		   Ps Ph Pd Pc RHOs RHOh RHOd RHOc} {

    global mframe

    hand $mframe(self) $s $h $d $c
    hand $mframe(pard) $Ps $Ph $Pd $Pc
    hand $mframe(lho) $LHOs $LHOh $LHOd $LHOc
    hand $mframe(rho) $RHOs $RHOh $RHOd $RHOc
}

gset tricktimeOK 1

 
 
proc startshowtricktimer {} {
    global tricktime tricktimeOK

    set tricktimeOK 0
    after $tricktime set tricktimeOK 1
}

 
 
proc delayedclearmatrix {} {
    global needtoerase

    set needtoerase 1
    after 5000 clearmatrixtimer
}

proc clearmatrixtimer {} {
    global needtoerase

    if $needtoerase {erasebidplay all}
}

 
 
proc erasebidplay {who} {
    global tricktimeOK

    while {!$tricktimeOK} {
	update
	after 100
    }
    if {$who == \"all\"} {
	global needtoerase

	set needtoerase 0
	erasebidplay lho
	erasebidplay rho
	erasebidplay pard
	erasebidplay self
    } else {






	set path .play.middle.box.$who
	catch {pack forget $path.suit $path.card}

    }
}

 
 
 
proc showplay {player suit card} {
# 279 \"tclcode/matrix0.deq\"

    global cardfont suitfont

    set path .play.middle.box.$player
    catch {pack forget $path.suit $path.card} c
    if {$c != \"\"} {
	 
	refont [label $path.suit -font $suitfont -borderwidth 0] suitfont
	refont [label $path.card -font $cardfont -borderwidth 0] cardfont
    }
    pack $path.suit $path.card -side left

    if {$suit != \"?\"} {
	eval \"$path.suit configure -text [$suit] -font $suitfont\"
	refont $path.suit suitfont
    } else {
	$path.suit configure -text \"\"
    }
    $path.card configure -text [string toupper $card]

}

 
 
 
 
proc showbid {player level strain} {
 
# 320 \"tclcode/matrix0.deq\"

    drawbid .play.middle.box.$player $level $strain

}

# 353 \"tclcode/matrix0.deq\"

proc drawbid {path level strain} {
    global NTtext NTfont cardfont suitfont 	passtext passfont doubletext doublefont redoubletext redoublefont


 

    catch {pack forget $path.suit $path.card} c
    if {$c != \"\"} {
	 
	refont [label $path.suit -font $suitfont -borderwidth 0] suitfont
	refont [label $path.card -font $cardfont -borderwidth 0] cardfont
    }
    pack $path.card $path.suit -side left

    if {$strain == \"n\"} {
	$path.suit configure -text $NTtext -font $NTfont -fg black
	refont $path.suit NTfont
	$path.card configure -text $level
    } elseif {$strain == \"x\"} {
	$path.suit configure -text $doubletext -font $doublefont -fg red
	refont $path.suit doublefont
	$path.card configure -text \"\"
    } elseif {$strain == \"xx\"} {
	$path.suit configure -text $redoubletext -font $redoublefont -fg blue
	refont $path.suit redoublefont
	$path.card configure -text \"\"
    } elseif {$strain == \"p\"} {
	$path.suit configure -text $passtext -font $passfont -fg black
	refont $path.suit passfont
	$path.card configure -text \"\"
    } elseif {$strain == \"-\"} {
	$path.suit configure -text \"\"
	$path.card configure -text \"\"
    } elseif {$strain == \"?\"} {
	$path.suit configure -text \"\"
	$path.card configure -text \"?\"
    } else {
	eval \"$path.suit configure -text [$strain] -font $suitfont\"
	refont $path.suit suitfont
	$path.card configure -text $level
    }
}


 
 
proc setname {player compassdir name} {
# 415 \"tclcode/matrix0.deq\"

    global namefont mframe playername position
    set playername($player) $name
    set position($player) $compassdir
    set f $mframe($player).name.label
    if {[string first \"(\" $name] == -1} {set name \"$name  ($compassdir)\"}
    catch {$f configure -text $name} c
    if {$c != \"\"} {
	 
	refont [label $f -font $namefont -text $name] namefont
	pack $f -pady 0
    }

}

# 410 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/matrix.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
gset newstyle_matrix 1

global tinymat smallmat screenheight screenwidth
set tinymat [expr $screenheight <= 600]
set smallmat [expr !$tinymat && ($screenheight <= 800)]

if {$tinymat || $smallmat} {
# 1 \"tclcode/matrixsize.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
 
 
 
 
gset pardheight 100
gset matrixwidth 200 
gset lhowidth 193
gset rhowidth $lhowidth
gset self_matrix_gap 55
gset suitgap 45
gset ourcardgap 23
gset theircardgap 19
gset rhomaxx 600
gset cardrectvgap 4

proc smallmatrix {b v {m 160}} {
    global handx handy canv namex namey suitgap ourcardgap theircardgap vgap 	    pardheight matrixheight matrixwidth lhowidth rhowidth 	    self_matrix_gap bottom_cutoff



    set bottom_cutoff $b
    set vgap $v
    set matrixheight $m
    set matrixtop $pardheight
    set matrixl $lhowidth
    set matrixbot [expr $pardheight + $matrixheight]
    set matrixr [expr $lhowidth + $matrixwidth]
    set canv(matrix) \"$matrixl $matrixtop $matrixr $matrixbot\"

    set handx(self) [expr $matrixl + $matrixwidth / 2]
    set handx(pard) $handx(self)
    set handy(pard) [expr $matrixtop - 50]
    set handy(self) [expr $matrixbot + $self_matrix_gap]
    set handx(lho) 50
    set handy(lho) [expr $pardheight + 40]
    set handx(rho) [expr $matrixr + 40]
    set handy(rho) $handy(lho)
    
    set canv(height) [expr $handy(self) + 35 - $bottom_cutoff]
    set canv(width) [expr $lhowidth + $matrixwidth + $rhowidth]

    foreach p {lho self pard rho} {
	set namex($p) $handx($p)
	set namey($p) [expr $handy($p) - 43]
    }
}

proc tinymatrix {} {smallmatrix 32 26 148}

proc mdealtest {{n -1}} {
    set q(0) {AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2}
    set q(1) {AKQJT9 AKQJT98 AKQJT987 AKQJT9876 {} {} {} {} {} {} {} {} {} {} {} {}}
    set q(2) {{} {} {} {} AKQJT9 AKQJT98 AKQJT987 AKQJT9876 {} {} {} {} {} {} {} {}}
    set q(3) {{} {} {} {} {} {} {} {} AKQJT9 AKQJT98 AKQJT987 AKQJT9876 {} {} {} {}}
    set q(4) {{} {} {} {} {} {} {} {} {} {} {} {} AKQJT9 AKQJT98 AKQJT987 AKQJT9876}
    set q(5) {AKQJT987654 Q82 J J6 {} {} {} {} {} {} {} {} {} {} {} {}}
    set q(6) {{} {} {} {} AKQJT987654 Q82 J J6 {} {} {} {} {} {} {} {}}
    set q(7) {{} {} {} {} {} {} {} {} AKQJT987654 Q82 J J6 {} {} {} {}}
    set q(8) {{} {} {} {} {} {} {} {} {} {} {} {} AKQJT987654 Q82 J J6}
    if {$n >= 0} {catch {eval \"fulldeal $q($n)\"}} {
	for {set i 1} {$i <= 8} {incr i} {
	    after [expr $i * 5000] fulldeal $q($i)
	}
    }
}

proc mt {{n 0}} {
    mdealtest $n
 
    showplay self c q
    showplay pard s k
    showplay lho d a
    showplay rho h j
    sillynames
}

proc mtest {{d {}}} {
    catch {destroy .tc}
    toplevel .tc
    canvsetup [canvas .tc.c]
    pack .tc.c -side top -expand yes -fill both
    fulldeal AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2
    eval \"mdealtest $d\"

    showplay self c q
    showplay pard s k
    showplay lho d a
    showplay rho h j
    sillynames
}


# 26 \"tclcode/matrix.deq\" 2

    if $tinymat {
	tryset fixedfont {Courier 8}
        tinymatrix
    } else {
	tryset fixedfont {Courier 10}
	smallmatrix 0 30
    }
} else {
    tryset fixedfont {Courier 12}
# 1 \"tclcode/matrixbig.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
gset handx(self) 320
gset handy(self) 370
gset handx(pard) $handx(self)
gset handy(pard) 50
gset handx(lho) 50
gset handy(lho) 150
gset handx(rho) 490
gset handy(rho) $handy(lho)
gset rhomaxx 650

gset canv(matrix) \"200 100 440 300\"

gset canv(height) 415

foreach p {lho self pard rho} {
    gset namex($p) $handx($p)
    gset namey($p) [expr $handy($p) - 43]
}

gset suitgap 50
gset ourcardgap 25
gset theircardgap 20
gset vgap 38

gset cardrectvgap 5

# 36 \"tclcode/matrix.deq\" 2

}

if $tinymat {gset fixedfont {Courier 8}}



foreach p {lho rho pard self} {gset matrixcards($p) 0}

proc matrix_showcards {b who} {
    global matrixcards matrix_showing
    if {$b != $matrixcards($who)} {
	global canv
	set c $canv(c)
	if [set matrixcards($who) $b] {
	    $c coords $canv(frame,$who) $canv(exilex) $canv(exiley)
	} else {
	    $c coords $canv(frame,$who) $canv(mx,$who) 		    [expr $canv(my,$who) + 		    ($matrix_showing ? 0 : $canv(YMatrixHide))]


	}	
    }
}    

proc highlight_card {tag w x y} {
    global canv
    $w itemconfigure $tag -background #c0c0c0
    set canv(highlighted) [$w find withtag $tag]
}

proc unhighlight_card {tag w x y} {
    global canv
    $w itemconfigure $tag -background white
    catch {unset canv(highlighted)}
}

set last_click_card_time -1
proc click_card {tag w time x y} {
    global canv last_click_card_time last_click_card_x last_click_card_y

     
    if {$last_click_card_time > 0
        && [expr $time - $last_click_card_time] < 750
        && [expr abs($last_click_card_x - $x)] < 5
        && [expr abs($last_click_card_y - $y)] < 5} return
    set last_click_card_time $time
    set last_click_card_x $x
    set last_click_card_y $y

    if [info exists canv(highlighted)] {
	if {$canv(highlighted) == [$w find withtag $tag]} {
	    command $canv(item_to_card,[$w find withtag $tag])
	}
    }
}

proc canvsetup {c} {
    global canv cardwidth cardheight matrixcards cardrectvgap

    catch {destroy $c}
    canvas $c -height $canv(height)
    set canv(c) $c
    set x [set canv(exilex) -2000]
    set y [set canv(exiley) 0]
    set canv(fg,s) black
    set canv(fg,h) red
    set canv(fg,d) red
    set canv(fg,c) black
    set canv(bg,s) white
    set canv(bg,h) white
    set canv(bg,d) white
    set canv(bg,c) white
    foreach suit {s h d c} {
	foreach card {a k q j t 9 8 7 6 5 4 3 2} {
	    set n [$c create bitmap $x $y -tags livecard]
	    $c itemconfigure $n -bitmap c_$card$suit 		    -background $canv(bg,$suit) -foreground $canv(fg,$suit)

	    set canv(fg_,$n) $canv(fg,$suit)
	    set canv(item_to_card,$n) $suit$card
	    set canv($card$suit) $n
	    set canv([string toupper $card]$suit) $n
	    set canv($card[string toupper $suit]) $n
	    set canv([string toupper $card$suit]) $n
	}
    }

 
    $c bind livecard <Any-Enter> { highlight_card current %W %x %y }
    $c bind livecard <Any-Leave> { unhighlight_card current %W %x %y }
    $c bind livecard <ButtonRelease-1> { click_card current %W %t %x %y }

    set bbox [$c bbox $canv(as)]
    set cardwidth [expr [lindex $bbox 2] - [lindex $bbox 0]]
    set cardheight [expr [lindex $bbox 3] - [lindex $bbox 1]]

 
    global namefont namewid namex namey
    foreach p {self pard} {
	set namewid($p) [
	$c create text $namex($p) $namey($p) -font $namefont -justify center
	]
    }
    foreach p {lho rho} {
	 
	set x [expr $namex($p) - $cardwidth / 2]
	set namewid($p) [
	$c create text $x $namey($p) -font $namefont -justify left -anchor w 
	]
    }

    global lhomaxx handx handy
    eval \"$c create rect $canv(matrix)\"
    set matrixleft [set lhomaxx [lindex $canv(matrix) 0]]
    set matrixright [lindex $canv(matrix) 2]
    set matrixtop [lindex $canv(matrix) 1]
    set matrixbot [lindex $canv(matrix) 3]
    set canv(YMatrixHide) [expr - ($matrixbot + 4)]
    set canv(matrixHiddenHeight) 	    [expr $handy(self) - $matrixbot + $cardheight / 2 + 3]


 
    set canv(mx,lho) [expr $matrixleft + $cardwidth / 2 + 5]
    set canv(my,lho) [expr ($matrixtop + $matrixbot) / 2]
    set canv(mx,rho) [expr $matrixright - $cardwidth / 2 - 5]
    set canv(my,rho) [expr ($matrixtop + $matrixbot) / 2]
    set canv(mx,self) $handx(self)
    set canv(my,self) [expr $matrixbot - $cardheight / 2 - $cardrectvgap]
    set canv(mx,pard) $canv(mx,self)
    set canv(my,pard) [expr $matrixtop + $cardheight / 2 + $cardrectvgap]

    global suitfont cardfont
 
    foreach p {lho self rho pard} {
	set canv(matrixtext,$p) [
	$c create text $canv(mx,$p) $canv(my,$p) -font $cardfont
	]
    }

 
    foreach p {lho self rho pard} {
	set path [frame $c.f$p]
	refont [label $path.card -font $cardfont -borderwidth 0] cardfont
	refont [label $path.suit -font $suitfont -borderwidth 0] suitfont
	pack $path.card $path.suit -side left
	set canv(frame,$p) 		[$c create window $canv(mx,$p) $canv(my,$p) -window $path]

	set matrixcards($p) 0
    }

}

 
 
proc setname {player compassdir name} {
    global namefont playername position canv namewid

    set playername($player) $name
    set position($player) $compassdir
    set f $namewid($player)
    set w $canv(c)
    if {[string first \"(\" $name] == -1} {set name \"$name  ($compassdir)\"}
    catch {$w itemconfigure $f -text $name} c
    if {$c != \"\"} {}
}

proc eraseallcards {} {
    erasebidplay all
    foreach suit {s h d c} {
	foreach card {a k q j t 9 8 7 6 5 4 3 2} {
	    erasecard $suit $card
	}
    }
}

 
proc erasecard {suit card} {
    global canv

    drawcard $suit $card $canv(exilex) $canv(exiley)
    $canv(c) itemconfigure $canv($card$suit) -foreground $canv(fg,$suit)
}

proc drawcard {suit card x y} {
    global canv

    set c $canv(c)
    showMatrix 1
    $c coords $canv($card$suit) $x $y
}

 
 
proc redrawmatrixcards {} {
    global canv

    foreach p {lho rho self pard} {
	if [info exists canv(matrixcard,$p)] {
	    eval \"showplay $p $canv(matrixcard,$p)\"
	}
    }
}



 
 
 
 
 
 
 
 
 
 
 

 
proc redohand {who suit card} {
    global curhandx curhandy hands handsx handsy

    regsub -nocase $card [set o $hands($who,$suit)] {} n
     
    if [string compare $n $o] {
	erasecard  $suit $card
	if {$who == \"lho\" || $who == \"rho\"} {
	     
	    set curhandx $handsx($who,$suit)
	    set curhandy $handsy($who,$suit)
	    suit $who $n $suit
	} else {
	    set hands($who,$suit) $n
	    hand $who 		    $hands($who,s) $hands($who,h) $hands($who,d) $hands($who,c)

	}
    }
}

 
proc tprestore {} {
    global canv purple
    set c $canv(c)
    foreach t [array names purple] {
	unset purple($t)
	catch {talkmsg \"Restoring color to $t\"}
	$c itemconfig $t -foreground $canv(fg_,$t)
    }
}

proc tpcard {what} {
    global canv purple
    set c $canv(c)
    set t $canv($what)
    if ![info exists purple($t)] {
	set purple($t) 1
	$c itemconfig $t -foreground purple
	lappend canv(maybepass) $t
	 
    } else {
	unset purple($t)
	$c itemconfig $t -foreground $canv(fg_,$t)
	 
    }
}

proc suit {who cards suit} {
    global removecard togglepassedaction cardgap curhandx curhandy 	    lhomaxx rhomaxx cardwidth hands handsx handsy canv


     
    set hands($who,$suit) $cards
    set handsx($who,$suit) $curhandx
    set handsy($who,$suit) $curhandy
    set l [string length $cards]
    set spacing $cardgap
    set xmin [expr $cardwidth / 2]
    if {$who == \"lho\" || $who == \"rho\"} {
	if {$l > 6} {incr spacing -2}
	if {$l > 7} {incr spacing -3}
	if {$l > 8} {incr spacing -2}
	if {$l > 9} {incr spacing -3}
	if {$spacing < 10} {set spacing 10}
	if {$who == \"lho\"} {set xmax $lhomaxx} {set xmax rhomaxx}
	while {[expr $curhandx + $cardwidth / 2 + ($l - 1) * $spacing + 3] 		> $xmax} {

	    if {$curhandx > $xmin} {incr curhandx -3} {incr spacing -1}
	}
    }
    if {$curhandx < $xmin} {set curhandx xmin}
    for {set i 0} {$i < $l} {incr i} {
	set card [string index $cards $i]
	drawcard $suit $card $curhandx $curhandy
	set removecard([string toupper $suit$card]) \"redohand $who $suit $card\"
	set togglepassedaction([string toupper $suit$card]) \"tpcard $card$suit\"
	set canv(dealt,[string tolower $suit$card]) 1
	incr curhandx $spacing
    }
}


proc hand {who s h d c} {
    global handx handy curhandx curhandy suitgap cardgap hands vgap 	    ourcardgap theircardgap


     
    if {$who == \"self\" || $who == \"pard\"} {
	set cardgap $ourcardgap
	set width [expr ([string length $s] + [string length $h] + [string length $d] + [string length $c]) * $cardgap + (([string length $s] > 0) + ([string length $h] > 0) + ([string length $d] > 0)) * $suitgap]
	set curhandx [expr $handx($who) - round(0.5 * $width)]
	set curhandy $handy($who)

	suit $who $s s
	if {$s != \"\"} {incr curhandx $suitgap}
	suit $who $h h
	if {$h != \"\"} {incr curhandx $suitgap}
	suit $who $d d
	if {$d != \"\"} {incr curhandx $suitgap}
	suit $who $c c
    } else {
	set cardgap $theircardgap
	set curhandx $handx($who)
	set curhandy $handy($who)
	suit $who $s s
	incr curhandy $vgap
	set curhandx $handx($who)
	incr curhandx 10
	suit $who $h h
	incr curhandy $vgap
	set curhandx $handx($who)
	suit $who $d d
	incr curhandy $vgap
	set curhandx $handx($who)
	incr curhandx 10
	suit $who $c c
    }
}

proc fulldeal_erase_straglers {} {
    global canv
    foreach suit {s h d c} {
	foreach card {a k q j t 9 8 7 6 5 4 3 2} {
	    if !$canv(dealt,$suit$card) { erasecard  $suit $card }
	}
    }
}

 
proc fulldeal {s h d c LHOs LHOh LHOd LHOc 		   Ps Ph Pd Pc RHOs RHOh RHOd RHOc} {

    global canv

     

    foreach suit {s h d c} {
	foreach card {a k q j t 9 8 7 6 5 4 3 2} {
	    set canv(dealt,$suit$card) 0
	}
    }

    tprestore


    if {\"$Ps$Ph$Pd$Pc$LHOs$LHOh$LHOd$LHOc$RHOs$RHOh$RHOd$RHOc\" != \"\"} {
	 
	hand self $s $h $d $c
	hand pard $Ps $Ph $Pd $Pc
	hand lho $LHOs $LHOh $LHOd $LHOc
	hand rho $RHOs $RHOh $RHOd $RHOc
	fulldeal_erase_straglers
    } else {
	 
	 
	global matrix_showing
	set z $matrix_showing
	hand self $s $h $d $c
	hand pard $Ps $Ph $Pd $Pc
	hand lho $LHOs $LHOh $LHOd $LHOc
	hand rho $RHOs $RHOh $RHOd $RHOc
	fulldeal_erase_straglers
	showMatrix $z  
    }
}

 
proc sillynames {} {
    setname self S {hairy dude}
    setname lho W {skinny dude}
    setname pard N {goofball}
    setname rho E {elephant water}
}    

proc matrixtext {player s {options {}}} {
    global canv

    eval \"$canv(c) itemconfigure $canv(matrixtext,$player) -text \\{$s\\} 	    $options\"

}

proc showplay {player suit card} {
    global canv

    if {$suit == \"?\"} {
	matrixtext $player \"?\"
    } else {
	removecardfromhand $suit $card
	erasebidplay $player
	matrix_showcards 1 $player
	drawcard $suit $card $canv(mx,$player) $canv(my,$player)
	set canv(matrixcard,$player) \"$suit $card\"
    }
}

proc showbid {player level strain} {
    global canv

    matrix_showcards 0 $player
    drawbid $canv(c).f$player $level $strain
}

 
 
proc erasebidplay {who} {
    global tricktimeOK

    while {!$tricktimeOK} {
	update
	after 100
    }
    if {$who == \"all\"} {
	global needtoerase

	set needtoerase 0
	erasebidplay lho
	erasebidplay rho
	erasebidplay pard
	erasebidplay self
    } else {
	global canv
	matrixtext $who \"\"
	if [info exists canv(matrixcard,$who)] {
	    eval \"erasecard $canv(matrixcard,$who)\"
	    unset canv(matrixcard,$who)
	}
	matrix_showcards 1 $who
    }
}
# 411 \"tclcode/floater.TCL\" 2





gset showingauction 0

 
# 433 \"tclcode/floater.TCL\"

proc showauction {bool} {
    global showingauction

    set showingauction $bool
    if $bool {
	pack .auction -side top -fill both -after .play
    } else {
	pack forget .auction
    }
}


# 455 \"tclcode/floater.TCL\"


# 498 \"tclcode/floater.TCL\"





 
 
menu .menu -tearoff 0
# 1 \"tclcode/menu.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
global m

 
proc simple {label {command <none>}} {
    global m

    if {\"<none>\" == $command} {set command $label}
    $m add command -label $label -command \"command \\\"$command\\\"\"
 
}

 
 
proc addrb {var label {command <none>} {value <none>}} {
    global m

    if {\"<none>\" == $command} {set command $label}
    if {\"<none>\" == $value} {set value $label}
    $m add radiobutton -label $label -command \"command \\\"$command\\\"\" 	    -variable $var -value \"$value\"

}

 
proc cascade {label {subcommands {}}} {
    global m

    $m add cascade -label $label -menu [set m2 \"$m.cas$label\"]
    menu $m2 -tearoff no
    set oldm $m
    set m $m2
    foreach sub $subcommands {
	eval \"simple $sub\"
    }
    set m $oldm
    return $m2
}

 
proc rcascade {label var {subcommands {}}} {
    global m

    $m add cascade -label $label -menu [set m2 \"$m.cas[join $label _]\"]
    menu $m2 -tearoff no
    set oldm $m
    set m $m2
    foreach sub $subcommands {
	eval \"addrb $var $sub\"
    }
    set m $oldm
    return $m2
}


set m [menu .menu.file -tearoff no]
.menu add cascade -menu $m -label File -underline 0

if {$tcl_platform(platform) == \"macintosh\"} {
    .menu add cascade -menu .menu.apple
    menu .menu.apple -tearoff no
    .menu.apple add command -label \"About...\" -command {command about}
} else {
    .menu.file add command -label \"About...\" -command {command about}
 
    .menu.file add separator
}

 
 
simple \"Login...\" login
simple \"Change Password...\" password
if {$tk_version >= 4.2} {
    simple \"Load CC...\" ccload 
    simple \"Save CC...\" ccsave
    simple \"Execute File...\" execute
    if {$tcl_platform(platform) == \"macintosh\"} {
	set needseated_fmenu_entries {2 3}
    } else {
	set needseated_fmenu_entries {4 5}
    }
} else {
    set needseated_fmenu_entries {} 
}
$m add separator
simple Quit

 

set m [menu .menu.join -tearoff no]
.menu add cascade -menu $m -label Join -underline 0

proc no_tables_to_join {b} {
    if $b {
	global join_menu_length join_menu
	.menu.join delete 0 end
	.menu.join add command -label \"(none)\" -state disabled
	.menu.join add separator
	.menu.join add command -label \"Check for tables\" 		-command \"command tables\"

	set join_menu_length 0
	foreach i [array names join_menu] { unset join_menu($i) }
    } else {
	catch {.menu.join delete \"(none)\"}
    }
}

no_tables_to_join 1

proc join_menu_add_table {name fullname} {
    global join_menu_length join_menu

    if [info exists join_menu($name)] {
	if {$fullname != $join_menu($name)} {
	    .menu.join entryconfigure $join_menu($name) -label $fullname
	    set join_menu($name) $fullname
	}
	return
    }
    if {[incr join_menu_length] == 1} {no_tables_to_join 0}
    set join_menu($name) $fullname
    .menu.join insert 0 command -label $fullname -command \"command \\\"join $name\\\"\"
}

proc join_menu_remove_table {name} {
    global join_menu_length join_menu

    if ![info exists join_menu($name)] return
    .menu.join delete $join_menu($name)
    if {[incr join_menu_length -1] == 0} {
	no_tables_to_join 1
    } else {
	unset join_menu($name)
    }
}    

 

set m [menu .menu.table -tearoff no]
.menu add cascade -menu $m -label Table -underline 0

simple Host
$m add separator
cascade Sit {North South East West}
simple Kibitz
simple Spec
$m add separator
cascade Communications {Disconnect {\"Show Parent\" parent} 	{\"Show Children\" children} {\"Show Net Location\" ip}}

simple \"Show who's here\" who
simple \"Beep everyone\" beep
set needtable_tmenu_entries {2 3 4 6 7 8}

 

set m [menu .menu.bridge -tearoff no]
.menu add cascade -menu $m -label Bridge -underline 0

set claimmenu [cascade Claim]
foreach i {13 12 11 10 9 8 7 6 5 4 3 2 1 0} {
    $claimmenu add command -label \"$i tricks\" -command \"GUIclaim $i\"
}
simple \"Accept claim\" accept
simple \"Reject claim\" reject
simple \"Retract claim\" retract
simple Review
simple \"Show initial cards\" cards
simple \"Show last trick\" last
simple \"Show EW CC\" {ccdump EW}
simple \"Show NS CC\" {ccdump NS}
$m add separator
set scoringmenu [cascade Scoring]
$scoringmenu add radiobutton -label IMP -command \"command \\\"score IMP\\\"\" 	-variable radioscoring

$scoringmenu add radiobutton -label MP -command \"command \\\"score MP\\\"\" 	-variable radioscoring

$scoringmenu add radiobutton -label Rubber 	-command \"command \\\"score Rubber\\\"\" 	-variable radioscoring -value RUBBER


$scoringmenu add radiobutton -label Hearts 	-command \"command \\\"score Hearts\\\"\" 	-variable radioscoring -value HEARTS


$scoringmenu add separator
$scoringmenu add radiobutton -label Competitive 	-command \"command competitive\" -variable radiocompetitive

$scoringmenu add radiobutton -label Noncompetitive 	-command \"command noncompetitive\" -variable radiocompetitive

.menu.bridge entryconfigure 10 -state disabled  
proc menus_tablehost {b {scoring {}} {competitive {}}} {
    global radiocompetitive radioscoring scoringmenu

    set radioscoring $scoring
    set radiocompetitive $competitive
    if $b {set setting normal} {set setting disabled}
    .menu.bridge entryconfigure 10 -state $setting
    .menu.bridge entryconfigure 11 -state $setting
}    
simple \"Deal next hand\" deal
.menu.bridge entryconfigure 11 -state disabled  
simple \"Show previous deal\" previous
set needbridge_bmenu_entries {0 1 2 3 4 5 6}
set needtable_bmenu_entries {7 8}  
.menu.bridge entryconfigure 12 -state disabled  
proc menus_enable_previous {} { .menu.bridge entryconfigure 12 -state normal }

 

set m [menu .menu.options -tearoff no]
.menu add cascade -menu $m -label Options -underline 0

$m add checkbutton -label \"Separate talk window\" -command {command \"separateTalk $separateTalk_\"} -variable separateTalk_
$m add checkbutton -label \"Hide matrix during auction\" -command {command \"hideMatrix $hideMatrix_\"} -variable hideMatrix_
$m add checkbutton -label \"Hide Command Line\" -command {command \"hideCommandLine $hideCommandLine_\"} -variable hideCommandLine_
$m add checkbutton -label \"Buttons for bidding\" -command {command \"bidButtons $bidButtons_\"} -variable bidButtons_
$m add checkbutton -label \"Beep at my turn\" -command {command \"beepAtMyTurn $beepAtMyTurn_\"} -variable beepAtMyTurn_
$m add checkbutton -label \"Deiconify if I'm beeped\" -command {command \"deiconifyIfBeeped $deiconifyIfBeeped_\"} -variable deiconifyIfBeeped_
rcascade \"Hide Auction\" auction_hide_time 			{{\"after first trick\" \"hideAuction -1\" -1}

			 {\"end of auction + 5 seconds\" \"hideAuction 5\" 5}
			 {\"end of auction + 10 seconds\" \"hideAuction 10\" 10}}

$m add separator
$m add command -label \"Bridge Font\" -state disabled
tryset radiofont Medium
$m add radiobutton -label \"Large\" -command \"command \\\"font large\\\"\" -variable radiofont
$m add radiobutton -label \"Medium\" -command \"command \\\"font medium\\\"\" -variable radiofont
$m add radiobutton -label \"Small\" -command \"command \\\"font small\\\"\" -variable radiofont

$m add separator
tryset radiotalkfont Medium
 
$m add command -label \"Talk Font\" -state disabled
$m add radiobutton -label \"Extra Large\" -command \"command \\\"talkfont extralarge\\\"\" -variable radiotalkfont
$m add radiobutton -label \"Large\" -command \"command \\\"talkfont large\\\"\" -variable radiotalkfont
$m add radiobutton -label \"Medium\" -command \"command \\\"talkfont medium\\\"\" -variable radiotalkfont
$m add radiobutton -label \"Small\" -command \"command \\\"talkfont small\\\"\" -variable radiotalkfont
$m add radiobutton -label \"Fixed18\" -command \"command \\\"talkfont fixed18\\\"\" -variable radiotalkfont
$m add radiobutton -label \"Fixed14\" -command \"command \\\"talkfont fixed14\\\"\" -variable radiotalkfont
$m add radiobutton -label \"Fixed12\" -command \"command \\\"talkfont fixed12\\\"\" -variable radiotalkfont

 

set m [menu .menu.help -tearoff no]
.menu add cascade -menu $m -label Help -underline 0

simple \"Introduction\" help
 

proc prevchar {c} {
    scan $c %c i
    format %c [incr i -1]
}

proc menus_helpcommands {commands} {
    global m help_texts

    set m .menu.help
    set endchars \\[fq\\]
    set begin a
    foreach s $commands {
	if {![string match \"*(*\" $s] && ![string match \"*)*\" $s]} {
	    if {[regexp $endchars [set first [string range $s 0 0]]] &&
	    ![info exists doneit($first)]} {
		set doneit($first) 1
		cascade \"$begin-[prevchar $first]\" $w
		set begin $first
		set w {}
	    }
	    lappend w \"$s \\\"help $s\\\"\"
	}
    }
    if {$w != {}} {cascade $begin-z $w}

    $m add separator
    foreach text $help_texts {
	simple $text
    }
}

 
 

proc menus_noclaim {} {
    foreach i {1 2 3} {
	.menu.bridge entryconfigure $i -state disabled
    }
}

proc menus_defclaim {} {
    foreach i {1 2} {
	.menu.bridge entryconfigure $i -state normal
    }
}

proc menus_declclaim {} {
    .menu.bridge entryconfigure 3 -state normal
}

 

 
proc claimable {n setting} {
    global claimmenu

    set n [expr 13 - $n]
    if $setting {set setting normal} {set setting disabled}
    $claimmenu entryconfigure $n -state $setting
}

 
proc GUIclaim {n} {
    global contract_tricks

 
    if ![info exists contract_tricks] return
    if {$n >= $contract_tricks} {
	command \"make [expr $n - 6]\"
    } else {
	command \"down [expr $contract_tricks - $n]\"
    }
}

proc update_claimmenu {decltricks deftricks} {
 
    set max [expr 13 - $deftricks]
    for {set i 0} {$i <= 13} {incr i} {
	if {$i < $decltricks || $i > $max} {
	    claimable $i 0
	} else {
	    claimable $i 1
	}
    }
}    

 
proc menus_declaring {b} {
    if $b {set setting normal} {set setting disabled}
    .menu.bridge entryconfigure 0 -state $setting
}

 

set bridge_menus_state 1  

proc activate_bridge_menus {b} {
    global bridge_menus_state needbridge_bmenu_entries

    if {$b == $bridge_menus_state} return
    
    if [set bridge_menus_state $b] {set setting normal} {set setting disabled}
    foreach n $needbridge_bmenu_entries {
	.menu.bridge entryconfigure $n -state $setting
    }
 
}

proc menus_newhand {} {
    activate_bridge_menus 1
    menus_noclaim
    menus_declaring 0
}

proc menus_nobridge {} {activate_bridge_menus 0; menus_noclaim}

menus_nobridge


set seated_menus_state 1

proc activate_seated_menus {b} {
    global seated_menus_state needseated_fmenu_entries

    if {$b == $seated_menus_state} return
    
    if [set seated_menus_state $b] {set setting normal} {set setting disabled}
    foreach n $needseated_fmenu_entries {
	 
	.menu.file entryconfigure $n -state $setting
    }
    if !$b {menus_noclaim; menus_declaring 0}
}

activate_seated_menus 0


set table_menus_state 1

proc activate_table_menus {b} {
    global table_menus_state needtable_bmenu_entries needtable_tmenu_entries

    if {$b == $table_menus_state} return
    if !$b {activate_seated_menus 0; menus_tablehost 0}
    
    if [set table_menus_state $b] {set setting normal} {set setting disabled}
    foreach n $needtable_bmenu_entries {
	.menu.bridge entryconfigure $n -state $setting
    }
    foreach n $needtable_tmenu_entries {
	.menu.table entryconfigure $n -state $setting
    }
}

activate_table_menus 0
# 506 \"tclcode/floater.TCL\" 2

. configure -menu .menu

 
label .stat

 
label .infoline

 
if $newstyle_matrix {
    canvsetup .play
} else {
    frame .play

    frame .play.middle
    frame .play.middle.top
    frame .play.middle.top.pard
    pack .play.middle.top.pard
    frame .play.middle.box -relief raised -borderwidth 4
    frame .play.middle.bottom
    frame .play.middle.bottom.self
    pack .play.middle.bottom.self
    frame .play.left
    frame .play.right
    frame .play.left.lho
    frame .play.right.rho
    gset mframe(self) .play.middle.bottom.self
    gset mframe(pard) .play.middle.top.pard
    gset mframe(lho) .play.left.lho
    gset mframe(rho) .play.right.rho
    pack .play.left .play.middle .play.right -side left -fill x -expand yes
    pack .play.left.lho -side right -anchor e
    pack .play.right.rho -side left -anchor w
    pack .play.middle.top .play.middle.box .play.middle.bottom -fill x

     
    frame .play.middle.box.lho
    frame .play.middle.box.rho
    frame .play.middle.box.pard
    frame .play.middle.box.self
    pack .play.middle.box.lho -side left -anchor w
    pack .play.middle.box.rho -side right -anchor e
    pack .play.middle.box.pard -side top -anchor n
    pack .play.middle.box.self -side bottom -anchor s

     
    frame .play.middle.box.f
    frame .play.middle.box.f.s
    frame .play.middle.box.f.h
    frame .play.middle.box.f.d
    frame .play.middle.box.f.c
    refont [eval \"button .play.middle.box.f.s.bogus $buttoncardoptions -state disabled\"] cardfont
    refont [eval \"button .play.middle.box.f.h.bogus $buttoncardoptions -state disabled\"] cardfont
    refont [eval \"button .play.middle.box.f.d.bogus $buttoncardoptions -state disabled\"] cardfont
    refont [eval \"button .play.middle.box.f.c.bogus $buttoncardoptions -state disabled\"] cardfont
    pack .play.middle.box.f.s.bogus
    pack .play.middle.box.f.h.bogus
    pack .play.middle.box.f.d.bogus
    pack .play.middle.box.f.c.bogus
    eval \"pack .play.middle.box.f.s .play.middle.box.f.h .play.middle.box.f.d 	    .play.middle.box.f.c -side top -anchor w $framesuitoptions\"

    pack .play.middle.box.f -side left -anchor w
}









 
set x [expr ![catch {regexp -nocase \"Apr 1 \" [exec date]} y]]
if !$x {set y 0}
if [expr $x && $y] {
 fulldeal AKQJ AKQJ AKQJ AK T98 T98 T98 QJT9 765 765 765 876 432 432 432 5432
 showbid self 8 n
} else {
 fulldeal AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2
 showbid self 7 n
}


 
proc focus_cmdline {} {
    global hideCommandLine_
    catch {
	focus .cmd
	if $hideCommandLine_ {
	    focus .cmd.talk
	} else {
	    focus .cmd.cmdline
	}
    }
}

 
 
frame .talk -relief ridge -borderwidth 3
scrollbar .talk.scroll -command \".talk.text yview\"
gset talktext [text .talk.text -wrap word -relief raised -yscrollcommand \".talk.scroll set\" -width 300 -height 100 -font $talkfont]
refont .talk.text talkfont
pack .talk.scroll -side right -fill y
pack .talk.text -side left
bind .talk.text <Configure> {.talk.text yview -pickplace end}
bind .talk.text <FocusIn> focus_cmdline

 
 
frame .debug -relief ridge -borderwidth 3
gset debugtext [text .debug.text -relief raised -yscrollcommand \".debug.scroll set\" -width 300 -height 10]
scrollbar .debug.scroll -command \".debug.text yview\"
pack .debug.scroll -side right -fill y
pack .debug.text -side left


 
frame .cmd
frame .cmd.f
refont [label .cmd.f.labelt -font $cmdlinelabelfont -text \"Talk:\"] cmdlinelabelfont
refont [label .cmd.f.labelc -font $cmdlinelabelfont -text \"Command:\"] cmdlinelabelfont
pack .cmd.f.labelc .cmd.f.labelt -side top -anchor e
refont [entry .cmd.cmdline -font $cmdlinefont -relief sunken -bd 2 -textvariable cmd] cmdlinefont
refont [entry .cmd.talk -font $cmdlinefont -relief sunken -bd 2 -textvariable talk] cmdlinefont
pack .cmd.f -side left
pack .cmd.cmdline .cmd.talk -fill x -side top -expand yes

 
frame .auction
frame .auction.bb
frame .auction.bb.0
frame .auction.bb.1
frame .auction.bb.2


 
proc auctionbbcommand {what} {
    global alert redalert

    command $what
    if $alert {command alert}
    if $redalert {command redalert}
    set alert 0
    set redalert 0
}

 

proc auctionbb {w {what same}} {
    global auctionbbfont
    if {$what == \"same\"} {set what $w}
    refont [button .auction.bb.1.$w -text $what 	    -command \"auctionbbcommand $what\" 	    -font $auctionbbfont -relief flat -padx 1] auctionbbfont


}

proc auctionbb2 {w {what same}} {
    global auctionbbfont
    if {$what == \"same\"} {set what $w}
    refont [button .auction.bb.2.$w -text $what 	    -command \"auctionbbcommand $what\" 	    -font $auctionbbfont -relief flat -padx 1] auctionbbfont


}

proc auctionbb0 {w {what same}} {
    global auctionbbfont
    if {$what == \"same\"} {set what $w}
    refont [button .auction.bb.0.$w -text $what 	    -command \"auctionbbcommand $what\" 	    -font $auctionbbfont -relief flat] auctionbbfont


}

auctionbb0 pass Pass
auctionbb 1C  
auctionbb 1D  
auctionbb 1H  
auctionbb 1S  
auctionbb 1N  
auctionbb 2C  
auctionbb 2D  
auctionbb 2H  
auctionbb 2S  
auctionbb 2N  
auctionbb 3C  
auctionbb 3D  
auctionbb 3H  
auctionbb 3S  
auctionbb 3N  
auctionbb 4C  
auctionbb 4D  
auctionbb 4H  
auctionbb 4S  
auctionbb 4N  
auctionbb2 5C  
auctionbb2 5D  
auctionbb2 5H  
auctionbb2 5S  
auctionbb2 5N  
auctionbb2 6C  
auctionbb2 6D  
auctionbb2 6H  
auctionbb2 6S  
auctionbb2 6N  
auctionbb2 7C  
auctionbb2 7D  
auctionbb2 7H  
auctionbb2 7S  
auctionbb2 7N  
auctionbb0 x   Double
auctionbb0 xx  Redouble

refont [checkbutton .auction.bb.0.alert -text \"Alert\" -variable alert 	-command {set redalert 0} -font $auctionbbfont 	-relief flat] auctionbbfont


refont [checkbutton .auction.bb.0.redalert -text \"Red Alert\" 	-variable redalert -command {set alert 0} 	-font $auctionbbfont -relief flat] auctionbbfont



pack .auction.bb.0.alert .auction.bb.0.pass .auction.bb.0.x .auction.bb.0.xx .auction.bb.0.redalert -side left
pack .auction.bb.1.1C .auction.bb.1.1D .auction.bb.1.1H .auction.bb.1.1S .auction.bb.1.1N .auction.bb.1.2C .auction.bb.1.2D .auction.bb.1.2H .auction.bb.1.2S .auction.bb.1.2N .auction.bb.1.3C .auction.bb.1.3D .auction.bb.1.3H .auction.bb.1.3S .auction.bb.1.3N .auction.bb.1.4C .auction.bb.1.4D .auction.bb.1.4H .auction.bb.1.4S .auction.bb.1.4N -side left
pack .auction.bb.2.5C .auction.bb.2.5D .auction.bb.2.5H .auction.bb.2.5S .auction.bb.2.5N .auction.bb.2.6C .auction.bb.2.6D .auction.bb.2.6H .auction.bb.2.6S .auction.bb.2.6N .auction.bb.2.7C .auction.bb.2.7D .auction.bb.2.7H .auction.bb.2.7S .auction.bb.2.7N -side left
pack .auction.bb.0 .auction.bb.1 .auction.bb.2 -side top

refont [label .auction.l -font $auctionlabelfont -text $auctionlabel] auctionlabelfont
frame .auction.r
frame .auction.r.0
frame .auction.r.1
frame .auction.r.2
frame .auction.r.3
refont [label .auction.r.0.name -font $namefont -textvariable playername(lho) -width $auctionnamewidth -padx 1] namefont
refont [label .auction.r.1.name -font $namefont -textvariable playername(pard) -width $auctionnamewidth -padx 1] namefont
refont [label .auction.r.2.name -font $namefont -textvariable playername(rho) -width $auctionnamewidth -padx 1] namefont
refont [label .auction.r.3.name -font $namefont -textvariable playername(self) -width $auctionnamewidth -padx 1] namefont

pack .auction.r.0 .auction.r.1 .auction.r.2 .auction.r.3 -side left -anchor n
pack .auction.l .auction.r -side left -anchor n

pack .auction.r.0.name
pack .auction.r.1.name
pack .auction.r.2.name
pack .auction.r.3.name

 
 
pack .stat -side top -fill x
pack .infoline -side top -fill x
pack .play -side top -expand no -fill both
 



pack .cmd -side bottom -fill x
pack .talk -side top -fill both -expand yes

prop_on

 


 
 
 

proc typedcommand {cmd} {
    if {$cmd == \"\"} {command {inullcommand c}} {command $cmd}
}

proc typedtalk {talk} {
    if {$talk == \"\"} {command {inullcommand t}} {talk $talk}
}

proc bindsetup {w tabto returnscript} {
 
    bind $w <Any-Enter> \"focus %W\"
    if {$tabto == \".cmd.cmdline\"} {
	bind $w <KeyPress-Tab> \"focus_cmdline; break\"
	bind $w <Control-KeyPress-i> \"focus_cmdline; break\"
    } else {
	bind $w <KeyPress-Tab> \"focus $tabto; break\"
	bind $w <Control-KeyPress-i> \"focus $tabto; break\"
    }
    bind $w <KeyPress-Return> $returnscript
    return $w
}

bindsetup .cmd.cmdline .cmd.talk 	{global cmd; if {$cmd == \"\"} {typedcommand $cmd} else {typedcommand $cmd; .cmd.cmdline delete 0 end}}


bindsetup .cmd.talk .cmd.cmdline 	{global talk; if {$talk == \"\"} {typedtalk $talk} else {typedtalk $talk; .cmd.talk delete 0 end}}


focus_cmdline




 
 
 
 

gset previous_trick_index 0
gset previous_trick {}

proc reset_previous_trick {{index -999}} {
    global previous_trick previous_trick_index

    if {$index == -999 || $index == $previous_trick_index} {
	set previous_trick {}
    }
}

proc set_previous_trick {s {erase 1}} {
    global previous_trick previous_trick_index

    set previous_trick $s
    incr previous_trick_index

     
    if $erase {after 10000 \"reset_previous_trick $previous_trick_index\"}
}

 

# 861 \"tclcode/floater.TCL\"


 
proc newauction {} {



    for {set i 0} {$i < 4} {incr i} {
	foreach child [winfo children .auction.r.$i] {
	    if ![regexp name $child] {catch {destroy $child}}
	}
    }

}

# 963 \"tclcode/floater.TCL\"


# 1040 \"tclcode/floater.TCL\"



proc turn_off_scrolllock {} {}


proc debugmsg {s} {
    global debugprinting floater_silent

    set old $debugprinting
    set debugprinting 1
    talkmsg $s
    set debugprinting $old
    if $floater_silent {puts $s}
}

 
 
 

proc setcursor {cursor w} {


    if {$w == \".menu\" || $w == \".#menu\"} return 
    global oldcursor

    set oldcursor($w) [lindex [$w configure -cursor] 4]
    $w configure -cursor $cursor
    foreach child [winfo children $w] {setcursor $cursor $child}

}

proc unsetcursor {w} {


    global oldcursor

    if [info exists oldcursor($w)] {
	catch {
	    $w configure -cursor $oldcursor($w)
	    foreach child [winfo children $w] {unsetcursor $child}
	}
    }

}

proc patientcursor {} {
    global cursorlevel
    
    if {[incr cursorlevel] == 1} {setcursor watch .}
}

proc normalcursor {} {
    global cursorlevel
    
    if {[incr cursorlevel -1] == 0} {unsetcursor .}
}
set cursorlevel 0
	

 
proc configall {w c} {
    eval \"$w configure $c\"
    foreach child [winfo children $w] {configall $child $c}
}


 
 
 

 
 

 



tryset tabletimeout 600


 
tryset tablereannounce 90


 
 

set receiveiamalivelist {}
set sendiamalivelist {}

 
tryset sendiamaliveinterval 40000

 
tryset receiveiamaliveinterval 20000

 



tryset iamalivetimeout 450


proc shouldreceiveiamalive {conn} {
    global receiveiamalivelist

    set receiveiamalivelist [linsert $receiveiamalivelist 0 $conn]
}

proc shouldnotreceiveiamalive {conn} {
    global receiveiamalivelist

    catch {
	set i [lsearch $receiveiamalivelist $conn]
	set receiveiamalivelist [lreplace $receiveiamalivelist $i $i]
    }
}

proc shouldsendiamalive {conn} {
    global sendiamalivelist

    set sendiamalivelist [linsert $sendiamalivelist 0 $conn]
}

proc shouldnotsendiamalive {conn} {
    global sendiamalivelist

    catch {
	set i [lsearch $sendiamalivelist $conn]
	set sendiamalivelist [lreplace $sendiamalivelist $i $i]
    }
}

proc sendiamalives {} {
    global sendiamalivelist sendiamaliveinterval

    after $sendiamaliveinterval sendiamalives
    foreach conn $sendiamalivelist {
	debugmsg \"Sending iamalive to $conn\"
	catch {FloaterSend $conn *alive*}
    }
}

proc checkreceiveiamalive {conn} {
    global iamalivetimeout timeofmostrecent floaterclock

 
    catch {
	debugmsg \"seconds since most recent msg on $conn: [expr ($floaterclock - $timeofmostrecent($conn))]\"
	if [expr ($floaterclock - $timeofmostrecent($conn)) > $iamalivetimeout] 		{floatertimeout $conn}

    }
}

proc checkreceiveiamalives {} {
    global receiveiamalivelist receiveiamaliveinterval

    after $receiveiamaliveinterval checkreceiveiamalives
    foreach conn $receiveiamalivelist { checkreceiveiamalive $conn }
}

sendiamalives
checkreceiveiamalives

 
 
 
 
 

gset MyTurnTimer -99
tryset MyTurnTimerCountdown 20
proc startMyTurnTimer {} {
    global MyTurnTimerCountdown MyTurnTimer
    set MyTurnTimer $MyTurnTimerCountdown
}    

proc MyTurnTimerRing {} {
    global showingauction
    if $showingauction {
	showauction 0
	showauction 1
	startMyTurnTimer
    }
}

proc stopMyTurnTimer {} {
    global MyTurnTimer
    set MyTurnTimer -99
}

 

proc floaterclockbump {} {
    global floaterclock MyTurnTimer

    incr floaterclock
    if {$MyTurnTimer > 0} {if {[incr MyTurnTimer -1] == 0} MyTurnTimerRing}
    after 1000 floaterclockbump
     
     
    if {[expr $floaterclock % 3] == 0} {command {}}
}

after 1000 floaterclockbump


proc countdown {x} {
    global $x

    if {[set $x] > 0} then \"after 1000 \\\"countdown $x\\\"\" else return
    incr $x -1
}

proc reset_rejoinnow {} {
    global rejoinclock rejoinclockincrement

    set rejoinclock 0
    set rejoinclockincrement 1
}

proc rejoinnow {} {
    global rejoinclock rejoinclockincrement

    if {$rejoinclock <= 0} then {
	if {$rejoinclockincrement < 1800} 		{set rejoinclockincrement [expr 2 * $rejoinclockincrement]}

	set rejoinclock $rejoinclockincrement
	countdown rejoinclock
	return 1
    } else {return 0}
}

proc reset_find_rho {} {
    global rhoclock rhoclockincrement

    set rhoclock 0
    set rhoclockincrement 1
}

proc findrhonow {} {
    global rhoclock rhoclockincrement

    if {$rhoclock <= 0} then {
	if {$rhoclockincrement < 1800} 		{set rhoclockincrement [expr 2 * $rhoclockincrement]}

	set rhoclock $rhoclockincrement
	countdown rhoclock
	return 1
    } else {return 0}
}

reset_find_rho
reset_rejoinnow

 
gset autodealing 0

proc autonewdeal {} {
    global autonewdeal_seconds autodealing

    if $autodealing return
    if {$autonewdeal_seconds >= 0} {
	set autodealing 1
	after [expr 1000 * $autonewdeal_seconds] {
	    global autodealing
	    
	    if $autodealing {
		set autodealing 0
		if {$autonewdeal_seconds >= 0} {command autodeal_now}
	    } else {





	    }
	}
    }
}

proc updateloc {} {
    global updateloc_seconds

    after [expr 1000 * $updateloc_seconds] updateloc
    catch {command iupdatelocation}
}

tryset updateloc_seconds 300
updateloc

 
 
 

 
 
gset should_defer 0

proc command args {
    global should_defer

    if $should_defer {deferpush \"commandn $args\"} else {eval \"commandn $args\"}
}










proc floaterreceive {msg conn} {
    global should_defer timeofmostrecent floaterclock

    set timeofmostrecent($conn) $floaterclock
     
    if {$msg == \"*alive*\"} return

    if $should_defer {
	deferpush \"floaterreceiven {$msg} {$conn}\"
    } else {
	floaterreceiven $msg $conn
    }
}

proc talk args {
    global should_defer

    if $should_defer {deferpush \"talkn $args\"} else {eval \"talkn $args\"}
}

proc FloaterClose args {
    global should_defer

    if $should_defer {deferpush \"FloaterClosen $args\"} 	    else {eval \"FloaterClosen $args\"}

}










proc floatertimeout args {
    global should_defer

    if $should_defer {deferpush \"floatertimeoutn $args\"} 	    else {eval \"floatertimeoutn $args\"}

}

 
 
 

 
 
proc defer {n} {
    global should_defer

    if {[incr should_defer $n] == 0} {
	while {![deferempty]} {eval [deferpop]}
    }
}

gset deferqueuelo 0
gset deferqueuehi 0

proc deferempty {} {
    global deferqueuehi deferqueuelo

    return [expr $deferqueuelo == $deferqueuehi]
}

proc deferpush {s} {
    global deferqueue deferqueuehi
    
    set deferqueue($deferqueuehi) $s
    incr deferqueuehi



}

proc deferpop {} {
    global deferqueue deferqueuelo
    
    set temp $deferqueue($deferqueuelo)
    unset deferqueue($deferqueuelo)
    incr deferqueuelo



    return $temp
}

 
 
 

set executing_index 0

proc Floater_execute {file} {
    global executing_index executing_command
    if {[set n [gets $file s]] >= 0} {
	if {$n > 0} {
	    deferpush \"show_executing [incr executing_index]; Floater_execute $file\"
	    set executing_command($executing_index) $s
	    return
	}
    }
    catch {close $file}
}    

proc show_executing {n} {
    global executing_command

    talkmsg \"Execute: $executing_command($n)\"
    commandn $executing_command($n)
    unset executing_command($n)
}
 
 
 

proc untabify {s} {
    if [regexp {([^	]*)	(.*)} $s whole left right] {
	set i [string length $left]
	while 1 {
	    set right \" $right\"
	    incr i
	    if [expr $i % 8 == 0] {return [untabify $left$right]}
	}
    } else {return $s}
}

proc truncate {s {n 80}} {
    if {[string length $s] > $n} {
	return [string range $s 0 [expr $n - 1]]
    } else {
	return $s
    }
}

proc unbraceclean {s} {
    regsub -all {\\\\(\\[|\\]|\\{|\\})} $s {\\1} x
    return $x
}

proc beginnewcc {direction} {
    global newcc newccline newccignoring

    set newccline 0
    set newccignoring 0
    set newcc $direction
}

proc addnewcc {s {bracecleaned 1}} {
    global newcc newccline cc newccignoring

    set s [untabify [truncate $s]]
    if $bracecleaned {set s [unbraceclean $s]}
    if {$newccline == 40} {set newccignoring 1; return}
    set cc($newcc,[incr newccline]) $s
}

proc endnewcc {} {
    global newcc newccline newccignoring cclines

    set cclines($newcc) $newccline
     
    if $newccignoring {
	return \"Warning: Ignored lines beyond the first 40\"
    } else {
	return \"\"
    }
}

 
 
proc ccstr {direction} {
    global cc cclines

    set s \"\"
    catch {
	if {$cclines($direction) < 1} {return \"\"}
	set s $cc($direction,1)
	for {set i 2} {$i <= $cclines($direction)} {incr i} {
	    set s \"$s\\t$cc($direction,$i)\"
	}
    }
    return $s
}

gset lastrange \"\"  
proc inrange {n range} {
    global lastrange lastrangelow lastrangehigh  

    if {$range != $lastrange} {
	set lastrange $range
	if [regexp {^([0-9]+)-([0-9]+)$} $range x lastrangelow lastrangehigh] {
	     
	} elseif [regexp {^([0-9]+)$} $range lastrangelow] {
	    set lastrangehigh $lastrangelow
	} elseif [regexp {^([0-9]+)-$} $range x lastrangelow] {
	    set lastrangehigh 1000000
	} elseif [regexp {^-([0-9]+)$} $range x lastrangehigh] {
	    set lastrangelow -1000000
	} else {error \"Invalid range: $range\"}
    }
    expr ($n >= $lastrangelow) && ($n <= $lastrangehigh)
}

proc ccdump {direction {range 1-}} {
    global cc cclines

    for {set i 1} {$i <= $cclines($direction)} {incr i} {
	if [inrange $i $range] {
	    talkmsg $cc($direction,$i)
	}
    }
}

proc ccsave {file direction} {
    global cc cclines

    for {set i 1} {$i <= $cclines($direction)} {incr i} {
	puts $file $cc($direction,$i)
    }
    close $file
}

proc getccline {direction line} {
    global cc cclines

    if ![info exists cclines($direction)] {return \"\"}
    if {$line <= $cclines($direction)} {
	return $cc($direction,$line)
    } else {
	return \"\"
    }
}

 
 
 

 
 
proc reverse_init {} {
    global reverse_n

    set reverse_n 0
}

proc reverse_print {s} {
    global reverse_n reverse_lines

    set reverse_lines($reverse_n) $s
    incr reverse_n
}

proc reverse_done {} {
    global reverse_n reverse_lines

    while {[incr reverse_n -1] >= 0} {
	talkmsg $reverse_lines($reverse_n)
	unset reverse_lines($reverse_n)
    }
}

 
proc Floater_login {} {
    global loginname loginpassword newbie

    toplevel .login

    frame .login.left
    frame .login.right
    frame .login.bottom

    button .login.bottom.cancel -text \"Cancel\" 	-command {set loginname \"\"; set loginpassword \"\"; destroy .login}

    button .login.bottom.clear -text \"Clear\" 	-command {set loginname \"\"; set loginpassword \"\"; focus .login.right.n}

    button .login.bottom.ok -text \"OK\" 	-command {destroy .login}


    proc newbietr {name el op} {
	global pw_or_email newbie

	if $newbie {set pw_or_email \"Email address: \"} 		{set pw_or_email \"Password: \"}

    }

    checkbutton .login.new -text \"New User\" -variable newbie
    trace variable newbie w newbietr
    if [info exists newbie] {set newbie $newbie} {set newbie 0}

    label .login.left.n -text \"Name: \"
    label .login.left.p -textvariable pw_or_email -width 13

    entry .login.right.n -bd 2 -relief sunken -textvariable loginname
    entry .login.right.p -bd 2 -relief sunken -textvariable loginpassword

    pack .login.bottom.cancel .login.bottom.clear .login.bottom.ok 	-side left -expand yes -fill x -padx 3m -pady 2m

    pack .login.left.n .login.left.p
    pack .login.right.n .login.right.p
    pack .login.bottom -side bottom
    pack .login.new -side bottom -pady 2m
    pack .login.left -side left -fill x -expand yes
    pack .login.right .login.right -side right -fill x -expand yes
    wm title .login \"Floater login\"

    bindsetup .login.right.n .login.right.p {focus .login.right.p}
    bindsetup .login.right.p .login.right.n {destroy .login}
    bind .login.right.n \\\\ {set loginname \"\"}

    grab set .login
    tkwait window .login
    trace vdelete newbie w newbietr
    set loginname [string trim $loginname]
    catch focus_cmdline
    if $newbie {return \"N$loginname\\\\$loginpassword\"} 	    {return \"O$loginname\\\\$loginpassword\"}

}

proc Floater_changepw {} {
    global changepwname oldpassword newpassword

    toplevel .changepw

    frame .changepw.left
    frame .changepw.right
    frame .changepw.bottom


    button .changepw.bottom.cancel -text \"Cancel\" 	-command {set changepwname \"\"; set oldpassword \"\"; 	set newpassword \"\"; destroy .changepw}


    button .changepw.bottom.clear -text \"Clear\" 	-command {set changepwname \"\"; set oldpassword \"\"; 	set newpassword \"\"; focus .changepw.right.n}


    button .changepw.bottom.ok -text \"OK\" 	-command {destroy .changepw}


    label .changepw.left.n -text \"Name: \"
    label .changepw.left.o -text \"Old password: \"
    label .changepw.left.p -text \"New password: \"

    entry .changepw.right.n -bd 2 -relief sunken -textvariable changepwname
    entry .changepw.right.o -bd 2 -relief sunken -textvariable oldpassword
    entry .changepw.right.p -bd 2 -relief sunken -textvariable newpassword

    pack .changepw.bottom.cancel .changepw.bottom.clear .changepw.bottom.ok 	-side left -expand yes -fill x -padx 3m -pady 2m

    pack .changepw.left.n .changepw.left.o .changepw.left.p
    pack .changepw.right.n .changepw.right.o .changepw.right.p
    pack .changepw.bottom -side bottom
    pack .changepw.left -side left -fill x -expand yes
    pack .changepw.right .changepw.right -side right -fill x -expand yes
    wm title .changepw \"change password\"

    bindsetup .changepw.right.n .changepw.right.o {focus .changepw.right.o}
    bindsetup .changepw.right.o .changepw.right.p {focus .changepw.right.p}
    bindsetup .changepw.right.p .changepw.right.n {destroy .changepw}
    bind .changepw.right.n \\\\ {set changepwname \"\"}

    grab set .changepw
    tkwait window .changepw
    catch {focus .cmd; focus .cmd.talk}
    return \"$changepwname\\\\$oldpassword\\\\$newpassword\"
}
",
"# 1 \"tclcode/floatert.TCL\"
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

# 1 \"tclcode/floater.TCL\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 


if {[info tclversion] < 8.0} {
    puts stderr \"You have compiled Floater with Tcl [info tclversion]\"
    puts stderr \"You must recompile with Tcl 8.0 or higher\"
    exit 1
}








# 1 \"tclcode/gset.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
 
proc tryset {a b} {
    if {[set x [string first \"(\" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    if [catch {set $a}] {set $a $b}
}

 
proc gset {a {b salami_on_rye}} {
    if {[set x [string first \"(\" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    if ![string compare $b salami_on_rye] {set $a} {set $a $b}
}

 
proc gunset {a} {
    if {[set x [string first \"(\" $a]] == -1} {
	global $a
    } else {
	global [string range $a 0 [incr x -1]]
    }

    unset $a
}

# 36 \"tclcode/floater.TCL\" 2

gset floater_version \"Floater 1.2b1\"
# 1 \"tclcode/errorhandle.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
proc bgerror {m} {catch {debugmsg $m}}
# 38 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/files.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 
 
proc lseenhand {root number scoring} {
    global seenhands maxseenhand 	    Nseen$scoring Sseen$scoring Eseen$scoring Wseen$scoring


 


    set seen seen
    foreach d {N S E W} {
	if [info exists $d$seen$scoring] {
	    eval \"set old $$d$seen$scoring\"
	    set $d$seen$scoring $old$number-
 
	}
    }
    set seenhands($root,$number) 1
    if [info exists maxseenhand($root)] 	    {if {$maxseenhand($root) > $number} return}

    set maxseenhand($root) $number
}

 
proc seen {root {silent 0}} {
    global seenhands maxseenhand youveseen

    if ![info exists maxseenhand($root)] {
	if {$youveseen && !$silent} 		{talkmsg \"You haven't seen any hands from $root\"}

	return \"\"
    }
    set m $maxseenhand($root)
    set s \"\"
    set t \"\"
    for {set i 1} {$i <= $m} {incr i} {
	if [info exists seenhands($root,$i)] {
	    append s \"$i-\"
	    append t \"$i \"
	}
    }
    if {$youveseen && !$silent} {talkmsg \"From set $root, you've seen: $t\"}
    if {$silent} {return $t} {return $s}
}







proc floater_mkdir {s} {
    if {[info tclversion] < 7.6} {exec mkdir $s} {file mkdir $s}
}

proc floater_delete {s} {
    if {[info tclversion] < 7.6} {exec /bin/rm $s} {file delete $s}
}

if [info exists env(DOT_FLOATER)] {
    tryset floaterdir $env(DOT_FLOATER)
}
tryset floaterdir [set env(HOME)]/.floater
tryset startupfile $floaterdir/startup.tcl
tryset seenfileroot $floaterdir/seenhands

if {[file exists $floaterdir] == 0} {catch {floater_mkdir $floaterdir}}
if {[file exists $seenfileroot] == 0} {catch {floater_mkdir $seenfileroot}}

 
proc tclfiles {dir {recurse 1}} {
    set slashstar \"\\/\\*\"
    set pattern $dir$slashstar
    set files \"\"
    while 1 {
	if ![catch {glob $pattern.tcl} newfiles] {append files \" $newfiles\"}
	if {!$recurse || [catch {glob $pattern}]} {return $files}
	set pattern $pattern$slashstar
    }
}

proc source_all_tclfiles {dir {recurse 1}} {
    global startupfile

    foreach file [tclfiles $dir $recurse] {
	if {$file != $startupfile} { 





	    if [catch {source $file} err] {
		puts stderr $err
	    }
	}
    }
}

 

proc setprioruse {name} {
    global usedname startupfile

    if [info exists usedname($name)] return
    set \"usedname($name)\" 1
    set u \"\\\"usedname(\"
    catch {exec cat << \"set $u$name)\\\" 1\\n\" >> $startupfile}
}

 
 
 

set seenname _everyone_

proc seenfile {root} {
    global seenfileroot seenname
    return $seenfileroot/$seenname/$root.tcl
}

 
proc seenhand {root number scoring} {
    global seenhands

    if [info exists seenhands($root,$number)] return
    lseenhand $root $number $scoring
    if [catch {exec cat << \"lseenhand $root $number $scoring\\n\" >> 	    [seenfile $root]}] {

	floatererror \"Floater error: unable to make permanent note of what hands you've seen!\"
	set e1 \"Floater error: unable to write to file \"
	set e2 [seenfile $root]
	floatererror \"$e1$e2\"
    }
}

proc loadseen {} {
    global seenhands maxseenhand seenname seenfileroot 	    globaldate previousglobaldate


    debugmsg \"loadseen with seenname=$seenname\"

     
    if {[info exists globaldate] && [info exists previousglobaldate]} {
	cleanseen $seenfileroot/$seenname $globaldate $previousglobaldate
	if {$seenname != \"_everyone_\"} {
	    cleanseen $seenfileroot/_everyone_ $globaldate $previousglobaldate
	}
    }

    catch {unset seenhands; unset maxseenhand}
    if {[file exists $seenfileroot/_everyone_] == 0} 	    {catch {floater_mkdir $seenfileroot/_everyone_}}

    if {[file exists $seenfileroot/$seenname] == 0} 	    {catch {floater_mkdir $seenfileroot/$seenname}}

    source_all_tclfiles $seenfileroot/_everyone_

     
    source_all_tclfiles $seenfileroot 0

    if {$seenname != \"_everyone_\"} 	    {source_all_tclfiles $seenfileroot/$seenname}

}

proc cleanseen {dir except1 except2} {
    debugmsg \"cleanseen $dir $except1 $except2\"
    foreach file [tclfiles $dir 0] {
	if {![string match \"$dir/$except1*\" $file]
	    && ![string match \"$dir/$except2*\" $file]} {
		debugmsg \"Removing $file\"
		floater_delete $file
	}
    }
}



 
 
 

 
proc validfile {filename} {
    global floaterdir

    regexp $floaterdir/.* [file dirname $filename]/
}
# 39 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/connect.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
gset conn_number 0

gset default_handshake \"Floater 'shake\"
gset silent_handshake \"Floater silent 'shake\"


 
proc FloaterListen {{port 0}} {
    global localIPaddr0
    PortNumber [socket -server FloaterAcceptConnection 	    -myaddr $localIPaddr0 $port]

}

proc FloaterAcceptConnection {sock addr port} {
    debugmsg \"AcceptConnection $sock $addr $port\"
    return [FloaterNewSocket $sock]
}

proc FloaterReadable {conn sock} {
    global expecting_handshake floater_silent default_handshake

    debugmsg \"FloaterReadable $conn $sock\"
    set s [gets $sock]
    debugmsg \"Got $s from $conn\"
    if [info exists expecting_handshake($conn)] {
	debugmsg \"expecting handshake\"
	if {$s == $default_handshake} {
	     
	    unset expecting_handshake($conn)
	    return
	} else {
	    if $floater_silent {
		global silent_handshake
		if {$s == $silent_handshake} {
		    global floater_silent_conns
		    set floater_silent_conns($conn) 1
		    unset expecting_handshake($conn)
		    return
		}
	    }
	    debugmsg \"Expecting handshake but got $s\"
	}
	 
	FloaterClose $conn
	return
    }

    if {$s == \"\" && [eof $sock]} 	    {FloaterClose $conn} 	    {debugmsg \"received $s\"; floaterreceive $s $conn}


}

 
proc FloaterWritable {conn sock} {
    debugmsg \"FloaterWritable $conn $sock\"
}

 
proc FloaterConnect {addr port {handshake default}} {
    debugmsg \"FloaterConnect $addr $port\"
    FloaterNewSocket [socket $addr $port] $handshake
}

 
 
proc FloaterNewSocket {sock {handshake default}} {
    global sock_to_conn conn_to_sock conn_number expecting_handshake

    if {$handshake == \"default\"} {
	global default_handshake
	set handshake $default_handshake
    }
    debugmsg \"NewSocket $sock $handshake\"
    fconfigure $sock -blocking 0 -buffering line
    set conn [incr conn_number]
    set sock_to_conn($sock) $conn
    set conn_to_sock($conn) $sock
    set expecting_handshake($conn) 1
 
    fileevent $sock readable \"FloaterReadable $conn $sock\"
    if {$handshake != \"\"} {
	puts $sock $handshake
	debugmsg \"sent handshake ($handshake) to $conn\"
    }
    return $conn
}

proc PortNumber {sock} {
    lindex [fconfigure $sock -sockname] 2
}

 

 
tryset failedsendwait 3000
 

 
proc FloaterSend {to msg} {
    global conn_to_sock

    catch {set s $conn_to_sock($to)}






    debugmsg \"Send $to ($s) $msg\"

    if [catch {puts $s $msg}] {
	global failedsendwait

	after $failedsendwait 	    debugmsg \\\"Closing $s due to failed send\\\"; 	    catch \\{close $s\\}


    }
}

 

proc FloaterCloseName {name} {
    global name_to_conn

    set s \"<none>\"
    catch {set s $name_to_conn($name)}
    debugmsg \"FloaterCloseName $name ($s)\"
    if {$s != \"<none>\"} {
	catch {
	    FloaterClose $s
	    unset \"name_to_conn($name)\"
	}
    }
}

 
 
 

#f is a filename (or \"|program args ...\").  r is a regular expression with
#one parenthesized component.  For each line, if the regexp matches,
#lappend the parenthesized component of the match to the result.
proc filter_regexp {f r} {
    set f [open $f r]
    set result \"\"
    while {[gets $f s] >= 0} {
	if [regexp $r $s all a] { lappend result $a; set q yes } { set q no }
	#puts \"Checking $s against regexp $r: $q\"
    }
    catch { close $f }
    #puts \"filter result: $result\"
    return $result
}

 
 
 
 
proc IP_from_ifconfig {} {
    set r {inet addr:([0-9]+[.][0-9]+[.][0-9]+[.][0-9]+)}
    set s \"\"
    catch {set s [filter_regexp \"|ifconfig ppp0\" $r]}
    if {$s == \"\"} {
	catch {set s [filter_regexp \"|ifconfig\" $r]}
    }

    set result \"\"
    foreach p $s {
	if {$p != \"127.0.0.1\"} {
	    if {$result == \"\"} {set result $p} {set result $p!$result}
	}
    }
    return $result
}

 
proc bogusIP {s} {
    if {$s == \"localhost\"} { return 1 }
    if {$s == \"localhost.localdomain\"} { return 1 }
    if {$s == \"127.0.0.1\"} { return 1 }
    if {$s == \"0.0.0.0\"} { return 1 }
    if {$s == \"255.255.255.255\"} { return 1 }
    return 0
}

proc filter_and_join {s filter joiner} {
    set result \"\"
    foreach k $s {
	if ![$filter $k] { lappend result $k }
    }
    join $result $joiner
}

proc nothing {sock ipaddr port} {}

set localIPaddr 127.0.0.1
set localIPaddr0 127.0.0.1
catch {
    set server [socket -server nothing 0]
    set socket [socket [info hostname] [PortNumber $server]]
    set localIPaddr0 [lindex [fconfigure $socket -peername] 0]
    set localIPaddr1 [lindex [fconfigure $socket -peername] 1]
    catch {close $socket}
    catch {close $server}
    set localIPaddr 	    [filter_and_join \"$localIPaddr0 $localIPaddr1\" bogusIP !]

    puts $localIPaddr
    if {$localIPaddr == \"\"} {
	set localIPaddr [set localIPaddr0 [IP_from_ifconfig]]
	puts $localIPaddr
    }
}

# 40 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/mail.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 

 
 
 

 



set to_be_emailed_n 0

 
proc emailresult {result} {
    global resultparser errorstring to_be_emailed to_be_emailed_n

    if {[set q [what_to_send]] != \"\"} {set result \"$result\\nMagic cookie!$q\"}
    if {$result == \"\"} {return 0}
    set r [

    pseudomail $result $resultparser



    ]
    if $r {
	 
	set to_be_emailed([incr to_be_emailed_n]) $result
    } else {
	while {$to_be_emailed_n > 0} {
	     
	     
	     
	     
	     
	    set result $to_be_emailed($to_be_emailed_n)
	    unset to_be_emailed($to_be_emailed_n)
	    incr to_be_emailed_n -1
	    if [emailresult $result] {return $r}
	}
    }
    return $r
}

proc emailseens {} {emailresult {}}

 
proc mail_bug {bug} {
    global bugmail errorstring


    pseudomail $bug $bugmail



}

 
proc pseudomail {what where} {
    global errorstring pseudomailaddr pseudomailport

    catch {
	set conn [FloaterConnect $pseudomailaddr $pseudomailport]
	FloaterSend $conn ozzie_and_harriet
	FloaterSend $conn \"$where $what\"
	FloaterClose $conn
    } errorstring
}
# 41 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/seen.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
proc query_have_seen {name set} {
    set x \"$name $set\"
    global $x
    array names $x
}

 
proc a_h_s {name set num} {
    global \"have_seen_sets_$name\"
    eval \"set \\\"have_seen_sets_$name\\($set)\\\" 1\"

    set x \"$name $set\"
    global $x
    eval \"set \\{$x\\($num)\\} 1\"
}

proc have_seen_sets {name} {
    global \"have_seen_sets_$name\"
    array names \"have_seen_sets_$name\"
}

proc discard_data_except_from {date} {
    global nameset

    foreach name $nameset {
	global \"have_seen_sets_$name\"
	foreach set [have_seen_sets $name] {
	    if ![string match *$date* $set] {
		set x \"$name $set\"
		global $x
		unset $x
 
		eval \"unset \\\"have_seen_sets_$name\\($set)\\\"\"
 
	    }
	}
    }
}

 

set to_be_sent_n 0

proc want_to_send {name set num} {
    global to_be_sent_n to_be_sent

 
    set to_be_sent([incr to_be_sent_n]) $name
    set to_be_sent([incr to_be_sent_n]) $set
    set to_be_sent([incr to_be_sent_n]) $num
}

 
 
proc what_to_send {} {
    global to_be_sent_n to_be_sent

    if {$to_be_sent_n == 0} {return \"\"}
    set s $to_be_sent(1)
    for {set i 2} {$i <= $to_be_sent_n} {incr i} {
	set s \"$s	$to_be_sent($i)\"
	unset to_be_sent($i)
    }
    set to_be_sent_n 0
    return $s
}
# 42 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/logo.deq\" 1

global floater_version
tryset about_text \"version [lrange $floater_version 1 end]\\nCopyright (c) 1996-1999 Geoff Pike\\nhttp:\\/\\/www.floater.org/\\nThis is free software.\"



proc about {{timeout 0}} {
    global about_text
    talkmsg \"About Floater:\\n$about_text\"
}
# 45 \"tclcode/logo.deq\"


# 43 \"tclcode/floater.TCL\" 2

# 1 \"tclcode/texts.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
# 1 \"tclcode/the_texts.deq\" 1
gset Copyright {Copyright (c) 1996--1999 Geoff Pike.
All rights reserved.

Floater is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

This software is provided \"as is\" and comes with absolutely no
warranties.  Geoff Pike is not liable for damages under any
circumstances.  Support is not provided.  Use at your own risk.

Personal, non-commercial use is allowed.  Attempting to make money
from Floater or products or code derived from Floater is not allowed
without prior written consent from Geoff Pike.  Anything that remotely
involves commercialism, including (but not limited to) systems that
show advertisements while being used and systems that collect
information on users that is later sold or traded require prior
written consent from Geoff Pike.
}
gset Readme {			    Floater 1.2b1
		  for Unix and for Microsoft Windows
			  September 14, 1999

		       http:slashslashwww.floater.org/

                            by Geoff Pike
			  geoff@floater.org


Please check the ever growing Floater web page at
http:slashslashwww.floater.org/ for the most up-to-date
documentation and information, including everything here and much more.

Floater is a free program for duplicate bridge play on the Internet.
It also supports non-duplicate bridge and 3-player hearts.

Floater 1.2 is a minor upgrade to 1.1 that includes several changes:
  o  Faster server
  o  New installer for Microsoft Windows users
  o  Some bug fixes

Version 1.2 is not interoperable with older versions.

To install, Microsoft Windows users should download and run the
installer from the Floater web page.  Unix users will need to rebuild
from scratch as described below.

Please report bugs to bugs@floater.org.

Floater for Macintosh will be available soon.  Sorry for the delay.

Please read this file as well as the files called BUGS and CONFUSING.

Microsoft Windows Installation Instructions:
--------------------------------------------

Download and run the installer, inst12b1.exe, available at
http:slashslashwww.floater.org/inst12b1.exe.  The installer has two basic
steps.  Step 1: the installer checks for Tcl/Tk 8.0 and offers to
download and install it for you if necessary.  Step 2: the installer
downloads the Floater executable and associated files from floater.org
and creates a shortcut to Floater from the Desktop and from the
Start Menu.

After installing Floater, you may delete the installer.

Unix Installation instructions:
-------------------------------

Please be aware that these instructions are for installation only.
See the web page for other, ultimately more useful, information.

Please read carefully.  Unlike the Mac and Microsoft Windows versions,
you must compile Floater yourself for Unix.  If you have never edited
a Makefile before, you may find this difficult.

If you have problems, please consult the web page to see if there are
notes from others who may have tried compiling Floater on your
architecture/OS.  Send bugs to bugs@floater.org, and also please send
descriptions of what you had to modify to get Floater to work on your
system.  When sending email about problems that you have not yet been
able to solve, please clearly indicate what you have tried so far.
Due to the high volume of email, responses may be slow.

Almost all of the difficult-to-port features of Floater are
implemented by using Tcl and Tk, which have already been ported to
many different machines.  Floater should run on a variety of machines
with no problem.  It is known to compile on SunOS, Solaris,
Linux, HPs (HP/UX), and Silicon Graphics (IRIX), among others.  Don't
be intimidated by the amount of software you may need to install---the
autoconf scripts really work and next to nothing needs to be fixed by hand.

Floater for Unix has two versions---textual and graphical.  Both
require Tcl and Tk, which are freely available.  In addition, the text
version requires System V style curses or ncurses (GNU's free
replacement for curses).  Tcl/Tk 8.0 is required.  You should use the
latest patch level, which as of September, 1999, is 8.0.5.  (Floater
does not work with Tcl/Tk 8.1 or 8.2.  If you port it to Tcl/Tk 8.2
let us know!)

By default, the graphical and textual versions are in the same
executable.  You may build an executable that does not include the
textual version, which is useful if you have X and don't want to deal
with curses (see Makefile for details).

BSD users without ncurses should have it installed anyway, as the
maintainer of BSD curses has publically announced that he is no longer
supporting it and he encourages people to switch to ncurses.  If you
are unsure whether you need ncurses to use Floater, try it first
without ncurses.  You may get ncurses by anonymous ftp from
prep.ai.mit.edu in the /pub/gnu directory.  Or, it is too much
trouble, you may compile only the X user interface (see Makefile for
details).

Detailed instructions follow.  For easier ftp'ing, the Floater
web page (http:slashslashwww.cs.berkeley.edu/~pike/floater/release.html)
allows you to download the appropriate files.

To install Floater 1.2b1 for Unix:
----------------------------------

0. Floater more or less requires UNIX and 32-bit integers.  Brave
souls who try to install it without those things may succeed but with
some difficulty.

1. If your site doesn't have it, install Tcl/Tk, available from the
Tcl/Tk web page at http:slashslashwww.scriptics.com.  Note that Tcl/Tk 8.0.5
is what you should try to use, but 8.0.x is fine.  See above.

2. You may or may not need ncurses.  System V users and many BSD users
should either not need it or already have it.  See above.

3. Get the compressed Floater tar file from the Floater web page.
Uncompress and untar the file by doing:
        gzip -c -d floater1.2b1.tar.gz | tar xvf -

(You may remove floater1.2b1.tar.gz now.)

4. Run the configure script by doing changing to the floater1.2b1
directory and running ./configure.  The flags accepted by the
configure script are as follows:
  --with-tcl=/some/path
     will look for tcl headers files and libs in /some/path/include
     and /some/path/lib

  --with-tk=/some/path
     same as --with-tcl but for tk

  --with-curses=/some/path
     same as above but for curses (it tries to look for ncurses and
     then curses but may not be perfect...)

  --without-curses
     doesn't look for curses at all and defines GUI_ONLY when
     building.

If the configure script runs successfully, it creates a Makefile.
(Thanks to Andrew Swan for creating the new and improved configure script!)

5. Do \"make\".  It may or may not work.  If it doesn't work, edit the
file Makefile.in to try to set up the paths for various libraries,
etc., as necessary.  More instructions are in that file.  Each time
you edit Makefile.in, do \"make Makefile\" to regenerate the Makefile,
and then do (just) \"make\" again.  (On some systems you can just do
\"make\" and it will automatically recreate the Makefile and then try to
recompile.)  If desperate, you may also want to refer to
Makefile.pike, which is a Makefile that is known to work on at least
one system somewhere.

6. Once you have successfully built Floater, a common problem when you
first run it is an error message about being unable to find init.tcl
in certain directories.  The easiest solution, if you have Tcl and Tk
in sibling directories, is to create a directory called lib, sibling
to those two, and do:
        cd lib
        ln -s ../tk8.0/library tk8.0
        ln -s ../tcl8.0/library tcl8.0

Another solution is to find init.tcl and put a copy of it in one of
the directories in which it is looking when you start up Floater.
Another is, before running Floater, to do \"setenv TCL_LIBRARY <dir>\"
where <dir> is the directory containing init.tcl (typically
<something>/tcl8.0/library).  A third is to properly install Tcl by
doing \"make install\" in the tcl8.0/ 1  directory---but you probably
have to be root to do this.

(Once you fix that, the analogous problem will likely crop up with Tk.
It will complain that it can't find a usable tk.tcl.  The same fixes
apply, but be sure to copy all the .tcl files in tk8.0/library if you
choose that solution.)
}
gset Confusing {This file is intended to list some of the more confusing aspects of
using Floater.

1. Floater relies on self-alerts.  If playing formally, you are
expected to explain your bidding and carding agreements as carefully
as you would at a tournament.  In any case, you alert by using the
commands `alert,' `redalert' and `explain.'   You should alert
at the same time or before you take an alertable action.  There are no
fixed rules as to what agreements are alertable---use your judgment
and do unto others as you would have them do unto you.

The easy way to alert an action is to type \"!\" (or \"!!\" for redalert)
on the same line as the command to perform that action---and
optionally put an explanation at the end.  For example, you could type
\"2D!weak two in either major\" to bid and alert your own bid
simultaneously.  See also the help on `alert,' `redalert' and
`explain.'

If you are using the graphical user interface, you may click on the
\"Alert\" or \"Redalert\" checkboxes BEFORE clicking on the call you wish
to make.  For example, clicking on \"1C\" when the \"Alert\" checkbox is
highlighted will have the same effect as typing \"1C!\" on the keyboard.

Everyone at the table except partner sees your alerts.

2. See also the file called BUGS.
}
gset Bugs {This file lists some of the known bugs and limitations of Floater.
Please read it.  You may assume everything listed here is being worked
on and will be eventually fixed.  Older bugs are at toward the bottom;
newer bugs are toward the top.  An asterisk after the numeral
indicates that the bug has been fixed.  (Some of the listings may be
cryptic or incomprehensible---my apologies.)

Send bug reports to bugs@floater.org.

8. When I host, scoring method defaults to whatever it was at the
previous table.  Furthermore, when I do, say, \"score imp,\" the list of
tables isn't updated immediately.

7. When using the GUI, occasionally I have had the menu bar at the
top disappear and not come back.  This appears to be a Tcl/Tk bug.  If
it happens, iconify Floater and then restore it, and the menu bar
will reappear.

6. The review command sometimes puts your side's actions in parens.
I think it should always put the other guys' actions in parens.

5.. Pseudomail works but doesn't correctly report whether it succeeded.
(It always reports success.)

4. The documentation is a work in progress.  For the latest, look at:
     http:slashslashwww.floater.org/doc

3. Curses may be confused about your screen size or terminal attributes.
Putting the following in your .cshrc may do the trick:
    setenv TERM vt100

    set noglob
    eval `tset -s`
    unset noglob

Another possible fix is to try doing:
    eval `resize`

2. Logging in disconnects you from the table.  (This is becuase the other
players would become confused if your name suddenly changed.  But it
can be fixed.)

1. Sometimes after being shunted (when you do the `host' command) you
find that you do not get connected properly to the table tree.  When
this happens, try again a few times.  As a last resort, you may do
`host <tablename>' to try to join the table tree at that location.
}
gset help_texts {Copyright Readme Confusing Bugs}
# 19 \"tclcode/texts.deq\" 2

proc display_text {name s} {
    global fixedfont
     
    set slash /
    regsub -all slashslash $s $slash$slash text

    talkmsg $text
# 44 \"tclcode/texts.deq\"

}
# 44 \"tclcode/floater.TCL\" 2






gset floaterclock 0
gset table_arrival_time 0
gset snooze 0


# 63 \"tclcode/floater.TCL\"



 

gset ntalklines 0  

gset dtalklines 0  
		   

gset talklineattop 0  
 
 

gset showerrors 1
gset debugprinting 0


if $floater_silent {
    proc clearrect {x y} {puts stdout \"clearrect $x $y\"}
    proc anchor {l} {puts stdout \"anchor $l\"}
    proc down_and_anchor {{l 1}} {puts stdout \"down_and_anchor $l\"}
    proc right {{l 1}} {puts stdout \"right $l\"}
    proc str {l} {puts stdout \"str `$l'\"}
    proc ch {l} {puts stdout \"ch $l\"}
}

proc talkmsg {s {draw 1} {allowPrefix 1}} {
    global talklines ntalklines talkwidth debugprinting showerrors
    global dtalklines scrolllock talktop floater_silent floater_silent_conns

    if $floater_silent {
	puts $s
	global conn_to_sock
	foreach conn [array names floater_silent_conns] {
	    catch {puts $conn_to_sock($conn) $s}
	}
	return
    }




    if $debugprinting return

    if {$talktop < 0} return
    if {!$showerrors && [regexp -nocase error $s]} return
    
     
    if [regexp \"(.*)\\n(.*)\" $s whole a b] {
	talkmsg $a
	talkmsg $b
	return
    }
    
    if {[string length $s] > $talkwidth} {
	 
	for {set i $talkwidth} {[incr i -1] > 0} {} {
	    if {[string index $s $i] == \" \"} {
		incr i -1
		talkmsg [string range $s 0 $i] 0 0
		talkmsg [string range $s [expr $i + 2] end] $draw 0
		return
	    }
	}
	 
	talkmsg [string range $s 0 [expr $talkwidth - 1]] 0 0
	talkmsg [string range $s $talkwidth end] $draw 0
	return
    }

    set talklines($ntalklines) $s
    incr ntalklines
    if !$scrolllock {set dtalklines $ntalklines}
    if $draw {drawtalkregion}
}
# 152 \"tclcode/floater.TCL\"


proc floatererror {s} { talkmsg \"ERROR: $s\" }

 


 
if {[catch {source $startupfile} err] 	&& ![regexp -nocase {no such file} $err]} {


    talkmsg \"ERROR: $err\"



}







tryset loginservername \"loginserver\"
tryset loginserveraddr \"128.32.131.251\"
tryset loginserverport \"2210\"
tryset resultservername \"resultserver\"
tryset resultserveraddr \"128.32.131.251\"
tryset resultserverport \"1430\"
tryset pseudomailaddr \"128.32.131.251\"
tryset pseudomailport \"1440\"
tryset resultparserprogram /home/cs/pike/floater/floatres/parsemail
tryset resultparser \"floater@floater.org\"
tryset bugmail \"pike@cs.berkeley.edu\" ; # \"bugs@floater.org\"

 
tryset defaultnote \"\"

 
tryset tricktime 2000

 
 



tryset autonewdeal_default 35


 
tryset autonewdeal_seconds $autonewdeal_default

tryset nokibitzers 0
tryset jointableservertree 1

tryset youveseen 1

tryset newbie [expr ![info exists usedname]]

 
 
 
# 240 \"tclcode/floater.TCL\"


 
 
 
# 400 \"tclcode/floater.TCL\"

 

gset tcl_interactive 1

set needAuctionUpdate 0

# 1 \"tclcode/options_common.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
 
 

 
 
 

set beepAtMyTurn_ 0
proc beepAtMyTurn {{toggle 0}} {
    global beepAtMyTurn_

    if $toggle {set beepAtMyTurn_ [expr !$beepAtMyTurn_]}
}

# 407 \"tclcode/floater.TCL\" 2






# 1 \"tclcode/matrix0.deq\" 1
 
 

 
 
 

 
 
 

 
 
 
 
 
 
 
gset newstyle_matrix 0

proc redrawmatrixcards {} {}

proc togglepassedcard {suit card} {
    global togglepassedaction

    if [info exists togglepassedaction([string toupper $suit$card])] 	    {catch $togglepassedaction([string toupper $suit$card])}

}

proc removecardfromhand {suit card} {
    global removecard

    if [info exists removecard([string toupper $suit$card])] 	    {catch $removecard([string toupper $suit$card])}

}

# 48 \"tclcode/matrix0.deq\"



 
proc rmcard {x y suit card} {
    set f \"$x $y\"
    anchor $f
    set suit [string toupper $suit]
    if {$suit == \"S\"} {rmcard2 $f $suit $card} {down_and_anchor}
    if {$suit == \"H\"} {rmcard2 $f $suit $card} {down_and_anchor}
    if {$suit == \"D\"} {rmcard2 $f $suit $card} {down_and_anchor}
    if {$suit == \"C\"} {rmcard2 $f $suit $card}
}

proc rmcard2 {f suit card} {
    global cursuit

    right 2  
    set w [set \"cursuit($f$suit)\" [zap $card $cursuit($f$suit)]]
    str \"$w \"
}

 
proc zap {char text} {
    set i [string first $char $text]
    if {$i < 0} {  
	return $text
    } elseif {$i == 0} {
	return [string range $text 1 end]
    } else {
	incr i -1
	set j [expr $i + 2]
	 
	return \"[string range $text 0 $i][string range $text $j end]\"
    }
}

  

 
proc suit {f cards suit} {

    global cursuit removecard

    set suit [string toupper $suit]
    set cards [string toupper $cards]
    str \"$suit $cards\"
    down_and_anchor
    set \"cursuit($f$suit)\" $cards
    for {set i [expr [string length $cards] - 1]} {$i >= 0} {incr i -1} {
	set card [string index $cards $i]
	set removecard([string toupper $suit$card]) \"rmcard $f $suit $card\"
    }
# 122 \"tclcode/matrix0.deq\"

}

 
 
proc hand {f s h d c} {
# 148 \"tclcode/matrix0.deq\"

    global handwidth
    anchor $f
    clearrect $handwidth 4

    suit $f $s s
    suit $f $h h
    suit $f $d d
    suit $f $c c 
}

# 184 \"tclcode/matrix0.deq\"


# 195 \"tclcode/matrix0.deq\"


 
 
 
proc fulldeal {s h d c LHOs LHOh LHOd LHOc 		   Ps Ph Pd Pc RHOs RHOh RHOd RHOc} {

    global mframe

    hand $mframe(self) $s $h $d $c
    hand $mframe(pard) $Ps $Ph $Pd $Pc
    hand $mframe(lho) $LHOs $LHOh $LHOd $LHOc
    hand $mframe(rho) $RHOs $RHOh $RHOd $RHOc
}

gset tricktimeOK 1

 
 
proc startshowtricktimer {} {
    global tricktime tricktimeOK

    set tricktimeOK 0
    after $tricktime set tricktimeOK 1
}

 
 
proc delayedclearmatrix {} {
    global needtoerase

    set needtoerase 1
    after 5000 clearmatrixtimer
}

proc clearmatrixtimer {} {
    global needtoerase

    if $needtoerase {erasebidplay all}
}

 
 
proc erasebidplay {who} {
    global tricktimeOK

    while {!$tricktimeOK} {
	update
	after 100
    }
    if {$who == \"all\"} {
	global needtoerase

	set needtoerase 0
	erasebidplay lho
	erasebidplay rho
	erasebidplay pard
	erasebidplay self
    } else {

	global matrixtext
	
	anchor $matrixtext($who)
	clearrect 2 1




    }
}

 
 
 
proc showplay {player suit card} {

    global matrixtext

    anchor $matrixtext($player)
    if {$suit == \"?\"} {
	str \"? \"
    } else {
	str $suit$card
    }
# 298 \"tclcode/matrix0.deq\"

}

 
 
 
 
proc showbid {player level strain} {
 

    global matrixtext

    anchor $matrixtext($player)
    if {$strain == \"-\"} {
	str \"  \"
    } elseif {$strain == \"?\"} {
	str \"? \"
    } elseif {$level > 0} {
	str \"$level$strain \"
    } else {	
	str \"$strain \"
    }



}


proc drawbid {x y level strain} {
    global auctionx auctiony auctionbot

 

    if {[expr $auctiony + $y + 2] <= $auctionbot} {
	anchor \"[expr $auctionx + 1 + 4 * $x] [expr $auctiony + $y + 2]\"

	 
	if {$strain == \"x\"} {
	    set s \"X \"
	} elseif {$strain == \"xx\"} {
	    set s \"XX\"
	} elseif {$strain == \"p\"} {
	    set s \"P \"
	} elseif {$strain == \"-\"} {
	    set s \"  \"
	} elseif {$strain == \"?\"} {
	    set s \"? \"
	} else {
	    set s $level$strain
	}
	
	clearrect 2 1
	if {$s != \"  \"} {str [string toupper $s]}
    }
}
# 396 \"tclcode/matrix0.deq\"


 
 
proc setname {player compassdir name} {

    global namepos namewidth

    anchor $namepos($player)
    if {[string first \"(\" $name] == -1} {set name \"$name ($compassdir)\"}
    if {[string length $name] > $namewidth} {
	set name [string range $name 0 [expr $namewidth - 1]]
    }
    if {$player == \"self\" || $player == \"pard\"} {
	rightjustify $name $namewidth
    } else {
	clearrect $namewidth 1
    }
    str $name
# 427 \"tclcode/matrix0.deq\"

}

# 413 \"tclcode/floater.TCL\" 2



gset showingauction 0

 

proc showauction {bool} {
    global auctionx auctiony auctionwidth auctionheight auctionright auctionbot
    global showingauction

    set showingauction $bool
    anchor \"$auctionx $auctiony\"
    clearrect $auctionwidth $auctionheight
    if $bool {
	hline . $auctionx $auctionright $auctiony
	vline . $auctionx $auctiony $auctionbot
    }
    textseated
}
# 444 \"tclcode/floater.TCL\"



 
proc rightjustify {s width {r 1}} {
    while {[string length $s] < $width} {
	set s \" $s\"
	if $r {ch \" \"}
    }
    return $s
}



proc hline {c xlo xhi y} {
    anchor \"$xlo $y\"
    for {} {$xlo <= $xhi} {incr xlo} {ch $c}
}

proc vline {c x ylo yhi} {
    anchor \"$x $ylo\"
    for {} {$ylo <= $yhi} {incr ylo} {ch $c; down_and_anchor}
}

 
hline - 30 46 4
hline - 30 46 10
vline | 29 5 9
vline | 47 5 9
 
 
gset mframe(self) {30 11}
gset mframe(pard) {30 0}
gset mframe(lho) {15 6}
gset mframe(rho) {49 6}
gset handwidth 14
 
gset namewidth 14
gset namepos(self) {15 11}
gset namepos(pard) {15 0}
gset namepos(lho) {15 5}
gset namepos(rho) {49 5}
 
gset matrixtext(self) {37 9}
gset matrixtext(pard) {37 5}
gset matrixtext(lho) {31 7}
gset matrixtext(rho) {43 7}
 
gset auctionx 64
gset auctiony 5
gset auctionright 79
gset auctionbot 14
gset auctionwidth [expr $auctionright - $auctionx + 1]
gset auctionheight [expr $auctionbot - $auctiony + 1]


# 570 \"tclcode/floater.TCL\"









 
set x [expr ![catch {regexp -nocase \"Apr 1 \" [exec date]} y]]
if !$x {set y 0}
if [expr $x && $y] {
 fulldeal AKQJ AKQJ AKQJ AK T98 T98 T98 QJT9 765 765 765 876 432 432 432 5432
 showbid self 8 n
} else {
 fulldeal AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2
 showbid self 7 n
}

# 801 \"tclcode/floater.TCL\"



 
 
 
 

gset previous_trick_index 0
gset previous_trick {}

proc reset_previous_trick {{index -999}} {
    global previous_trick previous_trick_index

    if {$index == -999 || $index == $previous_trick_index} {
	set previous_trick {}
    }
}

proc set_previous_trick {s {erase 1}} {
    global previous_trick previous_trick_index

    set previous_trick $s
    incr previous_trick_index

     
    if $erase {after 10000 \"reset_previous_trick $previous_trick_index\"}
}

 


gset oldpov S
gset oldseated 0

proc textseated {{seated -1} {pov S}} {
    global auctionx auctiony showingauction oldseated oldpov

    if {$seated == -1} {set seated $oldseated; set pov $oldpov}
    set oldseated $seated
    set oldpov $pov
    if !$showingauction return

    anchor \"$auctionx $auctiony\"
    down_and_anchor
    right 1
    if $seated {
	str \"LHO Par RHO you\"
    } else {
	if {$pov == \"S\"} {
	    str \"(W) (N) (E) (S)\"
	} elseif {$pov == \"N\"} {
	    str \"(E) (S) (W) (N)\"
	} elseif {$pov == \"E\"} {
	    str \"(S) (W) (N) (E)\"
	} elseif {$pov == \"W\"} {
	    str \"(N) (E) (S) (W)\"
	}
    }
}


 
proc newauction {} {

    showauction 1







}


 
 
 
 

 
set statusline {}
set infoline {}

gset leftwidth 14
gset rightwidth 30
gset rightpos 50

proc strinfield {s x y width} {
    anchor \"$x $y\"
    clearrect $width 1
    if {[string length $s] > $width} 	    {set s [string range $s 0 [expr $width - 1]]}

    str $s
}

strinfield $floater_version 0 0 15

 
proc connstat {{s {}}} {
    global leftwidth
    strinfield $s 0 1 $leftwidth 
}

 
proc displayhandname {{s {}}} {
    global leftwidth
    strinfield $s 0 2 $leftwidth
}

proc statushandvul {{s {}}} {
    global leftwidth
    strinfield $s 0 3 $leftwidth
}

proc statushanddlr {{s {}}} {
    global leftwidth
    strinfield $s 0 4 $leftwidth
}

proc statuscontract {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 0 $rightwidth
}

proc statustolead {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 1 $rightwidth
}

proc displaytrickswon {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 2 $rightwidth
}

 
proc statusclaim {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 3 $rightwidth
}

proc statusresult {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 4 $rightwidth
}

 
proc statusscore {{s {}}} {
    global leftwidth
    
    set x 0
    set y 5
    
    if {$s == \"\"} {set s \" ; ; ; ; \"}  

    while {[regexp {([^;]*); (.*)} $s whole t s]} {
	strinfield $t $x $y $leftwidth
	incr y
    }
    strinfield $s $x $y $leftwidth
}



gset oldntalklines 0
gset scrolllock 0




proc drawtalkregion {{must_redraw 0}} {
    global talklines dtalklines talktop talklineattop talkbottom oldntalklines
    global scrolllock ntalklines
    
    draw_on_current_display +

    set talksize [expr $talkbottom - $talktop + 1]

    if {($dtalklines >= $ntalklines) || ($ntalklines < $talksize)} {
	set dtalklines $ntalklines
	set scrolllock 0
    }

    set want_to_redraw 	   [expr ($dtalklines - $talklineattop) > $talksize]

    if {$must_redraw || ($want_to_redraw && !$scrolllock)} {
	 
	set y $talktop
	set i [set talklineattop [expr $dtalklines - $talksize]]
	if {$i < 0} {
	    if $scrolllock {set dtalklines $talksize}
	    set i 0
	}
	for {set talklineattop $i} 	    {($y <= $talkbottom) && ($i < $dtalklines) && ($i < $ntalklines)} 	    {incr i; incr y} {


		drawtalkline $y $talklines($i)
	}
	
	 
	if {$i == $ntalklines} {set scrolllock 0}
    } elseif !$scrolllock {
	 
	for {set y $talktop; set i $talklineattop} 		{$y <= $talkbottom && $i < $dtalklines} 		{incr i; incr y} {


	    if {$i >= $oldntalklines} {drawtalkline $y $talklines($i)}
	}
    }
    set oldntalklines $ntalklines
    reset_cursor_position
    draw_on_current_display -
}

proc talkscroll {n} {
    global scrolllock dtalklines

    incr dtalklines $n
    set scrolllock 1
    drawtalkregion 1
}

proc turn_off_scrolllock {} {
    talkscroll 1000000
}

proc talkregion {top bottom} {
    global talktop talkbottom talklineattop scrolllock

    set talktop $top
    set talkbottom $bottom
    drawtalkregion 1
}

proc drawtalkline {y s} {
    anchor \"0 $y\"
    str \"$s\\n\"
}






proc debugmsg {s} {
    global debugprinting floater_silent

    set old $debugprinting
    set debugprinting 1
    talkmsg $s
    set debugprinting $old
    if $floater_silent {puts $s}
}

 
 
 

proc setcursor {cursor w} {









}

proc unsetcursor {w} {

# 1083 \"tclcode/floater.TCL\"

}

proc patientcursor {} {
    global cursorlevel
    
    if {[incr cursorlevel] == 1} {setcursor watch .}
}

proc normalcursor {} {
    global cursorlevel
    
    if {[incr cursorlevel -1] == 0} {unsetcursor .}
}
set cursorlevel 0
	








 
 
 

 
 

 



tryset tabletimeout 600


 
tryset tablereannounce 90


 
 

set receiveiamalivelist {}
set sendiamalivelist {}

 
tryset sendiamaliveinterval 40000

 
tryset receiveiamaliveinterval 20000

 



tryset iamalivetimeout 450


proc shouldreceiveiamalive {conn} {
    global receiveiamalivelist

    set receiveiamalivelist [linsert $receiveiamalivelist 0 $conn]
}

proc shouldnotreceiveiamalive {conn} {
    global receiveiamalivelist

    catch {
	set i [lsearch $receiveiamalivelist $conn]
	set receiveiamalivelist [lreplace $receiveiamalivelist $i $i]
    }
}

proc shouldsendiamalive {conn} {
    global sendiamalivelist

    set sendiamalivelist [linsert $sendiamalivelist 0 $conn]
}

proc shouldnotsendiamalive {conn} {
    global sendiamalivelist

    catch {
	set i [lsearch $sendiamalivelist $conn]
	set sendiamalivelist [lreplace $sendiamalivelist $i $i]
    }
}

proc sendiamalives {} {
    global sendiamalivelist sendiamaliveinterval

    after $sendiamaliveinterval sendiamalives
    foreach conn $sendiamalivelist {
	debugmsg \"Sending iamalive to $conn\"
	catch {FloaterSend $conn *alive*}
    }
}

proc checkreceiveiamalive {conn} {
    global iamalivetimeout timeofmostrecent floaterclock

 
    catch {
	debugmsg \"seconds since most recent msg on $conn: [expr ($floaterclock - $timeofmostrecent($conn))]\"
	if [expr ($floaterclock - $timeofmostrecent($conn)) > $iamalivetimeout] 		{floatertimeout $conn}

    }
}

proc checkreceiveiamalives {} {
    global receiveiamalivelist receiveiamaliveinterval

    after $receiveiamaliveinterval checkreceiveiamalives
    foreach conn $receiveiamalivelist { checkreceiveiamalive $conn }
}

sendiamalives
checkreceiveiamalives

 
 
 
 
 

gset MyTurnTimer -99
tryset MyTurnTimerCountdown 20
proc startMyTurnTimer {} {
    global MyTurnTimerCountdown MyTurnTimer
    set MyTurnTimer $MyTurnTimerCountdown
}    

proc MyTurnTimerRing {} {
    global showingauction
    if $showingauction {
	showauction 0
	showauction 1
	startMyTurnTimer
    }
}

proc stopMyTurnTimer {} {
    global MyTurnTimer
    set MyTurnTimer -99
}

 

proc floaterclockbump {} {
    global floaterclock MyTurnTimer

    incr floaterclock
    if {$MyTurnTimer > 0} {if {[incr MyTurnTimer -1] == 0} MyTurnTimerRing}
    after 1000 floaterclockbump
     
     
    if {[expr $floaterclock % 3] == 0} {command {}}
}

after 1000 floaterclockbump


proc countdown {x} {
    global $x

    if {[set $x] > 0} then \"after 1000 \\\"countdown $x\\\"\" else return
    incr $x -1
}

proc reset_rejoinnow {} {
    global rejoinclock rejoinclockincrement

    set rejoinclock 0
    set rejoinclockincrement 1
}

proc rejoinnow {} {
    global rejoinclock rejoinclockincrement

    if {$rejoinclock <= 0} then {
	if {$rejoinclockincrement < 1800} 		{set rejoinclockincrement [expr 2 * $rejoinclockincrement]}

	set rejoinclock $rejoinclockincrement
	countdown rejoinclock
	return 1
    } else {return 0}
}

proc reset_find_rho {} {
    global rhoclock rhoclockincrement

    set rhoclock 0
    set rhoclockincrement 1
}

proc findrhonow {} {
    global rhoclock rhoclockincrement

    if {$rhoclock <= 0} then {
	if {$rhoclockincrement < 1800} 		{set rhoclockincrement [expr 2 * $rhoclockincrement]}

	set rhoclock $rhoclockincrement
	countdown rhoclock
	return 1
    } else {return 0}
}

reset_find_rho
reset_rejoinnow

 
gset autodealing 0

proc autonewdeal {} {
    global autonewdeal_seconds autodealing

    if $autodealing return
    if {$autonewdeal_seconds >= 0} {
	set autodealing 1
	after [expr 1000 * $autonewdeal_seconds] {
	    global autodealing
	    
	    if $autodealing {
		set autodealing 0
		if {$autonewdeal_seconds >= 0} {command autodeal_now}
	    } else {





	    }
	}
    }
}

proc updateloc {} {
    global updateloc_seconds

    after [expr 1000 * $updateloc_seconds] updateloc
    catch {command iupdatelocation}
}

tryset updateloc_seconds 300
updateloc

 
 
 

 
 
gset should_defer 0

proc command args {
    global should_defer

    if $should_defer {deferpush \"commandn $args\"} else {eval \"commandn $args\"}
}










proc floaterreceive {msg conn} {
    global should_defer timeofmostrecent floaterclock

    set timeofmostrecent($conn) $floaterclock
     
    if {$msg == \"*alive*\"} return

    if $should_defer {
	deferpush \"floaterreceiven {$msg} {$conn}\"
    } else {
	floaterreceiven $msg $conn
    }
}

proc talk args {
    global should_defer

    if $should_defer {deferpush \"talkn $args\"} else {eval \"talkn $args\"}
}

proc FloaterClose args {
    global should_defer

    if $should_defer {deferpush \"FloaterClosen $args\"} 	    else {eval \"FloaterClosen $args\"}

}










proc floatertimeout args {
    global should_defer

    if $should_defer {deferpush \"floatertimeoutn $args\"} 	    else {eval \"floatertimeoutn $args\"}

}

 
 
 

 
 
proc defer {n} {
    global should_defer

    if {[incr should_defer $n] == 0} {
	while {![deferempty]} {eval [deferpop]}
    }
}

gset deferqueuelo 0
gset deferqueuehi 0

proc deferempty {} {
    global deferqueuehi deferqueuelo

    return [expr $deferqueuelo == $deferqueuehi]
}

proc deferpush {s} {
    global deferqueue deferqueuehi
    
    set deferqueue($deferqueuehi) $s
    incr deferqueuehi



}

proc deferpop {} {
    global deferqueue deferqueuelo
    
    set temp $deferqueue($deferqueuelo)
    unset deferqueue($deferqueuelo)
    incr deferqueuelo



    return $temp
}

 
 
 

set executing_index 0

proc Floater_execute {file} {
    global executing_index executing_command
    if {[set n [gets $file s]] >= 0} {
	if {$n > 0} {
	    deferpush \"show_executing [incr executing_index]; Floater_execute $file\"
	    set executing_command($executing_index) $s
	    return
	}
    }
    catch {close $file}
}    

proc show_executing {n} {
    global executing_command

    talkmsg \"Execute: $executing_command($n)\"
    commandn $executing_command($n)
    unset executing_command($n)
}
 
 
 

proc untabify {s} {
    if [regexp {([^	]*)	(.*)} $s whole left right] {
	set i [string length $left]
	while 1 {
	    set right \" $right\"
	    incr i
	    if [expr $i % 8 == 0] {return [untabify $left$right]}
	}
    } else {return $s}
}

proc truncate {s {n 80}} {
    if {[string length $s] > $n} {
	return [string range $s 0 [expr $n - 1]]
    } else {
	return $s
    }
}

proc unbraceclean {s} {
    regsub -all {\\\\(\\[|\\]|\\{|\\})} $s {\\1} x
    return $x
}

proc beginnewcc {direction} {
    global newcc newccline newccignoring

    set newccline 0
    set newccignoring 0
    set newcc $direction
}

proc addnewcc {s {bracecleaned 1}} {
    global newcc newccline cc newccignoring

    set s [untabify [truncate $s]]
    if $bracecleaned {set s [unbraceclean $s]}
    if {$newccline == 40} {set newccignoring 1; return}
    set cc($newcc,[incr newccline]) $s
}

proc endnewcc {} {
    global newcc newccline newccignoring cclines

    set cclines($newcc) $newccline
     
    if $newccignoring {
	return \"Warning: Ignored lines beyond the first 40\"
    } else {
	return \"\"
    }
}

 
 
proc ccstr {direction} {
    global cc cclines

    set s \"\"
    catch {
	if {$cclines($direction) < 1} {return \"\"}
	set s $cc($direction,1)
	for {set i 2} {$i <= $cclines($direction)} {incr i} {
	    set s \"$s\\t$cc($direction,$i)\"
	}
    }
    return $s
}

gset lastrange \"\"  
proc inrange {n range} {
    global lastrange lastrangelow lastrangehigh  

    if {$range != $lastrange} {
	set lastrange $range
	if [regexp {^([0-9]+)-([0-9]+)$} $range x lastrangelow lastrangehigh] {
	     
	} elseif [regexp {^([0-9]+)$} $range lastrangelow] {
	    set lastrangehigh $lastrangelow
	} elseif [regexp {^([0-9]+)-$} $range x lastrangelow] {
	    set lastrangehigh 1000000
	} elseif [regexp {^-([0-9]+)$} $range x lastrangehigh] {
	    set lastrangelow -1000000
	} else {error \"Invalid range: $range\"}
    }
    expr ($n >= $lastrangelow) && ($n <= $lastrangehigh)
}

proc ccdump {direction {range 1-}} {
    global cc cclines

    for {set i 1} {$i <= $cclines($direction)} {incr i} {
	if [inrange $i $range] {
	    talkmsg $cc($direction,$i)
	}
    }
}

proc ccsave {file direction} {
    global cc cclines

    for {set i 1} {$i <= $cclines($direction)} {incr i} {
	puts $file $cc($direction,$i)
    }
    close $file
}

proc getccline {direction line} {
    global cc cclines

    if ![info exists cclines($direction)] {return \"\"}
    if {$line <= $cclines($direction)} {
	return $cc($direction,$line)
    } else {
	return \"\"
    }
}

 
 
 

 
 
proc reverse_init {} {
    global reverse_n

    set reverse_n 0
}

proc reverse_print {s} {
    global reverse_n reverse_lines

    set reverse_lines($reverse_n) $s
    incr reverse_n
}

proc reverse_done {} {
    global reverse_n reverse_lines

    while {[incr reverse_n -1] >= 0} {
	talkmsg $reverse_lines($reverse_n)
	unset reverse_lines($reverse_n)
    }
}

 
proc Floater_login {} {
    global loginname loginpassword newbie

    toplevel .login

    frame .login.left
    frame .login.right
    frame .login.bottom

    button .login.bottom.cancel -text \"Cancel\" 	-command {set loginname \"\"; set loginpassword \"\"; destroy .login}

    button .login.bottom.clear -text \"Clear\" 	-command {set loginname \"\"; set loginpassword \"\"; focus .login.right.n}

    button .login.bottom.ok -text \"OK\" 	-command {destroy .login}


    proc newbietr {name el op} {
	global pw_or_email newbie

	if $newbie {set pw_or_email \"Email address: \"} 		{set pw_or_email \"Password: \"}

    }

    checkbutton .login.new -text \"New User\" -variable newbie
    trace variable newbie w newbietr
    if [info exists newbie] {set newbie $newbie} {set newbie 0}

    label .login.left.n -text \"Name: \"
    label .login.left.p -textvariable pw_or_email -width 13

    entry .login.right.n -bd 2 -relief sunken -textvariable loginname
    entry .login.right.p -bd 2 -relief sunken -textvariable loginpassword

    pack .login.bottom.cancel .login.bottom.clear .login.bottom.ok 	-side left -expand yes -fill x -padx 3m -pady 2m

    pack .login.left.n .login.left.p
    pack .login.right.n .login.right.p
    pack .login.bottom -side bottom
    pack .login.new -side bottom -pady 2m
    pack .login.left -side left -fill x -expand yes
    pack .login.right .login.right -side right -fill x -expand yes
    wm title .login \"Floater login\"

    bindsetup .login.right.n .login.right.p {focus .login.right.p}
    bindsetup .login.right.p .login.right.n {destroy .login}
    bind .login.right.n \\\\ {set loginname \"\"}

    grab set .login
    tkwait window .login
    trace vdelete newbie w newbietr
    set loginname [string trim $loginname]
    catch focus_cmdline
    if $newbie {return \"N$loginname\\\\$loginpassword\"} 	    {return \"O$loginname\\\\$loginpassword\"}

}

proc Floater_changepw {} {
    global changepwname oldpassword newpassword

    toplevel .changepw

    frame .changepw.left
    frame .changepw.right
    frame .changepw.bottom


    button .changepw.bottom.cancel -text \"Cancel\" 	-command {set changepwname \"\"; set oldpassword \"\"; 	set newpassword \"\"; destroy .changepw}


    button .changepw.bottom.clear -text \"Clear\" 	-command {set changepwname \"\"; set oldpassword \"\"; 	set newpassword \"\"; focus .changepw.right.n}


    button .changepw.bottom.ok -text \"OK\" 	-command {destroy .changepw}


    label .changepw.left.n -text \"Name: \"
    label .changepw.left.o -text \"Old password: \"
    label .changepw.left.p -text \"New password: \"

    entry .changepw.right.n -bd 2 -relief sunken -textvariable changepwname
    entry .changepw.right.o -bd 2 -relief sunken -textvariable oldpassword
    entry .changepw.right.p -bd 2 -relief sunken -textvariable newpassword

    pack .changepw.bottom.cancel .changepw.bottom.clear .changepw.bottom.ok 	-side left -expand yes -fill x -padx 3m -pady 2m

    pack .changepw.left.n .changepw.left.o .changepw.left.p
    pack .changepw.right.n .changepw.right.o .changepw.right.p
    pack .changepw.bottom -side bottom
    pack .changepw.left -side left -fill x -expand yes
    pack .changepw.right .changepw.right -side right -fill x -expand yes
    wm title .changepw \"change password\"

    bindsetup .changepw.right.n .changepw.right.o {focus .changepw.right.o}
    bindsetup .changepw.right.o .changepw.right.p {focus .changepw.right.p}
    bindsetup .changepw.right.p .changepw.right.n {destroy .changepw}
    bind .changepw.right.n \\\\ {set changepwname \"\"}

    grab set .changepw
    tkwait window .changepw
    catch {focus .cmd; focus .cmd.talk}
    return \"$changepwname\\\\$oldpassword\\\\$newpassword\"
}
# 20 \"tclcode/floatert.TCL\" 2

"/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
};

#define numfiles (sizeof(tcl2cfiles) / sizeof(tcl2cfiles[0]))

void source(char *s)
{
  int i;

  s = TEMPCAT3("tclcode/", s, ".tcl");
  for (i = 0; i < numfiles; i++)
    if (streq(s, tcl2cfilenames[i])) {
      TclDo3("uplevel #0 {", tcl2cfiles[i], "}");
      return;
    }
  assert(0);
}
#endif /* TCL_IN_C */
