/****************************************************************************
 *                                                                          *
 * Copyright 1999-2005 ATI Technologies Inc., Markham, Ontario, CANADA.     *
 * All Rights Reserved.                                                     *
 *                                                                          *
 * Your use and or redistribution of this software in source and \ or       *
 * binary form, with or without modification, is subject to: (i) your       *
 * ongoing acceptance of and compliance with the terms and conditions of    *
 * the ATI Technologies Inc. software End User License Agreement; and (ii)  *
 * your inclusion of this notice in any version of this software that you   *
 * use or redistribute.  A copy of the ATI Technologies Inc. software End   *
 * User License Agreement is included with this software and is also        *
 * available by contacting ATI Technologies Inc. at http://www.ati.com      *
 *                                                                          *
 ****************************************************************************/

#ifndef _R200_EXT_
#define _R200_EXT_

#ifndef XREP_SZ
#define XREP_SZ(name)       sizeof(x##name##Reply)
#endif
#ifndef XREQ_SZ
#define XREQ_SZ(name)       sizeof(x##name##Req)
#endif 

// === FGL ===
#define ATIFGL_EXTENSION_NAME       "ATIFGLEXTENSION"

#define ATIFGL_NUMBER_EVENTS            0
#define ATIFGL_NUMBER_ERRORS            0

#define X_FGLGetDriverData              0
#define X_FGLGetDisplaySettings         1
#define X_FGLSetDisplaySettings         2
#define X_FGLVidModePanelSetGammaData   3
#define X_FGLVidModeSetGammaRamp        4
#define X_FGLVidModeGetGammaRamp        5
#define X_FGLVidModeGetGammaRampSize    6
#define X_FGLReserved_0007              7
#define X_FGLReserved_0008              8
#define X_FGLReserved_0009              9
#define X_FGLReserved_0010             10
#define X_FGLReserved_0011             11
#define X_FGLSetOverlayCRTC            12
/* 13 - 15 used by PowerPlay */
/* 16 - 24 used by DisplayMgr */

/* Some parts of the extension protocol are defined in header files
 * that are shared with the client-side implementation of the
 * extension in order to avoid duplication of the definitions. */
#include "fglrx_pp_proto.h"
#include "fglrx_dm_proto.h"

//////////////////////////////////////////////////////////////////////////////
// ProcFGLGetDriverData

// requests must be multiple of 4
typedef struct _FGLGetDriverData {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD16  size B16;           //    2
    CARD16  pad1;               //    2
} xFGLGetDriverDataReq;         // = 12

typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD8   majorVersion;       //    1
    CARD8   minorVersion;       //    1
    CARD8   patchlevel B16;     //    1
    CARD8   BIOSVersionMajor;   //    1
    CARD8   BIOSVersionMinor;   //    1
    CARD8   HasSecondary;       //    1
    CARD16  pad3 B16;           //    2
    CARD16  usBoardType B16;    //    2
    CARD16  usChipType  B16;    //    2
    CARD32  ulVideoRam  B32;    //    4
    CARD8   sATiRevID[17];      //   17 (previousely 1, now 1+16 to fullfill alignment)
    CARD8   AGPTransferMode;    //    1
    CARD32  AGPCapPtr;          //    4
    CARD32  AGPStatus;          //    4
    CARD32  AGPCommand;         //    4
    CARD32  ulGamma1  B32;      //    4
    CARD32  ulGamma2  B32;      //    4
    CARD32  ulDriverType  B32;  //    4
    CARD32  ulDesktopSetup B32; //    4
    CARD32  ulPrimary B32;      //    4
    CARD8   sBoardName[96];    //    96 
} xFGLGetDriverDataReply;       // = 172
// 172 bytes 



#define sz_xFGLGetDriverDataReq      XREQ_SZ(FGLGetDriverData)
#define sz_xFGLGetDriverDataReply    XREP_SZ(FGLGetDriverData)

//////////////////////////////////////////////////////////////////////////////
// ProcFGLGetDisplaySettings

// requests must be multiple of 4
typedef struct _FGLGetDisplaySettings {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD16  size B16;           //    2
    CARD16  pad1;               //    2
} xFGLGetDisplaySettingsReq;    // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  ulPrimary B32;      //    4
    CARD32  ulDesktop B32;      //    4
    CARD32  pad2 B32;           //    4
    CARD32  pad3 B32;           //    4
    CARD32  pad4 B32;           //    4
    CARD32  pad5 B32;           //    4
} xFGLGetDisplaySettingsReply;  // = 32
// 32 bytes (reply needs)

#define sz_xFGLGetDisplaySettingsReq      XREQ_SZ(FGLGetDisplaySettings)
#define sz_xFGLGetDisplaySettingsReply    XREP_SZ(FGLGetDisplaySettings)

//////////////////////////////////////////////////////////////////////////////
// ProcFGLSetDisplaySettings

// requests must be multiple of 4
typedef struct _FGLSetDisplaySettings {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  ulPrimary B32;      //    4
    CARD32  ulDesktop B32;      //    4
} xFGLSetDisplaySettingsReq;    // = 16

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  ulPrimary B32;      //    4
    CARD32  ulDesktop B32;      //    4
    CARD32  pad2 B32;           //    4
    CARD32  pad3 B32;           //    4
    CARD32  pad4 B32;           //    4
    CARD32  pad5 B32;           //    4
} xFGLSetDisplaySettingsReply;  // = 32
// 32 bytes (reply needs)

#define sz_xFGLSetDisplaySettingsReq      XREQ_SZ(FGLSetDisplaySettings)
#define sz_xFGLSetDisplaySettingsReply    XREP_SZ(FGLSetDisplaySettings)

//////////////////////////////////////////////////////////////////////////////
// ProcFGLSetOverlayCRTC

// requests must be multiple of 4
typedef struct _FGLSetOverlayCRTC {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  uCurCRTC B32;       //    4
//    CARD32  ulReserve B32;      //    4
} xFGLSetOverlayCRTCReq;    // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  uPrevCRTC B32;      //    4
    CARD32  uCurCRTC B32;       //    4
    CARD32  pad2 B32;           //    4
    CARD32  pad3 B32;           //    4
    CARD32  pad4 B32;           //    4
    CARD32  pad5 B32;           //    4
} xFGLSetOverlayCRTCReply;  // = 32
// 32 bytes (reply needs)

#define sz_xFGLSetOverlayCRTCReq      XREQ_SZ(FGLSetOverlayCRTC)
#define sz_xFGLSetOverlayCRTCReply    XREP_SZ(FGLSetOverlayCRTC)

/////////////////////////////////////////////////////////////////////////////
// ProcFGLVidModePanelSetGammaData

// requests must be multiple of 4
typedef struct _FGLVidModePanelSetGammaData {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  ulMonitor B32;      //    4
    CARD32  ulGamma   B32;      //    4
} xFGLVidModePanelSetGammaDataReq; // = 16

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  pad2 B32;           //    4
    CARD32  pad3 B32;           //    4
    CARD32  pad4 B32;           //    4
    CARD32  pad5 B32;           //    4
    CARD32  pad6 B32;           //    4
    CARD32  pad7 B32;           //    4
} xFGLVidModePanelSetGammaDataReply; // = 32
// 32 bytes (reply needs)

#define sz_xFGLVidModePanelSetGammaDataReq      XREQ_SZ(FGLVidModePanelSetGammaData)
#define sz_xFGLVidModePanelSetGammaDataReply    XREP_SZ(FGLVidModePanelSetGammaData)

//////////////////////////////////////////////////////////////////////////////
// FGLVidModeSetGammaRamp

typedef struct _FGLVidModeSetGammaRamp {
    CARD8   reqType;
    CARD8   fireglReqType;
    CARD16  length B16;
    /* specific */
    CARD32  screen B32;
    CARD32  ulController B32;
    CARD16  RGamma[256];
    CARD16  GGamma[256];
    CARD16  BGamma[256];
} xFGLVidModeSetGammaRampReq;

typedef struct {
    BYTE    type;                   /* X_Reply */
    BOOL    pad1;
    CARD16  sequenceNumber B16;
    CARD32  length B32;
    CARD32  pad2 B32;
    CARD32  pad3 B32;
    CARD32  pad4 B32;
    CARD32  pad5 B32;
    CARD32  pad6 B32;
    CARD32  pad7 B32;
} xFGLVidModeSetGammaRampReply;

#define sz_xFGLVidModeSetGammaRampReq      XREQ_SZ(FGLVidModeSetGammaRamp)
#define sz_xFGLVidModeSetGammaRampReply    XREP_SZ(FGLVidModeSetGammaRamp)

//////////////////////////////////////////////////////////////////////////////
// FGLVidModeGetGammaRamp
typedef struct _FGLVidModeGetGammaRamp {
    CARD8   reqType;
    CARD8   fireglReqType;
    CARD16  length B16;
    /* specific */
    CARD32  screen B32;
    CARD32  ulController B32;
    CARD16  size B16;
} xFGLVidModeGetGammaRampReq;

typedef struct {
    BYTE    type;                   /* X_Reply */
    BYTE    pad1;
    CARD16  sequenceNumber B16;
    CARD32  length B32;
    /* specific */
    CARD16  RGamma[256];
    CARD16  GGamma[256];
    CARD16  BGamma[256];
} xFGLVidModeGetGammaRampReply;

#define sz_xFGLVidModeGetGammaRampReq      XREQ_SZ(FGLVidModeGetGammaRamp)
#define sz_xFGLVidModeGetGammaRampReply    XREP_SZ(FGLVidModeGetGammaRamp)

//////////////////////////////////////////////////////////////////////////////
// FGLVidModeGetGammaRampSize
typedef struct _FGLVidModeGetGammaRampSize {
    CARD8   reqType;
    CARD8   fireglReqType;
    CARD16  length B16;
    CARD32  screen B32;
    CARD16  size B16;
} xFGLVidModeGetGammaRampSizeReq;
                                    // 10

typedef struct {
    BYTE    type;                   /* X_Reply */
    BYTE    pad1;                   
    CARD16  sequenceNumber B16;
    CARD32  length B32;
    CARD32  pad2 B32;
    CARD32  pad3 B32;
} xFGLVidModeGetGammaRampSizeReply;

#define sz_xFGLVidModeGetGammaRampSizeReq      XREQ_SZ(FGLVidModeGetGammaRampSize)
#define sz_xFGLVidModeGetGammaRampSizeReply    XREP_SZ(FGLVidModeGetGammaRampSize)

#endif // _R200_EXT_
