#include <qstring.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

//Taken from R200.h
#define DESKTOP_SETUP_SINGLE_FIRST        0x00000001 // only turn on first display
#define DESKTOP_SETUP_SINGLE_SECOND       0x00000002 // only turn on second display
#define DESKTOP_SETUP_MIRROR              0x00000004 // two displays share crtc1, use lower timings of two
#define DESKTOP_SETUP_CLONE               0x00000008 // two displays on two controllers, same fb location (default)
#define DESKTOP_SETUP_HORIZONTAL          0x00000010 // big-desktop, first on left and second on right
#define DESKTOP_SETUP_HORIZONTAL_REVERSE  0x00000020 // big-desktop, first on right and second on left
#define DESKTOP_SETUP_VERTICAL            0x00000040 // big-desktop, first on top, second on bottom
#define DESKTOP_SETUP_VERTICAL_REVERSE    0x00000080 // big-desktop, first on bottom, second on top
class DualScreenPage: public QWidget
{
  Q_OBJECT

  public:
    DualScreenPage ( QWidget *parent=0 ) ;

  private slots:
    void OnPrimary ( int id ) ;
    void OnDesktop ( int id ) ;
    void OnActivate ( int nPage ) ;
    void OnApply ( int *Accept ) ;

  private:
    void Init ( ) ;
    void ReadCurrentSettings ( ) ;
    void ArrangeMonitors ( ) ;
    void AticonfigErrorMsgBox();

    bool          m_Init ;
    bool          m_Changed ;
    int           m_Primary ;
    int           m_Desktop ;
    QButtonGroup *pPrimary ;
    QButtonGroup *pDesktop ;
    QLabel       *pSingle1, *pSingle2, *pDisable, *pLeft, *pRight, *pTop, *pBottom ;

} ;





