#include <qstring.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qpushbutton.h>
#include <X11/Xlib.h>
#define XMD_H 1
#include <X11/extensions/xf86vmode.h>

#define GAMMA_MIN	0.1
#define GAMMA_MAX	10.0
#define GAMMA_DEFAULT	1.0

class AdjustPage: public QWidget
{
  Q_OBJECT

  public:
    AdjustPage ( QWidget *parent=0, int CurMonitor=0 ) ;

  private slots:
    void OnLeft ( ) ;
    void OnRight ( ) ;
    void OnUp ( ) ;
    void OnDown ( ) ;
    void OnWider ( ) ;
    void OnSmaler ( ) ;
    void OnHigher ( ) ;
    void OnLower ( ) ;
    void OnSyncHorizontal ( ) ;
    void OnSyncVertical ( ) ;
    void OnUndo ( ) ;
    void OnSliderRed ( int Value ) ;
    void OnSliderGreen ( int Value ) ;
    void OnSliderBlue ( int Value ) ;
    void OnDefaultRed ( ) ;
    void OnDefaultGreen ( ) ;
    void OnDefaultBlue ( ) ;

    void OnApply ( int *Accept ) ;
    void OnCancel (  ) ;
    void OnActivate ( int nPage ) ;

  private:
    void Init ( ) ;
    bool ReadTimings ( ) ;
    bool ReadGamma ( ) ;
    void UpdateTimingsBox ( ) ;
    bool InvokeTimings ( ) ;
    bool InvokeGammaCorrection ( ) ;

    bool                m_HasSecondary;
    bool                m_Init ;
    bool                m_TimingsChanged ;
    int                 m_CurMonitor ;
    XF86VidModeModeLine m_Timings ;
    int			m_DotClock ;
    XF86VidModeModeLine m_CurTimings ;
    int			m_CurDotClock ;
    XF86VidModeGamma    m_Gamma ;
    XF86VidModeGamma    m_CurGamma ;

    QGroupBox    *pMonitorBox ;
    QPushButton  *pLeft, *pRight, *pUp, *pDown ;
    QPushButton  *pWider, *pSmaler, *pHigher, *pLower ;
    QCheckBox    *pSyncHorz, *pSyncVert ;
    QPushButton  *pUndo, *pDefault ;
    QCheckBox    *pCouple ;
#ifdef FGLRX_GAMMA_X
    QCheckBox    *pGammaX ;
#endif // FGLRX_GAMMA_X
    QSlider	 *pSliderRed, *pSliderGreen, *pSliderBlue ;
    QLabel	 *pTextRed, *pTextGreen, *pTextBlue ;
    QPushButton  *pDefaultRed, *pDefaultGreen, *pDefaultBlue ;

    enum SyncFlags { H_NEGATIVE = 0x00000002,
                     V_NEGATIVE = 0x00000008
                   } ;
} ;





