#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include "strdup.h"
#include "stdstuff.h"

/* If neither unix, vms, or MSDOS is defined, use unix as default. */
#if (!defined(unix)) && (!defined(vms)) && (!defined(MSDOS))
#define unix
#endif /* (!defined(unix)) && (!defined(vms)) && (!defined(MSDOS)) */

/* Various characters used for delimiting directories in operating */
/* systems. */
#define VMS_DIR_DELIMITER ']'
#define UNIX_DIR_DELIMITER '/'
#define MSDOS_DIR_DELIMITER '\\'

/* Define the delimiter for the OS we're compiling under. */
#if (defined(unix))
#define DIR_DELIMITER UNIX_DIR_DELIMITER
#elif (defined(vms))
#define DIR_DELIMITER VMS_DIR_DELIMITER
#elif (defined(MSDOS))
#define DIR_DELIMITER MSDOS_DIR_DELIMITER
#endif

/* Name of program's image at run-time. */
extern char *ProgramName;

/*-----------------------------------------------------------------------------
  Function: GetProgramName

  Purpose: Extract the program name of the current image that's executing.

  Parameters: char *Program;
                   -string representing the executable's image name, for
                    instance, `argv[0]'.
              char *DefaultName;
                   -string representing the name to use if a name can't
                    be found.

  Returns: nothing.

  Side Effects: ProgramName is given the name of the program.
-----------------------------------------------------------------------------*/
void
GetProgramName (Program, DefaultName)
     char *Program;
     char *DefaultName;
{
  char *NameMaybeWithExtension, *SepPos;

  /* If command line wasn't right, use the default program name. */
  if (Program != NULL)
    {
      /* Get the portion of the image name beginning with the final */
      /* directory delimiter and extract the program's name from the */
      /* image name. */
      SepPos = strrchr (Program, DIR_DELIMITER);

      if (SepPos == NULL)
	ProgramName = strdup (Program);
      else
	{
	  NameMaybeWithExtension = strdup (SepPos);

#if (defined(vms)) || (defined(MSDOS))
	  {
	    char *PeriodPos;

	    PeriodPos = strrchr (NameMaybeWithExtension, '.');

	    if (PeriodPos != NULL)
	      /* Remove the VMS or MSDOS extension (i.e. `.exe' or */
	      /* `.com'). */
	      *PeriodPos = '\0';
	  }
#endif /* (defined(vms)) || (defined(MSDOS)) */

	  /* Set `ProgramName' to the name (plus 1 because of the */
	  /* DIR_DELIMITER at the front). */
	  ProgramName = strdup (NameMaybeWithExtension + 1);

	  free (NameMaybeWithExtension);
	}
    }

  /* If all the above hasn't gotten a name, use the image name as the */
  /* program name. */
  if (ProgramName == NULL)
    ProgramName = strdup (DefaultName);
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
